/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) util.c: version 25.1 created on 11/27/91 at 14:41:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)util.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * util.c
 *
 *	Monitor utilities
 *
 */

#include "types.h"
#include "global.h"
#include "routines.h"

#define 	CTL_Q 		0x11
#define 	CTL_S 		0x13
#define 	ESCAPE 		0x1b

#define 	LINE_LIMIT 	80	/*  80 column output */
#define 	HALF_LINE 	40	/*  40 column output */

extern char escflag;

/*------------------------------------------------------------------------------
	checkloop () :
	Say 'loop?' to user, return response.
	If looping is disabled, just return a 0.
------------------------------------------------------------------------------*/
checkloop ()
{
	char ibuf [17];

	if(!loopstat) return (0);
	printf("Loop? (y/n) ");
	if((gets (ibuf, 16) == (char *)-1)) return (-1);
	if(Yes (*ibuf) || !*ibuf) return (1);
	return (0);
}

/*------------------------------------------------------------------------------
		dummy : for faking up menu entries. 
------------------------------------------------------------------------------*/
dummy() 
{ }

/*------------------------------------------------------------------------------
		dte : print the date this was compiled.
------------------------------------------------------------------------------*/
dte() 
{ 
	printf("%s",date);
}

/*------------------------------------------------------------------------------
	clokpr(prnt) :	 print the message. saves text space.
------------------------------------------------------------------------------*/
clokpr(prnt)
int prnt;
{
	if(powmain() || chkclok()) {	/* if on local clock, bad. */
		if(!prnt) {
			printf("Sorry, you are running on the local clock.\n");
			printf("You must be on the CSS clock to use this function.\n");
		}
		return(1);	/* not on css clock */
	}
	return(0);
}

/*******************[ STRING MANIPULATION UTILITIES ]**************************/

/*------------------------------------------------------------------------------
	strcmp : return <0 if p1 < p2, 0 if ==, >0 if p1 > p2.
------------------------------------------------------------------------------*/
strcmp (p1, p2)
register unsigned char *p1, *p2;
{
	for (; *p1 == *p2; p1++, p2++)
		if (*p1 == '\0') return (0);

	return ((int)*p1 - (int)*p2);
}

/*------------------------------------------------------------------------------
	strcpy : Copy string s2 to s1.  s1 must be large enough. return s1.
------------------------------------------------------------------------------*/
char *
strcpy(s1, s2)
register char *s1, *s2;
{
	register char *os1;

	os1 = s1;
	while(*s1++ = *s2++);
	return(os1);
}

/*------------------------------------------------------------------------------
	strncpy : Copy string s2 to s1, for size of cnt.
	s1 must be large enough. return s1.
------------------------------------------------------------------------------*/
char *
strncpy(s1, s2, cnt)
register char *s1, *s2;
register cnt;	/* number of chars to copy. */
{
	register char *os1;
	register i;

	os1 = s1;				/* save it */
	for(i=0; i < cnt; i++)			/* copy n chars */
	  *s1++ = *s2++;			/* copy chars across */
	return(os1);
}

/*------------------------------------------------------------------------------
	atox : convert input string to hex
------------------------------------------------------------------------------*/
unsigned
atox (ibuf)
char *ibuf;
{
	register char *ib;
	register int i;
	register int tc;

	ib = ibuf;
	i = 0;

	while (*ib) {
		tc = *ib++;
		i = i << 4;
		if (tc >= '0') tc -= '0';
		if (tc <= 9) {
			i += tc;
		}
		else {
			if (tc >= ('A' - '0')) tc -= ('A' - '0');
			if (tc >= ('a' - 'A')) tc -= ('a' - 'A');
			if (tc <= 5) {
				i += tc + 10;
			}
		}
	}
	return (i);
}

/*------------------------------------------------------------------------------
	sleep : Wait for ~.01 secs.
------------------------------------------------------------------------------*/
sleep (secs)
register int secs;
{
	register int i;

	while (secs--)
		for (i = 4200; i; i--);		/* ~secs .01 seconds */
}
 
/*------------------------------------------------------------------------------
  gets.c : Get a line of input from console and echo characters.
------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
 Change carriage return to line feed and echo carriage return line feed.
 Keep getting character and store them into buf until a line feed 
 or carriage return is received.
 take care character delete \b
 take care line delete character  @
 user will never get carriage return in the buf 
------------------------------------------------------------------------------*/
char *
gets(buf, limit)
char *buf;
{
	register char *lp;
	register c, count;

	lp = buf;
	count = 0;
	while(count < limit)
	{
		c = Getchar() & 0177;	/* only take 7 bits, or macro char */
		putchar (c);		/* echo char */

		switch(c)
		{
		case '\n':
		case '\r':
			if (c == '\r') putchar ('\n');
			*lp = '\0';
			return (buf);
		case '\b':
			if (lp <= buf)
				lp = buf;
			else
			{
				count--;
				lp--;
			}
			continue;
		case '@':
			count = 0;
			lp = buf;
			putchar ('\n');
			continue;
		case '\033':
			lp = buf;
			*lp = '\0';
			putchar ('\n');
			return ((char *)-1);
		case '\032':		/* ^Z */
			if((Getchar() & 0177) == '\032') /* has to be two zz */
				_restart ();
			break;
		default:
			count++;
			*lp++ = c;
		}
	}
	buf [limit - 1] = '\0';
	return (buf);
}

/*------------------------------------------------------------------------------
	getchar : Get a character from the console.
		  This is standalone, no macro buffer input allowed routine.
-----------------------------------------------------------------------------*/
getchar()
{
	register char c;

	while((c = con_in ()) == -1);	/* wait until return char */
	return(c);
}

/*------------------------------------------------------------------------------
	putchar : Puts a character in the console.
-----------------------------------------------------------------------------*/
putchar(c)
register char c;
{
	char in1;
	if ((in1=con_in ()) == CTL_S)
		getchar ();	/* don't check for macro chars */
	if(in1==ESCAPE)		/* if escaped */
		escflag=1;	/* show it was pressed */
	if (c != ESCAPE)
	{
		con_out (c);
		if (c == '\n') con_out ('\r');
	}
	return;
}

/*------------------------------------------------------------------------------
		atoi() = ASCII to (decimal) integer conversion.
-----------------------------------------------------------------------------*/
atoi(s)
char s[];
{
	int i,n;

	for(i=n=0;(s[i] >= '0') && (s[i] <= '9'); i++)
		n = 10 * n + s[i] - '0';
	return(n);
}

/*------------------------------------------------------------------------------
	itoa: Integer, (x) will be converted into ascii string, (s[]).
-----------------------------------------------------------------------------*/
itoa(x,s)
int x;
char s[];
{
	int i=0,sgn;

	if((sgn = x) < 0) x = -x;
	do {
		s[i++] = x % 10 + '0';
	} while ((x /= 10) > 0);
	if(sgn < 0) s[i++] = '-';
	s[i] = '\0';
	reverse(s);
}

/*------------------------------------------------------------------------------
	reverse : Reverses the string given to it, (s[]).
-----------------------------------------------------------------------------*/
reverse(s)
char s[];
{
	int c,i,j;

	for(i = 0,j = (strlen(s)-1); i < j;i++,j--) {
		c = s[i];
		s[i]=s[j];
		s[j]=c;
	}
}

/*------------------------------------------------------------------------------
	strlen : Standard string length counter.
-----------------------------------------------------------------------------*/
strlen(s)
char s[];
{
	char len;
	for(len=0;s[len] != '\0'; ++len);
	return(len);
}

/*------------------------------------------------------------------------------
	clscrn : Print specified number of lines.
------------------------------------------------------------------------------*/
clscrn(i) 
uint i; 
{ 
	register  int x;
	char	buffer[LINE_LIMIT + 1];

	if (i > LINE_LIMIT)
		i = LINE_LIMIT;
	
	for(x = 0; x != i; x++)
		buffer[x] = '\n';

	buffer[i] = '\0';
	printf("%s", buffer);
}

/*------------------------------------------------------------------------------
	anykey : Pressing any key will return to caller.
------------------------------------------------------------------------------*/
anykey() 
{ 
	printf("\n\rAny key to continue...");
	return(getchar());
}

/*------------------------------------------------------------------------------
	pline : Prints a pattern specified by 'c', 'n' number of times.
------------------------------------------------------------------------------*/
pline(c,n) 
char c;
uint n; 
{ 
	register int i;
	char	buffer[LINE_LIMIT + 1];

	if (n > LINE_LIMIT)
		n = LINE_LIMIT;

	for(i=0; i != n; i++)
		buffer[i] = (char)c;

	buffer[n] = '\0';
	printf("%s",buffer);
}

/*------------------------------------------------------------------------------
	cline : Prints a string pointed to by *s, in the center of the line,
	and fills both ends of the line with a pattern specified by 'p'.
------------------------------------------------------------------------------*/
cline(p,s) 
char p;
char *s; 
{ 
	register int i=0,len=0;
	printf("\n");

	if((len=strlen(s)) % 2) 
		pline(p,(HALF_LINE - 1 - (len/2)));
	else 
		pline(p,(HALF_LINE - (len/2)));

	printf("%s",s);

	pline(p,(HALF_LINE - (len/2)));
}

/*------------------------------------------------------------------------------
	invld : Invalid Entry prompt. 
------------------------------------------------------------------------------*/
invld() 
{ 
	putchar('\r'); 
	pline(' ',80); 
	printf("\rInvalid Entry.\007 \007");
	anykey();
}
/*-----------------------------------------------------------------------------
	 Yes : check for Y or y answer
-----------------------------------------------------------------------------*/
int
Yes (chr)
	char chr;
{

	if ((chr == 'Y') || (chr == 'y')) {
		return (1);
	}
	else 
		return (0);
}
/*-----------------------------------------------------------------------------
	 No : check for N or n answer
-----------------------------------------------------------------------------*/
int
No (chr)
	char chr;
{

	if ((chr == 'N') || (chr == 'n')) {
		return (1);
	}
	else 
		return (0);
}
/*-----------------------------------------------------------------------------
	 hit_return: returns a 1 if a return is hit, else 0
-----------------------------------------------------------------------------*/
hit_return()
{
	printf("Hit return to exit, any other key to continue\n");
		if ( getchar() == '\n')
			return(1);
		return(0);
}
/*-----------------------------------------------------------------------------
	 wait : wait loop-count amount of time; in increments of 1000
-----------------------------------------------------------------------------*/
wait(count)
int count;
{
	int i;
	count = count * 1000;
	for (i = 0; i != count; i++);
	return(0);
}
/******************************************************************************/
/* Tims star */
char	*star_tab[] = {
	"\r | ",
	"\r / ",
	"\r - ",
	"\r \\ ",
	};

int
star (comm_str, arg_cnt)
{

	int  i;
	int  j;
	int  pos;
	int  count;
	int  count1;

	count = atoi(comm_args[1]);
	count1 = atoi(comm_args[2]);

	for (i = 0; i != count; i++) {

		for (pos = 0; pos != 4; pos++) {
			printf ("%s",star_tab[pos]);
			for (j = 0; j != count1; j++);
		}
	}
	return(0);
}
