/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tapecmd.c: version 25.1 created on 11/27/91 at 14:41:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tapecmd.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "spm.h"
#include "misc.h"
#include "global.h"
#include "icb.h"
#include "devcmd.h"
#include "vreg.h"
#include "icb_config.h"
#include "rtb.h"
#include "disp.h"


extern	unsigned char	ioinit;
tape_wr(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	memaddr,drive,size;

	if(arg_cnt < 3)	{
		return(-1);
	}

	memaddr = (unsigned)atox(comm_args[1]);
	drive = (unsigned)atox (comm_args[2]);
	size = (unsigned)atox (comm_args[3]);
	tapereq(TPWRITE,memaddr,drive,size);

}

tape_rd(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	memaddr,drive,size;

	if(arg_cnt < 3)	{
		return(-1);
	}

	memaddr = (unsigned)atox(comm_args[1]);
	drive = (unsigned)atox (comm_args[2]);
	size = (unsigned)atox (comm_args[3]);
	tapereq(TPREAD,memaddr,drive,size);

}



tape_rd_eof(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	drive;

	if(arg_cnt < 1)	{
		return(-1);
	}

	drive = (unsigned)atox (comm_args[1]);
	tapereq(REOF,0,drive,0);

}


tape_wr_eof(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	drive;

	if(arg_cnt < 1)	{
		return(-1);
	}

	drive = (unsigned)atox (comm_args[1]);
	tapereq(WEOF,0,drive,0);
}


tape_rewind(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	drive;

	if(arg_cnt < 1)	{
		return(-1);
	}

	drive = (unsigned)atox (comm_args[1]);
	tapereq(REWIND,0,drive,0);
}


tape_status(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	drive;

	if(arg_cnt < 1)	{
		return(-1);
	}

	drive = (unsigned)atox (comm_args[1]);
	tapereq(TPSTAT,0,drive,0);
}


tape_tension(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	drive;

	if(arg_cnt < 1)	{
		return(-1);
	}

	drive = (unsigned)atox (comm_args[1]);
	tapereq(TENSION,0,drive,0);
}



#ifdef NOFIRM

/* tape forward/backward commands are not supported by firmware */

tape_forward(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	drive;

	if(arg_cnt < 1)	{
		return(-1);
	}

	drive = (unsigned)atox (comm_args[1]);
	tapereq(FORRECORD,0,drive,0);
}


tape_backward(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned 	drive;

	if(arg_cnt < 1)	{
		return(-1);
	}

	drive = (unsigned)atox (comm_args[1]);
	tapereq(REVRECORD,0,drive,0);
}

#endif

