/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) switches.c: version 25.1 created on 11/27/91 at 14:41:06	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)switches.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*------------------------------------------------------------------------------
		switches.c
------------------------------------------------------------------------------*/

#include "spm.h"
#include "global.h"
#include "misc.h"
#include "version.h"

extern char comm_args[][MAXARGSIZE];
extern unsigned char MemSimFlag;
extern char to_css; /* if set to a value, used for clock switching status. */
extern char prtline;	/* set to 0x5d if printing. */
extern char cpuack;

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
mem_simulate()
{
	if(!strcmp (comm_args[1], "on")) {
		MemSimFlag = TRUE;
		*WRCNTL1 &= ~WR1_DIAG_ANY_TYPE;
		*WRCNTL1 &= ~WR1_CSSRD_MASK;
		*WRCNTL1 |= WR1_RD32;
		printf ("Memory simulation is on.\n");
	}
	else if(!strcmp (comm_args[1], "off")) {
		MemSimFlag = FALSE;
		*WRCNTL1 |= WR1_DIAG_ANY_TYPE;
		*WRCNTL1 &= ~WR1_CSSRD_MASK;
		*WRCNTL1 |= WR1_4BYTE_RD;
		printf ("Memory simulation is off.\n");
	}
	else {
		printf("Illegal argument '%s', \n", comm_args[1]);
		printf("legal options are 'on' and 'off'.\n");
	}
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
cache020()
{
	if(!strcmp (comm_args[1], "on")) {
		_cache(1);
		cacheflag = 1;
	}
	else if(!strcmp (comm_args[1], "off")) {
		_cache(0);
		cacheflag = 0;
	}
	else
		printf("Illegal argument.\n",comm_args[1]);
	printf("Cache is now %s.\n",(cacheflag) ? "on" : "off");
	return(0);
}
	
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
Clock(comm_str, argc)
char *comm_str;
int argc;
{
	if(argc == 0) {			/* if we just want status.. */
		if(powmain() || *STATUSREG &0x20000000) /* on local clock... */
			printf("\n*Local clock active ");
		else
			printf("\n*CSS clock active ");
#ifdef	SPM_IMAGE
		printf("(IMAGE Version %d.%d.%d).\n",
			RELEASE, VERSION, PRE_REL);
#endif

#ifdef	SPM_PROM
		printf("(PROM Version %d.%d.%d).\n", 
			RELEASE, VERSION, PRE_REL);
#endif

		return(0);
	}
	if(!strcmp (comm_args[1], "css")) {
		if(powmain()) {
			printf("\nUnable to switch to CSS clock.");
			printf("\nMain power must be active.\n");
			return(0);
		}
		CloSwi(0);	/* switch to CSS clock now. */
	}
	else
		if(!strcmp(comm_args[1], "bd")) {
#ifdef	SPM_PROM
			if(!chkclok()) 
				nvpwrstat(2);	/* Indicate clk synchronized */
#endif

			CloSwi(1);		/* switch to local clock. */
 		}	
	else
		printf("Illegal argument, options are 'CSS' and 'bd'.\n");

	return(0);
}

/*------------------------------------------------------------------------------
	Switch clocks.
------------------------------------------------------------------------------*/
CloSwi(arg)
int arg;
{
	if(arg) {			/* must want to go to local clocks.. */
		to_css = 0;
		*WRCNTL1 &= ~(WR1_RRDY|WR1_ID_RST); /* assert cpu.res.ready,
							      disp.res  */
		*WRCNTL1 |= (WR1_DREQ);	/* deassert cpu.disp.req */
		*CLKCNTL = 0x00000000;	/* just switch to local clock. */
	}
	else {					/* switch to CSS clock.. */
		to_css = 5;
		*WRCNTL1 &= ~(WR1_RRDY|WR1_ID_RST); /* assert cpu.res.ready,
							      disp.res*/
		*WRCNTL1 |= (WR1_DREQ);		/* deassert cpu.disp.req */
		*CLKCNTL = 0x00000001;		/* switch clocks.. eh? */
	}
}

#ifdef	SPM_IMAGE
/*------------------------------------------------------------------------------
	printer : Enable/Disable the printer.
------------------------------------------------------------------------------*/
printer()
{
	prtline = (prtline == 0x5b) ? 0 : 0x5b;
	printf("\nPrinter is currently %sabled.\n",(prtline==0) ? "dis" : "en");
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
stupidon()
{
	cpuack = 1;	/* turn this on */
	printf ("\nCPU ACK flag is currently set\n");
	return(0);
}

/*------------------------------------------------------------------------------
	realstupid : Set or reset the BUS error inhibit flag in the
		     Write Control register #0. This flag is ACTIVE low. 
------------------------------------------------------------------------------*/
realstupid()		/* Turn on the disable all CSS bus errors. */
{
	*WRCNTL0 = (*WRCNTL0 & WR0_FRC_INH7) ?	/* What is current setting. */
	(*WRCNTL0 &= ~WR0_FRC_INH7) :		/* Enable Inhibit flag. */
	(*WRCNTL0 |= WR0_FRC_INH7);		/* Disable inhibit flag. */

	printf("\nBus error inhibit flag is currently %sabled\n",
	(*WRCNTL0 & WR0_FRC_INH7) ? "dis" : "en");
	return(0);
}

setmodify()
{
	*WRCNTL1 &= ~WR1_FMOD;	/* clear this bit. */
}

clrmodify()
{
	*WRCNTL1 |= WR1_FMOD;	/* set this bit. */
}
#endif

