/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sprintf.c: version 25.1 created on 11/27/91 at 14:41:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sprintf.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* 
 ===========================================================================
		sprintf - standalone
 ===========================================================================
 * Modified from STANDALONE PRINTF - Shihnan Huang (June, 1988)
 * shortened to use some of the routines also in printf; jpw
 * watch out stack space, allocate over 100 bytes on stack
 *
 * Escape sequences implemented:
 *	%nd	1-prec decimal, signed
 *	%nD	2-prec decimal, signed
 *	%no	1-prec octal, unsigned
 *	%n)	2-prec octal, unsigned
 *	%nx	1-prec hex, unsigned
 *	%nX	2-prec hex, unsigned
 *	%ns	string
 *	%c	character
 *	%%	percent
 *
 * in above, "n" can be an integer arg or "v", whence field width comes
 *   from arg list.
 */

#define va_arg(list, mode) ((mode *)(list += sizeof(mode)))[-1]

#define	ESC		'%'

char *
sputnum (buf, val, fmt, radix, sign)
char         *buf;
register int val;
{
    char digbuf[100], negflag = 0;
    int ndig = 0, spaces = fmt;

    if (sign && val<0)
	{
		if ((val = -val) < 0) val = 0; 
		negflag++; 
    }

    switch (radix)
	{
	case 10:
		ndig = putn2 (val, digbuf);
		break;
	case 16:
		do {
		    digbuf[ndig++] = val & 0XFL;
		    val = (val >> 4) & 0X0FFFFFFF;
		} while (val);
		break;
	case 8:
		do {
		    digbuf[ndig++] = val & 0X7L;
		    val = (val >> 3) & 0X1FFFFFFF;
		} while (val);
		break;
	case 2:
		do {
		    digbuf[ndig++] = val & 0X1L;
		    val = (val >> 1) & 0X7FFFFFFF;
		} while (val);
		break; 
    }

    spaces = fmt-ndig-negflag;
    if (sign) 
		while (spaces-- > 0) *buf++ = ' ';
    else 
		while (spaces-- > 0) *buf++ = '0';

    if (negflag) *buf++ = '-';

    while (ndig)
	{
		if ((spaces = digbuf[--ndig]) >= 10) spaces += 'A'-'0'-10;
		*buf++ = spaces + '0'; 
    }
    return(buf);
}

/*-------------------------------------------------------------------------*/

char *
sputstring (buf, str, fmt)
char          *buf;
register char *str;
register int fmt;
{
    while (*str && fmt--) *buf++ = *str++;
    while (fmt-- > 0)     *buf++ = ' ';
    return(buf);
}

/*-------------------------------------------------------------------------*/

int
sprintf (s, ctl, args)
char *s;
char *ctl;
{
	register int *argp = &args;
	register char *cc = ctl;
	register int ch;
	int Arg1, Arg2;

	while (ch = *cc++)
	{
		if (ch != ESC)
		{
			*s++ = ch; 
			continue; 
		}

		Arg1 = -1; Arg2 = -1;

		if (((ch = *cc++) >= '0' && ch <= '9') || (ch == 'v'))
		{
			if (ch == 'v') 
				Arg1 = *argp++;
			else {
				cc--;
				cc = (char *) RdArg(cc,&Arg1);
			}

			if ((ch = *cc++) == '.')
			{
				if (*cc == 'v')
				{ 
					Arg2 = *argp++;
					cc++; 
				}
				else 
					cc = (char *) RdArg(cc,&Arg2); 
				ch = *cc++; 
			}
		}

		switch (ch)
		{
		case ESC:
			*s++ = ESC;
			break;
		case 0:
			*s++ = ESC;
			*s = '\0';
			return;
		case 'D':
		case 'd':
			s = sputnum(s,*argp++,Arg1,10,1);
			break;
		case 'O':
		case 'o':
			s = sputnum(s,*argp++,Arg1,8,0);
			break;
		case 'X':
		case 'x':
			s = sputnum(s,*argp++,Arg1,16,0);
			break;
		case 'c':
			*s++ = *argp++;
			break;
		case 's':
			s = sputstring(s,*argp++,Arg1);
			break;

		default:
			*s++ = ESC;
			*s++ = ch;
			break;
		}
	}
	*s = '\0';
}
