/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sizemem.c: version 25.1 created on 11/27/91 at 14:40:58	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sizemem.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* sizemem.c:  sizes main ram, and divides it into chunks.  Then, builds
tables in main memory (1st meg of ram) for all valid cpu's to test.  

table is a struct mem setup in main memory;  filled out in each of the
64k segments assigned to a single cpu.

The first meg of ram is divided into 16 slices of 64kbytes; one for each
of the possible processors.  In each of the slices available for the
cpu's, build a table.   When all tables have been built, go and issue
the start command to each of the cpu's.
*/

#include "misc.h"
#include "globl.h"
#include "spm.h"
#include "rwicio.h"
#include "iom.h"
#include "disp.h"
#include "rwi.h"

#define MM_INIT 0x78	/* Turn green LED, EDAC and error interrupt bits on. */

struct fmem { /* struct for memory test. */
	char		tst_slot;	/* what slot this segment is in. */
	char		tst_stat;	/* status of this megabyte. */
	char		tst_sp1;	/* spare */
	char		tst_sp2;	/* spare */
	unsigned 	tst_start;	/* where it starts. */
	unsigned 	tst_len;	/* how long this segment is. */
	struct fmem *tst_next;	/* where next struct is. */
};

struct tmem {		/* let's have fun.. */
	char mslot;	/* what slot we have found a ram card in */
	char msize;	/* what size board it is. */
	char mstat;	/* what the status of test was. */
};

extern unsigned char bdhere[];			/* slots for CSS board's... */
extern char cpuack;	/* set if testing cpu ack responces. */
extern char got_berr;		/* added by YVC at 2/1/88 for testing IOM */
extern char emulate;		/* added by YVC at 2/1/88 for testing IOM */
extern char tsterrs;	/* this is set to zero when we want to. */
extern char ignore_it;	/* If set, ignore CSS bus errors. */
extern char ram_sl;	/* set to first valid ram slot after test. */
extern unsigned char myslot;			/* This is where I am. */


sizemem(verify)	/* size the memory, into chunks.. */
int verify;
{
	register unsigned *ptr=(unsigned *)0x8ffffffc; /* pointer to read from. */
	int	i, i1, cntcpu=0, tot,sum;
	int slice, slices, remain, smem, nmem;
	struct tmem ram[14];	/* only need 14 of them, one cpu, one spam */

	for(i = 0, i1 = 0; i < 16; i++) {  /* loop through all of slot id's.. */ 
		if(bdhere[i] == CPUHERE)	/* if it's a cpu.. */
			cntcpu++;		/* add one. */

		ram[i].mslot = 0xff;	/* make sure there isn't a slot here. */
		ram[i].mstat = 0;	/* make sure stat's are clear. */

		if(bdhere[i] == MEMHERE)  /* here is a ram card... */
		{ 			/*convert to nibblized addr and slot*/
			cssmap(MAP00,(unsigned char)i,(unsigned char) 0x0f);
			/* read id, and find out how many megs we have. */
			tot = (*ptr & 0x00000700) >> 8;
			switch(tot)	/* now, what is it? */
			{
			case 1: tot = 8; break;		/* add 8 megabytes. */ 
			case 2: tot = 16; break;	/* add 16 megabytes. */
			case 3:
			case 5: tot = 32; break;	/* add 32 megabytes. */
			case 6: tot = 64; break;	/* add 64 meg's */
			case 7: tot = 128; break;	/* add 128 meg's */
			default: tot = 0; break;
			}
			ram[i1].msize = tot;		/* size of ram. */
			if(tot) ram[i1++].mslot = i;	/* slot number. */
		}
	}

	tot = 0;			/* total number of megabytes. */
	for(i = 0; i < i1; i++)		/* loop through all found mem boards */
		tot += ram[i].msize;	/* add in the memory found here. */

	if(!tot)	/* if the one memory board we found was bad.. */
		return(-1);

/* 
** now; we have identified all ram slots, have the total amount of mem,
** and the total number of cpu's, so let's see what they do...
*/
	tot -= 1;		/* remove first megabyte */
	slice = tot / cntcpu;   /* divide total memory by number of cpu's. */
	remain = tot % cntcpu; /* get left over megabytes of ram. */

	smem = 0;	/* keep track of memslot. */
	nmem = 1; 	/* protect first meg in first slot */

/* program to first ram card, map zero, 1st megabyte. */
	cssmap(MAP00,ram_sl,(char) 0x00); /*convert to nibblized addr and slot*/
	for(i = 0; i < 16; i++)	/* loop through all cpu's, and build table. */
	{
		if(bdhere[i] != CPUHERE) /* if there is not a cpu card here. */
			continue;	/* next slot. */
		if(remain) /* add in one meg per cpu until out of extra megs.. */
		{
			slices = slice + 1;	/* add in any remainder from ram. */
			remain--;
		}
		else
			slices = slice; /* else, use this one. */
		progcpu(slices, i, &nmem, &smem, verify, &ram[smem]);
	}
	if(!verify)
	{
		for(i = 0; i < 16; i++)	/* look for cpu's to enable. */
		{
			if(bdhere[i] != CPUHERE) /* if there is not a cpu card here. */
				continue;	/* next slot. */
			tsterrs = 0;	/* make sure enabled reporting of ack's.. */
			cpuack = 1;	/* show we ARE expecting this. */

/* tgm 	Taken out until the problem with reading the mailbox and doing the
	memory test causing a bus error is resolved.
			if(ipccsend(i,0x42,(int)0)) return(1);
*/
			cpuack = got_berr = 0;	/* clear these. */
		}
	}
	else
	{
		for(i = 0; ram[i].mslot < 0xff; i++) /* loop through table. */
		{
			if(ram[i].mstat > 0xf0)
				continue;	/* loop back, failed card. */
			if(ram[i].mstat)	/* if failed test for this slot. */
			{
				bogdis(i); /* disable this slot, and show bad card. */
				ram[i].mslot = 0xf3;	/* fill in bad slot. */
				for(i = 0; i < 14; i++) /* loop through table. */
					if(ram[i].mslot < 0xf0)
						break;	/* found another card. */
				if(i == 14) /* nope.. didn't find one. */
					return(-1);	/* bad. */
				i--; /* test this card now. */
				printf("You have another memory card.  Continue? (Y/N) : ");
				if(getchar() != 'y')  /* said something other than yes. */
					return(-1); /* failed. */
			}
		}
	}
	return(0);
}

progcpu(slice, cpusl, nmem, smem, verify, ram) /* build a table for one slot. */
int slice;	/* number of 1 meg slices to build. */
int cpusl;	/* cpu slot number to build array into. */
int *nmem;	/* pointer to current megabyte slice. */
int *smem;	/* pointer to current memory array being used. */
int verify;	/* if set, check status, instead of build table. */
struct tmem *ram;	/* points to array of ram structures. */
{
	struct fmem *wrk;	/* our working pointer. */

	wrk = (struct fmem *)((cpusl * 65536) + 0x80000100); /* offset to start */
	while(slice-- > 0)	/* while slices left to build. */
	{
		if(*nmem >= (int)ram->msize) /*if there is a megabyte left in here*/
		{
			*nmem = 0;	/* next slot. */
			*smem += 1;	/* next slot.. */
			ram++; /* find next ram slot, and re-init to zero. */
			if(ram->mslot == 0xff)	/* if nothing left, it's wrong. */
			{
				wrk++; /* so it clears the rigth stucture.. */
				break;	/* no memory cards left, eh? bad program.. */
			}
		}
		if(!verify)
		{
			wrk->tst_slot = ram->mslot;	/* what slot to test. */
			wrk->tst_stat = 0;	/* result of test. */
			wrk->tst_sp1  = 0;	/* spare */
			wrk->tst_sp2  = 0;	/* spare */
			wrk->tst_start = *nmem * 0x100000; /*tell him which meg to use*/
			wrk->tst_len = 0x100000;	/* one megabyte to test. */
				 /*point to next structure, remember; high nibble really zero*/
			wrk->tst_next = (struct fmem *)((unsigned)(wrk+1) & 0x0fffffff);
		}
		else
		{
			if(wrk->tst_stat)	/* result of test. */
				ram->mstat = 1;	/* show this slot failed. */
		}
		*nmem += 1;	/* increment to next memory segment. */
		wrk++;	/* next structure.. */
	}
	wrk--;	/* back up one pointer. */
	if(!verify)
		wrk->tst_next = (struct fmem *)0; /* make it zero. */
	return(0);
}

firstram()	/* find and test first meg of ram. */
{
	int i;
	char x;

	if((i = findmem(1)) == 18)		/* could not find one. */
		return(-1);			/* bad. */

	while(1) {		/* now, find any ram card, and test it. */

		if(test1meg(i))	{	/* failed test */
			bogdis(i);	/* disable this slot, show bad card. */

			if((i = findmem(0)) == 18)    /* could not find one. */
				return(-1);	

			printf("You have another memory card, Continue? (Y/N)");
			x = getchar ();
			if (Yes (x))
				return(-1);	/* failed. */
			continue;		/* and continue with next test*/
		}

		ram_sl = (char)i;		/* save it. */
		break;				/* must have passed.. yes? */
	}
	return(0);	/* say ok to continue. */
}

test1meg(slot) /* test 1 megabyte of ram to be valid data. */
int slot;
{
	register unsigned tstpat, tstpat1, tstpat2;
	register unsigned addr, addr1, addr2, readback;
	unsigned char x2;
	
	tsterrs = cpuack = 0;	/* make sure these are cleared. */

	mm_init(slot,1);				/* Init the memory board. */
	x2  = (unsigned char)CSSADD(0);
	cssmap(MAP00,slot,x2);	/* convert to nibblized address and slot */
	addr = CSSMAP(0); /* convert address to be 0x8xxxxxxx */
	addr1 = addr;	/* save it..*/
	addr2 = addr + 1048576; /* save ending byte, for speed. */


	for(;addr < addr2;addr+=4)		/* initiate 1st megabytes */
		*((unsigned *)addr) = 0;

	addr = addr1;
	/* ripple a one bit in first location */
	for(tstpat=0x00000001; tstpat>0; tstpat = tstpat << 1)
	{
		*((unsigned *)addr) = tstpat;
		readback = *((unsigned *)addr);
		if(readback != tstpat)
			return(1); /* failed.. sigh. */
	}
	/* ripple a zero bit through first location */
	for(tstpat=0xfffffffe; tstpat!=0xffffffff; tstpat=(tstpat << 1)|0x00000001)
	{
		*((unsigned *)addr) = tstpat;
		readback = *((unsigned *)addr);
		if(readback != tstpat)
			return(1); /* failed.. sigh. */
	}

	tstpat = 0x55555555; /* first pattern.. */
	tstpat1 = 0xaaaaaaaa; /* second pattern.. */
	tstpat2 = 0x0; /* third pattern.. */
	/* now, do a rough content test. */
	for(addr = addr1; addr < addr2; addr+=4) /*first, fill with first pattern.*/
		*((unsigned *)addr) = tstpat;

	for(addr = addr1; addr < addr2; addr +=4) /* now, verify, and fill.. */
	{
		readback = *((unsigned *)addr);
		if(readback != tstpat)
			return(1); /* failed.. sigh. */
		*((unsigned *)addr) = tstpat1;
	}
	for(addr = addr1; addr < addr2; addr+=4) /* now, verify, and fill again.. */
	{
		readback = *((unsigned *)addr);
		if(readback != tstpat1)
			return(1); /* failed.. sigh. */
		*((unsigned *)addr) = tstpat2; /* final clear.. */
	}
	for(addr = addr1; addr < addr2; addr+=4) /* now, verify, and fill again.. */
	{
		readback = *((unsigned *)addr);
		if(readback != tstpat2)
			return(1); /* failed.. sigh. */
	}
	return(0);
}

/*------------------------------------------------------------------------------
	mm_init : intialize a memory module in a give slot.
			  Enable EDAC, parity checking, interrupt generation.
			  Turn off Red LED, and turn on Green LED.
------------------------------------------------------------------------------*/
mm_init(x,y)
char x,y;
{
	char i;
	unsigned int	*INT_INFO_REG= 	(unsigned int *)0x9fffffc0;
	unsigned char *CTL_REG = (unsigned char *)0x9fffffe4;

	if(y) {
		cssmap(MAP01,x,(char)0x0f);	/* don't forget addr! */
		*INT_INFO_REG = 0x80800fa0 | ((*STATUSREG & STAT_SLOTMASK) >> 12);
		*(char *)CTL_REG = MM_INIT;
	}
	else {
		for(i=0; i<16;i++) {
			if(bdhere[i]==MEMHERE) {
				cssmap(MAP01,i,(char)0x0f);	/* don't forget addr! */
				*INT_INFO_REG = 0x80800fa0|((*STATUSREG&STAT_SLOTMASK) >> 12);
				*(char *)CTL_REG = MM_INIT;
			}
		}
	}
}
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
