/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sccint.c: version 25.1 created on 11/27/91 at 14:40:54	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sccint.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
******************************************************************************
**	FILE NAME:	sccint.c
******************************************************************************
*/ 

#include "rwiscc.h"
#include "rwi.h"

char rxdata;					/* buffer for receiver. */

struct scc *sccs[] = {
	SCC0A,
	SCC0B,
	SCC1A,
	SCC1B,
};


/******************************************************************************
 *
 * handle our SCC transmitter interrupts
 *
 ******************************************************************************/
txint(d0,d1,a0,a1,index)
{
	register struct scc *sccptr;

		sccptr = sccs[index];			/* fix up for powerup tests.. */
		sccptr->reg[0].reg = WR0_TXINT; /* reset transmitter interrupt */
		sccptr->reg[0].reg = WR0_RHIUS; /* reset highest int under serv */
		return;							/* all done with this.. */
}


/******************************************************************************
 *
 * handle our SCC receiver interrupts
 *
 ******************************************************************************/

extern struct icbcb icbcb;

rxint(d0,d1,a0,a1,index)
{
	register struct scc *sccptr; /* */

		sccptr = sccs[index];			/* give me the chan number. */
		sccptr->reg[0].reg = WR0_RHIUS; /* reset highest int under serv */
		rxdata = sccptr->reg[0].reg; 	/* read this, if needed. */
		rxdata = sccptr->reg[8].reg; 	/* save the received data for above. */
		return;							/* all done with this.. */
}


/******************************************************************************
 *
 * handle our SCC external/status interrupts
 *
 ******************************************************************************/

exint(d0,d1,a0,a1,index)
{
	register unsigned char rr0;
	register int *bdptr;
	register struct scc *sccptr;

	sccptr = sccs[index];			

	rr0 = sccptr->reg[0].reg;
	printf("Exint entered RR0 = %x\n",rr0);
	sccptr->reg[0].reg = WR0_EXINT; /*reset external status interrupt */
	sccptr->reg[0].reg = WR0_RHIUS; /*reset highest priority int under service*/
}


/******************************************************************************
 *
 * handle our SCC special interrupts
 *
 ******************************************************************************/

spint(d0,d1,a0,a1,index)
{
	register unsigned char rr1;
	register struct scc *sccptr;

	sccptr = sccs[index];			

	printf("Spint entered\n");

	rr1 = sccptr->reg[1].reg;
	sccptr->reg[0].reg = WR0_ERROR; /* reset special interrupt */
	sccptr->reg[0].reg = WR0_RHIUS; /*reset highest priority int un_service */
}


