/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pwrtest.c: version 25.1 created on 11/27/91 at 14:40:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pwrtest.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "misc.h"
#include "globl.h"
#include "spm.h"
#include "rwicio.h"
#include "iom.h"
#include "ioa0.h"
#include "disp.h"
#include "rwi.h"
#include "novram.h"
#include "ipcc.h"

extern unsigned char bdhere[];			/* slots for CSS board's... */
extern char got_berr;		/* added by YVC at 2/1/88 for testing IOM */
extern char emulate;		/* added by YVC at 2/1/88 for testing IOM */
extern char tsterrs;		/* this is set to zero when we want to. */
extern char ignore_it;		/* If set, ignore CSS bus errors. */
extern char cpuack;		/* set if we want to only print out junk. */
extern char ipcctest;		/* set ipcc flag to handle spy test. */
extern unsigned char pwr_test;		/* */
extern unsigned char scsiflag;		/* */
extern unsigned char myslot;			/* This is where I am. */
extern char *pmerr1;			/* PM error messages. */
extern char ram_sl;	/* set to first valid ram slot after test. */
char cputest2;		/* cpu board stage 2 test flag . */
unsigned mailstat;	/* data from id mail byte. */

#define	IF_ESC	if(ifesc()) { cpu_idle(0,0); return; }
#define	IF_ESC1	if(ifesc()) { cpu_idle(0,0); return(1); }
#define	MAILBOX	0xdffffffc

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
cputest(tst)	/* do first stage cpu test for all cpu's. */
int tst;	/* what test numbers to start. */
{
	int i;
	int err;
	int val=0; /* if val is set, we already had one good cpu. */
	char  in;

	if((i = findcpu(1)) == 18)
		return(1);		/* No CPU found. */

	cputest2 = 1;
	for(; i < Sbus_Num_Slot; i++) {  /* find all cpu's, and test them. */
	
		if(bdhere[i] != CPUHERE) {	/* if it's not here.. */	
			continue;		/* Continue to next slot.. */
		}

		switch (tst) {
			case 1:
				err = test1cpu(i);	/* failed test */
				break;
			case 2:
				err = test2cpu(i);	/* failed test */
				break;
			case 3:
				err = test3cpu(i);	/* failed test */
				break;
			default:
				printf("\nProgrammer error. (%d)\n", tst);
				cputest2 = 0;
				return(1);
		}

		if(err)	{			/* it failed the test... */
			bogdis(i);		/* disable this slot. */
			if(!val) {		/* if this is first cpu.. */
			
				if((i = findcpu(0)) == 18) {  
					cputest2 = 0;
					return(1);	/* No more CPU's */
				}
			}
			printf("\nYou have another CPU card.  Continue (y/n)? ");
			in = getchar ();
			if (Yes (in)) {
				cputest2 = 0;
				return (-1);
			}
			printf("\n");
		}
		else 
			val=1;
	}
	cputest2 = 0;
	return(0);	/* say ok to continue. */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
bogdis(slot) /* disable a card in this slot.  show bad card type. */
int slot;
{
	char *st;

	switch(bdhere[slot]) { /* what type of card? */
		case MEMHERE: 
			st = "memory"; 
			break;
		case CPUHERE: 
			st = "cpu"; 
			break;
		case IOMHERE: 
			st = "iom"; 
			break;
		default: 
			st = "unknown"; 
			break;
	}
	emulate = tsterrs = ignore_it = 1;	/* ignore bus errors..*/

	printf("\nError, %s in slot %x (%d) failed.\n", st, slot, slot);

	cssmap(MAP07, (unsigned char)slot, (unsigned char)0x0f);

	ifdisable(0);				/* disable it again.. */
	emulate = tsterrs = ignore_it = 0;	/* enable normal bus errors..*/
	bdhere[slot] = 0xff;			/* clear this entry out. */
}

/*------------------------------------------------------------------------------
	readmail : Monitors the status byte from the PM(s).
			   Changes have been implemented for the SPEC change.
------------------------------------------------------------------------------*/
readmail()	/* read in a mail byte. */
{
	register unsigned *ptr=(unsigned *)MAILBOX;  /* pointer to read from.*/
	unsigned ar[3];		/* three times; for fun. */
	register i, i1=0;			/* counters. */

	while(1) {				/* loop. */

		for(i = 0; i < 3; i++)			/* fill in array.. */
			ar[i] = *ptr & 0x0000ff00;	/* get and save data. */

		if(got_berr) {		
			if(++i1 == 20)		/* If really bad */
				return(1);			

			got_berr = 0;		/* clear bus error flag. */
			continue;		/* loop back... */
		}
		if(ar[0] != ar[1] || ar[0] != ar[2]) { /* some didn't match. */
		
			if(++i1 == 20) 
				return(1);

			i1 = 0;			/* give it a try again.. */
			continue;
		}
		break;			/* it's ok, so break out of loop. */
	}

	mailstat = ar[0];		/* ok, write it out. */
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
test1cpu(slot) /* do phase 1 tests for a single cpu. */
int slot;
{
	int	err_code;
	emulate = 1;				/* skip all bus errors.. */
	got_berr = 0;				/* clear this. */

	cssmap(MAP05, (uchar)slot, (uchar)0xf);

	if(readmail()) {		/* read in the mail byte from array. */
		emulate = 0;		/* clear this. */
		return(1);		/* failed id read, so it's bad. */
	}

	if(mailstat & 0x0000ff00) {	/* mask other bits off.. */

		if(mailstat & 0x00007f00) {	/* mask busy and bad bits */
			err_code = ((mailstat & 0x7F00) >> 8);
			if (err_code < (sizeof(pmerr1) / sizeof(char *)))
				printf("\nPM stage 1 error code: %s\n",
				pmerr1[err_code]);
			else
				printf("\nPM stage 1 error:  Unknown error code.\n");
			emulate = 0;
			return(1);	/* this board failed. */
		}
	}
	emulate = 0;	/* restore bus error handler.. */
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
test2cpu(slot) /* do phase 2 tests for a single cpu. */
int slot;
{
	int i, i1;
	int	err_code;

	cssmap(MAP05, (uchar)slot, (uchar)0xf);

	tsterrs = 0;		/* enable reporting of ack's.. */
	cpuack = 1;		/* show we ARE expecting this. */

	if(ipccsend(slot,IPCC_SM_SLOT,(int)myslot))	/* Send SPM slot. */
		return(1);		

	if(ipccsend(slot,IPCC_MM_SLOT,(int)ram_sl))	/* Send MEM slot. */
		return(1);

	if(ipccsend(slot,IPCC_PM_PUTR,(int)2))		/* Start phase 2 test */
		return(1);

	ignore_it = emulate = tsterrs = 1;	/* disable all bus errors..*/
	cpuack = got_berr = 0;			/* clear these. */

	for(i = 0; i < 0x400; i++) {		/* while waiting.. */
		if(readmail()) {
			printf("\nRead CPU in slot %x mail failed\n",slot);
			ignore_it = emulate = tsterrs = 0; /* enable errors..*/
			return(1);		/* failed, so it's bad. */
		}

		if(!(mailstat & 0x00008000))	/* check busy bit */
			break;		

		for(i1 = 0; i1 < 3000; i1++);	/* pause for a moment */

		if(ifesc()) 
			return(0);	/* allow exiting for next pm. */
	}

	emulate = tsterrs = ignore_it = 0;	/* enable normal bus errors..*/
	if(mailstat & 0x00007f00) {		/* mask busy bit off.. */
		err_code = ((mailstat & 0x7F00) >> 8);
		if (err_code < (sizeof(pmerr1) / sizeof(char *)))
			printf("\nPM stage 2 error code: %s\n",
			pmerr1[err_code]);
		else
			printf("\nPM stage 2 error:  Unknown error code.\n");
		emulate = 0;
		return(1);	/* this board failed. */
	}

	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
test3cpu(slot) /* do phase 3 tests for a single cpu. */
int slot;
{
	int i, i1=0x2fff;
	int	err_code;

	tsterrs = 0;			/* enable reporting of ack's.. */
	cpuack = 1;			/* show we ARE expecting this. */
	ipcctest = 1;			/* Use a different INT handler. */

	cssmap(MAP05, (uchar)slot, (uchar)0xf);

	if(ipccsend(slot,IPCC_SM_SLOT,(int)myslot))	/* Send SPM slot. */
		return(1);

	if(ipccsend(slot,IPCC_MM_SLOT,(int)ram_sl))	/* Send MEM slot. */
		return(1);

	if(ipccsend(slot,IPCC_PM_PUTR,(int)3))		/* Start phase 3 test */
		return(1);

	emulate = tsterrs = ignore_it = 1;		/* disable bus errors */
	cpuack = got_berr = 0;				/* clear these. */

	while(i1--) {

		for(i = 0; i < 5000; i++);
		if(readmail()) {	/* read in the mail from array. */
			emulate=tsterrs=ignore_it=0;	/* enable errors..*/
			printf("\nFailed while reading mailbox register.\n");
			return(1);	/* failed id read, so it's bad. */
		}

		if(ifesc()) 
			break;

		if(!(mailstat & 0x00008000))	/* check busy bit */
			break;	

		if(ifesc()) 
			return(0);		/* allow exiting for next pm. */
	}
	emulate = tsterrs = ignore_it = 0;	/* enable normal bus errors..*/

	if((!i1) || (i1<0)) {
		printf("\nTimed out on stage 3:\n");
		printf("Mail status is %x.\n",mailstat);
		return(1);
	}

	if(mailstat & 0x7f00) 	{	/* mask busy & error bits off.. */
		err_code = ((mailstat & 0x7F00) >> 8);
		if (err_code < (sizeof(pmerr1) / sizeof(char *)))
			printf("\nPM stage 3 error code: %s\n",
			pmerr1[err_code]);
		else
			printf("\nPM stage 3 error:  Unknown error code.\n");
		emulate = 0;
		return(1);	/* this board failed. */
	}

	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iomtest()	/* do iom tests, one at a time. */
{
	int i;
	int err;
	int val=0;	/* if val is set, we already had one good iom/ioa. */
	char	in;

	if((i = findiom(1)) == 18) 
		return(1);		/* no iom/ioa pairs. */

	for(; i != Sbus_Num_Slot; i++) { /* find all iom's, and test them. */
	
		if(bdhere[i] != IOMHERE)  	/* if it's not here.. */	
			continue;		/* next slot.. */
		
		pwr_test = 1;	/* set for yung's stuff. */
		if(iom1test(i)) { /* failed test */
			pwr_test = 0;	/* back to normal. */
			bogdis(i); 	/* disable this slot */
			if(!val) {	/* if this is first iom */
				if((i = findiom(0)) == 18) 
					return(1);	/* no more iom's. */
			}
			printf("\nYou have another IOM card. Continue (y/n)? ");
			in = getchar ();
			if(Yes (in)) 
				return(1); 
		}
		else if(test1ioa(i, ram_sl))  { /* failed test */
		
			pwr_test = 0;	/* back to normal. */
			bogdis(i); 	/* disable this slot */
			if(!val) {	/* if this is first iom/ioa... */
			
				if((i = findiom(0)) == 18) 
					return(1);	/* no more iom's. */
			}
			printf("\nYou have another IOM/IOA pair. Continue (y/n)?");
			in = getchar();
			if (Yes (in)) 
				return(1); 
		}
		pwr_test = 0;	/* back to normal. */
		val=1;
	}
	return(0);	/* say ok to continue. */
}
	
int
cpu_test ()
{
	printf("\rStage 1 CPU powerup.          ");
	if(cputest(1)) { 
		cpu_idle(0,0); /* if failed 1st stage test.. */
		return(1); 
	}	

	IF_ESC1

	printf("\rStage 2 CPU powerup.          ");
	if(cputest(2)) { 
		cpu_idle(0,0); /* if failed 2nd stage test.. */
		return(1);	
	}	

	IF_ESC1

	printf("\rStage 3 CPU powerup.          ");
	if(cputest(3)) {	
		ipcctest = 0; /* failed third stage tests.. */
		return(1);
	}

	return(0);
}

