/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pwroff.c: version 25.1 created on 11/27/91 at 14:40:45	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pwroff.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "rwi.h"
#include "rwicio.h"
#include "novram.h"
#include "spm.h"

struct cio *cur_cioptr;
char pwrcmd = 0;

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
do_off_pwr() 
{				/* Turn off the power for sub routine. */
	pwrcmd = 1;		/* Turn off power now. */
	ck_pwr_on();		/* actually do the command. */
}

/*------------------------------------------------------------------------------
		This routine should decide on what to do with the power.
		Depending on 5 things : keywas, cmdwas, powmain(), key().
------------------------------------------------------------------------------*/
ck_pwr_on()
{
	struct cio *cioptr = CIO_0;
	unsigned char port_data;

	if((!key()) || (pwrcmd==1))
		pwr_off();				/* turn power off. */
}

/*------------------------------------------------------------------------------
			Get the current key position.
------------------------------------------------------------------------------*/
key()
{ 
	struct cio *cioptr = CIO_0;
	int k;
	k=(cioptr->portdata[PORTC].reg & ON_SW);
	return(k);
}

/*------------------------------------------------------------------------------
		Set the novram->cmdwas flag and change clock to cause a reset. 
------------------------------------------------------------------------------*/
pwr_off()
{
	register struct novram *novram = NOVRAM;
	struct cio *cioptr = CIO_0;
	unsigned int k = 0;
	unsigned int stat;

	*WRCNTL1 &= ~WR1_CSSRST;			/* assert css reset. */
	printf("\nSwitching to the Local Clock for power-off\n");
	novram->cmdwas = 1;			/* make sure power goes off.. */
	*WRCNTL1 &= ~(WR1_RRDY|WR1_ID_RST); /* assert cpu.res.ready,disp.res. */
	*WRCNTL1 |= (WR1_DREQ);			/* deassert cpu.disp.req */
	*CLKCNTL = 0x00000000;			/* just switch to local clock */
	for(k=0; k<400000; k++);		/* wait for reset */
	printf("Did not receive a reset when switching clocks.\n");
}

/*------------------------------------------------------------------------------
				Handle our CIO port A bit interrupts
------------------------------------------------------------------------------*/
pportaint(d0,d1,a0,a1,index)
{
	register struct cio *cioptr;

	cioptr = cur_cioptr; 	/* Yes we are taking the current cio. */
	cioptr->portcs[0].reg = ICW_CPUS; /* Clear int pend & int under serv. */  
	cioptr->portcs[0].reg = ICW_CIUS; /* Reenable interrupts. */
	ck_pwr_on();			  /* Always check this.. */
}

/*------------------------------------------------------------------------------
				Handle our CIO port B bit interrupts
------------------------------------------------------------------------------*/
pportbint(d0,d1,a0,a1,index)
{
	register struct cio *cioptr = cur_cioptr;

	cioptr = CIO_0;
	cioptr->portcs[1].reg = ICW_CPUS; /* clr int pending & int under serv */
	cioptr->portcs[1].reg = ICW_CIUS; /* reenable interrupts */
}

/*------------------------------------------------------------------------------
		interrupt service routine for our counter timers 
------------------------------------------------------------------------------*/
ctint()
{
	register struct cio *cio_ptr = cur_cioptr;
	register unsigned int timer_ints, timer_num;

	timer_ints++;
	cio_ptr->ctcs[timer_num].reg = ICW_CPUS | CT_GCB; 
	cio_ptr->ctcs[timer_num].reg = ICW_SIE; 
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
