/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) powerup.c: version 25.1 created on 11/27/91 at 14:40:37	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)powerup.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "misc.h"
#include "globl.h"
#include "spm.h"
#include "rwicio.h"
#include "iom.h"
#include "ioa0.h"
#include "disp.h"
#include "rwi.h"
#include "novram.h"

#define	IF_ESC	if(ifesc()) { cpu_idle(0,0); return; }
#define	MAILBOX	0xdffffffc

extern	int  iopm_present;
extern unsigned char bdhere[];		/* slots for CSS boards */

extern unsigned char scsiflag;		/* scsi present flag */

#ifdef	SPM_PROM
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pwr_chk()	/* check if power switch is on */
{
	struct cio *cioptr = CIO_0;
	unsigned char key_position;

	key_position = key();		/* get current key setting. */

	if(key_position == KEY_OFF) {	
		printf("\nPlease turn key to 'ON' position when ready to \n");
		printf("     continue, or press ESC to enter local monitor.\n");

		while(!ifesc()) { /* loop until key on, or ESC depressed. */

			if(key_position == KEY_ON)   /* Is key on yet? */
				break;	/* YES - break loop */
			else		/* NO - do another read */
				key_position = key ();
		}
	}
	cioptr->portcs[0].reg = ICW_CPUS;   
	cioptr->portcs[0].reg = ICW_CIUS;	/* re-enable interrupts */
	nvrwichk();				/* Check and adjust rwi stuff */
	if(pwr_on()) 				/* Go turn main power on. */
		return(0);
	adelay2(); 				/* do a small delay */
	if(powmain()) {				/* If it fails */
		pwr_off(); 			/* kill all main power now. */
		printf("Main power failed.  Entering local monitor.\n");
		return(0);
	}
	return(1);	/* it's ok to switch clocks now. */
}
#endif

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
autoboot()	
{
	char 	save_path;
	register struct novram *ptr = (struct novram *)NOVRAM;
	unsigned int i, i1;
	char  *bootstr;

	ptr->diag_fly_by = 1;
	return;
}

start_main()
{
	int i;
	int iom_cnt;

	if(clokpr(0)) 
		return;

	iopm_present = 0;

	printf("\rResetting CSS bus.             ");
	css_reset();			/* Do a reset to the css bus. */

	pollslot(0);				

	printf("\rChecking IOPM responses.");
	if (iopm_present)
		check_iopm_magic();

	IF_ESC

	printf("\rChecking system configuration.");
	if((iom_cnt = ck_css_config()) == 0xFF)	{ /* returns number of IOM's */
		printf("\nBad system configuration detected.\n");
		cpu_idle(0,0);
		softreset();
	}

	IF_ESC

	printf("\rTesting 1st Megabyte Memory.  ");
	firstram();				/* find first memory board */

	if (iom_cnt) {
		printf("\rIOM/IOA test.                 ");
		if(iomtest()) {		/* do the iom tests in the meantime */
			cpu_idle(0,0);
			softreset();
		}
	}

	IF_ESC

	if (!ck_dpm_present()) {
		if (cpu_test())
			softreset();
		IF_ESC

		printf("\rSizing memory.                ");
		sizemem(0);			/* let's build tables */
	}
	IF_ESC

	if (iom_cnt) {
		printf("\rInitializing and Polling ICB slots.");
		poll_io_slot(0);		/* Reinit the table and poll. */
		for(i = 0; i < 0x280000; i++);	/* time to recover. */

		poll_io_slot(1);		/* Load the table. */

		if(scsiflag) {
			printf("\nWaiting for SCSI drive to spin up.");
			scsiwait();
		}
	}

	IF_ESC

	printf("\rSetting PM(s) to idle mode.     ");
	cpu_idle(0,0);				/* Tell pm boards to idle. */

	printf("\rConfiguration check.               ");
	novchk();			/* Go check on nov_ram configuration. */
	autoboot();			/* Autoboot the default code. */

#if 0
	softreset();
#endif
}

