/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pollio.c: version 25.1 created on 11/27/91 at 14:40:32	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pollio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "icb.h"
#include "vreg.h"
#include "mac.h"
#include "icb_config.h"
#include "spm.h"
#include "menu.h"
#include "ioa0.h"
#include "disp.h"
#include "vac.h"
#include "novram.h"

#define Sbus_Num_Slot			16		/* Max Sbus Slot. */

extern char got_berr;				/* */
extern char emulate;				/* */
extern unsigned char bdhere[];			/* css slots */
extern char ignore_it;				/* ignore CSS bus errors. */

struct icb_config	io_conf[MAX_SSIO][MAXSLOTS];
unsigned char   dtbid;
unsigned char 	xdtbid;
unsigned char 	scsiflag;


/*------------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
poll_io(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot;
	register	i;

	printf ("Poll I/O slots.\n");
	poll_io_slot(0);			/* fix up this stuff. */
	for(i = 0; i != 0x280000; i++);		/* tgm s/b 0x200000, delay? */
	poll_io_slot(1);			/* call routine */
	if(scsiflag)			/* check scsi after init other slots */ 
		scsiwait();
}

/*------------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
poll_io_slot(flg)	/* poll the io subsytem slots */
char flg;
{
	short		i,j;
	unsigned char	id;
	unsigned char	iom_num;
	unsigned int	nm;
	struct icb	*icbadd;
	struct mac	*macptr;

	emulate = 1;	/* set quiet buserror stuff. */
	iom_num = 0;
	ignore_it = 1;	/* enable ignoring of bus errors..*/

	if(!flg) {	/* Initialiaze the stuff */
		for(i = 0; i != MAX_SSIO; i++)	{
			for(j = 0; j != MAX_IO_SLOT; j++) {
			    io_conf[i][j].iomslot = 0;
			    io_conf[i][j].icb_slot_id = (unsigned char)0xff;
			    io_conf[i][j].bdptr = (struct bd_desc *)0;
			    io_conf[i][j].iop_base = (struct icb *)0;
			}
		}
		scsiflag = 0;
	}

	for(i = 0; i != Sbus_Num_Slot; i++) {	/* all slots */
		if(bdhere[i] == IOMHERE) {
			dtbid = 4;
			xdtbid = 0x10;

			cssmap(MAP00, (unsigned char)i, 0x00);

			for(j = 0; j != MAX_IO_SLOT; j++) { /* Max 19 slots */
				got_berr = 0;	/*  clear bus error flag */
				nm = j + (SLOTSTART >> SLOTSHFT);
				icbadd = (struct icb *)
						((nm << SLOTSHFT) | 0x80000000);
				id = icbadd->bdtypreg;
				if(got_berr)	{ /* if bus error, no board */
					continue;	/* skip this slot */
				}
				id = id & 0x1f;	/* board id */
				switch (flg)	/* check board id */
				{
				case 0:
					switch (id)	/* check board id */
					{
	   				case VACBDTYP:	/* vac board */
					       	vacinit(id,i,j,icbadd,iom_num);
						break;
	   				case EDT:	/* edt board */
	   				case HSDT:	/* high speed edt */
						break;
	   				case SCSI:	/* SCSI board */
						scsiflag = 1;  
						break;
	   				case GCP:	/* gc board */
	   				case EGCP:	/* gc16 board */
						icbadd->intreg = 0x2040 | j;
						break;
	   				case MAC:	/* mac board */
						macptr = (struct mac *)icbadd;
						macptr->rstreg = MACRESET;
						break;
					default:
						printf("Unknown board slot:%x \n",j);
						break;
					}
					break;
				case 1:
					switch (id)	/* check board id */
					{
	   				case EDT:	/* edt board */
	   				case SCSI:	/* SCSI board */
	   				case HSDT:	/* high speed edt */
	   				case GCP:	/* gc board */
	   				case EGCP:	/* gc16 board */
						init_desc(id,i,j,icbadd,iom_num);
						break;
	   				case MAC:	/* mac board */
						macptr = (struct mac *)icbadd;
						macptr->rstreg = 0;
						macptr->intreg = MACINTPRI;
						iobd_info(id,i,j,icbadd,iom_num);
						break;
					default:
						break;
					}
					break;
				}
			}
		iom_num++;
		}
	}
	emulate = got_berr = 0; /* make sure these are cleared again. */
	ignore_it = 0;	 	/* disable ignoring of bus errors..*/
}

iobd_info(bdid,io_sys,io_slot,icbadd,iom_num)
char	io_sys;
short	io_slot;
unsigned char bdid,iom_num;
struct icb	*icbadd;
{
	struct		icb_config	*icbp;


/* Store the board information in io_config */
	icbp = &io_conf[iom_num][io_slot];
	icbp->iomslot = (char)io_sys;		/* IO module slot */
	icbp->icb_slot_id = bdid;	/* Board id info */
	icbp->iop_base = icbadd;		/* ICB base address */
}

init_desc(bdid,io_sys,io_slot,icbadd,iom_num)
char	io_sys;
short	io_slot;
unsigned char bdid,iom_num;
struct icb	*icbadd;
{
	struct		icb_config	*icbp;
	struct		bd_desc		*bdp;
	unsigned	int		*header;
	struct	 	icb	*icbbase;

/* Use map 0 to address ICB base address from service module */
/* Set ICB base address for the board */
	icbbase = icbadd;
	header = (unsigned int *)((unsigned)icbadd + BDVECT);
	/* Get board descriptor pointer */
	bdp = (struct bd_desc *)(((*header&LWWORD)+(io_slot*IO_OFST))|IO_MAP0);

	if (bdid != SCSI) {
		if(!time(2000,&icbbase->tasreg,TASBIT,0))
		{
resetslot:
/*
* halt the board
*/
			icbbase->intreg = HLTIOP;
			switch (bdid)	{	/* check board id */
		   		case EDT:	/* edt board */
					printf("EDT ");
					break;
		   		case HSDT:	/* high speed edt */
					printf("HSDT ");
					break;
		   		case GCP:	/* gc board */
					printf("GCP ");
					break;
		   		case EGCP:	/* gc16 board */
					printf("EGCP ");
					break;
		   		case MAC:	/* mac board */
					printf("MAC ");
					break;
				default:
					printf("Unknown board ");
					break;
				}
			printf("in ICB slot %x IOM in CSS slot %x does not respond...\n",io_slot,io_sys);
			return;
		}
	}
	bdp->bd_slot = io_slot;
	bdp->bd_icbint = 1;
	if((bdid == EDT) || (bdid == HSDT) || (bdid == SCSI)) {
		bdp->bd_dtbid = dtbid++;
		bdp->bd_xdtbid = xdtbid++;
	}
	if (bdid != SCSI) {
		icbbase->tasreg = 1; /* clear TAS */
		if ((bdid == EDT) || (bdid == HSDT))
			bdp->bd_opt = S90;   /* set up S90 flag into board */
		if(!ivrupdt(icbbase)) 
			goto resetslot;
	}
	else {
		icbbase->tasreg = 1; /* clear TAS */
		bdp->bd_opt = S90;   /* set up S90 flag into SCSI board */
	}
		
/* Store the board information into io_config */
	icbp = &io_conf[iom_num][io_slot];
	icbp->iomslot = (char)io_sys;		/* IO module slot */
	icbp->icb_slot_id = bdid;	/* Board id info */
	icbp->bdptr = bdp;			/* Board descriptor pointer */
	icbp->iop_base = icbbase;		/* ICB base address */
}

/*
	Changed the routine to use the info in the io_conf structures,
	previosly, the io subsystem was polled twice, now poll_io_slot
	does the polling and this uses that data.
*/
scsiwait()	/* poll the io subsytem slots */
{
	unsigned char	iom_num;
	unsigned char	icb;
	struct icb	*icbadd;
	unsigned	int		*header;
	struct		bd_desc		*bdp;
	unsigned        delay;
	unsigned char   slot;

	scsiflag = 0;	/* 08/16/88 alan */

	/*	All io_conf structures 	*/
	for (iom_num = 0; iom_num != IOM_PER_SYS; iom_num++) {


		for (icb = 0; icb != MAX_IO_SLOT; icb++) {
			
			/*	if SCSI do this stuff, else next structure */
			if (io_conf[iom_num][icb].icb_slot_id == SCSI) {

				slot = (uchar)io_conf[iom_num][icb].iomslot;
				cssmap(MAP00, (unsigned char)slot, 0x00);
				icbadd = io_conf[iom_num][icb].iop_base;
				bdp = io_conf[iom_num][icb].bdptr;

				header = (unsigned int *)
					((unsigned)icbadd + BDVECT);

				if(!time(2000,&icbadd->tasreg,TASBIT,0)) {
resetslot:
					icbadd->intreg = HLTIOP;
					printf("\nI/O subsytem in CSS slot %x SCSI in ICB slot %x does not respond...\n",io_conf[iom_num][icb].iomslot,icb);
					return;
				}

/*	delay = 2000000; will be modified before last release: halan */
				delay = 3000000; /* */
				while (delay--) {
					if (!delay) {
						printf("SCSI powerup test time-out\n");
						goto resetslot;
					}

					if (bdp->bd_stst == STCMPLT) {
						bdp->bd_opt = S90; 	/* in S90 system , extra*/
						break;
					}
				}
				icbadd->tasreg = 1; /* clear TAS */
				if(!ivrupdt(icbadd))
					goto resetslot;
			}
		}				
	}
}

ivrupdt(icbbase) 
struct	 icb	*icbbase;
{
    register	status;


    icbbase->intreg = (IVRUPDT | INTIOP);
    if(!time(500,&icbbase->bdtypreg,IOPIPND,IOPIPND))
        status = 0;
    else    
	status = icbbase->intreg; /* clear the interrupt */
    return(status);
}


time(howlong,location,mask,value) 
unsigned char *location, mask, value; 
{
    int i, j;

    for(i=0; i != howlong; i++) {
        for(j=0; j != 50; j++) {
            if((*location & mask) == value)
                return(1);
        }
    }
    return(0);
}


iotbl(comm_str,arg_cnt)	/* show icb configurations */
char *comm_str;
int arg_cnt;
{
	short		i,j;
	unsigned char	id,iom_num;
	struct		icb_config	*icbp;

	iom_num = 0;
	for(i = 0; i != Sbus_Num_Slot; i++) {	/* find IO module */
		if(bdhere[i] == IOMHERE) {
			for(j = 0; j != MAX_IO_SLOT; j++) { /* check io slot */
				icbp = &io_conf[iom_num][j];
				id = icbp->icb_slot_id;	/* Board id info */
				switch (id)	{	/* check board id */
	   				case VACBDTYP:	/* vac board */
					   printf("VAC    ");
					   break;
	   				case EDT:	/* edt board */
					   printf("EDT    ");
					   break;
	   				case SCSI:	/* SCSI board */
					   printf("SCSI   ");
					   break;
	   				case HSDT:	/* high speed dt */
					   printf("HSDT   ");
						break;
	   				case EGCP:	/* gc16 board */
	   				case GCP:	/* gc board */
					   printf("GC     ");
					   break;
	   				case MAC:	/* mac board */
					   printf("MAC    ");
					   break;
					default:
						continue;
						break;
				}
			printf("Module, IOM 0x%x CSS slot 0x%x (%d) ICB slot 0x%x (%d)\n",
			iom_num, i, i, j, j);
			}
		iom_num++;
		}
	}
}


vacinit(id,i,j,icbadd,iom_num)
char	i;
short	j;
unsigned char id,iom_num;
struct icb	*icbadd;
{
	int temp;
	struct vac 	*vacptr;
	struct icb_config 	*icbp;

	icbp=&io_conf[iom_num][j];
	icbp->iomslot = (char)i;
	icbp->icb_slot_id = id;
	icbp->iop_base = icbadd;
	vacptr = (struct vac *)icbadd;
	/* reset vac & set yellow led */
	vacptr->vac_reset_id = VAC_SRST;
	/* read stat reg is SYSOK set */
	temp = vacptr->vac_icb_stat;	
	if(!(temp & VAC_SYS_OK)) {
		/* if SYSOK then unreset vac */
		/* turn off yellow led and turn on green led */
		vacptr->vac_reset_id = 0;	
		temp = (VAC_RUN_LED |VAC_NRM_LED| 90);
		vacptr->vac_reset_id = temp;	
	}	
	else {
		printf(" ERR - SYSOK not set on VAC \n ");
	}
}

/*---[tgm]----------------------------------------------------------------------
	logiom: Logical IOM number. This will return the logical IOM number
			given the PHYSICAL IOM slot location.
------------------------------------------------------------------------------*/
logiom(pslot)
register char pslot;
{
	char slot, lslot;

	if (bdhere[pslot] != IOMHERE) {	/* Is there an IOM in slot */
		printf ("No IOM in slot %x\n", pslot);
		return (-1);
	}

	for(slot = lslot = 0; slot != Sbus_Num_Slot; slot++) { /* All Slots. */
		if(bdhere[slot] == IOMHERE) 
			lslot++;
		if(slot == pslot) 
			break;
	}

	return(lslot-1);
}

/*---[tgm]----------------------------------------------------------------------
	Locate_def: Locate the default pathname of a valid IOM and CONTROLLER.
------------------------------------------------------------------------------*/
locate_def(path)
unsigned char path[];
{
	register struct	 icb_config	*icb_ptr;
	register char slot=0, id=0;
	char b[3];
	char	found = 0;
	char	iom = 0;
	char	css;

	for(css = 0; !found && css != Sbus_Num_Slot; css++) { 	/* All Slots. */
		if(bdhere[css] != IOMHERE)		/* Get 1st IOM card. */
			continue;				/* Got one. */

		for(slot = 0; slot != MAX_IO_SLOT; slot++) {	/* all slot */
			icb_ptr = &io_conf[iom][slot];
			id = icb_ptr->icb_slot_id;		/* Bd id info */
			if((id==EDT)||(id==HSDT)||(id==SCSI)) {
				found = 1;
				break;
			}
		}
	}

	if(slot == MAX_IO_SLOT || css == Sbus_Num_Slot)	/* Did not find any. */
		return(1);			/* Return with an error. */

	itoa(css ,b);					/* Convert to ASCII. */
	strcpy(path,b);
	strcpy(&path[strlen(path)],"/");

	itoa(slot,b);				/* Convert into ASCII. */
	strcpy(&path[strlen(path)],b);
	strcpy(&path[strlen(path)],"d0");

#ifdef DEBUG
	printf("1.) locate_def: slot=%d  path=%s\n",slot,path);
#endif

	return(0);
}
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/

