/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pollcss.c: version 25.1 created on 11/27/91 at 14:40:28	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pollcss.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*------------------------------------------------------------------------------
	pollcss.c 
------------------------------------------------------------------------------*/
#include "types.h"
#include "global.h"
#include "disp.h"
#include "spm.h"
#include "novram.h"

extern unsigned char bdhere[];		/* slots for CSS board's */
extern unsigned char myslot;
extern struct novram *novram;		/* Point to the novram */
extern char got_berr;		/* Bus error flag */
extern char emulate;		/* Bus error emulation flag */
int	iopm_present;
char ignore_it;			/* If set, ignore CSS bus errors. */
char validmap;			/* show a poll slots has been done. */
char bussv;			/* Bus save */
char tsterrs;			/* Bus error flag */

struct slotst sf;

char *MEM_TYPE [] = {
	"UNKNOWN SIZ",
	"(8 Meg)    ", 
	"(16 Meg)   ", 
	"(32 Meg)   ", 
	"           ",
	"(32 Meg)   ", 
	"(64 Meg)   ", 
	"(128 Meg)  ", 
};
#define		MAX_MEM_TYPE	7

/*------------------------------------------------------------------------------
	pollsl : Poll slots, and leave enabled/disabled.
------------------------------------------------------------------------------*/
pollsl(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{

#ifdef	SPM_PROM
	printf("Polling CSS slots; disabled");
	pollslot(1);				/* build a css table, disable */
	printf("\rPolling CSS slots; enabled\n");
	pollslot(0);				/* build a css table, enable */
#endif

#ifdef	SPM_IMAGE
	printf("Resetting CSS bus");
	css_reset();			/* Do a reset to the css bus. */
	printf("\rPolling CSS slots; enabled\n");
	pollslot(0);			/* build a css table, enable */
#endif

	return(0);
}

/*------------------------------------------------------------------------------
	slotson : Enable only slots valid in current table.
------------------------------------------------------------------------------*/
slotson()	/* enable only slots valid in current table. */
{
	register i;

	if(clokpr(0)) 				/* fails. */
		return;
	if(!validmap) {				/* If not valid, poll css */
		printf ("Current map not valid executing pollslot\n");
		pollslot(1);			/* go enable them all */
	}

	emulate = tsterrs = ignore_it = 1;	/* ignore bus errors. */
	for(i = 0; i < Sbus_Num_Slot; i++)	/* check out table */
		if((bdhere[i]!=NOBOARD) && (i!=myslot)) {
			cssmap(MAP00, (unsigned char)i, 0x0f);
			ifenable(0);		/* enable the slot */
			sf.on[i] = 1;		/* Enable this slot */
		}
	emulate = got_berr = tsterrs = ignore_it = 0;	/* make sure it's off */
}

/*------------------------------------------------------------------------------
	pollslot : Poll the css slots, for boards.
------------------------------------------------------------------------------*/
pollslot(off)
int off;			/* if set, leave the boards disabled */
{
	register	i, i1, x;
	int	cnt;
	register unsigned *bdstat = (unsigned *)0x8ffffffc;

	if(init_css()) 
		return;
	emulate = 1;			/* set quiet 68020 buserror flag */
	tsterrs = ignore_it = 1;	/* ignore bus errors */

	for(i = 0; i < Sbus_Num_Slot; i++) {	/* enable each slot */
		if(i == myslot) 
			continue;
		cssmap(MAP00, (unsigned char)i, 0x0f);
		ifenable(0);		/* enable css slot */
		if(novram->newpwr) {	/* is this new power? */
			ifdisable(0);	/* 68030 requires 100ms init reset */
			for (cnt = 0; cnt != 0x20000; cnt++);
			ifenable(0);		/* enable css slot */
		}
	}
	for(i1 = 0; i1 < 4000; i1++);	/* allows cpu's to come up */

	for(i = 0; i < Sbus_Num_Slot; i++) {	/* read each slot_id */
		cssmap(MAP00, (unsigned char)i, 0x0f);
		got_berr = 0;		/* ensure I can see bus error */
		i1 = *bdstat;			/* read board id */
		if(got_berr) {			/* if bus error, no board */
			got_berr = 0;		/* clear it again */	
			sf.on[i] = 0;		/* Initialize this slot flag */
			bdhere[i] = NOBOARD;	/* Initialize the table */
			continue;		/* and skip this slot */
		}
		i1 &= BDIDMASK;			/* save only board id */
		bdhere[i] = (uchar)i1;		/* found a board */
/* printf ("%1x:  %2x\n",(char)i, (uchar)i1); */
		if((bdhere[i] & BDTYPEMASK) == MEMTYPE)
			mm_init(i,1);

		if((bdhere[i] & BDTYPEMASK) == IOPTYPE && !off) {  /* IOPM */
			ifdisable(0);	/* '030 requires 520 clk cycle reset */	
			for(i1 = 0; i1 < 4000; i1++);
			ifenable(2);
			iopm_init(i);
			ifenable(1);
			iopm_present = 1;
		}

		sf.on[i] = 1;			/* Slot enabled Switch */	
	}
	if (off) {				/* Disable all boards */
		for(i = 0; i != Sbus_Num_Slot; i++) {	
			if(i == myslot) 		/* skip SPM */
				continue;
			cssmap(MAP00, (unsigned char)i, 0x0f);
			ifdisable(0);  /* '030 requires 520 clk cycle reset */	
			sf.on[i] = 0;			/* Disable this slot. */
		}
	}
	validmap = 1;				/* show it's valid now. */
	tsterrs = ignore_it = 0;		/* Clear the ignore flags */
	emulate = got_berr = 0; 		
	novram->newpwr = 0;			/* Indicate old power. */
	
}


show_css_table ()
{
	int	i, arg;
	unsigned char i1, i2;
	char	opt_string[16];

	for(i = 0; i < Sbus_Num_Slot; i++) {	/* loop all slots. */
		opt_string[0] = '\0';
		switch(bdhere[i] & BDTYPEMASK) {
			case SPMTYPE: 
				printf("SPM    ");
				break;
			case MEMTYPE: 
				printf("MM     ");
				/* read id, and move it down */
				arg = bdidsl(i); 
				arg = (arg &0x00000700) >> 8;
				if (arg > MAX_MEM_TYPE) 
					arg = 0;
				strcpy (opt_string, MEM_TYPE[arg]);
				break;
			case CPUTYPE: 
				printf("PM     ");
				break;
			case DPMTYPE: 
				printf("DPM    ");
				break;
			case IOMTYPE: 
				printf("IOM    ");
				break;
			case IOPTYPE: 
				printf("IOPM   ");
				break;
			case VAMTYPE: 
				printf("VAM    ");
				break;
			case NOBOARDTYPE:
				continue;
				break;
			default: printf("UNKNOWN"); break;
		}
		printf(" module in slot 0x%x (%d) %s\n", i, i, opt_string);
	}
}

/*------------------------------------------------------------------------------
	bdidsl : Read the board id, but don't disturb map ram.
------------------------------------------------------------------------------*/
bdidsl(slot)
int slot;
{
	unsigned *ptr1 = (unsigned *)0x8ffffffc;	/* board id pointer. */
	unsigned char was;
	unsigned id;

	was = cssmap_save(MAP00);
	cssmap (MAP00, (unsigned char)slot, 0x0f);
	id = *ptr1;					/* Get data. */
	cssmap_restore (MAP00, was);
	return(id);					/* And send it back. */
}

/*------------------------------------------------------------------------------
	ifenable :	Enable the slot and interface to a slot.
			flg == 0:  enable module and i/f
			flg == 1:  enable module
			flg == 2:  enable i/f
------------------------------------------------------------------------------*/
ifenable(flg)
char flg;
{
	register i, d=50000;		/* changed to bypass 68020 bug.. */
	int *bog=(int *)0x8ffffffc; 	/*pointer for sending commands*/
	bussv = got_berr;			/* Save state. */

	_cache(0);			/* Disable 68020 cache. */
	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE);	/* Clear force response bit. */

	if(flg==0 || flg==1) { /* enable slot */
		*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | MODULE_ENABLE; 
		*bog = 0;				
		for(i = 0; i < d; i++);
	}

	if(flg==0 || flg==2) { /* enable interface */
		*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | IF_ENABLE; 
		*bog = 0;				
		for(i = 0; i < d; i++);
	}

	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE);	/* turn off forced stuff. */
	_cache(1);				/* Enable 68020 cache. */
	got_berr = bussv;			/* Restore state. */
}

/*------------------------------------------------------------------------------
	ifdisable :	Disable the slot and interface to a slot.
			flg == 0:  disable module and i/f
			flg == 1:  disable module
			flg == 2:  disable i/f
------------------------------------------------------------------------------*/
ifdisable(flg)
char flg;
{
	register i, d = 40000;	/* register variables to bypass 68020 bug.. */
	int *bog = (int *)0x8ffffffc; /*pointer for sending commands*/
	bussv = got_berr;			/* Save state. */

	_cache(0);				/* Disable 68020 cache. */
	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE);	/* Clear force response bit. */
	if(flg==0 || flg==2) { /* disable interface */
		*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | IF_DISABLE;
		*bog = 0;	
		for(i = 0; i < d; i++);
	}

	if(flg==0 || flg==1) { /* disable slot */
		*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | MODULE_DISABLE;	
		*bog = 0;
		for(i = 0; i < d; i++);
	}
	if(flg==0 || flg==2) { /* enable interface */
		*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | IF_ENABLE; 
		*bog = 0;				
		for(i = 0; i < d; i++);
	}

	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE);	/* Turn off forced stuff. */
	_cache(1);				/* Enable 68020 cache. */
	got_berr = bussv;			/* Restore state. */
}

/*------------------------------------------------------------------------------
	findiom : Find first iom board slot number, and return it.
------------------------------------------------------------------------------*/
findiom(prt)
int prt;
{
	int i;

	if(!validmap)   /* if not valid make a table */
		pollslot(0);

	for(i = 0; i < Sbus_Num_Slot; i++)		/* All slots */
		if(bdhere[i] == IOMHERE)		/* Found one.. */
			return(i);			/* Send it back. */
	if(prt)
		printf("Could not find IOM card.\n");
	return(18);					/* Return bad status. */
}

/*------------------------------------------------------------------------------
	findmem : Find first mem board slot number.
------------------------------------------------------------------------------*/
findmem(prt)
int prt;
{
	int i;

	if(!validmap)   /* if not valid make a table */
		pollslot(0);

	for(i = 0; i < Sbus_Num_Slot; i++)		/* All slots */
		if(bdhere[i] == MEMHERE)		/* Found one.. */
			return(i);			/* Send it back. */

	if(prt)
		printf("Could not find RAM card.\n");
	return(18);					/* Return bad status. */
}

/*------------------------------------------------------------------------------
	findcpu : Find first cpu board slot number.
------------------------------------------------------------------------------*/
findcpu(prt)
int prt;
{
	int i;

	if(!validmap)   /* if not valid make a table */
		pollslot(0);

	for(i = 0; i < Sbus_Num_Slot; i++)		/* All slots */
		if(bdhere[i] == CPUHERE)		/* found one.. */
			return(i);			/* send it back. */

	if(prt)						/* allowed to print. */
		printf("Could not find CPU card.\n");
	return(18);					/* Return bad status. */
}

/*----------------------------------------------------------------------------*/

