/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pmrmw.c: version 25.1 created on 11/27/91 at 14:40:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pmrmw.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*------------------------------------------------------------------------------
	pmrmw.c
------------------------------------------------------------------------------*/
#include "ipcc.h"
#include "pm.h"

#define ESC 0x1b
#define MAP04	04		/* Map ram 4, Used for BUSLOCK test. */

extern struct pmslt s[];
extern unsigned char procerr;
extern unsigned char myslot;

static unsigned char mmslot, pasc;
static unsigned int loop; 

extern char *gets ();

/*------------------------------------------------------------------------------
	pmrmw() : PM Read Modify Write test menu.
------------------------------------------------------------------------------*/
pmrmw() 
{
	register x;
	char b[10];
	unsigned char esc=0, c[4];
	c[0] = (char)0;
	
	if(mmsel(1)) { anykey(); return(0); }
	mmslot = s[0].mms;
	loop = 0;

	while(1) {
		clscrn(5);
		cline('-',"[ PM Read/Modify/Write Test Menu ]");
		pmhder(0);			/* Print the menu header. */
		clscrn(1);
		printf("    s.) Start the test(s).\n");
		printf("    m.) Select Memory Board.\n");
		printf("    p.) Select PM(s) for Testing.\n");
		printf("    l.) Set Number of Loop(s)\n");
		printf("    e.) Status Report.\n");
		printf("    d.) Display status.\n");
		printf("\n  <ESC> Goes to previous menu\n\n");

		pline('-',80);
		clscrn(2);
		
		if (gets (c, 4) == (char *)-1)
			return;
		switch(c[0]) {
			case 's':
				while(!ifesc()) {
					if(pmprep()) {
						printf("Failed initialization.\n");
						break;				/* init of buslock test */
					}
					if(ifesc()) break;
					if(rmwtst()) break;
					if(ifesc()) break;
					if(!loop) continue;
					else break;
				}
				break;
			case 'm': mmsel(2); mmslot=s[0].mms; break;	
			case 'p': pmsel(0); break;
			case 'l':
				printf("\nEnter loop count (0=indefinite) now at %x : ",loop);
				if(gets(b,6) == (char *)-1) { esc=1; break; }
				if(b[0]=='\0') break;
				loop=atox(b);
				printf("%x",loop);
				break;
			case 'e': pmrst(0); break;
			case 'd': rmwstat(); break;
			default : break;
		}
		if (esc)
			return (0);
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmprep()
{
	register unsigned x, z;
	int y;
#ifdef DEBUG
	printf("pmprep: mmslot=%x loop=%x\n");
#endif

	if(!loop) y = 0x100;					/* Loops to be done. *.
	else y = loop;							/* If not forever get loops. */
	cssmap(MAP04,mmslot,0x0f);				/* Use MAP04 for memory. */
	for(x=0; s[x].pms != 0xff; x++) {
		s[x].tst = IPCC_BUS_LOCK;			/* (0x50) Bus Lock test. */ 
		s[x].str = 0;						/* Offset = 0. */
		s[x].flg = y;
		s[x].pas = 1;
		s[x].mms = mmslot;
		s[x].err0 = 0;
		s[x].err1 = 0;
		if(chkslot(s[x].pms)) {					/* in Idle mode. */
			cpu_idle(1,s[x].pms);
			if(z=pmexec(x)) {
				printf("Failed (%x) IPCC on s[%x].pms = %x.\n",z,x,s[x].pms);
				anykey();
				return(1);
			}
		}
	}
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
rmwtst()
{
    register unsigned int *idptr, *semptr;
	register unsigned int dc, du, glp, tmpid;
    register unsigned int loopcnt, ownscnt, lp, lp1;
	struct buslock *blp = ((struct buslock *)(0xc0000000));
	struct ble *blep;
	
#ifdef DEBUG
	printf("1.) rmwtst:\n");
#endif

	dc = 0x0;
    du = 0x80000000;					/* own semaphore pattern */
	idptr = (unsigned *)&blp->bus_id;		/* get addr of id field */
	semptr = (unsigned *)&blp->bus_sema;	/* get addr of token field */
	blep = (struct ble *)&blp->bles[myslot];
	blep->bus_status = 0;

#ifdef DEBUG
	printf("2.) blep=%x semptr=%x idptr=%x\n",blep,semptr,idptr);
#endif

	*semptr = 0;					/* Initial setting. */
	blp->bus_go = 0x80;				/* Start the test. */
	if(!loop) lp1 = 0x100;			/* Loops to be done. */
	else lp1 = loop;				/* If not forever get loops. */
	
    for(lp=lp1;lp;lp--) { 
        loopcnt++;
        if(!(do_cas(semptr, dc, du))) 	/* fight for token */
        {								/* got semaphore token */
            ownscnt++;					/* incrment own semaphore count */
			tmpid = ((~loopcnt & 0xfffffff) ^ myslot);
            *idptr = tmpid;					/* write id field */
            for(glp=0x8; glp > 0; glp--) { /* violation when I own it. */
				if(ifesc()) {
					blp->bus_go = 0x00;					/* Stop the test. */
					break;
				}
				if(*semptr != du) {
					printf("%s, MM(%08x)=%08x, CREG=%08x, UREG=%08x\n",
						"Bus lock problem-1", semptr, *semptr, dc, du);
					blep->be_sema = *semptr;
					blep->be_id = *idptr;
					blep->be_code = 1;
					blep->bus_status = 0x80;
				}
				if(*idptr != tmpid) {
					printf("%s, MM(%08x)=%08x, EXP=%08xi\n",
						"Bus lock problem-2", idptr, *idptr, tmpid);
					blep->be_sema = *semptr;
					blep->be_id = *idptr;
					blep->be_code = 2;
					blep->bus_status = 0x80;
				}
			} 	
			if(!blp->bus_go) break;
			*semptr = 0;				/* release the semaphore token */
			if(ifesc()) blp->bus_go = 0x00;		/* Stop the test. */
		}
		if(!(loopcnt & 0xff) || !(blp->bus_go)) {	/* report every 256 loops */
			blep->loopcnt = loopcnt;
			blep->ownscnt = ownscnt;
			if(!blp->bus_go) break;				/* done if cancel */
		}
	}
	blp->bus_go = 0x00;		/* Stop the test. */
	rmwstat();
	return(0);
}

/*------------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
rmwstat()
{
	struct buslock *blp = ((struct buslock *)(0xc0000000));
	struct ble *blep;
	register unsigned x;
	unsigned char bstat;			/* 0=O.K. ,0x80=Failed. */

	cssmap(MAP04,mmslot,0x0f);				/* Use MAP04 for memory. */

	cline('=',"[ Read/Modify/Write Status Report ]");
		blep = (struct ble *)&blp->bles[myslot];
		printf(" SPM in slot %x %s the BUSLOCK test.\n",
		myslot,(blep->bus_status==0x80)?"FAILED":"PASSED");
		printf(" Tries = %x  Locked = %x\n",blep->loopcnt,blep->ownscnt);
		if(blep->bus_status==0x80) {
			printf(" Error : code = %x  I.D. = %x  Sema = %x ",
			blep->be_code,blep->be_id,blep->be_sema);
		}
		pline('-',80);
	for(x=0; s[x].pms != 0xff; x++) {
		if(!chkslot(s[x].pms)) continue;
		blep = (struct ble *)&blp->bles[s[x].pms];
		printf(" PM in slot %x %s the BUSLOCK test.\n",
		s[x].pms,(blep->bus_status==0x80)?"FAILED":"PASSED");
		printf(" Tries = %x  Locked = %x\n",blep->loopcnt,blep->ownscnt);
		if(blep->bus_status==0x80) {
			printf(" Error : code = %x  I.D. = %x  Sema = %x ",
			blep->be_code,blep->be_id,blep->be_sema);
		}
		pline('-',80);
	}
	if(loop) anykey();
	return(0);
}
/*---------------------------------[ DONE ]-----------------------------------*/
