/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pmmm.c: version 25.1 created on 11/27/91 at 14:40:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pmmm.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/***	SPM directed PM Main Memory Test ***/

#include "ipcc.h"
#include "types.h"
#include "global.h"
#include "memerr.h"
#include "disp.h"

#define	MAXSLOT	0x10		/* max. 16 slots/system */

extern struct merr memerr;
extern uchar myslot;
extern unsigned char bdhere[];		/* This are the polled slots id. */
extern char cpuack;					/* Flag for handling acknwoledges. */
extern char ipcctest;				/* set ipcc flag to handle spy test. */

/* struct mtest mtarray[MAXSLOT]; */

mpmmm() 
{
	cpuack = ipcctest = 1;
	mpmmm1();
	cpuack = ipcctest = 0;
}

mpmmm1()
{
	register int si;
	unsigned	pslot, mslot, saddr, length, loops, req_cnt;
	unsigned char ibuf[20];
	register struct mtest *mtsp;

	printf("\nS90 System Multiple PM's Memory Test.\n");
	cpuack=1;			/* I want to see ACKs. */
	for (si=0; si < MAXSLOT; si++) {
		mtarray[si].valid = 0;
		mtarray[si].err_valid = 0;
		mtarray[si].ccnt = 0;
	}
	req_cnt = 0;

	/* Query the request */
	for(;;)
	{
		for(;;) {
			printf("\rPM Module slot #: ");
			if(((char)(gets(ibuf, 20))) == -1) return(0);
			if(((pslot = atox(ibuf)) >= MAXSLOT) || (pslot < 0)) {
				printf("Out of range.\n");	
				continue;
			}
			if(ifesc()) return(0);
			if(bdhere[pslot] == CPUHERE) break;
			else { printf("Invalid slot #.\n"); continue;
			}
		}
		for(;;) {
			printf("\rMemory slot #: ");
			if(((char)(gets(ibuf, 20))) == -1) return(0);
			if(((mslot = atox(ibuf)) >= MAXSLOT) || (mslot < 0)) {
				printf("Out of range.\n");	
				continue;
			}
			if(ifesc()) return(0);
			if(bdhere[mslot] == MEMHERE) break;
			else { printf("Invalid slot #.\n"); continue;
			}
		}
		if(ifesc()) return(0);
		printf("\rStart offset:");
		if(((char)(gets(ibuf, 20))) == -1) return(0);
		else saddr=atox(ibuf);

		if(ifesc()) return(0);
		printf("\rNumber of bytes:");
		if(((char)(gets(ibuf, 20))) == -1) return(0);
		else length=atox(ibuf);
		if(ifesc()) return(0);

		printf("\rLoop times:");
		if(((char)(gets(ibuf, 20))) == -1) return(0);
		else loops=atox(ibuf);
		if(ifesc()) return(0);

		mtsp = &mtarray[pslot];
		mtsp->mslot = mslot;
		mtsp->saddr = saddr;
		mtsp->length = length;
		mtsp->loops = loops;
		mtsp->valid = 1;

		if((si=chk_cont()) == -1) return(0);
		else if(si) break;
	}
	for (si=0; si < MAXSLOT; si++)
	{
		mtsp = &mtarray[si];
		if(!mtsp->valid) continue;

		ipsendwt((uchar)si, IPCC_SM_SLOT, myslot);
		ipsendwt((uchar)si, IPCC_MM_SLOT, mtsp->mslot);
		ipsendwt((uchar)si, IPCC_MM_OFFSET, mtsp->saddr);
		ipsendwt((uchar)si, IPCC_COUNT, mtsp->length);
		ipsendwt((uchar)si, IPCC_MM_TEST2, mtsp->loops);
		req_cnt++;
  	}
	if(!req_cnt) {
		printf("No request!\n");
		return(0);
	}

    for(;;) {	
		printf("\rLoop: ");
		for(si=0; si < MAXSLOT; si++)
			if(mtarray[si].valid == 1)
				printf(" PM %d = %d,", si, mtarray[si].ccnt);

		/* execute data times */
		for(si=0; si < MAXSLOT; si++)
			if(mtarray[si].err_valid == 1) {
				putchar('\n');
				mtarray[si].err_valid++;
				prmerr(si);
			}
    	if (ifesc()) {		/* checks any "abort" interrupt request */
			printf("\n\n\n");
			for(si=0; si < MAXSLOT; si++) {
				if(mtarray[si].err_valid) prmerr(si);
				if(mtarray[si].valid)
					ipsendwt((uchar)si, IPCC_CANCEL, 1);
			}
			break;
		}
	}
}


prmerr(slot)
unsigned slot;
{
	register struct mtest *mtp;

	mtp = &mtarray[slot];
	printf("PM(slot= %d), Memory test(slot= %d): %s error (code= %d),\n",slot,
		mtp->mslot,(mtp->err_code == 1) ? "data" : "address",mtp->err_code);
	printf("at %x, read data= %x, expected data= %x\n",
		mtp->err_addr,mtp->err_rdata,mtp->err_xdata);
}

chk_cont()
{
	unsigned char	ibuf[20];

	for (;;) {
		printf("More PMs? (y/n)");
		if(gets(ibuf, 20) == -1) return(-1);
		if (Yes (ibuf[0]))
			return (0);
		if (No (ibuf[0]))
			return (1);
	}
}

