/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pmmenu.c: version 25.1 created on 11/27/91 at 14:40:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pmmenu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "disp.h"
#include "ipcc.h"
#include "pm.h"

#define ESC		0x1b
#define MAP05	05		/* Map ram 5, Used for Mailbox register. */

extern unsigned char bdhere[];	/* This are the polled slots id. */
extern char cpuack;			/* Flag for handling acknwoledges. */
extern unsigned mailstat;		/* Data from id mail byte. */
extern unsigned char myslot;	/* This is where I am. */
extern char tsterrs;			/* this is set to zero when we want to. */
extern char ipcctest;			/* set ipcc flag to handle spy test. */
extern char emulate;		/* added by YVC at 2/1/88 for testing IOM */
extern char ignore_it;			/* If set, ignore CSS bus errors. */

struct pmslt s[8];

extern char *gets ();

unsigned char procerr;
/*------------------------------------------------------------------------------
	These are local errors detected by the menu environment.
------------------------------------------------------------------------------*/
char *pmerr0[] = {
	"",								/* Status 0 = Passed. */
	"No PM(s) Selected",			/* Status = 1. */
	"No MM(s) Selected",			/* Status = 2. */
	"IPCC SPM slot send.",			/* Status = 3. */
	"IPCC MM slot send.",			/* Status = 4. */
	"IPCC CMD send.",				/* Status = 5. */
	"READ MAIL error.",				/* Status = 6. */
	"Timed-out on READMAIL.",		/* Status = 7. */
	"No Memory Module found.",		/* Status = 8. */
	"No Processor Module found.",	/* Status = 9. */
	"IPCC MM offset send.",			/* Status = a. */
	"Unknown Error code."
};

/*------------------------------------------------------------------------------
	The error codes returned by PM after PM power up tests.
------------------------------------------------------------------------------*/
char *pmerr1[]={
	"",									/* 00 */
	"Data Store",						/* 01 */
	"CTAG",								/* 02 */
	"BTAG",								/* 03 */
	"TLB",								/* 04 */
	"MTAG",								/* 05 */
	"FLUSH Function",					/* 06 */
	"ROOT pointers",					/* 07 */
	"INTERRUPT request",				/* 08 */
	"BUS parity",						/* 09 */
	"RCV Funnel",						/* 10 */
	"MOVML",							/* 11 */
	"R-perm",							/* 12 */
	"W-perm",							/* 13 */
	"X-perm",							/* 14 */
	"PAGE fault",						/* 15 */
	"NAK",								/* 16 */
	"TIMEOUT",							/* 17 */
	"BAD I/O",							/* 18 */
	"TABLE WALK",						/* 19 */
	"CACHE Read_Hit",					/* 20 */
	"CACHE Read_Miss",					/* 21 */
	"CACHE Write Through",				/* 22 */
	"CACHE Write Miss",					/* 23 */
	"",									/* 24 */
	"",									/* 25 */
	"SPY",								/* 26 */
	"W-Space Exception",				/* 27 */
	"Fault Reg. : Wrong Space",			/* 28 */
	"Fault Reg. : BERROR",				/* 29 */
	"Fault Reg. : SINCE",				/* 30 */
	"Fault Reg. : Wrong Co-proc",		/* 31 */
	"Fault Reg. : Busy",				/* 32 */
	"Fault Reg. : Cmd-Pending",			/* 33 */
	"MMU Power-Up",						/* 34 */
	"Unknown Error code."
};

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmmenu()
{
	register x;
	char c[4];
	char *tst="Test", *pm="PM", b[6];
	c[0] = (char)0;

	if(clokpr(0)) return;				/* Return if in local clock. */

	for(x=0;x<8;x++) {					/* Initialize all of these. */
		s[x].pms=0xff; s[x].mms=0xff;
		s[x].pas=1; s[x].loop=0; 
		s[x].err0=0; s[x].err1=0;
		s[x].flg=0;
	}
	while(1) {
		clscrn(5);
		cline('=',"[ Processor Module Test Menu ]");
		pmhder(0);			/* Print the menu header. */
		clscrn(1);
		printf("    s.) Start %s Confidence %s.\n",pm,tst);
		printf("    i.) %s Individual %s.\n",pm,tst);
		printf("    m.) SPM/%s Multi Memory %s.\n",pm,tst);
		printf("    b.) Read/Modify/Write (Buslock) Test.\n");
		printf("    p.) Select %s(s) for %s.\n",pm,tst);
		printf("    l.) Set Number of Loop(s) on %s.\n",tst);
		printf("    e.) Set Error Reporting on %s(s).\n",pm);
		printf("    c.) Select %s(s) cache on/off flag(s).\n",pm);
		printf("\n  <ESC> To return to monitor\n\n");

		pline('-',80);
		clscrn(1);

		if (gets (c, 4) == (char *)-1)
			return;
		switch(c[0]) {
			case 's':
				for(x=0;s[x].pms != 0xff;x++) {
					s[x].rmail = 0x7f;
					s[x].tst = IPCC_IND_CONF;
				}
				pmdotst();		/* PM's confidence test */
				break;
			case 'i': pmitst(); break;
			case 'm': mpmmm(); break;
			case 'b': pmrmw(); break;
			case 'p': pmsel(0); break;
			case 'l': pmsetloop(); break;
			case 'e': pmrst(0); break;
			case 'c': pmcache(); break;
			default : break;
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmitst() 
{
	register x;
	char c[4];

	c[0] = (char)0;
	while(1) {
		clscrn(5);
		cline('-',"[ PM INDIVIDUAL TEST MENU ]");
		pmhder(0);			/* Print the menu header. */
		clscrn(1);
		printf("    s.) Start the test(s).\n");
		printf("    t.) Select Individual test.\n");
		printf("    m.) Select Memory Board for PM.\n");
		printf("    e.) Status Report.\n");
		printf("    p.) Select PM(s) for Testing.\n");
		printf("    l.) Set Number of Loop(s)\n");
		printf("\n  <ESC> Goes to previous menu\n\n");

		pline('-',80);
		clscrn(2);
	
		if (gets (c, 4) == (char *)-1)
			return;
		switch(c[0]) {
			case 's':
				for(x=0;s[x].pms != 0xff;x++) {
					s[x].rmail=0x2f;
					s[x].tst = IPCC_IND_TEST;
				}
				pmdotst();
				break;
			case 't':
				c[0]=pmsel(1);
				pmindisp();
				pmseltst(c[0]);
				break;
			case 'm': mmsel(0); break;
			case 'e': pmrst(0); break;
			case 'p': pmsel(0); break;
			case 'l': pmsetloop(); break;
			default : break;
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmdotst()
{
	register x=0, c=0;
	char esc=0;

	pmrst(1);						/* Reset the error count. */
	for(x=c=0;(x<8) && (s[0].pms!=0xff) && (s[x].pms!=0xff); x++) {
		if(chkslot(s[x].pms)) {					/* in Idle mode. */
			cpu_idle(1,s[x].pms);
			c++;
		}
	}
	if(!c) {		/* No selection yet. */
		printf("\nNo PM has been selected for testing\n");
		anykey();
		return(0);					
	}
	cpuack=1;
	while(!ifesc()) {
		printf("\r(Slot)/pass : ");
		for(x=0;(x<8) && (s[x].pms!=0xff); x++) {
			if(esc=ifesc()) break;
			if((!s[x].err0 && !s[x].err1) && (chkslot(s[x].pms)) &&
			(s[x].pas < (s[x].loop) || !s[x].loop)) {
				s[x].err0 = pmexec(x);
				if(!s[x].err0) { if(esc=chkmail(x)) break; }
			}
			if(chkslot(s[x].pms))
				printf("(%x)=%x ",s[x].pms,s[x].pas);
		}
		if(esc) break;
		for(c=x=0;(s[x].pms != 0xff) && (!esc); x++) {
			if(esc=ifesc()) break;
			if((!s[x].err0 && !s[x].err1) && (chkslot(s[x].pms)) &&
			(s[x].pas < (s[x].loop) || !s[x].loop)) c=1;
		}
		if((!c) || (esc)) break;	
	}
	cpuack=0;
	pmstat();			/* Print the error. */
	return(0);
}

/*------------------------------------------------------------------------------
	pmindisp : Displays the individual test selection menu.
------------------------------------------------------------------------------*/
pmindisp()
{
	register x,y,z;
	unsigned char sz=0,hz=0;
	
	for(x=0;x < (sizeof(pmerr1)/sizeof(char *)); x++) {
		if(*pmerr1[x] == 0) continue;
		sz++;
	}
	z=hz = sz/2;
	for(x=1,y=0;((y++)+hz) <= sz; x++) {
		if(*pmerr1[y] == 0) continue;
		printf("%x.) %s",x,pmerr1[y]);

		if(x<0x10) pline(' ',(35 - (strlen(pmerr1[y]))));
		else pline(' ',(34 - (strlen(pmerr1[y]))));

		for(;(*pmerr1[(y+z)] == 0) && ((y+z)<sz); z++);

		if((y+hz)>sz) break;
		printf("%x.) %s\n",(x+hz),pmerr1[(y+z)]);
	}
}

/*------------------------------------------------------------------------------
	pmseltst :
------------------------------------------------------------------------------*/
pmseltst(x) 
char x;
{
	char b[5], tst;

	if(bdhere[s[x].pms] != CPUHERE) {
		printf("\n%x is an invalid PM slot.\n",s[x].pms);
		anykey();
		return;
	}
	printf("\n\n   Enter test for PM in slot : %x : ", s[x].pms);
	if(gets(b,3) == (char *)-1) return;
	tst=atox(b);
	if((tst>0x20) || (tst<1)) { invld(); return; }
	s[x].flg = (int)tst;
	if(s[x].flg>=0x18) s[x].flg += 2;
	return;
}

/*------------------------------------------------------------------------------
	pmstat : Displays the error status of the structure.
------------------------------------------------------------------------------*/
pmstat()
{
	register x;
	unsigned int perr0,perr1;
	
	perr0 = sizeof(pmerr0)/sizeof(char *);
	perr1 = sizeof(pmerr1)/sizeof(char *);

	cline('=',"[ PM TEST STATUS ]");
	for(x=0;(x < 8) && (s[x].pms!=0xff); x++) {
		if(!chkslot(s[x].pms)) continue;
		printf("\nPM in slot %x : ",s[x].pms);
		if((s[x].err0) || (s[x].err1)) {
			if(s[x].err0) {
				if((s[x].err0 >= perr0) || (pmerr0[(s[x].err0)] == 0))	
					s[x].err0 = perr0;
				printf("Process failure - %s",pmerr0[(s[x].err0)]);
			}
			if(s[x].err1) {
				if((s[x].err1 >= perr1) || (pmerr0[(s[x].err1)] == 0))	
					s[x].err1 = perr1;
				printf("Test failure - %s",pmerr1[(s[x].err1)]);
			}
		}
		else printf("Passed");
	}
	anykey();
}

/*------------------------------------------------------------------------------
	pmsetloop : Will set loop count for test(s).
------------------------------------------------------------------------------*/
pmsetloop()
{
	register x,c;
	char b[7];

	while(1) {
		clscrn(10);
		cline('-',"[ SET LOOP COUNT MENU ]");
		pmhder(1);			/* Print header/No update. */
		clscrn(1);
		for(x=0;(x < 8) && (s[x].pms!=0xff); x++) {
			printf("    PM Slot : %x = ",s[x].pms);
			if(!s[x].loop) printf("Loop forever\n");
			else printf("%x\n",s[x].loop);
		}
		printf("\n  <ESC> Goes to previous menu\n");
		clscrn(2);
		pline('-',80);					/* Print line. */	
		printf("\n  Enter slot number: ");
		
		if (gets (b, 4) == (char *)-1)
			return;
		b[1]='\0';
		c=atox(b);
		putchar(c);
		if((c < 0) || (c > 0x0f) || (bdhere[c]!=CPUHERE) ||
		((x=lslot(c)) == -1))  invld();
		else {
			printf("\nEnter loop count (0=indefinite): ");
			if(gets(b,6) == (char *)-1) return;
			s[x].loop=atox(b);
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
lslot(ps)
uchar ps;
{
	char i;
	for(i=0;(i<8) && (s[i].pms != ps);i++);
	if(i>=8) return(-1);
	return(i);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmcache()
{
	register x,c;
	char b[4];

	while(1) {
		clscrn(10);
		cline('-',"[ SET/UNSET CACHE FLAG MENU ]");
		pmhder(1);			/* Print header/No update. */
		clscrn(1);
		for(x=0;(x < 8) && (s[x].pms!=0xff); x++) {
			printf("    PM Slot: %x is %s.\n",s[x].pms,(s[x].flg)?"ON":"OFF");
		}
		printf("\n  <ESC> Goes to previous menu\n");
		pline('-',80);			/* Print line. */	
	
		if (gets (b, 4) == (char *)-1)
			return;
		b[1]='\0';
		c=atox(b);
		if((c < 0) || (c > 0x0f) || (bdhere[c]!=CPUHERE) ||
		((x=lslot(c)) == -1))  invld();
		else s[x].flg = (s[x].flg) ? 0 : 1;	
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmrst(flg)
uchar flg;
{
	register x;
	char	 in[4];

	while(1) {
		if(!flg) {
			clscrn(10);
			cline('-',"[ ERROR REPORTING MENU ]");
			pmhder(1);			/* Print header/No update. */
			clscrn(1);
			printf("    1.) Reset Error count.\n");
			printf("    2.) Show Current Error Buffer.\n");
			printf("    3.) Reset the CSS Bus.\n");
			printf("\n  <ESC> Goes to previous menu\n");
			pline('-',80);			/* Print line. */	

			if (gets (in, 4) == (char *)-1)
				return;
			in[0] -= '0';
		}
		else 
			in[0]=flg;

		switch(in[0]) {
			case 1: 
				for(x=0;x<8;x++) {
					s[x].pas = 0;
					s[x].err0 = 0;
					s[x].err1 = 0;
				}
				break;
			case 2: pmstat(); break;
			case 3: css_reset1(); break;
			default : break;
		}
	if(flg) break;
	}
}

/*------------------------------------------------------------------------------
	pmexec(x) : will send thru the IPCC structure the neccessary
				information for the PM to conduct the test.
				x = Physical slot number.
------------------------------------------------------------------------------*/
pmexec(x)
uchar x;
{
	int i;

#ifdef DEBUG
	printf("pmexec : s[%x].pms=%x\n",x,s[x].pms);
#endif
	if(s[x].mms == 0xff)					/* Do we have memory. */
		return(2);
	if(ipccsend(s[x].pms,IPCC_SM_SLOT,(int)myslot))			/* SPM slot. */
		return(3);	
	if(ipccsend(s[x].pms,IPCC_MM_SLOT,(int)s[x].mms))		/* MEM slot. */
		return(4);
	if(s[x].tst == IPCC_BUS_LOCK) {
		if(ipccsend(s[x].pms,IPCC_MM_OFFSET,(int)s[x].str))	/* MEM offset. */
			return(0x0a);
	}
	if(((s[x].flg == 0x1a) && (s[x].tst == IPCC_IND_TEST)) ||
	((s[x].flg) && (s[x].tst == IPCC_IND_CONF))) ipcctest=1;
	else {
		ipcctest = 0;							/* No special int handling. */
		ignore_it = emulate = tsterrs = 1;		/* Ignore all interrupts. */
	}
	if(ipccsend(s[x].pms,s[x].tst,s[x].flg))	/* Do the command. */
		return(5);					
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
chkmail(slot)
char slot;
{
	register i,t;
	char esc;

	cssmap(MAP05, (uchar)s[slot].pms, (uchar)0x0f);
	t=s[slot].rmail;
	while(1) {
		if(esc=ifesc()) break;
		for(i=0;i<0x40000 ;i++);				/* Wait a while. */
		if(readmail()) {
			s[slot].err0 = 6;				/* Read mail error. */
			break;
		}
		if(esc=ifesc()) break;
		if(mailstat & 0x8000) {
			if(!(t--)) {
				s[slot].err0 = 7;				/* Timed-out on readmail. */
				break;
			}
		}
		else {
			s[slot].pas++;
			s[slot].err1=(mailstat & 0x7f00) >> 8;
			ipcctest=ignore_it=emulate=tsterrs = 0;	/* Restore vars. */
			break;
		}
	}
	if(esc) return(1);
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmsel(flg)
char flg;
{
	char x=0,c=0,pslt[8];
	char b[4];

	for(c=x=0;x<16;x++) {
		if(bdhere[x]==CPUHERE)
			pslt[c++] = x;
	}
	pslt[c] = 0xff;				/* This is the end of the line. */
	while(1) {
		if(!flg) {
			clscrn(10);
			cline('-',"[ PM SELECTION MENU ]");
			pmhder(1);							/* Print header/No update. */
			clscrn(1);							/* Clear and skip a line. */
		}
		for(x=0;(pslt[x] != 0xff) && (x<8); x++) {
			if(!flg) {
				printf("    %sABLE PM in slot %x.\n",
				(chkslot(pslt[x])) ? "DIS" : "EN",pslt[x]);
			}
			else {
				printf("    PM in Slot %x",pslt[x]);
				if(flg==2) printf(" will use MM in slot %x",s[x].mms);
				printf(".\n");
			}
		}
		if(!flg) {
			printf("    <t> ENABLES all PM(s).\n");
		}
		printf("\n  <ESC> Goes to previous menu\n\n");
		pline('-',80);
		clscrn(3);

		if (gets (b, 4) == (char *)-1)
			return(-1);
		b[1]='\0';
		c=atox(b);
		if(b[0]=='t' && !flg) {
			for(c=x=0;x<16;x++) {
				if(bdhere[x]==CPUHERE) {
					if(!chkslot(x)) togslot(x);
					s[c++].pms = x;
				}
			}
			continue;
		}
		if((c < 0) || (c > 0x0f) || (bdhere[c]!=CPUHERE) ||
		((x=lslot(c)) == -1)) { invld(); continue; }
		else {
			if(flg) {
				if(!chkslot(c)) togslot(c);
			}
			else togslot(c);
		}
		if(flg) return(x);
		else continue;
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
pmhder(flg)
char flg;
{
	uchar c, x;

	printf("PM(s) in slot(s) = ");
	for(c=x=0;x<16;x++) {
		if(bdhere[x]==CPUHERE) {
			if(!flg) s[c++].pms=x;
			printf("%s%x ",(chkslot(x)) ? "" : "*",x);
		}
	}
	printf("\nMM(s) in slot(s) = ");
	for(c=x=0;x<16;x++) {
		if(bdhere[x]==MEMHERE)
			printf("%s%x ",(chkslot(x)) ? "" : "*",x);
	}
	putchar('\n');				/* I don't Know what this line does. */
	pline('-',80);				/* Prints a line of '-'. */
	if(!flg && (mmsel(1)))		/* Select the default Pm/Mm combination. */	
		anykey();
	return(0);
}

/*------------------------------------------------------------------------------
	sl : 0 

------------------------------------------------------------------------------*/
mmsel(sl)
char sl;
{
	register c,x;
	char mslt[8], pslt[8], mm[4], pm=0;

	char temporary = 1;

	while(1) {
		if(!sl) {
			clscrn(5);
			cline('=',"[ MEMORY MODULE SLECTION MENU ]");
			pmhder(1);			/* Print the menu header. */
			clscrn(2);
		}
		for(x=0;x<8;x++)
			mslt[x]=pslt[x]=0xff;

		for(mm[0]=pm=x=0;x<16;x++) {
			if(bdhere[x]==MEMHERE) mslt[mm[0]++] = x;
			if(bdhere[x]==CPUHERE) pslt[pm++] = x;
		}
		if(!mm[0]) { printf("No Memory board\n"); return(1); }
		if(!pm) { printf("No Processor board\n"); return(1); }
		if(!sl) {
			if((pm = pmsel(2)) == -1) break;		/* Select PM/MM pair. */
			if(bdhere[pslt[pm]] != CPUHERE) {
				printf("\n%x is an invalid PM slot.\n",pslt[pm]);
				anykey();
				return(1);
			}
			printf("\nEnter Memory Module for PM in slot %x : ",pslt[pm]);

			if (gets (mm, 4) == (char *)-1)
				break;
			putchar(mm[0]);
			if(((mm[0]-='0') < 0) || (mm[0] >= 0x0f) || (bdhere[mm[0]]!=MEMHERE))
				invld();
			else s[pm].mms = mm[0];	
		}
		if(sl==1) {
			if(mm[0]==1) {
				for(x=0;(x<8) && (s[x].pms!=0xff); x++)
					s[x].mms = mslt[0];
			}
			if(temporary) {
				for(x=0;(x<8) && (s[x].pms!=0xff); x++)
					s[x].mms = mslt[0];
			}
		}
		if(sl==2) {
			printf("\nEnter MM to be used for Buslock test : ");
			if (gets (mm, 4) == (char *)-1)
				break;
			putchar(mm[0]);
			if(((mm[0]-='0') < 0) || (mm[0] >= 0x0f) || (bdhere[mm[0]]!=MEMHERE))
				invld();
			else for(x=0;(x<8) && (s[x].pms!=0xff); x++) s[x].mms = mm[0];
		}
		if(sl) break;
	}
	return(0);
}
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
