/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) other.c: version 25.1 created on 11/27/91 at 14:40:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)other.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "iom.h"
#include "spm.h"
#include "misc.h"
#include "sa_dir.h"
#include "filehdr.h"
#include "scnhdr.h"
#include "aouthdr.h"
#include "a.out.h"
#include "iopm_comm.h"
#include "boot.h"

struct fhdr {
	FILHDR filhdr;
	AOUTHDR saouthdr;
	SCNHDR sctnhdr[6];
};

extern unsigned char  myslot;
extern unsigned int_data;

/* 
	load_icb_run(): Called by Trap1.
	This routine loads codes residing in system memory (address 0) into
	local static ram on service module and passes control to it
*/
#ifdef	SPM_PROM
load_icb_run()
{
	register i;
	register unsigned *dest, *src, start, *startp, tmp;
	register struct fhdr *fhptr;
	register struct scnhdr *scnptr;

	fhptr=(struct fhdr *)ICB_RD_ADDR;
		
	scnptr=fhptr->sctnhdr;
	startp = (unsigned *)(scnptr->s_paddr + 0x4); /* start address ptr */
	for(i=0; i<fhptr->filhdr.f_nscns; i++,scnptr++) {
		dest = (unsigned *)scnptr->s_paddr; 	/* dest addr */
		src = (unsigned *)(scnptr->s_scnptr + (unsigned)fhptr); 
		for(tmp=0; tmp<scnptr->s_size; tmp+=4,src++,dest++) 
			*dest = *src; 		/* move it into local ram */
	}
	start = *startp;		/* get the beginning address */
	_cache(0);			/* disable 68020 on-chip cache */
	(*(PFI)start)(); 		/* Pass control to loaded codes */
}
#endif

/* 
	load_iopm_run(): Called by Trap2.
	This routine loads codes residing in system memory (address 0) into
	local static ram on service module and passes control to it
*/
#ifdef	SPM_PROM
load_iopm_run()
{
	register i;
	register unsigned *dest, *src, start, *startp, tmp;
	register struct fhdr *fhptr;
	register struct scnhdr *scnptr;

	fhptr=(struct fhdr *)IOPM_RD_ADDR;
		
	scnptr=fhptr->sctnhdr;
	startp = (unsigned *)(scnptr->s_paddr + 0x4); /* start address ptr */
	for(i=0; i<fhptr->filhdr.f_nscns; i++,scnptr++) {
		dest = (unsigned *)scnptr->s_paddr; 		/* dest addr */
		src = (unsigned *)(scnptr->s_scnptr + (unsigned)fhptr); 
		for(tmp=0; tmp<scnptr->s_size; tmp+=4,src++,dest++) 
			*dest = *src; 		/* move it into local ram */
	}
	start = *startp;		/* get the beginning address */
	_cache(0);			/* disable 68020 on-chip cache */
	(*(PFI)start)(); 		/* Pass control to loaded codes */
}
#endif

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_int_tbl_init(iom_slot,data)
char 	iom_slot;
unsigned data;
{
	register unsigned int 	*tp;
	register unsigned int	*start;
	register unsigned int   *end;
	register unsigned int   tdata;
	register unsigned int   offset;
	unsigned char		addr;

	offset = IOM_INT_V;		/* addr of IO module interrupt vector */
	start = (unsigned *)CSSMAP(offset);
	end   = (unsigned *)(CSSMAP(offset) + INT_SIZE);
	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,iom_slot,addr);

	/* initial IOM interrupt vector table */
	for (tp = start; tp < end ; ) {
		data = data & 0xffff0000;
		data = data | ((unsigned)myslot << 8);
		data = data | ((unsigned)myslot << 12);
		data = data & 0xff00ffff; /* set level 5 interrupt */
		data = data | 0x00800000; /* set direct int bit */
		*tp = data;
		tp++; tp++;
	}
	offset = IOS_INT_V;		/* addr of IO device interrupt vector */
	start = (unsigned *)CSSMAP(offset);
	end   = (unsigned *)(CSSMAP(offset) + INT_SIZE);
	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,iom_slot,addr);

	/* initial IO device interrupt vector table */
	for (tp = start; tp < end ; ) {
		data = data & 0xffff0000;
		data = data | ((unsigned)myslot << 8);
		data = data | ((unsigned)myslot << 12);
		data = data & 0xff00ffff; /* set level 5 interrupt */
		data = data | 0x00800000; /* set direct int bit */
		*tp = data;
		tp++; tp++;
	}
}


/* 
	sp_int_set(): To set service module to dispatch CSS interrupt
			     back to itself and cause a css command interrupt
			     to service module.
*/

sp_int_set()
{
	int			i, j;
	register unsigned 	*k, m;

	*WRCNTL1 &= ~WR1_ID_RST;
	*WRCNTL1 |= WR1_ID_RST;

	/* setup for cpu access to dispatcher rams */
	/* *WRCNTL1 &= ~WR1_FINTREC & ~WR1_DREQ; */
	*WRCNTL1 &= ~WR1_DREQ;

	/* initialize the queue ram */
	for(k=QUEUE_RAM; k<QUEUE_RAM + QUEUE_LWORDS;k++) 
		*k = ((unsigned)k << 16) | ((unsigned)k & 0x0000ffff);

	/* initialize the pointer rams */
	for(k=POINTER_RAM; k<POINTER_RAM + POINTER_LWORDS;k++)
		*k= 0x7f7f0000;

	/* initialize the miscellaneous rams */
	for(k=MISC_RAM; k<MISC_RAM + MISC_LWORDS; k++)
		*k= 0x0f0003ff;

	*WRCNTL1 = (*WRCNTL1 & 0x00fbffff) | WR1_FRC_RST_ACK | WR1_IRDY
			| WR1_FDEST | WR1_FINTREC | WR1_RRDY | WR1_FMOD | WR1_DATYPE | WR1_DREQ; 
	*WRCNTL1 |= WR1_ID_RST;  /* turn on dispatcher again. */


	/* request the dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ;
	/* fill cfig ram with requested cpu number (service module number) */
	for(k=MISC_RAM; k<MISC_RAM + CONFIG_LWORDS; k++) {
		m = *k;
		/* check that if the count is foxed then bit 10 is zero,
		otherwise write a one */
		if((m & CNTR_MASK) == 0x3ff)
			m &= ~CNTR_ZERO_BIT;
		else
			m |= CNTR_ZERO_BIT;
		*k = (m & ~CONFIG_MASK) | (myslot << CONFIG_SH);
	}
	/* reset dispatcher hardware */
	*WRCNTL1 &= ~WR1_ID_RST; 
	*WRCNTL1 |= WR1_ID_RST; 
	/* force SPM to pretend to be the requested cpu */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_PRETEND_MASK) | ((myslot << WR0_PRETEND_SH) & 0x00ffffff);
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) | ((~myslot << 20) & 0x00ffffff) | ((myslot << 16) & 0x00ffffff);
	/* *WRCNTL1 &= ~WR1_FINTREC;	force SP receive interrupt */
	*WRCNTL1 |= WR1_DREQ;

}

sp_int_ack2(sp_slot)
unsigned sp_slot;
{
	register unsigned 	ack_offset, *ip;
	unsigned char		addr;

	ack_offset = (unsigned)0xffffff2c;
	addr = (unsigned char)CSSADD(ack_offset);
	cssmap(MAP03, (unsigned char)sp_slot, addr);
	ip  = (unsigned *)0xbfffff2c;

	/*
	4 bytes css read to service module itself to 
	acknowledge interrupt to itself
	*/
	int_data = *ip; 	/* css 4 bytes read */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
load_ram()
{
#ifdef	SPM_IMAGE
	register unsigned *dest, *src, final;
	register struct fhdr *fhptr=(struct fhdr *)0x100ff08;
	register struct scnhdr *scnptr;

	scnptr=fhptr->sctnhdr;
	src = (unsigned *)(scnptr->s_scnptr + 0x100ff08); /* set buffer point */
	dest = (unsigned *)scnptr->s_paddr; 	   /* final location of code. */
	final = scnptr->s_paddr + 0x400; 	   /* final start of code. */

	for(; src<(unsigned *)0x103e000; src++, dest++)
		*dest = *src;		/* move it, long word at a time. */
	(*(PFI)final)();		/* and Jump to it */
#endif
}
