/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) novtst.c: version 25.1 created on 11/27/91 at 14:40:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)novtst.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*------------------------------------------------------------------------------
	novtst.c
------------------------------------------------------------------------------*/
#include "types.h"
#include "spm.h"
#include "novram.h"
#include "global.h"

extern unsigned char *buff;
extern char comm_args[][MAXARGSIZE];
extern struct novram *novram;			/* Points to Base of NVRAM. */

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
nov_cpy(st, de)	/* copy out the novram into the buffer space. */
register unsigned char *st, *de; /* start and dest. */
{
	register unsigned char *st1, *de1;	/* pointer to orignal. */
	register i1,i2;						/* counter. */

	i2 = sizeof(struct novram);			/* Get size of the whole structure. */
	st1 = st;							/* save starting values. */
	de1 = de;
	for(i1 = 0; i1 < i2; i1++)	/* entire structure. */
		*de++ = *st++;								/* move across one byte. */
	if(chk_sum(st1, i2) != chk_sum(de1, i2))		/* if don't match. */
	{
		printf("Warning: destination checksum did not match CRC checksum.\n");
		return(1);									/* bad.. */
	}
	return(0);										/* passed copy.. */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
nov_tst(comm_str, arg_cnt)	/* test the novram for read/write. */
char *comm_str;
int arg_cnt;
{
	register unsigned char *st = (unsigned char *)NOVRAM; /* original. */
	register unsigned char *de = (unsigned char *)buff; /* tmp buffer. */
	int i=0;

/* first: save all novram contents. */
	if(nov_cpy(st, de))					/* if it failed.. */
		return;							/* it failed copy for some reason. */
	if(*(comm_str+3) == 'l')			/* if told to loop. */
	{
		printf("Press ESC to exit loop\n");
		while(1)								/* looping */
		{
			nov_tst_ram();						/* test the actual ram. */
			if(ifesc()) break;					/* escape loop. */
			if(i++ == 100)
			{
				printf(".");
				i = 0;
			}
		}
		printf("\n");
	}
	else
		nov_tst_ram();		/* test the actual ram. */
	nov_cpy(de, st);		/* put it back now, don't care about errors... */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
nov_tst_ram()	/* do the actual novram test.. */
{ /* tst stolen from dram test.. thanks ron! */
	register unsigned *addr = (unsigned *)NOVRAM;
	register unsigned offadd;
	register unsigned tstpat,readback;
	register unsigned pat1=0x00000000;
	register unsigned pat2=0x55555555;
	register unsigned pat3=0xaaaaaaaa;
	char *msg;

	msg = "Nvram data ripple test failed.";
	/* ripple a one bit in first location */
	for(tstpat=0x00000001; tstpat>0; tstpat = tstpat << 1) {
		*addr = tstpat;	/* ok, write test pattern. */
		readback = *addr; /* read it back now. */
		if(readback != tstpat)
		{
			print_err(msg,(unsigned)addr,tstpat,readback);
			return(1);
		}
	}
	/* ripple a zero bit through first location */
	for(tstpat=0xfffffffe; tstpat != 0xffffffff; tstpat=(tstpat<<1)| 0x00000001)
	{
		*addr = tstpat;
		readback = *addr;
		if(readback != tstpat)
		{
			print_err(msg,(unsigned)addr,tstpat,readback);
			return(1);
		}
	}

	msg = "Nvram address ripple test failed.";
	for(offadd=0x00000400; offadd >= 0x00000004 ; offadd = offadd >> 1)
	{	/* initilize first pattern. */
		addr = (unsigned *)((unsigned)NOVRAM + offadd);
		*addr = pat1;
	}
	for(offadd=0x00000400; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)NOVRAM + offadd);
		readback = *addr; /* verify. */
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return(1);
		}
		*addr = pat2;	/* init as second pattern. */
		readback = *addr; /* verify. */
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return(1);
		}
		*addr = pat3; /* init as third pattern. */
		readback = *addr; /* verify. */
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return(1);
		}
	}

	msg = "Nvram content test failed.";
	for(addr=(unsigned *)NOVRAM; addr < (unsigned *)((unsigned)NOVRAM + (unsigned )0x7f8) ; addr++)
		*addr = pat1;	/* init to all pat1. */
	for(addr=(unsigned *)NOVRAM; addr < (unsigned *)((unsigned)NOVRAM + (unsigned )0x7f8) ; addr++)
	{  /* verify first pattern, and init to second. */
		readback = *addr;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return(1);
		}
		*addr = pat2;
		readback = *addr;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return(1);
		}
	}
	for(addr=(unsigned *)NOVRAM; addr < (unsigned *)((unsigned)NOVRAM + (unsigned)0x7f8) ; addr++)
	{ /* verify second pattern, and init to third. */
		readback = *addr;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return(1);
		}
		*addr = pat3;
		readback = *addr;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return(1);
		}
	}
}

