/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) novram.c: version 25.1 created on 11/27/91 at 14:39:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)novram.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*------------------------------------------------------------------------------
	novram.c
------------------------------------------------------------------------------*/
#include "spm.h"
#include "types.h"
#include "novram.h"
#include "disp.h"
#include "ioa0.h"
#include "icb.h"
#include "icb_config.h"
#include "rwi.h"
#include "globl.h"
#include "global.h"
#include "rwi.h"
#include "rwicio.h"
#include "rwiad.h"
#include "dev.h"

#define NOVRAM_VER	2

#define		MAX_MEM_TYPE	7

extern char *MEM_TYPE [];
extern unsigned short crctab[];
extern unsigned char bdhere[];
extern struct icb_config	io_conf[][MAXSLOTS];
extern char comm_args[][MAXARGSIZE];
extern unsigned char *buff;
extern unsigned int ps_num;			/* Power supply pointer. */
extern char	validmap;

extern uint get_device_info ();
extern uint i_unit_get ();
extern uint i_unit_set ();

struct novram *novram = NOVRAM;			/* Points to Base of NVRAM. */

extern	uint	boot_type;
extern  uchar   css_slot;
extern  uchar   sub_slot;
extern  uchar   phys_dev;
extern  uchar   log_dev;
extern  char    filename[];
extern  struct  icb_config  *icb_ptr;

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
init_novram(level)
char level;
{
	register unsigned char *ptr;
	struct	novram	*nov_save;
	int	cnt;

	ps_num=0;

	nov_cpy (novram, buff);	/* save original novram, for recovery */
	nov_save = (struct novram *)buff;

	/* Clear the novram from css_slot location to start of software area. */
	if(level==1) {
		for(ptr = (uchar *)&novram->css_slot[0];
				ptr < (uchar *)&novram->main_pwr[0]; ptr++) 
			*ptr = 0xFF; 

		for(ptr = (uchar *)&novram->main_pwr[0];
				ptr < (uchar *)&novram->runtime_crc; ptr++) 
			*ptr = 0x00; 
	}

	if(level==2) {
		for(ptr = (unchar *)NOVRAM; 
				ptr < (unchar *)&novram->css_slot[0]; ptr++)
			*ptr = 0x00; 

		for(ptr = (uchar *)&novram->css_slot[0];
				ptr < (uchar *)&novram->main_pwr[0]; ptr++) 
			*ptr = 0xFF; 

		for(ptr = (uchar *)&novram->main_pwr[0];
				ptr < (unchar *)&novram->shared_crc; ptr++) 
			*ptr = 0x00; 

		novram->novram_ver = NOVRAM_VER;	/* re-configured. */
		novram->autoboot = 1;			/* autobooting on. */
		novram->diag_fly_by = 0;		/* do the diag. */
		novram->boot_dev = 0;			/* default to H/D. */
	}

	if(level==3) {
		for(ptr = (unchar *)&novram->inlet_air_low_warning;
			      ptr < (unchar *)&novram->console_baud_rate; ptr++)
			*ptr = 0x00; 
	}

	novram->keywas=nov_save->keywas;	/* Restore key value. */
	novram->cmdwas=nov_save->cmdwas;	/* Restore command value. */
	novram->pwrstat=nov_save->pwrstat;	/* Restore power stat value. */
	novram->modem_baud_rate = nov_save->modem_baud_rate;
	for (cnt = 0; cnt != PASSWORD_LENGTH; cnt++)
		novram->password[cnt] = nov_save->password[cnt];

	novram->inlet_air_low_warning = adc_conv(INLET_AIR,5,0);
	novram->inlet_air_high_warning = adc_conv(INLET_AIR,40,0);
	novram->inlet_air_low_shutdown = adc_conv(INLET_AIR,0,0);
	novram->inlet_air_high_shutdown = adc_conv(INLET_AIR,60,0);

	novram->console_baud_rate = 9600;	/* Default Baud rate. */
	novram->printer_baud_rate = 9600;	/* Printer default baud. */
	novram->ups_baud_rate = 300;		/* UPS default baud rate. */

	novram->exhaust_air_low_warning = adc_conv(EXHAUST_AIR,5,0);
	novram->exhaust_air_high_warning = adc_conv(EXHAUST_AIR,40,0);
	novram->exhaust_air_low_shutdown = adc_conv(EXHAUST_AIR,0,0);
	novram->exhaust_air_high_shutdown = adc_conv(EXHAUST_AIR,60,0);

	novram->main_ps_temp_low_warning = adc_conv(PS_TEMP,5,0);
	novram->main_ps_temp_high_warning = adc_conv(PS_TEMP,45,0);
	novram->main_ps_temp_low_shutdown = adc_conv(PS_TEMP,0,0);
	novram->main_ps_temp_high_shutdown = adc_conv(PS_TEMP,60,0);

	novram->five_volt_low_warning = adc_conv(MAIN_FIVE_VOLT,4,6);
	novram->five_volt_high_warning = adc_conv(MAIN_FIVE_VOLT,5,4);
	novram->five_volt_low_shutdown = adc_conv(MAIN_FIVE_VOLT,4,3);
	novram->five_volt_high_shutdown = adc_conv(MAIN_FIVE_VOLT,5,7);

	novram->twelve_volt_low_warning = adc_conv(MAIN_TWELVE_VOLT,11,4);
	novram->twelve_volt_high_warning = adc_conv(MAIN_TWELVE_VOLT,12,6);
	novram->twelve_volt_low_shutdown = adc_conv(MAIN_TWELVE_VOLT,11,0);
	novram->twelve_volt_high_shutdown = adc_conv(MAIN_TWELVE_VOLT,13,0);

	novram->neg_twelve_volt_low_warning = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,11,4);
	novram->neg_twelve_volt_high_warning = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,12,6);
	novram->neg_twelve_volt_low_shutdown = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,11,0);
	novram->neg_twelve_volt_high_shutdown = 
					adc_conv(MAIN_NEG_TWELVE_VOLT,13,0);

	novram->five_volt_current_warning = 
					adc_conv(MAIN_FIVE_VOLT_CURRENT,235,0);
	novram->five_volt_current_shutdown = 
					adc_conv(MAIN_FIVE_VOLT_CURRENT,281,0);

	novram->cage_air_low_warning = adc_conv(CAGE_AIR,5,0);
	novram->cage_air_high_warning = adc_conv(CAGE_AIR,40,0);
	novram->cage_air_low_shutdown = adc_conv(CAGE_AIR,0,0);
	novram->cage_air_high_shutdown = adc_conv(CAGE_AIR,60,0);

	novram->cage_air_delta = adc_conv(CAGE_AIR,15,0);
	novram->rshutdown = 0;
	novram->rwi_val_crc = nov_chk_sum(1);
}

/*------------------------------------------------------------------------------
	nvrwichk : Checks if novram checksum is valid.
------------------------------------------------------------------------------*/
nvrwichk()
{
	if(novram->rwi_val_crc != nov_chk_sum(1))
		init_novram(3);
	return(0);
}
		
/*------------------------------------------------------------------------------
	nvpwrstat : Checks to see power status vs. clock status.
			    flg : 0 = return current value.
			    	  1 = clear novram->pwrstat.
                      		  2 = Load novram->pwrstat.  
------------------------------------------------------------------------------*/
#ifdef	SPM_PROM
nvpwrstat(flg)
unsigned int flg;
{
	if(flg==1) novram->pwrstat = 0;
	if(flg==2) novram->pwrstat = 1;
	return(novram->pwrstat);
}
#endif

/*------------------------------------------------------------------------------
	nvedit: Nvram edit and display.
------------------------------------------------------------------------------*/
nvedit()
{
	register unsigned cnt0=0,cnt1,cnt2,cnt3;
	register struct novram *nv=NOVRAM;
	char *dis="DIS", *ena="EN", *abl="ABLED.";
	char *cur="Sensor is";
	char *pwr="for Power Supply #", b[6];
	char x=0;
	char quit_loop;
	char next_loop;
	char edit_flag;
	char number_ps;

	if (ACRW_HERE)
		number_ps = 2;
	else
		number_ps = PS_PER_SYS;

	nov_cpy (nv, buff);	/* save original novram, for recovery */

start_over:
	quit_loop = 0;
	next_loop = 0;
	edit_flag = 0;
	while(!quit_loop && !next_loop) {
		for(cnt0 = 0; cnt0 != number_ps; cnt0++) {
			cnt1 = 1;
			clscrn(24);			/* Clear the screen. */
			cline('=',"[ Power Supply Sensor Enable/Disable ]");

			printf("\n  %x.) I.D. %s%x......................0x%xh.",
			cnt1++,pwr,cnt0,nv->main_pwr[cnt0].ps_id);
			printf("\n  %x.) Scaling factor %s%x............0x%xh.",
			cnt1++,pwr,cnt0,nv->main_pwr[cnt0].scale_factor);
			printf("\n  %x.) Positive Five Volt %s%x %s.....%s%s",
			cnt1++,pwr,cnt0,cur,
			(nv->main_pwr[cnt0].five_volt)?ena:dis,abl);
			printf("\n  %x.) Positive Twelve Volt %s%x %s...%s%s",
			cnt1++,pwr,cnt0,cur,
			(nv->main_pwr[cnt0].twelve_volt)?ena:dis,abl);
			printf("\n  %x.) Negative Twelve Volt %s%x %s...%s%s",
			cnt1++,pwr,cnt0,cur,
			(nv->main_pwr[cnt0].neg_twelve_volt)?ena:dis,abl);
			printf("\n  %x.) Five Volt Current %s%x %s......%s%s",
			cnt1++,pwr,cnt0,cur,
			(nv->main_pwr[cnt0].five_volt_current)?ena:dis,abl);
			printf("\n  %x.) Power Supply Temperature %s%x %s...%s%s",
			cnt1++,pwr,cnt0,cur,(nv->main_pwr[cnt0].temp)?ena:dis,abl);

			printf("\n\n  <Esc> = Quit with no changes.");
			printf("\n    <e>   = Edit this screen.");
			printf("\n    <q>   = Quit prompt and save changes.");
			printf("\n    <c>   = Cabinet sensor menu.");
			printf("\n    <CR>  = Next power supply.");
			printf("\n    <s>   = Start over.\n\n");
			pline('-',80);
			printf("\n");

			switch (cnt1 = getchar()) {
				case 0x1b:
					nov_cpy (buff, nv);
					return (0);
				case 'e':
				case 'E':
					edit_flag = 1;
					break;
				case 'q':
				case 'Q':
					quit_loop = 1;
					break;
				case 'c':
				case 'C':
					next_loop = 1;
					break;
				case 's':
				case 'S':
					nov_cpy (buff, nv);
					goto start_over;
					break;
				default:
					break;
			}
			
			if (quit_loop || next_loop)
				break;
			
			if (!edit_flag)
				continue;

			edit_flag = 0;
			printf("\nEnter the Parameter to set:");
			cnt1 = getchar();
			switch(cnt1) {
				case '1':
					printf("\nEnter the PS I.D. (hex) :");
					gets(b,3);
					x=atox(b);
					nv->main_pwr[cnt0].ps_id = x;
					break;
				case '2':
					printf("\nEnter the Scale Factor (hex) :");
					gets(b,3);
					x=atox(b);
					if(x==0) { invld(); break; }
					nv->main_pwr[cnt0].scale_factor = x;
					break;
				case '3':
					nv->main_pwr[cnt0].five_volt = 
					(nv->main_pwr[cnt0].five_volt) ? 0 : 1;
					break;
				case '4':
					nv->main_pwr[cnt0].twelve_volt =
					(nv->main_pwr[cnt0].twelve_volt) ? 0 : 1;
					break;
				case '5':
					nv->main_pwr[cnt0].neg_twelve_volt =
					(nv->main_pwr[cnt0].neg_twelve_volt) ? 0 : 1;
					break;
				case '6':
					nv->main_pwr[cnt0].five_volt_current =
					(nv->main_pwr[cnt0].five_volt_current) ? 0 : 1;
					break;
				case '7':
					nv->main_pwr[cnt0].temp =
					(nv->main_pwr[cnt0].temp) ? 0 : 1;
					break;
				default :
					invld();
					break;
			}
		}
	}

	next_loop = 0;
	while(!quit_loop && !next_loop) { /* Cabinet Sensors */

		cnt1 = 0;
		for(cnt0 = 0; cnt0 != 4; cnt0++) {
			clscrn(24);		/* Clear the screen. */
			cline('=',"[ Cabinet Sensor Enable/Disable ]");
			for(cnt2=1,cnt3=cnt1; cnt1 < (cnt3+2); cnt1++) {
				printf("\n\n  %x.) Cabinet %d %s......... %s%s",
				cnt2++,cnt1,cur,
				(nv->cab_present[cnt1].present) ? ena:dis, abl);
				printf("\n  %x.) Cabinet %d Inlet Air %s %s%s",cnt2++,
				cnt1,cur,(nv->cab_present[cnt1].inlet_air) ? ena :dis, abl);
				printf("\n  %x.) Cabinet %d Exhaust Air %s .... %s%s",cnt2++,
				cnt1,cur,(nv->cab_present[cnt1].exhaust_air) ? ena :dis, abl);
				if(cnt0 >= 3) cnt1++;
			}

			printf("\n\n  <Esc> = Quit with no changes.");
			printf("\n    <e>   = Edit this screen.");
			printf("\n    <q>   = Quit prompt and save changes.");
			printf("\n    <m>   = Modem baud menu.");
			printf("\n    <CR>  = Next cabinet.");
			printf("\n    <s>   = Start over.\n\n");
			pline('-',80);
			printf("\n");

			switch (cnt3 = getchar()) {
				case 0x1b:
					nov_cpy (buff, nv);
					return (0);
				case 'e':
				case 'E':
					edit_flag = 1;
					break;
				case 'm':
				case 'M':
					next_loop = 1;
					break;
				case 'q':
				case 'Q':
					quit_loop = 1;
					break;
				case 's':
				case 'S':
					nov_cpy (buff, nv);
					goto start_over;
					break;
				default:
					break;
			}
			
			if (quit_loop || next_loop)
				break;
			
			if (!edit_flag)
				continue;

			edit_flag = 0;
			printf("\nChoose the sensor to toggle.");
			cnt3 = getchar();
			if(cnt3 <= '3') cnt1-=2;
			else { cnt1--; cnt3 -= 3; }
			if(cnt1==7) { invld(); continue; }

			switch(cnt3) {
				case '1':
					nv->cab_present[cnt1].present =
					(nv->cab_present[cnt1].present) ? 0 : 1;
					break;
				case '2':
					nv->cab_present[cnt1].inlet_air =
					(nv->cab_present[cnt1].inlet_air) ? 0 : 1;
					break;
				case '3':
					nv->cab_present[cnt1].exhaust_air =
					(nv->cab_present[cnt1].exhaust_air) ? 0 : 1;
					break;
				default :
					invld();
					break;
			}
		}
	}

	while (!quit_loop) {

		clscrn (24);
		printf ("\n\nModem Baud Rate Currently:    %d\n",
		nv->modem_baud_rate);

		printf("\n\n  <Esc> = Quit with no changes.");
		printf("\n    <e>   = Edit baud rate.");
		printf("\n    <q>   = Quit prompt and save changes.");
		printf("\n    <s>   = Start over.\n\n");
		pline('-',80);
		printf("\n");

		switch (cnt3 = getchar()) {
			case 0x1b:
				nov_cpy (buff, nv);
				return (0);
			case 'q':
			case 'Q':
				quit_loop = 1;
				break;
			case 'e':
			case 'E':
				edit_flag = 1;
				break;
			case 's':
			case 'S':
				nov_cpy (buff, nv);
				goto start_over;
				break;
			default:
				break;
		}
		
		if (edit_flag) {

			printf ("\nEnter the desired baud rate ID:\n");
			printf ("\n	1.	1200");
			printf ("\n	2.	2400");
			printf ("\n	3.	9600");
			printf ("\n	4.	19200");
			printf ("\n	5.	38400\n\n");


			switch (cnt3 = getchar()) {
				case '1':
					nv->modem_baud_rate = 1200;
					quit_loop = 1;
					break;
				case '2':
					nv->modem_baud_rate = 2400;
					quit_loop = 1;
					break;
				case '3':
					nv->modem_baud_rate = 9600;
					quit_loop = 1;
					break;
				case '4':
					nv->modem_baud_rate = 19200;
					quit_loop = 1;
					break;
				case '5':
					nv->modem_baud_rate = 38400;
					quit_loop = 1;
					break;
				default:
					break;
			}
			printf ("\nNew baud rate:  %d.\n", nv->modem_baud_rate);
		}
	}

	if(nov_chk_sum(0) != nv->prom_crc) {
		clscrn(10);
		printf ("Save Changes? (y/n)\n");
		clscrn(5);
		x = getchar ();
		if (Yes (x))
			nov_cpy (buff, nv);
		else 
			up_nov_chksum();
	}
	else {
		printf("No changes detected\n");
		printf("Note:  Baud rate changes will not be detected\n");
	}
	return(0);
}

/*------------------------------------------------------------------------------
	nv_def_path() : Modifies the Default boot path in the NVRAM
------------------------------------------------------------------------------*/
nv_def_path(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	char b[PATH_LENGTH],x;

	switch (*(comm_str)) {
		case 'c':
			printf("Clear the boot paths? (y/n)\n");
			x = getchar ();
			if ( ! Yes (x) )
				return(0);

			for(x=0; x != PATH_LENGTH; x++) {
				novram->spm_boot_disk[x] = (char)0;
				novram->diag_boot[x] = (char)0;
				novram->prom_crc = nov_chk_sum (0);
			}
			return;
		case 'd':
			printf("Enter new diag default path; ESC to quit\n");
			if(gets(b,31) == -1) 
				return(0);
			strcpy(novram->diag_boot,b);
			novram->prom_crc = nov_chk_sum (0);
			break;
		case 'r':
			printf("Enter new SPM default path; ESC to quit\n");
			if(gets(b,31) == -1) 
				return(0);
			strcpy(novram->spm_boot_disk,b);
			novram->prom_crc = nov_chk_sum (0);
			break;
	}
	printf("Runtime code default boot path = %s\n", novram->spm_boot_disk);
	printf("Diagnostic default boot path = %s\n", novram->diag_boot);
}

/*------------------------------------------------------------------------------
	up_nov_chksum() : Update the novram checksum.
------------------------------------------------------------------------------*/
up_nov_chksum()	
{
	novram->prom_crc = nov_chk_sum(0);
}

/*------------------------------------------------------------------------------
	nov_chk_sum() : Checksum the novram, and return value calculated.
					Starting at location "st".
			flg == 1: warning low and high levels
			flg == 0: boot paths, configuration
------------------------------------------------------------------------------*/
nov_chk_sum(flg)
register unsigned flg;
{
	register unsigned char *nv;
	register crc=0, i, end;			/* temp variables. */

	if(flg) {
		nv = ((unchar *)(&novram->inlet_air_low_warning));
		end = ((uint)(&novram->console_baud_rate));
	}
	else {
		nv = (unsigned char *)NOVRAM;
		end = ((uint)(&novram->diag_fly_by));
	}

#ifdef DEBUG
printf("1.) nov_chk_sum: prom_crc=%x nv=%x end=%x\n",novram->prom_crc,nv,end);
#endif

	for(i=(uint)nv; i < end; i++, nv++)
		crc = (crc<<8) ^
		      crctab[((((crc>>(8))&0x00ff) ^ (*nv & 0x00ff))&0x00ff)];

#ifdef DEBUG
printf("2.) nov_chk_sum: prom_crc=%x nv=%x end=%x\n",novram->prom_crc,nv,end);
#endif
	return(crc & 0x0000ffff);	/* and return to calling program. */
}

/*------------------------------------------------------------------------------
	novchk() :	Check and see if the nov ram is set up..
				If not, set it up.
------------------------------------------------------------------------------*/
novchk()
{
	register unsigned sbus;
	short	i,j;
	char needupdate=0;
	unsigned char	id,iom_num;
	struct		icb_config	*icbp;

	if (!validmap) {
		printf ("Configuration Table not valid, execute cl css.\n");
		return;
	}

	if(novram->novram_ver != NOVRAM_VER) 
		nov_reconfig(2);

	if(nov_chk_sum(0) != novram->prom_crc) 
		nov_reconfig(1);

	for(sbus = 0; sbus != Sbus_Num_Slot; sbus++) {
#ifdef DEBUG1
		printf("novchk 1: add=%x slot=%x NV=%x TAB=%x\n",
		&novram->css_slot[sbus],sbus,novram->css_slot[sbus],bdhere[sbus]);
#endif
	 	if(novram->css_slot[sbus] != bdhere[sbus])
			needupdate++;
	}

	iom_num = 0;
	for(i = 0; i < Sbus_Num_Slot; i++)	/* find IO module */
	{
		if(bdhere[i] == IOMHERE)	{
			if(novram->iom_slot[iom_num].iom_slot != i) {
				needupdate++;
#ifdef DEBUG1
	printf("novchk 2: slot=%x  WAS=%x  S/B=%x\n",iom_num,
	novram->iom_slot[iom_num].iom_slot, i);
#endif
			}
			for(j = 0; j < MAX_IO_SLOT; j++)  { /* check io slot */
				icbp = &io_conf[iom_num][j];
				id = icbp->icb_slot_id;	/* Board id info */
				if(novram->iom_slot[iom_num].icb_slot[j]!=id) {
					needupdate++;
#ifdef DEBUG1
	printf("novchk 3: iomslot=%x icb=%x WAS=%x S/B=%x\n",iom_num, j,
	novram->iom_slot[iom_num].icb_slot, id);
#endif
				}
			}
			iom_num++;
		}
	}

	if(needupdate) {
		printf("\n");
		printf("WARNING: Polled and Stored CONFIGURATION mismatch.\n");
		nov_reconfig(0);		/* reconfigure novram. */
	}
}

/*------------------------------------------------------------------------------
	nvinit() : Nvram intializition.
------------------------------------------------------------------------------*/
nvinit(comstr, argcnt)
char *comstr;
int argcnt;
{
	char x;

	if (!validmap) {
		printf ("Configuration Table not valid, execute cl css.\n");
		return;
	}

	if(!argcnt) {
		nov_reconfig(1);
		return(0);
	}
	else {
		if(((x=(char)atox(comm_args[1])) < 0) || (x > 2)) {
			invld();
			return(1);
		}
	nov_reconfig(x);
	}
}

/*------------------------------------------------------------------------------
	nov_reconfig(crcbad) :	Reconfigure the novram.
				crcbad = Level of reconfiguration.
------------------------------------------------------------------------------*/
nov_reconfig(crcbad)
int crcbad;	/* if set, then it's a bad crc; assume never initilized. */
{
	int c;

	if(!crcbad) {		/* just a configuration error. */
		printf("\nWarning:  NV RAM configuration needs updating. (y/n)");
		c = getchar();	/* get one character in, no macro buffer. */
		printf("%c\n",(char)c);	/* show character input. */
		if(c != 'y')		/* if didn't say yes.. */
			return;		/* skip reconfigure. */

		nov_def_path();		/* Initialize the boot pathname. */
	}

	if(crcbad==1) {
		printf("\nNV RAM: System and RWI configurations being initialized.\n");
		init_novram(1);		/* go init it. */
		nov_def_path();		/* Initialize the boot pathname. */
	}

	if(crcbad==2) {
		printf("\nNon-volatile RAM is being completely re-configured.\n");
		init_novram(2);		/* go init it. */
		update_boot_path (3);
	}

	init_novram_config();	/* init the novram now, since it's bad. */
	up_nov_chksum();		/* Update the novram checksum.. */
}

/*------------------------------------------------------------------------------
	c_dfb: Change the Diagnostic Fly By flag.
------------------------------------------------------------------------------*/
#ifdef	SPM_PROM
c_dfb()
{
	novram->diag_fly_by = (novram->diag_fly_by) ? 0 : 1;
	printf("\nDiagnostic Fly By flag is currently %s.\n",
		(novram->diag_fly_by) ? "SET" : "NOT SET");
	up_nov_chksum(0);		/* Update the novram checksum. */
}
#endif

/*------------------------------------------------------------------------------
	c_atb: Change the autoboot flag.
------------------------------------------------------------------------------*/
c_atb()
{
	novram->autoboot = (novram->autoboot) ? 0 : 1;
	printf("\nAutoboot is currently %sABLED\n",(novram->autoboot)?"EN":"DIS");
	up_nov_chksum(0);		/* Update the novram checksum. */
}

/*------------------------------------------------------------------------------
	mark_auto_boot(val) : Mark what we are doing to boot.
						  val : 1 = auto boot, 0 = manual boot.
------------------------------------------------------------------------------*/
mark_auto_boot(val)
int val;
{
	novram->autoboot = (char)val;	/* Change it. */
	up_nov_chksum();		/* Update the novram checksum. */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
init_novram_config()
{
	register unsigned sbus;
	register int chan, mux, i;

	if (!validmap) {
		printf ("Configuration Table not valid, execute cl css.\n");
		return;
	}

	novram->main_pwr[0].ps_id = SWITCHING_POWER;	/* Default. */
	novram->main_pwr[0].scale_factor = SW_VOLTS_PER_AMP; /* 160	 */
	novram->main_pwr[0].five_volt = 1;		/* Enable Sensor. */
	novram->main_pwr[0].twelve_volt = 1;		/* Enable Sensor. */
	novram->main_pwr[0].neg_twelve_volt = 1;	/* Enable Sensor. */
	novram->main_pwr[0].five_volt_current = 1;	/* Enable Sensor. */
	novram->main_pwr[0].temp = 1;			/* Enable Sensor. */

	novram->cab_present[0].present = 1;		/* At least One. */
	if (ACRW_HERE) {
		novram->cab_present[0].inlet_air = 0;	/* Disable sensor. */
		novram->cab_present[0].exhaust_air = 0;	/* Disable sensor. */
	}
	else {
		novram->cab_present[0].inlet_air = 1;	/* Enable sensor. */
		novram->cab_present[0].exhaust_air = 1;	/* Enable sensor. */
	}

	for(i = 1, mux=0x20, chan=0; i < 7; i++, mux+= 0x20) {

		if(mux > 0x70) {		/* past last one here.. */
			mux = 0;
			chan+=2;		/* next channel number. */
		}

		if(readsensor(mux,chan)) { 
			novram->cab_present[i].present = 1; /* Cabinet here. */
			novram->cab_present[i].inlet_air = 1; /* Enable. */
			novram->cab_present[i].exhaust_air = 1;	/* Enable. */
		}
		else {
			novram->cab_present[i].present = 0;	/* no cabinet */
			novram->cab_present[i].inlet_air = 0;	/* Disable. */
			novram->cab_present[i].exhaust_air = 0;	/* Disable. */
		}
	}

	for(i = 1, mux=0x10, chan=3; i < 5; i++, mux+= 0x10)
		if(readsensor(mux,chan)) {					/* read cabinet temps */
			novram->main_pwr[i].ps_id = SWITCHING_POWER;	/* show it here. */
			novram->main_pwr[i].scale_factor = SW_VOLTS_PER_AMP; /* 160	 */
			novram->main_pwr[i].five_volt = 1;			/* Enable Sensor. */
			novram->main_pwr[i].twelve_volt = 1;		/* Enable Sensor. */
			novram->main_pwr[i].neg_twelve_volt = 1;	/* Enable Sensor. */
			novram->main_pwr[i].five_volt_current = 1;	/* Enable Sensor. */
			novram->main_pwr[i].temp = 1;				/* Enable Sensor. */
		}
		else {
			novram->main_pwr[i].ps_id = 0xff;			/* else, not here. */
			novram->main_pwr[i].scale_factor = 0;
			novram->main_pwr[i].five_volt = 0;			/* Disable Sensor. */
			novram->main_pwr[i].twelve_volt = 0;		/* Disable Sensor. */
			novram->main_pwr[i].neg_twelve_volt = 0;	/* Disable Sensor. */
			novram->main_pwr[i].five_volt_current = 0;	/* Disable Sensor. */
			novram->main_pwr[i].temp = 0;				/* Disable Sensor. */
		}
	for(sbus = 0; sbus < Sbus_Num_Slot; sbus++) {
			novram->css_slot[sbus] = bdhere[sbus];	/* save slot id's */
	}
	novram_io();
}

/*---[tgm]----------------------------------------------------------------------
nov_def_path : Verifies that the path in the novram is valid.
	       If not default to 1st IOM, 1st controller, drive 0.
------------------------------------------------------------------------------*/
nov_def_path()
{
	char *pathptr;
	char  path_error=0;

	pathptr=(char *)&novram->spm_boot_disk[0];	/* Get default. */

	get_device_info (pathptr);

	if (boot_type == DV_NO_DEV) {
		printf("Illegal syntax in default SPM path %s\n", pathptr);
		path_error += 1;
	}

	pathptr=(char *)&novram->diag_boot[0];		/* Get default. */

	get_device_info (pathptr);
	
	if (boot_type == DV_NO_DEV) {
		printf("Illegal syntax in default diag path %s\n", pathptr);
		path_error += 2;
	}

	if (path_error) 
		update_boot_path (path_error);
	else
		return (0);

	return (1);
}


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
novram_io()	/* Store the io configuration NOVRAM.*/
{
	short		i,j;
	uchar	id,iom_num;

	iom_num = 0;
	for(i = 0; i < IOM_PER_SYS; i++) {        /* clear all boards's to FF */
		novram->iom_slot[i].iom_slot = 0xFF;
		for(j = 0; j <= MAX_IO_SLOT; j++)
			novram->iom_slot[i].icb_slot[j] = 0xff;
	}

	for(i = 0; i < Sbus_Num_Slot; i++) {		/* find IO module */
	
		if(bdhere[i] == IOMHERE) {

			novram->iom_slot[iom_num].iom_slot = i;

			for(j = 0; j < MAX_IO_SLOT; j++) {  /* check io slot */
				id = io_conf[iom_num][j].icb_slot_id;
				novram->iom_slot[iom_num].icb_slot[j] = id;
			}
			iom_num++;
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
show_config()	/* show novram configuration. */
{
	register unsigned num;
	register unsigned sbus_slot;
	register unsigned iom_num, icb_slot;
	char	opt_string[16];
	int	arg;

	if(clokpr(0)) /* If running on local clock return. */
		return(1);

	if (!validmap) {
		printf ("Configuration Table not valid, execute cl css.\n");
		return;
	}

	printf("\n");
	for(num=0; num < PS_PER_SYS; num++) {
		printf("Power supply %d type is ",num);
		switch(novram->main_pwr[num].ps_id ) {
			case SWITCHING_POWER:
				printf("Switching Power.\n");
				break;
			case HC_POWER:
				printf("HC Power.\n");
				break;
			case NO_POWER_SUPPLY:
				printf("No P/S Detected.\n");
				break;
			default:
				printf("Unknown type.\n");
				break;
		}
	}
	printf("Runtime code default = %s\n",novram->spm_boot_disk);
	printf("Diagnostic default = %s\n",novram->diag_boot);
	printf("Default SPM port baud rates are:\n");
	printf("    Console port : %d\n", novram->console_baud_rate);
	printf("    Modem port   : %d\n", novram->modem_baud_rate);
	printf("    Printer port : %d\n", novram->printer_baud_rate);
	printf("Diagnostic AREA NV RAM checksum is : %4X\n\n",
	nov_chk_sum(0));

	anykey ();
	clscrn (25);

	for (sbus_slot = 0; sbus_slot != Sbus_Num_Slot; sbus_slot++) {
		opt_string[0] = '\0';
		switch(novram->css_slot[sbus_slot] & BDTYPEMASK) {
			case SPMTYPE: printf("SPM    "); break;
			case MEMTYPE: 
				printf("MM     ");
				arg = bdidsl(sbus_slot); 
				arg = (arg &0x00000700) >> 8;
				if (arg > MAX_MEM_TYPE) 
					arg = 0;
				strcpy (opt_string, MEM_TYPE[arg]);
				break;
			case CPUTYPE: printf("PM     "); break;
			case DPMTYPE: printf("DPM    "); break;
			case IOMTYPE: printf("IOM    "); break;
			case IOPTYPE: printf("IOPM   "); break;
			case VAMTYPE: printf("VAM    "); break;
			case NOBOARDTYPE: continue; break;
			default: printf("UNKNOWN"); break;
		}
		printf(" module in slot 0x%x (%d)  %s\n", 
				sbus_slot, sbus_slot, opt_string);
	}

	anykey ();
	clscrn (25);

	for(iom_num = 0; iom_num < IOM_PER_SYS; iom_num++) {
	    for(icb_slot = 0; icb_slot < ICB_DEVS_PER_IOA; icb_slot++) {
			switch(novram->iom_slot[iom_num].icb_slot[icb_slot]) {
				case EDT:  printf("EDT    "); break;
				case SCSI: printf("SCSI   "); break;
				case GCP:
				case EGCP: printf("GC     "); break;
				case MAC:  printf("MAC    "); break;
				case ICB_NO_BOARD: continue; break;
				default:   printf("UNKNOWN"); break;
			}
		printf(" module, IOM 0x%x CSS slot 0x%x (%d) ICB slot 0x%x (%d)\n",
		iom_num,novram->iom_slot[iom_num].iom_slot, novram->iom_slot[iom_num].iom_slot, icb_slot, icb_slot);
	    }
	}
}


/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/

update_boot_path (flag)
uint	flag;
{
	char	b[PATH_LENGTH];

	switch (flag) {
		case 1:
			printf("Enter new SPM default path; ESC to quit\n");
			if(gets(b,31) == -1) 
				return(0);
			strcpy(novram->spm_boot_disk,b);
			novram->prom_crc = nov_chk_sum (0);
			break;
		case 2:
			printf("Enter new diag default path; ESC to quit\n");
			if(gets(b,31) == -1) 
				return(0);
			strcpy(novram->diag_boot,b);
			novram->prom_crc = nov_chk_sum (0);
			break;
		case 3:
			printf("Enter new SPM default path; ESC to quit\n");
			if(gets(b,31) == -1) 
				return(0);
			strcpy(novram->spm_boot_disk,b);
			novram->prom_crc = nov_chk_sum (0);

			printf("Enter new diag default path; ESC to quit\n");
			if(gets(b,31) == -1) 
				return(0);
			strcpy(novram->diag_boot,b);
			novram->prom_crc = nov_chk_sum (0);
			break;
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
chk_sum(strt, len)
register unsigned char *strt;
register len;
{
	register crc=0, i;			/* temp variables. */

	for(i = 0; i < len; i++, strt++)
		crc=(crc<<8) ^ crctab[((((crc>>(8))&0x00ff) ^ (*strt&0x00ff))&0x00ff)];
	return(crc & 0x0000ffff);	/* and return to calling program. */
}

int
run_pwroff()
{
	return(novram->rshutdown);
}

