/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) menu.c: version 25.1 created on 11/27/91 at 14:39:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)menu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*  menu.c
 *
 *	print_menu (ptr) - Print current local menu
 *
 *	struct menu {
 *		char *comm_text;
 *		char *comm_opt;
 *		char *comm_desc;
 *		char comm_type;
 *		unsigned char lo_limit;
 *		unsigned char hi_limit;
 *		union {
 *			PFI procedure;
 *			struct menu *menu_p;
 *		} command;
 *		char *help;
 *	};
 *
 *	Menu.comm_text is the full text for the command name, such as 'l(ist)'.
 *	Menu.comm_opt is the description of the options for the command.
 *	Menu.comm_desc is the description for the command.
 *	Menu.comm_type is one of 'c' or 'm', defining the command to be
 *		a straight command or a pointer to another menu, respectively.
 *	Menu.lo_limit is the low limit of the number of arguments allowed for
 *		the command.
 *	Menu.hi_limit is the high limit of the number of arguments allowed for
 *		the command.
 *	Menu.command is a union containing either a pointer to a procedure or
 *		a pointer to another menu.
 *	Menu.command.procedure points to the related procedure.
 *	Menu.command.menu_p points to the related sub-menu.
 *	Menu.help is a text description for this command.
 *	Menus are terminated with a null string in the menu.comm_text field.
 */
#include "types.h"
#include "menu.h"
#include "routines.h"
#include "globl.h"
#include "global.h"
#include "misc.h"

#ifdef	SPM_IMAGE
extern char macbuf[]; /* used in the download directory. 2kbytes of space */
char mac_args[MAXARGS][MAXARGSIZE]; /* space for mac substitution. */
char *macro;	/* this is the pointer to current buffer. */
char *swapin;	/* this is the pointer to current swap buffer. */
char *savemac;	/* this is the pointer to current buffer. */
char frombuf; /* used to toggle buffer execute on and off. */
char exitmac; /* if set, return to monitor *NOW*. */
char inbuf1; /* if set, copy all characters into buffer. */
char inbuf; /* used to toggle buffer input on and off. */
char forever; /* used for looping on command buffer. */
char swapping;	/* if set, it's getting characters from substitution string. */
unsigned mactime;	/* timer for macro buffer. */
extern char tmp_size; /* used to toggle buffer execute on and off. */
#endif

print_menu ()
{
    struct menu *mp;
    register unsigned char	linec = 0;
    register char		ch;

    mp = menu_stack[menu_ptr - 1].m_ptr;

    while (*mp->comm_text != '\0')
	{
		printf ("%10S  %19S  %s", mp->comm_text, mp->comm_opt, mp->comm_desc);
		if (mp->comm_type == 'm')
			printf (" %s", "Menu");
		putchar ('\n');
		mp++;
		linec++;

		if (linec < 23)
			continue;
		else
		{
			linec = 0;
			printf("==> <ESC> to quit; <Other Key> to continue: ");
			ch = getchar();
			printf("\r                                               \r");
			if ((ch & 0177) == ESCAPE)
				return(0);
		}
    }
    return (0);
}


print_help(comm_str, arg_cnt)
char *comm_str;
int	arg_cnt;
{
	int	i;
	struct menu *menup;
	char	*cp;
	char combuf[256];

	if(arg_cnt < 1)  /* if there are no arguments. */
	{
		combuf[0]=0; /* make it so. */
		printf("Which command? : ");
		if(!((cp = gets(combuf,255)) == combuf))
			return(0); /* didn't type a command. */
	}
	else
	{
		i = 0;
		while(combuf[i] = comm_args[1][i])
			i++;
		cp = combuf;	/* set pointer. */
	}
	if (argsplit(cp) == -1)
		return(0);	/* if no args to copy.. */
	if((i=com_search(comm_args[0],0, 1)) != -1 && i) /* if found it */ 
		printf ("Command not found\n");
	return(0);	/* return anyway we want to. */
}

#ifdef	SPM_IMAGE
maccmd(comm_str, arg_cnt) /* command routine for macro buffer. */
char *comm_str;
int arg_cnt;
{
	char *addr;
	int 	i;
	char ch;

/*	forever = 0;	/* make it not loop now.. Commented out, to try it. */
	switch((int)mref_siz)
	{
	case '?':	/* default: help command. */
	case 'h':	/* default: help command. */
	case 'l':	/* default: help command. */
		printf("\
usage: mac.[funbchasedt] [<arg> <arg>]\n\
 where:\n\
    f               Forever - loop on entire command buffer.\n\
    u <name> <add>  Upload - save buffer to host system\n\
    n <add>         New - delete contents of buffer\n\
    b <c> <string>  Buffer change: substitute <string> for <#c> pair\n\
    c <add>         Check - check contents of buffer\n\
    h               Help - this option.\n\
    a <add>         Append - add to end of buffer\n\
    s               Stop - stop input of commands into buffer\n\
    e <add>         Execute - execute commands in buffer\n\
    d <add>         Download - download a new buffer\n\
    t <loop>        Timer - loop HEX times then issue ESC\n\
");
		break;
	case 'f':   /* same as execute, only loop forever.. */
		forever = 1; /* make it loop. */
	case 'e':	/* same as execute. */
		exitmac = 0;	/* make sure this is cleared out. */
		if(!arg_cnt)	/* if using default buffer. */
			macro = macbuf; /* get character buffer. */
		else
			macro = (char *)atox(comm_args[1]); /* get character buffer. */
		if(*macro) /* if chars there.. */
		{
			savemac = macro;	 /* save it for later. */
			frombuf = 1; /* enable commands. */
		}
		else
			printf("Sorry, command buffer is not loaded.\n");
		break;
	case 'n':
		if(!arg_cnt)	/* if using default buffer. */
			macro = macbuf; /* get character buffer. */
		else
			macro = (char *)atox(comm_args[1]); /* get character buffer. */
		macro = macbuf; /* and reset it.*/
		*macro = 0; /* clear it. */
		inbuf = 1;	/* show we are in input mode now. */
		printf("\nBuffer input active.\n");
		break;
	case 'a':
		if(!arg_cnt)	/* if using default buffer. */
			macro = macbuf; /* get character buffer. */
		else
			macro = (char *)atox(comm_args[1]); /* get character buffer. */
		while(*macro)	/* while characters in the buffer. */
			macro++;	/* skip to next character. */
		inbuf = 1;	/* show we are in input mode now. */
		printf("\nBuffer append active.\n");
		break;
	case 'b':	/* substitution buffer change/add. */
		if(!arg_cnt) /* if no arguments, show what's here. */
		{
			for(i = 0; i < MAXARGS; i++) /* loop through all. */
				printf("[%c] = %s\n", (i+'a'), mac_args[i]); /* show it. */
			break;	/* all done. */
		}
		ch = comm_args[1][0]; /* get first char. */
		ch--;	/* sub one, for offset from zero. */
		ch &= 0x0f; /* and fix up string pointer. */
		if(comm_args[1][1]) /* there is more than one char.. */
		{ /* probably a bad typo.  do what we can to tell them.. */
			printf("Too many letters in first argument.\n");
			printf("Usage:  mac.b                  to show strings.\n");
			printf("        mac.b letter           to clear string.\n");
			printf("        mac.b letter string    to add string.\n");
			break;	/* no go. */
		}
		if(arg_cnt == 1)	/* it's a delete buffer.. */
			mac_args[ch][0] = 0;	/* clear this string out. */
		else
		{
			strncpy(mac_args[ch], comm_args[2], MAXARGSIZE-1); /* copy in.*/
			mac_args[ch][MAXARGSIZE-1] = '\0'; /* just incase :) */
		}
		break;
	case 'd':
		macget(comm_str,arg_cnt); /* get a macro buffer from host. */
		break;
	case 'u':
		macsav(comm_str,arg_cnt); /* save a macro into host memory. */
		break;
	case 's':
		*macro = '\0'; /* clear current location..*/
		inbuf = 0;	/* clear this out as well. */
		inbuf1 = 0;	/* clear this out as well. */
		printf("\nStop executed.\n");
		break;
	case 'c':
		if(!arg_cnt)	/* if using default buffer. */
			addr = macbuf; /* get character buffer. */
		else
			addr = (char *)atox(comm_args[1]); /*get character buffer*/
		i = 0;
		while(ch = (*addr++)&0x7f)  /* while chars here. */
		{
			if(ch >= 0x20 || ch == '\n')
				printf("%c", ch);	/* show current contents. */
			else
				printf("^%c", ch+0x40);	/* show current control contents. */
			if(ch == '\n' || ch == '\r') /* new line, show it. */
			{
				if(i++ == 20) /* one screen full. */
				{
					i = 0; /* next page. */
					printf("\n\rContinue (y/n)? ");
					if(getchar() == 'n') /* oh well.. */
						break; /* stop now. */
				}
			}
		}
		break;
	case 't':
		if(inbuf)	/* if adding to macro buffer commands.. allow this one. */
		{
			while(*macro = *comm_str++) /* while chars here. */
				macro++;	/* add to string. */
			*macro++ = '\n'; /* add line feed. */
			*macro = '\0'; /* make sure it's been terminated.. */
			break; /* done. */
		}
		if(!arg_cnt)	/* if using default buffer. */
			mactime = 0; /* clear out count as well. */
		else
			mactime = (unsigned)atox(comm_args[1]); /* get loop count. */
		printf("Timer set to 0x%X (%d).\n", mactime, mactime);
		break;	/* done. */
	}
	tmp_size = 'l'; /* change back for all other comands.. sigh. */
}

macchar()	/* get a character from the macro buffer. */
{
	register c, c1;

	if(exitmac)  /* if saw escape char.. exit. */
	{
		frombuf = forever = 0;
		c = '\r'; /* change to end all comands. */
		return(c);	/* and send back char. */
	}
	if(swapping) /* if macro expansion in progress. */
	{
		if(*swapin) /* if there is one left in buffer. */
			return(*swapin++); /* send it back. */
		else
			swapping = 0;	/* clear this out. */
	}
	if(!(c = (*macro++&0x7f)))  /* if end of the buffer.. */
	{
		if(mac_start()) /* reset pointers. */
			if((c = (*macro++&0x7f)))  /* if !end of the buffer.. */
				return(c);	/* return with char. */
		frombuf = 0;	/* turn off buffer mode. */
		c = '\r'; /* change to end all comands. */
	}
	if(c == '#') /* macro substitution command. */
	{
		if(!(c1 = (*macro++&0x7f)))  /* if end of the buffer.. */
		{
			macro--; /* backup one character again, for next pass. */
			exitmac = 1; 	/* let's exit this. */
			printf("\nInvalid use for argument character #.\n");
			return('#'); /* end of buffer. */
		}
		if(c1 == '#') /* this is an escaped '#' */
			return(c1);	/* return it now. */
		c1--;	/* sub one to run from zero instead of 1.. */
		c1 &= 0x0f; /* strip off top bits. */
		if(!*mac_args[c1]) /* if there is NOT a string here. */
		{
			exitmac = 1; 	/* let's exit this. */
			printf("\nInvalid data for argument #%c.\n", (char)c);
			return('\n');	/* show not here. */
		}
		swapin = mac_args[c1]; /* point to swapping character string. */
		swapping++; /* show it's active now. */
		return(*swapin++); /* return new character. */
	}
	return(c);	/* and send back char. */
}

mac_start()	/* return 1 if continue, else return 0 */
{
	if(forever)	/* if in looping mode.. */
	{
		if(ifesc())  /* if hit escape char.. */
		{
			swapping = forever = frombuf = 0;	/* turn off buffer mode. */
			return(0); /* make sure it ends. */
		}
		macro = savemac; /* point it back to the beginning. */
		return(1);	/* continue. */
	}
	return(0); /* stop looping. */
}

init_buf()	/* initilize the macro buffer. */
{
	register i = 0;

	macro = macbuf;	/* make sure it's zeroed.. */
	*macro = i;	/* make sure it's zeroed.. */
	frombuf = i;	/* make sure it's zeroed.. */
	forever = i;	/* make sure it's zeroed.. */
	exitmac = i;	/* make sure it's zeroed.. */
	inbuf = i;	/* make sure it's zeroed.. */
	inbuf1 = i;	/* make sure it's zeroed.. */
	swapping = i;	/* show not swapping. */
	for(i = 0; i < MAXARGS; i++) /* clear out pre-defined buffers. */
		mac_args[i][0] = 0; /* make sure it's not here. */
}

echo(comm_str, arg_cnt) 	/* just echo this string to console. */
char *comm_str;
int arg_cnt;
{
	return(0); /* don't do anything, since it's already on screen. */
}


beep()	/* make a noise. */
{
	printf("");
	return(0);
}

wait_it(comm_str, arg_cnt) 	/* wait for a key press, or X seconds. */
char *comm_str;
int arg_cnt;
{
	int i1, i2, beep=0;

	if(*comm_str == 'b') /*  if BEEPwait command. */
		beep++;
	if(beep) printf("");
	printf("\nPress any key to continue: "); /* show them. */
	if(!arg_cnt)	/* if no arguments.. */	
		getchar();	/* wait for it, no macro buffer allowed. */
	else
	{
		i2 = atox(comm_args[1]); /* get number of seconds. */
		while(i2--)	/* while seconds. */
		{
			for(i1 = 0; i1 < 42000; i1++)
				if(con_in() != -1) /* if pressed a key. */
				{
					printf("\n");	/* next line. */
					return(0); /* exit loop *now* */
				}
			if(beep) printf("");
		}
	}
	printf("\n");	/* next line. */
	return(0);
}
#endif

/*
 * Global menu
 *
 * These are the global commands.
 *
 */

struct init_menu i_global_comm[] = {
	"h(elp)", "", "", 'c', 0, 1, print_help, (char *)0,
	"?", "", "", 'c', 0, 0, help, (char *)0,
	"l(ist)", "", "", 'c', 0, 0, print_menu, (char *)0,
	"ls", "", "", 'c', 0, 2, print_menu, (char *)0,
#ifdef	SPM_IMAGE
	"mac<.[abcdefhlnstu?]>", "", "", 'c', 0, 2, maccmd, (char *)0,
	"wait", "", "", 'c', 0, 1, wait_it, (char *)0,
	"bwait", "", "", 'c', 0, 1, wait_it, (char *)0,
	"beep", "", "", 'c', 0, 1, beep, (char *)0,
	"echo", "", "", 'c', 0, MAXARGS+1, echo, (char *)0, /* trick below */
#endif
	"", "", "", '\0', 0, 0, 0, (char *)0,
};

/* Note: Maximum arguments is normally MAXARGS; by specifing one more, it will
   truncate to MAXARGS when it comes back from splitargs();  so, if you specify
   more than will ever come back, it won't give you an argument error.
   At least, this is the theory I came up with.. 
*/

struct menu *global_comm = (struct menu *)i_global_comm;

    /* Make the menu stack one larger so we can do the global stuff */
struct mstack menu_stack [MENUSTACKSIZE + 1];
int menu_ptr;

