/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mem1.c: version 25.1 created on 11/27/91 at 14:39:34	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mem1.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "types.h"
#include "globl.h"
#include "global.h"
#include "spm.h"
#include "menu.h"
#include "loc_rout.h"

int edac_flag;		/* Enable or disable EDAC circuit */
char mem_test;		/* set if we want to know about EDAC INTS. */
int brk_flg;		/* operator abort flag */
unsigned err_cnt;	/* error counter for memory tests */
extern  unsigned char emulate;
extern  char got_berr;

extern  void	fill32 ();
int	memtest8 ();
void	disable_mem ();
void	enable_mem ();
int	check_pipe_wr ();
struct wr_info *get_wr_info ();

struct  wr_info
	{
	unsigned int	raw_data;
	unsigned int	addr_off;
	unsigned int	wr_size;
	};

#define		FULL_WAIT	1000
#define		ADDR_OFF_SHFT	8
#define		ADDR_MASK	0x03
#define		ADDR_CLR	0xFFFFFCFF
#define		TST_PAT_SHIFT	4
#define		TST_PAT_MASK	0x1F
#define		WRITE_TYPE_MASK 0x1F
#define		WRITE_TYPE_SHFT 8
#define		BYTE_WRITE	0
#define		WORD_WRITE	1
#define		LONG_WRITE	2
#define		MAX_MEM_ERR	16
#define		PIPELINE_LIMIT	4
#define		MMT8_SIZE	32
#define		RANDOM_MULT	0xFDB97531
#define		DEFAULT_RANDOM	0x12345679
#define		STATUS_NACK	0x00000001

extern unsigned int tst_pat[];

char  *wr_type [] = {
	"byte write",
	"word write",
	"long write",
	"no write done",
	};


/* CSS memory test
*  memtest8() -- Command syntax :
*             mmt8  <start addr> <[slot]>
*  Type of transfer is not specified 
*  Input command pipeline Test, data selected to verify pipeline, start
*  and slot only used to define beginning point to use for the test, size 
*  is not defined, as the test will always use 32 bytes of the memory
*/

int
memtest8(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int random_value;
	int write[PIPELINE_LIMIT];
	unsigned char write_data[MMT8_SIZE];
	int err = 0;
	int i;
	int addr_off;
	int rnd_use;
	int old_err = 0;
	register unsigned int cnt;
	register unsigned int pass = 0;
	unsigned char slot;
	unsigned char addr;
	register unsigned int wr_data;
	register unsigned char *wr_addr;
	register unsigned char *wr_save;
	register unsigned char *start;
	register unsigned char *end;
	char  save_berr;

	save_berr = got_berr;
	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);

	init_css();	/* make sure everthing is ready. */
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	random_value = (unsigned)atox(comm_args[2]); /* get seed. */
	if (random_value == 0)
		random_value = DEFAULT_RANDOM;
	offset &= 0xFFFFFFFC;	/* align on a long boundary */
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (unsigned char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (unsigned char *)(start + MMT8_SIZE);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt8 on CSS block, press <ESC> to stop\n");
	printf ("Data is generated by test\n");
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x \n", 
					slot, (offset&0x0fffffff), MMT8_SIZE); 

	if(edac_flag == 1)		/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}
	while (1) {
		if (ifesc())   
			break;

		fill32 (start, end, 0x00000000, 0);  /* fill with 0's */
		fill32 (write_data, (write_data + MMT8_SIZE), 0x00000000, 0);  
		
		if (ifesc())   
			break;

		disable_mem ();
		for (cnt = 0; cnt < PIPELINE_LIMIT;)
			{
			random_value *= RANDOM_MULT;
			rnd_use = write[cnt] = (int)(random_value & 0x7FFFFFFF);
			rnd_use = rnd_use >> ADDR_OFF_SHFT; 
			addr_off = rnd_use & ADDR_MASK;
			rnd_use = rnd_use >> TST_PAT_SHIFT; 
			wr_data = tst_pat[(rnd_use & TST_PAT_MASK)];
			rnd_use = rnd_use >> WRITE_TYPE_SHFT;
			wr_addr = (unsigned char *)(start + (cnt * 8));
			wr_save = (unsigned char *)(write_data + (cnt * 8));
			switch ((rnd_use & WRITE_TYPE_MASK) % 3)
				{
				case BYTE_WRITE:
					cnt++;
					wr_addr += addr_off;
					wr_save += addr_off;
					*(unsigned char *)wr_addr = 
					     (unsigned char)(wr_data & 0xFF);
					*(unsigned char *)wr_save = 
					     (unsigned char)(wr_data & 0xFF);
					break;
				case WORD_WRITE:
					if (addr_off == 0x3)
						{
						if (cnt == 3)
							{
							write[cnt] &= ADDR_CLR;
							addr_off = 0;
							}
						else
							{
							cnt++;
							write[cnt] = -1;
							}
						}
					cnt++;
					wr_addr += addr_off;
					wr_save += addr_off;
					*(unsigned short *)wr_addr = 
					     (unsigned short)(wr_data & 0xFFFF);
					*(unsigned short *)wr_save = 
					     (unsigned short)(wr_data & 0xFFFF);
					break;
				case LONG_WRITE:
					if (addr_off != 0x0)
						{
						if (cnt == 3)
							{
							write[cnt] &= ADDR_CLR;
							addr_off = 0;
							}
						else
							{
							cnt++;
							write[cnt] = -1;
							}
						}
					cnt++;
					wr_addr += addr_off;
					wr_save += addr_off;
					*(unsigned int *)wr_addr = 
					     (unsigned int)wr_data;
					*(unsigned int *)wr_save = 
					     (unsigned int)wr_data;
					break;
				}
			}
/*
	negative test for attempted write to board with full pipeline
*/

		for (i = 0; i < FULL_WAIT; i++);
		got_berr = 0;
		emulate = 1;
		*wr_addr = 0xFFFFFFFF;
		emulate = 0;
		if (got_berr != 1)
			{
			printf ("mmt8 ERROR 5: writes did not get bus error\n");
			err++;
			}

		if ( !(*STATUSREG && STATUS_NACK))
			{
			printf ("mmt8 ERROR 5 writes: low nack - logic 0\n");
			err++;
			}

		enable_mem ();

		err += check_pipe_wr (write, start, write_data);

		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;
		printf ("Passes:  %d,  Total Errors:  %d", ++pass, err);
		}
	printf("\n mmt8 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	got_berr = save_berr;
	return (err);
}

int
check_pipe_wr (write, start, write_data) 
unsigned int write [];
register unsigned int *start;
register unsigned int *write_data;
{

	register unsigned int err = 0;
	register unsigned int wr_data_lo;
	register unsigned int wr_data_hi;
	register unsigned int rd_data_lo;
	register unsigned int rd_data_hi;
	register struct wr_info *write_info;
	register int cnt;

	for (cnt = 0; cnt < PIPELINE_LIMIT; cnt++)
		{
/*
	Get data from memory board under test
*/
		rd_data_lo = *start;
		start++;
		rd_data_hi = *start;
		start++;

/*
	Get data from local memory image
*/
		wr_data_lo = *write_data;
		write_data++;
		wr_data_hi = *write_data;
		write_data++;

		if (rd_data_lo != wr_data_lo)
			{
/*
	Get parameters describing how write was done
	Print error message describing how write was done, and expected
	versus received data
*/
			write_info = (struct wr_info *)get_wr_info (write[cnt]);
			printf ("Pipeline write failure\n");
			printf ("%s, a1-a0:  %d, pattern:  %08x\n",
				wr_type[write_info->wr_size], write_info->addr_off, write_info->raw_data);
			printf ("Addr:  0x%08x, Expected:  %08x, Got:  %08x\n",
				(start - 1), wr_data_lo, rd_data_lo);
			err++;
			}

		if (rd_data_hi != wr_data_hi)
			{
/*
	Get parameters describing how write was done
	Print error message describing how write was done, and expected
	versus received data
*/
			write_info = (struct wr_info *)get_wr_info (write[cnt]);
			printf ("Pipeline write failure\n"); 
			printf ("%s, a1-a0:  %d, pattern:  %08x\n",
				wr_type[write_info->wr_size], write_info->addr_off, write_info->raw_data);
			printf ("Addr:  0x%08x, expected:  %08x, got:  %08x\n",
				start, wr_data_hi, rd_data_hi);
			err++;
			}
		}
	return (err);
	}

/*------------------------------------------------------------------------------
	enable_mem:	Enable the slot and interface to a slot.
------------------------------------------------------------------------------*/
void
enable_mem()
{
	register int i;
	char  save_berr;
	register int d=50000;		/* changed to bypass 68020 bug.. */
	int *bog=(int *)0x80000040;	/*pointer for sending commands, 9 will
					  use map register 1 which has 0xF in
					  the lower half.*/

	save_berr = got_berr;
	_cache(0);			/* Disable 68020 cache. */
	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE); /* Clear force responce bit. */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | 0x35; /* enable IF. */
	*WRCNTL0 &= ~WR0_FRC_INH7;
	emulate = 1;
	*bog = 0;		/* send any data, it's ignored. */
	emulate = 0;
	for(i = 0; i < d; i++);

	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE);	/* turn off forced stuff. */
	*WRCNTL0 |= WR0_FRC_INH7;
	_cache(1);	/* Enable 68020 cache. */
	got_berr = save_berr;
}

/*------------------------------------------------------------------------------
	disable_mem:	Disable the slot and interface to a slot.
------------------------------------------------------------------------------*/
void
disable_mem()
{
	register int i;
	char  save_berr;
	register int d = 40000;	/* register variables to bypass 68020 bug.. */
	register int *bog = (int *)0x80000040; /*  any address, bus type 
						   will be used to disable */

	save_berr = got_berr;
	_cache(0);	/* Disable 68020 cache. */
	
	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE);	/* Clear force responce bit. */
	*WRCNTL0 = ((*WRCNTL0 & ~WR0_FTYPE_MASK) | 0x34);     /* Disable IF. */
	*WRCNTL0 &= ~WR0_FRC_INH7;

	emulate = 1;
	*bog = 0;		/* Send any data, it's ignored. */
	emulate = 0;
	for(i = 0; i < d; i++);

	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE);	/* Turn off forced stuff. */
	*WRCNTL0 |= WR0_FRC_INH7;
	_cache(1);	/* Enable 68020 cache. */
	got_berr = save_berr;
}

struct wr_info *get_wr_info (rnd_use)
register int rnd_use;
{

	struct  wr_info ret_struct;
	struct  wr_info *ret_value = &ret_struct;
	
	if (rnd_use == -1)
		{
		ret_struct.raw_data = 0;
		ret_struct.addr_off = 0;
		ret_struct.wr_size = 3;
		return (ret_value);
		}

	rnd_use = rnd_use >> ADDR_OFF_SHFT; 
	ret_struct.addr_off = rnd_use & ADDR_MASK;
	rnd_use = rnd_use >> TST_PAT_SHIFT; 
	ret_struct.raw_data = tst_pat[(rnd_use & TST_PAT_MASK)];
	rnd_use = rnd_use >> WRITE_TYPE_SHFT;
	ret_struct.wr_size = ((rnd_use & WRITE_TYPE_MASK) % 3);

	return (ret_value);
}
