/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mem0.c: version 25.1 created on 11/27/91 at 14:39:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mem0.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "types.h"
#include "globl.h"
#include "global.h"
#include "spm.h"
#include "menu.h"
#include "loc_rout.h"
#include "misc.h"

#define		EDAC_ENABLE	0x7C
#define		EDAC_DISABLE	0x60

int edac_flag;		/* Enable or disable EDAC circuit */
char mem_test;		/* set if we want to know about EDAC INTS. */
int brk_flg;		/* operator abort flag */
unsigned err_cnt;	/* error counter for memory tests */

void	fill8 ();
void	fill16 ();
void	fill32 ();
void	display8 ();
void	display16 ();
void	display32 ();
int	check8 ();
int	check16 ();
int	check32 ();
int	fill_chk8 ();
int	fill_chk16 ();
int	fill_chk32 ();
int	memtest0 ();
int	memtest1 ();
int	memtest2 ();
int	memtest3 ();
int	memtest4 ();
int	memtest5 ();
int	memtest6 ();
int	memtest7 ();
extern  int  memtest8 ();
int	memtest9 ();
int	memtest10 ();

#define		BYTE_ACCESS	8
#define		WORD_ACCESS	16
#define		LONG_ACCESS	32
#define		DISP_BYTES	20
#define		DISP_WORDS	24
#define		DISP_LONGS	28
#define		MAX_MEM_ERR	16
#define		PIPELINE_LIMIT	4

/*
	test patterns used by the pipeline tests these will exercise all
	64 data lines.
	test patterns for various memory tests 
*/

#define		TEST_SEED	0x00000000
#define		TEST_INCR1	0x40302010
#define		TEST_INCR2	0x00000105

/*
	update this variable if the size of tst_pat changes
*/
#define		TST_PAT_SIZ	32

unsigned int tst_pat[] = {
		0xaaaaaaaa,
		0x55555555,
		0xffffffff,
		0x00000000,
		0x00000000,
		0x00000000,
		0x55555555,
		0x55555555,
		0x66666666,
		0x66666666,
		0x78787878,
		0x78787878,
		0x7F807F80,
		0x7F807F80,
		0x7FFF8000,
		0x7FFF8000,
		0x7FFFFFFF,
		0x80000000,
		0x80000000,
		0x00000000,
		0x00000000,
		0x12488421,
		0x84211248,
		0x137FEC80,
		0x12488421,
		0x84211248,
		0x137FEC80,
		0x08CEF731,
		0xFFFFFFFF,
		0xEDB77BDE,
		0x74568781,
		0x17897921,
};


char help_mem0[]="mmt0.[bwl] start_address length <slot>\nwhere:  b = 1 byte, w = 2 bytes, l = 4 bytes.";
char help_mem1[]="mmt1.[bwl] start_address length data_pattern <slot>\nwhere: b = 1 byte, w = 2 bytes, l = 4 bytes.";
char help_mem2[]="mmt2.[bwl] start_address length <slot>\nwhere: b = 1 byte, w = 2 bytes, l = 4 bytes.";
char help_mem3[]="mmt3.[bwl] start_address length data_pattern <slot>\nwhere: b = 1 byte, w = 2 bytes, l = 4 bytes.";
char help_mem4[]="mmt4.[bwl] start_address length <slot>\nRead FIFO Test where: b = 8 bytes, w = 16 bytes, l = 32 bytes.";
char help_mem5[]="mmt5.[bwl] start_address length data_pattern <slot>\nRead FIFO Test where:  b = 8 bytes, w = 16 bytes, l = 32 bytes.";
char help_mem6[]="mmt6.[bwl] start_address length <slot>\nMarching Ones where: b = 1 byte, w = 2 bytes, l = 4 bytes.";
char help_mem7[]="mmt7.[bwl] start_address length <slot>\nRead FIFO Test where: b = 8 bytes, w = 16 bytes, l = 32 bytes";
char help_mem8[]="mmt8 start_address seed <slot>\nInput Pipeline Test where:  bwl not used.";
char help_mem9[]="mmt9.[bwl] start_address length <data> <incr> <slot>\nFill memory where:  b = 1 byte, w = 2 bytes, l = 4 bytes.";
char help_mem10[]="mmt10.[bwl] start_address length <slot>\Display memory where:  b = 1 byte, w = 2 bytes, l = 4 bytes.";

char help_edac[]="edac start_address length <slot>";
char help_bedac[]="bedac.[bwl] <slot>\nWhere: b = 8 bytes, w = 16 bytes, l = 32 byte reads.";

struct init_menu mem_debug [] = {
	"mmt0<.[bwl]>","<addr> <size> [<slot>]",
	"write_all check_all", 'c', 2, 3, memtest0, help_mem0,
	
	"mmt1<.[bwl]>","<addr> <size> <data> <incr> [<slot>]",
	"write_all check_all", 'c', 4, 5, memtest1, help_mem1,
	
	"mmt2<.[bwl]>","<addr> <size> [<slot>]",
	"write/check immediate", 'c', 2, 3, memtest2, help_mem2,
	
	"mmt3<.[bwl]>","<addr> <size> <data> <incr> [<slot>]",
	"write/check immediate", 'c', 4, 5, memtest3, help_mem3,
	
	"mmt4<.[bwl]>","<addr> <size> [<slot>]",
	"read fifo test", 'c', 2, 3, memtest4, help_mem4,
	
	"mmt5<.[bwl]>","<addr> <size> <data> <incr> [<slot>]",
	"read fifo test", 'c', 4, 5, memtest5, help_mem5,
	
	"mmt6<.[bwl]>","<addr> <size> [<slot>]",
	"marching ones test", 'c', 2, 3, memtest6, help_mem6,
	
	"mmt7<.[bwl]>","<addr> <size> [<slot>]",
	"read fifo test", 'c', 2, 3, memtest7, help_mem7,
	
	"mmt8","<addr> <seed> [<slot>]",
	"input pipeline test", 'c', 2, 3, memtest8, help_mem8,
	
	"mmt9<.[bwl]>","<addr> <size> <data> <incr> [<slot>]",
	"fill memory", 'c', 4, 5, memtest9, help_mem9,
	
	"mmt10<.[bwl]>","<addr> <size> [<slot>]",
	"display memory", 'c', 2, 3, memtest10, help_mem10,
	
	"edacon","",
	"Enable/Disable EDAC", 'c', 0, 1, set_edac, (char *)0,
	
	"e(dac)","[<addr> <size> <slot>]",
	"write/read edac test", 'c', 0, 3, edac_it, help_edac,
	
	"le(dac)","[<addr> <size> <slot>]",
	"loop write/read edac test", 'c', 0, 3, edac_it, help_edac,
	
	"ce(dac)","[<addr> <size> <slot>]",
	"edac checkbits test", 'c', 0, 3, cedac_it, (char *)0,
	
	"lce(dac)","[<addr> <size> <slot>]",
	"edac checkbits test", 'c', 0, 3, cedac_it, (char *)0,
	
	"re(dac)","[<slot>]",
	"edac pending int test", 'c', 0, 1, redac_it, (char *)0,
	
	"lre(dac)","[<slot>]",
	"looping edac pending int test", 'c', 0, 1, redac_it, (char *)0,
	
	"be(dac)","[<slot>]",
	"edac 8,16,32 byte read test", 'c', 0, 1, bedac_it, (char *)0,
	
	"lbe(dac)","[<slot>]",
	"looping edac 8,16,32 byte read test", 'c', 0, 1, bedac_it, help_bedac,
	
	"","","", '\0', 0, 0, 0, (char *)0,
};


/* CSS memory test
*  memtest0() -- Command syntax :
*             mmt0  <start addr> <size> <[slot]>
*  Type of transfer is user specified with character 
*  b - byte; w - word; l - long; other char - all types
*  Uses a fill completely check completely algorithm - incrementing data
*/

int
memtest0 (comm_str, arg_cnt)  
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned int pass = 0;
	unsigned int err = 0;
	unsigned int old_err = 0;
	int test_select = 0;
	int flag = 1;
	register unsigned int tseed;
	register unsigned int incr = TEST_INCR1;
	register char addr;
	register char slot;
	register char *start;
	register char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */
	init_css();
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get block size. */
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt0 on CSS block, press <ESC> to stop\n");
	printf ("Data from tst_pat array,  incr:  %08x \n", incr);
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
				slot, (offset & 0x7FFFFFFF), size); 
	switch(mref_siz)
	{
		case 'l':
			printf ("long access\n");
			break;
		case 'w':
			printf ("word access\n");
			break;
		case 'b':
			printf ("byte access\n");
			break;
		default:
			printf ("all accesses (byte/word/long)\n");
			break;
	}

	if(edac_flag == 1)			/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}

	while (flag)
	{
		tseed = tst_pat[pass % TST_PAT_SIZ];
		if (ifesc ())
			break;

		switch(mref_siz)
		{
			case 'b':
				fill8 (start, end, tseed, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check8 (start, end, tseed, incr);
				break;
			case 'w':
				fill16 (start, end, tseed, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check16 (start, end, tseed, incr);
				break;
			case 'l':
				fill32 (start, end, tseed, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check32 (start, end, tseed, incr);
				break;
			default:
				switch(test_select++ % 3)
				{
					case 0:
						fill8 (start, end, tseed, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check8 (start, end, tseed, incr);
						break;
					case 1:
						fill16 (start, end, tseed, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check16 (start, end, tseed, incr);
						break;
					case 2:
						fill32 (start, end, tseed, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check32 (start, end, tseed, incr);
						break;
				}
				break;
		}
		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;

		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
	}
	printf("\n mmt0 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	return (err);
}

/* CSS memory test
*  memtest1() -- Command syntax :
*             mmt1  <start addr> <size> <data> <incr> <[slot]>
*  Type of transfer is user specified with character 
*  b - byte; w - word; l - long; other char - all types
*  Uses a fill completely check completely algorithm - specified inverting data
*/

int
memtest1 (comm_str, arg_cnt)  
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned int pass = 0;
	unsigned int err = 0;
	unsigned int old_err = 0;
	int test_select = 0;
	int flag = 1;
	register unsigned int tdata;
	register unsigned int incr;
	register char addr;
	register char slot;
	register char *start;
	register char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */
	init_css();
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get block size. */
	tdata = (unsigned)atox(comm_args[3]); /* get data. */
	incr = (unsigned)atox(comm_args[4]); /* get incr. */
	if(arg_cnt > 4)
		slot = (unsigned char)atox(comm_args[5]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt1 on CSS block, press <ESC> to stop\n");
	printf ("data = %08x, incr = %08x\n", tdata, incr);
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
				slot, (offset & 0x7FFFFFFF), size); 
	switch(mref_siz)
	{
		case 'l':
			printf ("long access\n");
			break;
		case 'w':
			printf ("word access\n");
			break;
		case 'b':
			printf ("byte access\n");
			break;
		default:
			printf ("all accesses (byte/word/long)\n");
			break;
	}

	if(edac_flag == 1)			/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}

	while (flag)
	{
		if (ifesc ())
			break;

		switch(mref_siz)
		{
			case 'b':
				fill8 (start, end, tdata, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check8 (start, end, tdata, incr);
				break;
			case 'w':
				fill16 (start, end, tdata, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check16 (start, end, tdata, incr);
				break;
			case 'l':
				fill32 (start, end, tdata, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check32 (start, end, tdata, incr);
				break;
			default:
				switch(test_select++ % 3)
				{
					case 0:
						fill8 (start, end, tdata, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check8 (start, end, tdata, incr);
						break;
					case 1:
						fill16 (start, end, tdata, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check16 (start, end, tdata, incr);
						break;
					case 2:
						fill32 (start, end, tdata, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check32 (start, end, tdata, incr);
						break;
				}
				break;
		}
		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;

		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
		tdata = ~tdata;
	}
	printf("\n mmt1 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	return (err);
}

/* CSS memory test
*  memtest2() -- Command syntax :
*             mmt2  <start addr> <size> <[slot]>
*  Type of transfer is user specified with character 
*  b - byte; w - word; l - long; other char - all types
*  Uses a fill immediately check algorithm - incrementing data
*/

int
memtest2 (comm_str, arg_cnt)  
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned int pass = 0;
	unsigned int err = 0;
	unsigned int old_err = 0;
	int test_select = 0;
	int flag = 1;
	register unsigned int tseed;
	register unsigned int incr = TEST_INCR1;
	register char addr;
	register char slot;
	register char *start;
	register char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */
	init_css();
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get block size. */
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt2 on CSS block, press <ESC> to stop\n");
	printf ("Data is from tst_pat array, incr:  %08x \n", incr);
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
				slot, (offset & 0x7FFFFFFF), size); 
	switch(mref_siz)
	{
		case 'l':
			printf ("long access\n");
			break;
		case 'w':
			printf ("word access\n");
			break;
		case 'b':
			printf ("byte access\n");
			break;
		default:
			printf ("all accesses (byte/word/long)\n");
			break;
	}

	if(edac_flag == 1)			/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}

	while (flag)
	{
		tseed = tst_pat[pass % TST_PAT_SIZ];
		if (ifesc ())
			break;

		switch(mref_siz)
		{
			case 'b':
				err += fill_chk8 (start, end, tseed, incr);
				break;
			case 'w':
				err += fill_chk16 (start, end, tseed, incr);
				break;
			case 'l':
				err += fill_chk32 (start, end, tseed, incr);
				break;
			default:
				switch(test_select++ % 3)
				{
					case 0:
						err += fill_chk8 (start, end, tseed, incr);
						break;
					case 1:
						err += fill_chk16 (start, end, tseed, incr);
						break;
					case 2:
						err += fill_chk32 (start, end, tseed, incr);
						break;
				}
				break;
		}
		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;

		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
	}
	printf("\n mmt2 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	return (err);
}

/* CSS memory test
*  memtest3() -- Command syntax :
*             mmt3  <start addr> <size> <data> <incr> <[slot]>
*  Type of transfer is user specified with character 
*  b - byte; w - word; l - long; other char - all types
*  Uses a fill immediately check algorithm - specified inverting data
*/

int
memtest3 (comm_str, arg_cnt)  
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned int pass = 0;
	unsigned int err = 0;
	unsigned int old_err = 0;
	int test_select = 0;
	int flag = 1;
	register unsigned int tdata;
	register unsigned int incr;
	register char addr;
	register char slot;
	register char *start;
	register char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */
	init_css();
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get block size. */
	tdata = (unsigned)atox(comm_args[3]); /* get data. */
	incr = (unsigned)atox(comm_args[4]); /* get incr. */
	if(arg_cnt > 4)
		slot = (unsigned char)atox(comm_args[5]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt3 on CSS block, press <ESC> to stop\n");
	printf ("data:  %08x,  incr:  %08x \n", tdata, incr);
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
				slot, (offset & 0x7FFFFFFF), size); 
	switch(mref_siz)
	{
		case 'l':
			printf ("long access\n");
			break;
		case 'w':
			printf ("word access\n");
			break;
		case 'b':
			printf ("byte access\n");
			break;
		default:
			printf ("all accesses (byte/word/long)\n");
			break;
	}

	if(edac_flag == 1)			/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}

	while (flag)
	{
		if (ifesc ())
			break;

		switch(mref_siz)
		{
			case 'b':
				fill8 (start, end, tdata, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check8 (start, end, tdata, incr);
				break;
			case 'w':
				fill16 (start, end, tdata, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check16 (start, end, tdata, incr);
				break;
			case 'l':
				fill32 (start, end, tdata, incr);
				if (ifesc ())
					{
					flag = 0;
					break;
					}
				err += check32 (start, end, tdata, incr);
				break;
			default:
				switch(test_select++ % 3)
				{
					case 0:
						fill8 (start, end, tdata, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check8 (start, end, tdata, incr);
						break;
					case 1:
						fill16 (start, end, tdata, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check16 (start, end, tdata, incr);
						break;
					case 2:
						fill32 (start, end, tdata, incr);
						if (ifesc ())
							{
							flag = 0;
							break;
							}
						err += check32 (start, end, tdata, incr);
						break;
				}
				break;
		}
		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;

		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
		tdata = ~tdata;
	}
	printf("\n mmt3 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	return (err);
}

/* CSS memory test
*  memtest4() -- Command syntax :
*             mmt4  <start addr> <size> <[slot]>
*  Type of transfer is user specified with character 
*  b - 8 byte; w - 16 byte; l - 32 byte; other char - 32 byte is default
*  Uses a fill completely check algorithm - incrementing data
*/

int
memtest4 (comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned int pass = 0;
	unsigned int err = 0;
	unsigned int old_err = 0;
	register unsigned int tseed;
	register unsigned int incr = TEST_INCR1;
	register char addr;
	register char slot;
	register char *start;
	register char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */
	init_css();
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get block size. */
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	switch(mref_siz)
	{
		case 'l': /* set to 32 byte mode. */
			offset &= 0xffffffe0;
			size &= 0xffffffe0;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_32BYTE_RD;  
			break;
		case 'w': /* set to 16 byte mode. */
			offset &= 0xfffffff0;
			size &= 0xfffffff0;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_16BYTE_RD;  
			break;
		case 'b': /* set to 8 byte mode. */
			offset &= 0xfffffff8;
			size &= 0xfffffff8;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_8BYTE_RD;  
			break;
		default: /* 32 byte mode is default. */
			offset &= 0xffffffe0;
			size &= 0xffffffe0;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_32BYTE_RD;  
			break;
	}


	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt4 on CSS block, press <ESC> to stop\n");
	printf ("Data is from tst_pat array, incr:  %08x \n", incr);
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
				slot, (offset & 0x7FFFFFFF), size); 
	switch(mref_siz)
	{
		case 'l':
			printf ("32 byte reads \n");
			break;
		case 'w':
			printf ("16 byte reads \n");
			break;
		case 'b':
			printf ("8 byte reads \n");
			break;
		default:
			printf ("32 byte read is default \n");
			break;
	}

	if(edac_flag == 1)			/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}

	while (1)
	{
		tseed = tst_pat[pass % TST_PAT_SIZ];
		if (ifesc ())
			break;

		fill32 (start, end, tseed, incr);

		if (ifesc ())
			break;
			
		err += check32 (start, end, tseed, incr);
		
		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;

		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
	}
	printf("\n mmt4 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
	return (err);
}

/* CSS memory test
*  memtest5() -- Command syntax :
*             mmt5  <start addr> <size> <data> <incr> <[slot]>
*  Type of transfer is user specified with character 
*  b - 8 bytes; w - 16 bytes; l - 32 bytes; other char - 32 bytes is default
*  Uses a fill completely check algorithm - specified inverting data
*/

int
memtest5 (comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned int pass = 0;
	unsigned int err = 0;
	unsigned int old_err = 0;
	register unsigned int tdata;
	register unsigned int incr;
	register char addr;
	register char slot;
	register char *start;
	register char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */
	init_css();
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get block size. */
	tdata = (unsigned)atox(comm_args[3]); /* get data. */
	incr = (unsigned)atox(comm_args[4]); /* get incr. */
	if(arg_cnt > 4)
		slot = (unsigned char)atox(comm_args[5]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	switch(mref_siz)
	{
		case 'l': /* set to 32 byte mode. */
			offset &= 0xffffffe0;
			size &= 0xffffffe0;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_32BYTE_RD;  
			break;
		case 'w': /* set to 16 byte mode. */
			offset &= 0xfffffff0;
			size &= 0xfffffff0;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_16BYTE_RD;  
			break;
		case 'b': /* set to 8 byte mode. */
			offset &= 0xfffffff8;
			size &= 0xfffffff8;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_8BYTE_RD;  
			break;
		default: /* 32 byte mode is default. */
			offset &= 0xffffffe0;
			size &= 0xffffffe0;
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_32BYTE_RD;  
			break;
	}

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt5 on CSS block, press <ESC> to stop\n");
	printf ("data:  %08x,  incr:  %08x \n", tdata, incr);
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
				slot, (offset & 0x7FFFFFFF), size); 
	switch(mref_siz)
	{
		case 'l':
			printf ("32 byte reads \n");
			break;
		case 'w':
			printf ("16 byte reads \n");
			break;
		case 'b':
			printf ("8 bytes reads \n");
			break;
		default:
			printf ("32 byte read is default \n");
			break;
	}

	if(edac_flag == 1)			/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}

	while (1)
	{
		if (ifesc ())
			break;

		fill32 (start, end, tdata, incr);

		if (ifesc ())
			break;
			
		err += check32 (start, end, tdata, incr);
		
		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;

		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
		tdata = ~tdata;
	}
	printf("\n mmt5 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
	return (err);
}

/* CSS memory test
*  memtest6() -- Command syntax :
*             mmt6  <start addr> <size> <[slot]>
*  Type of transfer is user specified with character 
*  b - 1 byte; w - 2 bytes; l - 4 bytes; other char - all
*  Marching ones test, pattern 00-01-11-10-00, read-write-incr_ptr loop
*/

int
memtest6 (comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned int pass = 0;
	unsigned int err = 0;
	unsigned int old_err = 0;
	register int count;
	register int test_select = 0;
	register unsigned int old;
	register unsigned int new;
	register char addr;
	register char slot;
	register char *start;
	register char *end;
	register unsigned int *ptr;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */
	init_css();
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get block size. */
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt6 on CSS block, press <ESC> to stop\n");
	printf ("Marching ones test, data is pre-defined \n");
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
				slot, (offset & 0x7FFFFFFF), size); 
	switch(mref_siz)
	{
		case 'l':
			test_select = 32;
			printf ("long access \n");
			break;
		case 'w':
			test_select = 16;
			printf ("word access \n");
			break;
		case 'b':
			test_select = 8;
			printf ("byte access \n");
			break;
		default:
			test_select = 56;
			printf ("all accesses (byte/word/long) \n");
			break;
	}

	if(edac_flag == 1)			/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}

	new= 0x00000000;

	ptr = (unsigned int *)start;
	do
		{
		*ptr = new;
		ptr++;
		} while (ptr < (unsigned int *)end);

	do {
		count = ( BYTE_ACCESS & test_select );
		while (count--) {
			old= new;
			new= ~((~new) << 1);
			err += old_new8 (start, end, old, new);
			if (ifesc()) {
				test_select = 0;
				break;
				}
			} 

		count = ( BYTE_ACCESS & test_select );
		while (count--) {
			old= new;
			new= new<< 1;
			err += old_new8 (start, end, old, new);
			if (ifesc()) {
				test_select = 0;
				break;
				}
			} 

		count = ( WORD_ACCESS & test_select );
		while (count--) {
			old= new;
			new= ~((~new) << 1);
			err += old_new16 (start, end, old, new);
			if (ifesc()) {
				test_select = 0;
				break;
				}
			} 

		count = ( WORD_ACCESS & test_select );
		while (count--) {
			old= new;
			new= new<< 1;
			err += old_new16 (start, end, old, new);
			if (ifesc()) {
				test_select = 0;
				break;
				}
			} 

		count = ( LONG_ACCESS & test_select );
		while (count--) {
			old= new;
			new= ~((~new) << 1);
			err += old_new32 (start, end, old, new);
			if (ifesc()) {
				test_select = 0;
				break;
				}
			}

		count = ( LONG_ACCESS & test_select );
		while (count--) {
			old= new;
			new= new<< 1;
			err += old_new32 (start, end, old, new);
			if (ifesc()) {
				test_select = 0;
				break;
				}
			} 

		if (err == old_err)
			printf ("\r");
		else
			printf ("\n");
		
		old_err = err;
		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
		} while (test_select);
	printf("\n mmt6 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	return (err);
}

/* CSS memory test
*  memtest7() -- Command syntax :
*             mmt7  <start addr> <size> <[slot]>
*  Type of transfer is user specified with character 
*  b - 8 bytes; w - 16 bytes; l - 32 bytes; other char - default is 32 byte
*  Read FIFO Test, patterns selected to verify complete 64-bit bus 
*/

int 
memtest7(comm_str, arg_cnt) 	
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	register unsigned int cnt;
	register unsigned int err = 0;
	register unsigned int pass = 0;
	register unsigned int old_err = 0;
	register unsigned int rdata;
	unsigned char slot;
	unsigned char addr;
	register unsigned char *start;
	register unsigned int *ptr;
	register unsigned char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);

	init_css();	/* make sure everthing is ready. */
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get length. */
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	switch(mref_siz)
	{
		case 'l': /* set to 32 byte mode. */
			offset &= 0xffffffe0;	/* align address */
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_32BYTE_RD;  
			break;
		case 'w': /* set to 16 byte mode. */
			offset &= 0xfffffff0;	/* align address */
			*WRCNTL1 &= ~WR1_32BYTE_RD;
			*WRCNTL1 |= WR1_16BYTE_RD;  
			break;
		case 'b': /* set to 8 byte mode. */
			offset &= 0xfffffff8;	/* align address */
			*WRCNTL1 &= ~WR1_32BYTE_RD;
			*WRCNTL1 |= WR1_8BYTE_RD; 
			break;
		default: /* 32 byte mode is default. */
			offset &= 0xffffffe0;	/* align address */
			*WRCNTL1 &= ~WR1_32BYTE_RD;  
			*WRCNTL1 |= WR1_32BYTE_RD;  
			break;
	}
	size = ((size + (sizeof(long) * TST_PAT_SIZ) - 1) & 0xffffff80);

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (unsigned char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (unsigned char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt7 on CSS block, press <ESC> to stop\n");
	printf ("Data is from tst_pat, there is no incr\n");
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
					slot, (offset&0x0fffffff), size); 
	switch(mref_siz)
	{
		case 'l': 
			printf ("32 byte reads\n");
			break;
		case 'w': 
			printf ("16 byte reads\n");
			break;
		case 'b': 
			printf ("8 byte reads\n");
			break;
		default:
			printf ("32 byte reads are default\n");
			break;
	}


	if(edac_flag == 1)		/* user wants edac enabled */
	{
		edac_on();
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_off();
		printf("EDAC is disabled\n");
	}
	while (1) {
		if (ifesc())   
			break;

		for (ptr = (unsigned int *)start, cnt = 0; 
					ptr < (unsigned int *)end; ptr++, cnt++)
			*ptr = tst_pat[cnt % TST_PAT_SIZ];

		if (ifesc())   
			break;

		for (ptr = (unsigned int *)start, cnt = 0; 
					ptr < (unsigned int *)end; ptr++, cnt++)
			if ((rdata = *ptr) != tst_pat[cnt % TST_PAT_SIZ]) {
				printf ("Addr:  %.08X;  Expected:  %.08X;  Got:  %.08X\n", 
				ptr, tst_pat[cnt % TST_PAT_SIZ], rdata);
				if (err++ == MAX_MEM_ERR)
					break;
				}
		if (err != old_err)
			printf ("\n");
		else
			printf ("\r");
		old_err = err;
		printf ("Passes:  %d;  Total Errors:  %d", ++pass, err);
	}
	printf("\n mmt7 completed...Passes:  %d,  Errors:  %d\n", pass, err);
	*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
	return (err);
}

/* CSS memory test
*  memtest9() -- Command syntax :
*             mmt9  <start addr> <size> <data> <incr> <[slot]>
*  Fill memory with user specified pattern
*/

int
memtest9(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	register unsigned int tdata;
	register unsigned int incr;
	unsigned char slot;
	unsigned char addr;
	register unsigned char *start;
	register unsigned char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);

	init_css();	/* make sure everthing is ready. */
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get length. */
	tdata = (unsigned)atox(comm_args[3]); /* get length. */
	incr = (unsigned)atox(comm_args[4]); /* get length. */
	if(arg_cnt > 4)
		slot = (unsigned char)atox(comm_args[5]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (unsigned char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (unsigned char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt9 on CSS block, press <ESC> to stop\n");
	printf ("Fill memory, data:  %08x,  incr:  %08x\n", tdata, incr);
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
					slot, (offset&0x0fffffff), size); 
	switch(mref_siz)
	{
		case 'l': 
			printf ("long fills \n");
			fill32 (start, end, tdata, incr);
			break;
		case 'w': 
			printf ("word fills \n");
			fill16 (start, end, tdata, incr);
			break;
		case 'b': 
			printf ("byte fills \n");
			fill8 (start, end, tdata, incr);
			break;
		default:
			printf ("long fills default \n");
			fill32 (start, end, tdata, incr);
			break;
	}
	return (0);
}

/* CSS memory test
*  memtest10() -- Command syntax :
*             mmt10  <start addr> <size> <[slot]>
*  Display memory 
*/

int
memtest10(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int offset;
	unsigned int size;
	unsigned char slot;
	unsigned char addr;
	register unsigned char *start;
	register unsigned char *end;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);

	init_css();	/* make sure everthing is ready. */
	rready();
	iready();

	offset = (unsigned)atox(comm_args[1]); /* get address. */
	size = (unsigned)atox(comm_args[2]); /* get length. */
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) /*find first memory card*/
			return;

	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,slot,addr);	/* don't forget addr! */
	cssmap(MAP01,slot,(char)0x0f);	/* don't forget addr! */
	start = (unsigned char *)CSSMAP(offset); /* convert addr to be 0x8xxxxxxxx */
	end = (unsigned char *)(start + size);
	offset  = CSSMAP(offset); /* convert address to be 0x8xxxxxxxx */

	printf ("Memory test mmt10 on CSS block, press <ESC> to stop\n");
	printf ("Display memory\n");
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x, ", 
					slot, (offset&0x0fffffff), size); 
	switch(mref_siz)
	{
		case 'l': 
			printf ("long reads \n");
			display32 (start, end);
			break;
		case 'w': 
			printf ("word reads \n");
			display16 (start, end);
			break;
		case 'b': 
			printf ("byte reads \n");
			display8 (start, end);
			break;
		default:
			printf ("long reads default \n");
			display32 (start, end);
			break;
	}
	return (0);
}

void
display8 (ptr_start, ptr_limit)

register  unsigned  char *ptr_start;
register  unsigned  char *ptr_limit;
{
	register int diff;
	register int count;
	register int line_count = 0;

	diff = (int)((int)ptr_limit - (int)ptr_start);
	diff -= (diff % DISP_BYTES);
	do {
		if ((++line_count % pagsize) == 0)
			if (anykey () == ESCAPE) {
				printf ("\n");
				return;
			}

		printf ("\n0x%08X    ", ptr_start);
		count = DISP_BYTES;
		do {
			printf ("%02x ", *ptr_start);
			ptr_start++;
			diff--;
			} while (--count);
		} while (diff);
	if (ptr_start < ptr_limit)
		{
		printf ("\n0x%08X    ", ptr_start);
		for (; ptr_start < ptr_limit; ptr_start++)
			printf ("%02x ", *ptr_start);
		}
	printf ("\n0x%08X\n", ptr_start);
}	

void
display16 (ptr_start, ptr_limit)

register  unsigned  short *ptr_start;
register  unsigned  short *ptr_limit;
{
	register int diff;
	register int count;
	register int line_count = 0;

	diff = (int)((int)ptr_limit - (int)ptr_start);
	diff -= (diff % DISP_WORDS);
	do {
		if ((line_count++ % pagsize) == 0)
			if (anykey () == ESCAPE) {
				printf ("\n");
				return;
			}

		printf ("\n0x%08X    ", ptr_start);
		count = (DISP_WORDS / sizeof(short));
		do {
			printf ("%04x ", *ptr_start);
			ptr_start++;
			diff -= 2;
			} while (--count);
		} while (diff);
	if (ptr_start < ptr_limit)
		{
		printf ("\n0x%08X    ", ptr_start);
		for (; ptr_start < ptr_limit; ptr_start++)
			printf ("%04x ", *ptr_start);
		}
	printf ("\n0x%08X\n", ptr_start);
}	

void
display32 (ptr_start, ptr_limit)

register  unsigned  int *ptr_start;
register  unsigned  int *ptr_limit;
{
	register int diff;
	register int count;
	register int line_count = 0;

	diff = (int)((int)ptr_limit - (int)ptr_start);
	diff -= (diff % DISP_LONGS);
	do {
		if ((line_count++ % pagsize) == 0)
			if (anykey () == ESCAPE) {
				printf ("\n");
				return;
			}

		printf ("\n0x%08X   ", ptr_start);
		count = (DISP_LONGS / sizeof(long));
		do {
			printf (" %08x", *ptr_start);
			ptr_start++;
			diff -= 4;
			} while (--count);
		} while (diff);
	if (ptr_start < ptr_limit)
		{
		printf ("\n0x%08X    ", ptr_start);
		for (; ptr_start < ptr_limit; ptr_start++)
			printf ("%08x ", *ptr_start);
		}
	printf ("\n0x%08X\n", ptr_start);
}	

void
fill8 (ptr_start, ptr_limit, tseed, incr)

register  unsigned  char *ptr_start;
register  unsigned  char *ptr_limit;
register  unsigned  char tseed;
register  unsigned  char incr;
{
	if (incr) {
		do {
			*ptr_start = tseed;
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			*ptr_start = tseed;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
}

void
fill16 (ptr_start, ptr_limit, tseed, incr)

register  unsigned  short *ptr_start;
register  unsigned  short *ptr_limit;
register  unsigned  short tseed;
register  unsigned  short incr;
{
	if (incr) {
		do {
			*ptr_start = tseed;
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			*ptr_start = tseed;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
}

void
fill32 (ptr_start, ptr_limit, tseed, incr)

register  unsigned  int *ptr_start;
register  unsigned  int *ptr_limit;
register  unsigned  int tseed;
register  unsigned  int incr;
{
	if (incr) {
		do {
			*ptr_start = tseed;
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			*ptr_start = tseed;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
}

int
check8 (ptr_start, ptr_limit, tseed, incr)

register unsigned char *ptr_start;
register unsigned char *ptr_limit;
register unsigned char tseed;
register unsigned char incr;
{
register unsigned char rdata;
register unsigned int err = 0;
	if (incr) {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.02X;  Got:  %.02X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.02X;  Got:  %.02X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	return (err);
}

int
check16 (ptr_start, ptr_limit, tseed, incr)

register unsigned short *ptr_start;
register unsigned short *ptr_limit;
register unsigned short tseed;
register unsigned short incr;
{
register unsigned short rdata;
register unsigned int err = 0;
	if (incr) {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.04X;  Got:  %.04X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.04X;  Got:  %.04X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	return (err);
}

int
check32 (ptr_start, ptr_limit, tseed, incr)

register unsigned int *ptr_start;
register unsigned int *ptr_limit;
register unsigned int tseed;
register unsigned int incr;
{
register unsigned int rdata;
register unsigned int err = 0;
	if (incr) {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.08X;  Got:  %.08X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.08X;  Got:  %.08X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	return (err);
}

int
fill_chk8 (ptr_start, ptr_limit, tseed, incr)

register unsigned char *ptr_start;
register unsigned char *ptr_limit;
register unsigned char tseed;
register unsigned char incr;
{
	register unsigned char rdata;
	register int err = 0;

	if (incr) {
		do {
			*ptr_start = tseed;
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.02X;  Got:  %.02X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			tseed += incr;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			*ptr_start = tseed;
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.02X;  Got:  %.02X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	return (err);
}

int
fill_chk16 (ptr_start, ptr_limit, tseed, incr)

register unsigned short *ptr_start;
register unsigned short *ptr_limit;
register unsigned short tseed;
register unsigned short incr;
{
	register unsigned short rdata;
	register int err = 0;

	if (incr) {
		do {
			*ptr_start = tseed;
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.04X;  Got:  %.04X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			tseed += incr;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			*ptr_start = tseed;
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.04X;  Got:  %.04X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	return (err);
}

int
fill_chk32 (ptr_start, ptr_limit, tseed, incr)

register unsigned int *ptr_start;
register unsigned int *ptr_limit;
register unsigned int tseed;
register unsigned int incr;
{
	register unsigned int rdata;
	register int err = 0;

	if (incr) {
		do {
			*ptr_start = tseed;
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.08X;  Got:  %.08X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			tseed += incr;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			*ptr_start = tseed;
			if ((rdata = *ptr_start) != tseed) {
				printf ("Addr:  %.08X;  Expected:  %.08X;  Got:  %.08X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	return (err);
}

int 
old_new8 (ptr_start, ptr_limit, old_value, new_value)

register   unsigned char  *ptr_start;
register   unsigned char  *ptr_limit;
register   unsigned char   old_value;
register   unsigned char   new_value;
{
	register   unsigned int    err = 0;
	register   unsigned char  rdata;

	do {
		if ((rdata = *ptr_start) != old_value) {
			printf ("Addr:  %.08X;  Expected:  %.02X;  Got:  %.02X\n", 
					ptr_start, old_value, rdata);
			if (err++ == MAX_MEM_ERR)
				return (err);
			}

		*ptr_start++ = new_value;
		} while (ptr_start != ptr_limit);
	return (err);
}

int
old_new16 (ptr_start, ptr_limit, old_value, new_value)

register   unsigned short  *ptr_start;
register   unsigned short  *ptr_limit;
register   unsigned short   old_value;
register   unsigned short   new_value;
{
	register   unsigned int    err = 0;
	register   unsigned short  rdata;

	do {
		if ((rdata = *ptr_start) != old_value) {
			printf ("Addr:  %.08X;  Expected:  %.04X;  Got:  %.04X\n", 
					ptr_start, old_value, rdata);
			if (err++ == MAX_MEM_ERR)
				return (err);
			}

		*ptr_start++ = new_value;
		} while (ptr_start != ptr_limit);
	return (err);
}

int
old_new32 (ptr_start, ptr_limit, old_value, new_value)

register   unsigned int  *ptr_start;
register   unsigned int  *ptr_limit;
register   unsigned int   old_value;
register   unsigned int   new_value;
{
	register   unsigned int  err = 0;
	register   unsigned int  rdata;

	do {
		if ((rdata = *ptr_start) != old_value) {
			printf ("Addr:  %.08X;  Expected:  %.08X;  Got:  %.08X\n", 
					ptr_start, old_value, rdata);
			if (err++ > MAX_MEM_ERR)
				return (err);
			}

		*ptr_start++ = new_value;
		} while (ptr_start != ptr_limit);
	return (err);
}

/* EDAC interrupt service routine called from excptions.c */
mem_edac_err()
{
unsigned int merr_addr;
unsigned int merr_info;
unsigned int int_slot;
unsigned int edac_stat;

char merr_array;
char merr_stat;
int i;

	err_cnt += 1;

		/* upper 4 bits mean nothing.*/
	merr_addr = (*EDAC_ERR_ADDR_REG &0x0fffffff); 
	edac_stat = *EDAC_STAT_REG;
	merr_info = *EDAC_ERR_INFO_REG;

	printf("\nEDAC error: add_reg = %08x  err_info_reg = %08x stat_reg = %08x",merr_addr,merr_info,edac_stat);

	if(ifesc())
		brk_flg = 1;

	*EDAC_CTL_REG = 0;		/* test mode */
	mem_test = 1;
	*EDAC_CTL_REG = 0;		/* test mode */

	*EDAC_CTL_REG = (unsigned char)TEST2MOD;

}

/* This function simply enables the EDAC on the memory board */
edac_on()
{
int int_slot;

	mem_test = 1;						/* ISR flag */

	int_slot= 0x80000f80 |((*STATUSREG & STAT_SLOTMASK) >> 12); /*move it over*/
	*EDAC_INT_INFO_REG = int_slot;   /* set int info */

	*EDAC_CTL_REG = (unsigned char)TEST2MOD;
}

/* See if the operator wants to abort the test */
chk_abort()
{
	if(ifesc())
		brk_flg = 1;
}

/* Disable the edac on the memory board */
edac_off()
{
	mem_test = 0;			/* tell edac ISR to ignore edac INTS */

	*EDAC_CTL_REG = EDAC_DISABLE;		/* test mode */
}

/* Sets or resets edac_flag used to enable or disable the EDAC */
/* for memory tests mmt0 thru mmt8 */

set_edac()
{
	
	if(edac_flag == 0)		/* if edac_flag is 0, set to 1 */
	{
		edac_flag = 1;
		printf("EDAC is enabled\n");
	}
	else
	{
		edac_flag = 0;
		printf("EDAC is disabled\n");
	}

}



