/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mem.c: version 25.1 created on 11/27/91 at 14:39:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mem.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "spm.h"
#include "disp.h"
#include "novram.h"

#define		TEST_INCR	0x04030201

/*
	update this variable if the size of tst_pat changes
*/
#define		TST_PAT_SIZ	32
#define		MAX_MEM_ERR	16

unsigned int tst_pat[] = {
	0xaaaaaaaa, 0x55555555, 
	0xffffffff, 0x00000000,
	0x00000000, 0x00000000, 
	0x55555555, 0x55555555,
	0x66666666, 0x66666666, 
	0x78787878, 0x78787878,
	0x7F807F80, 0x7F807F80, 
	0x7FFF8000, 0x7FFF8000,
	0x7FFFFFFF, 0x80000000, 
	0x80000000, 0x00000000,
	0x00000000, 0x12488421, 
	0x84211248, 0x137FEC80,
	0x12488421, 0x84211248, 
	0x137FEC80, 0x08CEF731,
	0xFFFFFFFF, 0xEDB77BDE, 
	0x74568781, 0x17897921,
};

void	fill32 ();
int	check32 ();

/* sizemem.c:  sizes main ram, and divides it into chunks.  Then, builds
tables in main memory (1st meg of ram) for all valid cpu's to test.  

table is a struct mem setup in main memory;  filled out in each of the
64k segments assigned to a single cpu.

The first meg of ram is divided into 16 slices of 64kbytes; one for each
of the possible processors.  In each of the slices available for the
cpu's, build a table.   When all tables have been built, go and issue
the start command to each of the cpu's.
*/

/* note: the following is setup as map 1 referenced only!!! */
int int_slot;	/* send command to css command register. */
unsigned int	*ERR_INFO_REG= 	(unsigned int *)0x9fffffec;
unsigned int	*ERR_ADDR_REG= 	(unsigned int *)0x9ffffff4;
unsigned int	*INT_INFO_REG= 	(unsigned int *)0x9fffffc0;
unsigned int	*STAT_REG =	(unsigned int *)0x9ffffffc;
unsigned char	*CTL_REG =	(unsigned char *)0x9fffffe4;

#define MM_INIT 0x78	/* green LED on, EDAC and error interrupt bits */

extern unsigned char bdhere[];

firstram()	/* find and test first meg of ram. */
{
	int i;

	if((i = findmem(1)) == 18) 	/* find the first memory board */
		return(-1);		/* bad. */

	if(test1meg(i)) 		/* failed test */
		return(-1); 		/* failed. */

	return(0);			/* say ok to continue. */
}

test1meg(slot) /* test 1 megabyte of ram to be valid data. */
int slot;
{
	register unsigned int tstpat;
	register unsigned int i;
	register unsigned addr, addr1, addr2, readback;
	unsigned char x2;
	

	x2  = (unsigned char)CSSADD(0);
	cssmap(MAP00,slot,x2);	/* convert to nibblized address and slot */
	addr = CSSMAP(0); /* convert address to be 0x8xxxxxxx */
	addr1 = addr;	/* save it..*/
	addr2 = addr + 1048576; /* save ending byte, for speed. */


	/* ripple a one bit in first location */
	for(tstpat=0x00000001; tstpat; tstpat = tstpat << 1) {
		*((unsigned *)addr) = tstpat;
		readback = *((unsigned *)addr);
		if(readback != tstpat)
			return(1); /* failed.. sigh. */
	}

	/* ripple a zero bit through first location */
	for(tstpat=0xfffffffe; tstpat != 0xffffffff; 
				tstpat=(tstpat << 1)|0x00000001) {
		*((unsigned *)addr) = tstpat;
		readback = *((unsigned *)addr);
		if(readback != tstpat)
			return(1); /* failed.. sigh. */
	}

	for (i = 0; i != TST_PAT_SIZ; i++) {
		fill32 ((uint *)addr1, (uint *)addr2, tst_pat[i], TEST_INCR);
		if (check32 ((uint *)addr1, (uint *)addr2, tst_pat[i], TEST_INCR))
			return (1);
	}
	return(0);
}

/*------------------------------------------------------------------------------
	mm_init : intialize a memory module in a give slot.
			  Enable EDAC, parity checking, interrupt generation.
			  Turn off Red LED, and turn on Green LED.
------------------------------------------------------------------------------*/
mm_init(x,y)
char x,y;
{
	char i;
	unsigned int int_info;

	int_info = 0x80800fa0 | ((*STATUSREG & STAT_SLOTMASK) >> 12);

	if(y) {
		cssmap(MAP01,x,(char)0x0f);	/* don't forget addr! */
		*INT_INFO_REG = int_info;
		*(char *)CTL_REG = MM_INIT;
	}
	else {
		for(i=0; i != Sbus_Num_Slot; i++) {
			if(bdhere[i]==MEMHERE) {
				cssmap(MAP01,i,(char)0x0f);	/* setup map */
				*INT_INFO_REG = int_info;	/* int info */
				*(char *)CTL_REG = MM_INIT;
			}
		}
	}
}

/*
 * mm_interrupt:
 *
 *	handle a memory module error interrupt.
 *
 *	read error information and error address which will
 *	re-enable interrupts.
 *
 *	To run on SPM:
 *
 *		The SPM should read the two registers, then log the error
 *		for itself, and then pass the error along to a processor
 *		module so that the kernel can log the error in its unix
 *		error logging facility.
 *
 */

mm_interrupt(mm_slot)
register uint	mm_slot;
{
	register uint		mm_err_info, mm_err_addr;

	/*
	 * This register must be read first, as the err info register
	 * resets the error capturing.
	 */

	/* read memory error address register */

	mm_err_addr = *ERR_ADDR_REG;

	/* read memory error information register */

	mm_err_info = *ERR_INFO_REG;

	show_mm_err(mm_slot, mm_err_addr, mm_err_info );
}


show_mm_err(mm_slot, mm_err_addr, mm_err_info )
register uint	mm_slot;
register uint	mm_err_addr;
register uint	mm_err_info;
{
	printf("\nMemory board error in slot 0x%x, location 0x%x, error reg 0x%x\n",
	  mm_slot, mm_err_addr & 0xfffffff, mm_err_info);

	/*
	 * If a multiple bit error is seen, then single
	 * bit errors should not be checked for.
	 */

	if (!(mm_err_info & 0x00800000)) {
		printf("Array 0 uncorrectable error\n");
		disp_mm_err((mm_err_info & 0x007f0000) >> 16);
		disp_mm_synr((mm_err_info & 0x7f000000) >> 24);
	}
	else if (!(mm_err_info & 0x00000080)) {
		printf("Array 1 uncorrectable error\n");
		disp_mm_err(mm_err_info & 0x0000007f);
		disp_mm_synr((mm_err_info & 0x00007f00) >> 8);
	}
	else if (!(mm_err_info & 0x80000000)) {
		printf("Array 0 single bit corrected error\n");
		disp_mm_err((mm_err_info & 0x007f0000) >> 16);
		disp_mm_synr((mm_err_info & 0x7f000000) >> 24);
	}
	else if (!(mm_err_info & 0x00008000)) {
		printf("Array 1 single bit corrected error\n");
		disp_mm_err(mm_err_info & 0x0000007f);
		disp_mm_synr((mm_err_info & 0x00007f00) >> 8);
	}
}


disp_mm_err(err_code)
register uint	err_code;
{
	printf("Source board is in CSS slot %x\n", err_code & 0x0f);

	if (err_code & 0x40) {
		printf("Partial write error\n");
		return;
	}

	/* otherwise it was a read error */
	if (!(err_code & 0x10))
		printf("Read 32 error\n");
	else if (!(err_code & 0x20))
		printf("Read 16 error\n");
	else
		printf("Partial read error\n");
}


/*
   Using syndrome information to get a byte from syndrome table as below.
   The byte from syndrome table decode as following:

   _________________________________________________________________
   | Bit 7 | Bit 6 | Bit 5 | Bit 4 | Bit 3 | Bit 2 | Bit 1 | Bit 0 |
   -----------------------------------------------------------------
      1       1   Uncorrectable multi-bit error
      1       0   Double bit error
      0       1   error in check bit (Bit0 - Bit5 represent bit location)
      0       0   error in data bit  (Bit0 - Bit5 represent bit location)
*/

#define UNCORRECT	0xc0
#define DOUBLE		0x80
#define CHKBIT		0x40
#define DATABIT		0x00

unsigned char syntab[128] =	{
	0xc0, 0x80, 0x80, 0xc0, 0x80, 0xc0, 0xc0, 0x80, /* 0 - 7 */
	0x80, 0xc0, 0x1f, 0x80, 0xc0, 0x80, 0x80, 0x1e, /* 8 - F */
	0x80, 0xc0, 0x1d, 0x80, 0x1c, 0x80, 0x80, 0x1b, /* 10 - 17 */
	0x1a, 0x80, 0x80, 0x19, 0x80, 0x18, 0xc0, 0x80, /* 18 - 1F */
	0x80, 0xc0, 0x07, 0x80, 0x06, 0x80, 0x80, 0x05, /* 20 - 27 */
	0x04, 0x80, 0x80, 0x03, 0x80, 0x02, 0xc0, 0x80, /* 28 - 2F */
	0x00, 0x80, 0x80, 0xc0, 0x80, 0x01, 0xc0, 0x80, /* 30 - 37 */
	0x80, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0x46, /* 38 - 3F */

	0x80, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0xc0, /* 40 - 47 */
	0xc0, 0x80, 0x80, 0x0f, 0x80, 0xc0, 0x0e, 0x80, /* 48 - 4F */
	0xc0, 0x80, 0x80, 0x0d, 0x80, 0x0c, 0x0b, 0x80, /* 50 - 57 */
	0x80, 0x0a, 0x09, 0x80, 0x08, 0x80, 0x80, 0x45, /* 58 - 5F */
	0xc0, 0x80, 0x80, 0x17, 0x80, 0x16, 0x15, 0x80, /* 60 - 67 */
	0x80, 0x14, 0x13, 0x80, 0x12, 0x80, 0x80, 0x44, /* 68 - 6F */
	0x80, 0x10, 0xc0, 0x80, 0x11, 0x80, 0x80, 0x43, /* 70 - 77 */
	0xc0, 0x80, 0x80, 0x42, 0x80, 0x41, 0x40, 0xff, /* 78 - 7F */
};


/* Decode memory syndrome information from syndrome table above */
disp_mm_synr(err_code)
register uint	err_code;
{
	uchar	syncode;
	
	syncode = syntab[err_code];
	if ((syncode & 0xc0) == UNCORRECT)
		printf("Uncorrectable multi-bit error\n");
	else
	if ((syncode & 0xc0) == DOUBLE)
		printf("Double-bit error\n");
	else
	if ((syncode & 0xc0) == CHKBIT)
		printf("Error in check bit = %d\n", syncode & 0x3f);
	else
	if ((syncode & 0xc0) == DATABIT)
		printf("Error in data bit = %d\n", syncode & 0x3f);
}

void
fill32 (ptr_start, ptr_limit, tseed, incr)

register  unsigned  int *ptr_start;
register  unsigned  int *ptr_limit;
register  unsigned  int tseed;
register  unsigned  int incr;
{
	if (incr) {
		do {
			*ptr_start = tseed;
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			*ptr_start = tseed;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
}

int
check32 (ptr_start, ptr_limit, tseed, incr)

register unsigned int *ptr_start;
register unsigned int *ptr_limit;
register unsigned int tseed;
register unsigned int incr;
{
register unsigned int rdata;
register unsigned int err = 0;
	if (incr) {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("ADDR: %08X;  EXP: %08X;  GOT: %08X\n", 
						ptr_start, tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			tseed += incr;
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	else {
		do {
			if ((rdata = *ptr_start) != tseed) {
				printf ("ADDR:  %08X; EXP:  %08X; GOT:  %08X\n",
					((unsigned)ptr_start & 0x0FFFFFFF), tseed, rdata);
				if (err++ == MAX_MEM_ERR)
					return (err);
				}
			ptr_start++;
			} while (ptr_start < ptr_limit);
	}
	return (err);
}

