/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) locram.c: version 25.1 created on 11/27/91 at 14:39:08	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)locram.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm.h"
#include "types.h"

#define TSTSTR		(SRAMSTART)
#define TSTEND		(SRAMSTART + 0x03a000)

char pcnt;

#define		TEST_INCR	0x04030201

/*
	update this variable if the size of tst_pat changes
*/
#define		TST_PAT_SIZ	32

extern unsigned int tst_pat[];

extern  void  fill32 ();
extern  int   check32 ();

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
lramtst()
{
	int stat;
	char cf;

	pcnt=1;
	while(!(ifesc())) {
		printf("\nPass = %d",pcnt++);
		if(stat=dotst(TSTSTR,TSTEND)) {
			printf("\n");
			if(stat == -1) 
				return(0);
			else 
				return(stat);
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
dotst(start,end)
ulong start,end;
{
	register  unsigned int  offset;
	ulong sptr, wp;
	int i;

	if(end > (SRAMSTART+SRAMSIZE) || start < SRAMSTART)
		err(0,0,0,0);

/*---[ Ripple 1 Test. ]------------------------------------------------------*/

	printf("\rRipple a 1 in data of address 0\n");
	for(wp = 0x00000001; wp; wp <<= 1) {
		*(ulong *)start = wp;
		if(*(ulong *)start != wp) {
			err(2,start,*(ulong *)start,wp);
			return(1);
		}
	} 

	if(ifesc()) return(-1);

/*---[ Ripple 0 Test. ]------------------------------------------------------*/
	printf("\rRipple a 0 in data of address 0\n");
	for(wp = 0xFFFFFFFE; wp != 0xFFFFFFFF; wp = ((wp << 1)|0x00000001)) {
		*(ulong *)start = wp;
		if(*(ulong *)start != wp) {
			err(3,start,*(ulong *)start,wp);
			return(1);
		}
	}

	if(ifesc()) 
		return(-1);

/*---[ Address Test. ]--------------------------------------------------------*/
	printf("\rAddress pattern test.   ");
	for(offset = 0x00000001; sptr < end ; sptr = (start + (offset <<= 1)))
		*(uchar *)sptr = (char)0;

	for(offset = 0x00000001; sptr < end ; sptr = (start + (offset <<= 1))) {
		if (*(uchar *)sptr != (char)0)
			err(5, sptr, *(uchar *)sptr, (uchar)tst_pat[0]);

		*(uchar *)sptr = (char)tst_pat[0];
		if(*(uchar *)sptr != (char)tst_pat[0]) {
			err(4,sptr,*(uchar *)sptr,(uchar)tst_pat[0]);
			return(1);
		}
	}

	if(ifesc()) 
		return(-1);

/*---[ Pattern Test. ]--------------------------------------------------------*/
	printf("\n");
	for(i = 0; i != TST_PAT_SIZ; i++) {
		fill32 (start, end, tst_pat[i], TEST_INCR);
		if (check32 (start, end, tst_pat[i], TEST_INCR)) {
			err(1,sptr,*(ulong *)sptr,tst_pat[i]);
			return(1);
		}
	}

	if(ifesc()) 
		return(-1);

	return (0);		
}/*-----------------------------[ END of TEST ]-------------------------------*/

/*------------------------------------------------------------------------------
	err: Local ram (SPM) error handling test.
------------------------------------------------------------------------------*/
err(tst,loc,was,sb)
char tst;
ulong loc,was,sb;
{
	if(!tst) {
		printf("Outside the RAM test area.\n");
		return(1);
	}
	printf("Failed location = 0x%8x WAS=0x%8x S/B=0x%8x Pass=%x\n",
		loc,was,sb,pcnt);
	printf("While doing ");
	switch(tst) {
		case 1:
			printf("PATTERN");
			break;
		case 2:
			printf("WRIPPLE 1");
			break;
		case 3:
			printf("WRIPPLE 0");
			break;
		case 4:
			printf("ADDRESS DATA");
			break;
		case 5:
			printf("ADDRESS BACKGROUND");
			break;
		default:
			printf("\rUnknown Failure.");
			break;
	}
	printf(" TEST\n");
	return(1);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
