/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) localmenu.c: version 25.1 created on 11/27/91 at 14:39:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)localmenu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
    11/18/87 Yung Chang added io_debugger in systet
 test menu for IOSS
*/
/*  localmenu.c
 *
 *	All the local menus.
 *
 *	struct menu {
 *		char *comm_text;
 *		char *comm_opt;
 *		char *comm_desc;
 *		char comm_type;
 *		unsigned char lo_limit;
 *		unsigned char hi_limit;
 *		union {
 *			PFI procedure;
 *			struct menu *menu_p;
 *		} command;
 *      char *help;
 *	};
 *
 *	Menu.comm_text is the full text for the command name, such as 'l(ist)'.
 *	Menu.comm_opt is the description for the options in the command.
 *	Menu.comm_desc is the description for the command.
 *	Menu.comm_type is one of 'c' or 'm', defining the command to be
 *		a straight command or a pointer to another menu, respectively.
 *	Menu.lo_limit is the low limit of the number of arguments allowed for
 *		the command.
 *	Menu.hi_limit is the high limit of the number of arguments allowed for
 *		the command.
 *	Menu.command is a union containing either a pointer to a procedure or
 *		a pointer to another menu.
 *	Menu.command.procedure points to the related procedure.
 *	Menu.command.menu_p points to the related sub-menu.
 *  Menu.help is a text description of the command.
 *	Menus are terminated with a null string in the menu.comm_text field.
 */
#include "types.h"
#include "menu.h"
#include "routines.h"

extern int init_novram_config();
extern int up_nov_chksum();
extern int show_config();
extern int c_atb();		/* Change Auto Boot flag. */
extern int c_dfb();		/* Change Diag Fly By flag. */
extern int dte();		/* Print the date the code was compiled. */
extern int nv_def_path();
extern	int  show_em();
extern	int  margin();
extern	int  display_cios_status();
extern	int  pmmenu();

/*
 * Menus
 *
 * The menu pointers have to be cast to PFI due to a compiler deficiency.
 * The same for the init_menu struct instead of just a menu declaration.
 */

char hlp_clk[]="cl(ock) <arg>\n  where: arg is 'css' for css clock, 'bd' for local clock,or null for status\nof current clock.\n";

struct init_menu i_boot_level[] = {
	"b(oot)", "",
	"Return to PROM and Boot Runtime Code", 'c', 0, 0, bootme,(char *)0,

	"exit", "",
	"Return to PROM", 'c', 0, 0, bootme,(char *)0,

	"pwroff","", 
	"Turn off main power", 'c', 0, 2, do_off_pwr, (char *)0,

	"cl(ock)", "",
	"Clock Source: CSS or on-board",'c',0,1,Clock, hlp_clk,

	"s(tatus)", "",
	"System Status", 'm', 0, 0, (PFI)i_system_status, (char *)0,

	"t(st)", "",
	"System Test", 'm', 0, 0, (PFI)i_system_test, (char *)0,

	"","","", '\0', 0, 0, 0, (char *)0,
};

struct init_menu i_system_status [] = {
	"sy(stem)","",
	"Print sys config from NV RAM",'c',0,0,show_config,(char *)0,

	"show","CSS|ICB ",
	"Show CSS and ICB config",'c', 0, 1,show_em,(char *)0,

	"ti","<h><m><s><day><m><d><yr>",
	"Read/Set time and date",'c',0,7,tod,(char *)0,

	"te", "",
	"Read card cage temperature",'c',0,0,temp,  (char *)0,

#ifdef	SPM_IMAGE
	"margin","ps_num  l/h/n",
	"Command for modifying MARGIN settings", 'c',2,2,margin,(char *)0,

	"ciod","",
	"Display CIO output status", 'c',0,0,display_cios_status,(char *)0,
#endif

	"up(date)","",
	"Update system config in NV RAM",'c',0,0,init_novram_config,(char *)0,

	"cr(c)","",
	"Update the CRC in the NV RAM",'c',0,0,up_nov_chksum,(char *)0,

	"atb","",
	"Toggle Autoboot flag.",'c',0,0,c_atb,(char *)0,

	"dte","",
	"Print compile date.",'c',0,2,dte,(char *)0,

	"nvi(init)","<level (0-2)>",
	"Initialize the NV RAM",'c',0,1,nvinit,(char *)0,

	"nve(dit)","",
	"Edit the NV RAM",'c',0,0,nvedit,(char *)0,

	"cpa(th)","",
	"Clear both Boot Paths",'c',0,0,nv_def_path,(char *)0,

	"vpa(th)","",
	"View current Boot Paths",'c',0,0,nv_def_path,(char *)0,

	"dpa(th)","",
	"Change Diag Boot Path",'c',0,0,nv_def_path,(char *)0,

	"rpa(th)","",
	"Change Runtime Boot Path",'c',0,0,nv_def_path,(char *)0,

	"","","", '\0', 0, 0, 0, (char *)0,
};

struct init_menu i_system_test [] = {
	"d(ebugger)","", 
	"Debugger", 'm', 0, 0, (PFI)i_debugger, (char *)0,

	"di(spatch)","",
	"Interrupt Dispatcher Diagnostics", 'm',0,0,(PFI)id_diag1,(char*)0,

	"s(et)","",
	"Set Global Variables", 'm', 0, 0, (PFI)i_set_global, (char *)0,

	"m(emory)","",
	"Memory Tests", 'm', 0, 0, (PFI)mem_debug, (char *)0,

	"i(diag)","",
	"Interrupt Dispatcher Utilities", 'm',0,0,(PFI)id_diagnostics,(char *)0,

	"pm(menu)","",
	"PM Utilities", 'c',0,0,pmmenu,(char *)0,

	"", "", "", '\0', 0, 0, 0, (char *)0,
};

#ifdef	SPM_IMAGE
struct init_menu i_set_global [] = {
	"tstset","",
	"set test flag",'c',0,0,stupidon,(char *)0,

	"setres","",
	"Toggles BUS ERROR inhibit flag.",'c',0,0,realstupid,(char *)0,

	"printer","",
	"Toggles shadow printer flag.",'c',0,0,printer,(char *)0,

	"", "", "", '\0', 0, 0, 0, (char *)0,
};
#endif

/*
 * This is where we set the real menu pointers up.  This is required for the
 * menu to work.
 */
struct menu *boot_level = (struct menu *)i_boot_level;
struct menu *system_status = (struct menu *)i_system_status;
struct menu *system_test = (struct menu *)i_system_test;
#ifdef	SPM_IMAGE
struct menu *set_global = (struct menu *)i_set_global;
#endif

