/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iopm.c: version 25.1 created on 11/27/91 at 14:38:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iopm.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include  "types.h"
#include  "iopm_comm.h"
#include  "novram.h"
#include  "dev.h"
#include  "sdk_disk.h"
#include  "disp.h"
#include  "global.h"

#define		BLK_SIZE	0x400		/* 1K block */
#define		MAGIC_TIMEOUT	100		

#define		IOPM_WRITES	8
#define		IOPM_SETTLE	0x50000

#define		FAIL		1
#define		PASS		0

extern  uint    tst_pat[];
#define	TST_PAT_SIZ	32
#define	TEST_INCR	0x04030201
#define	IOPM_START_ADDR	0xA8000000
#define	IOPM_MEM_SIZE	0x00020000

#define IOPM_CMD_TIMEOUT	0xFFFF
#define	IOPM_DISK_TIMEOUT	5000
#define	IOPM_TAPE_TIMEOUT	50000
#define	WASTE_LIMIT	0x1000

extern	uchar	css_slot;
extern	uchar	sub_slot;
extern	uchar	phys_dev;
extern	uchar	log_dev;
extern	uint	boot_type;

extern	struct slotst sf;

extern char got_berr;		/* Bus error flag */
extern char emulate;		/* Bus error emulation flag */
extern char ignore_it;			/* If set, ignore CSS bus errors. */

extern	unsigned char	bdhere[];

unsigned int get_iopm_blk_num ();
int	rd_iopm_dev ();

extern  void    fill32 ();
extern  int	check32 ();

int
iopm_bootable (slot)
char slot;
{
	uchar  device_id;
	uchar  sav_berr;
	cssmap (MAP02, slot, 0x0F);

	sav_berr = got_berr;
	got_berr = 0;
	emulate = ignore_it = 1;

	device_id = *(uchar *)IOPM_DEV_BD_ID;	/* assumes MAP02 used */

	emulate = ignore_it = 0;
	if (got_berr) {
		got_berr = sav_berr;
		return(0);			/* not bootable */
	}
	got_berr = sav_berr;

	if (device_id & IOPM_BOOTABLE_DEV)
		return (1);			/* bootable device board */
	else
		return (0);			/* device board not bootable */
}

unsigned int
get_iopm_blk_num (type)
char	type;
{

	uchar  sav_berr;
	IOP_COMM_PTR  iopm_cmd = (struct iop_comm *)IOPM_COMM_ADDR;

	if (bdhere[css_slot] != IOPHERE) {
		printf ("No IOPM in slot %x (%d).\n", css_slot, css_slot);
		return(1);
	}

	sav_berr = got_berr;
	got_berr = 0;
	emulate = ignore_it = 1;

	cssmap (MAP02, css_slot, 0x0F);

	if (iopm_cmd->istatus != (uint)CSS_OWNED) {
		printf ("IOPM Stucture in unexpected state - not CSS\n");
		printf ("Expected %d; Got %d\n", CSS_OWNED, iopm_cmd->istatus);
		return (1);
	}

	iopm_cmd->phys_dev = (uint)phys_dev;
	iopm_cmd->log_dev = (uint)log_dev;
	iopm_cmd->icmd = (uint)IOPM_BLOCK_NUM;

	if (do_iopm_cmd () == FAIL) {
		got_berr = sav_berr;
		emulate = ignore_it = 0;
		return(0xFFFFFFFF);
	}
	got_berr = sav_berr;
	emulate = ignore_it = 0;

	if (iopm_cmd->ret_code) {
		return(0xFFFFFFFF);
	}

	if (type)		/* slice type is important */
		if (iopm_cmd->dev_type != type) {
			printf ("Slice type not as desired.\n");
			printf ("Expected %d, Got %d.\n", type, 
				iopm_cmd->dev_type);
			return(0xFFFFFFFF);
		}

	return(iopm_cmd->st_block);
}

int
rd_iopm_dev (block, size)
uint	block;
uint	size;
{
	uchar  sav_berr;

	IOP_COMM_PTR  iopm_cmd = (struct iop_comm *)IOPM_COMM_ADDR;

	if (bdhere[css_slot] != IOPHERE) {
		printf ("No IOPM in slot %x (%d).\n", css_slot, css_slot);
		return(1);
	}

	cssmap (MAP02, css_slot, 0x0F);

	sav_berr = got_berr;
	got_berr = 0;
	emulate = ignore_it = 1;

	if (iopm_cmd->istatus != (uint)CSS_OWNED) {
		printf ("IOPM Stucture in unexpected state - not CSS\n");
		printf ("Expected %d; Got %d\n", CSS_OWNED, iopm_cmd->istatus);
		got_berr = sav_berr;
		emulate = ignore_it = 0;
		return (1);
	}

	iopm_cmd->phys_dev = (uint)phys_dev;
	iopm_cmd->st_block = block;
	iopm_cmd->num_block = size;
	iopm_cmd->icmd = (uint)IOPM_R_DEV;

	if (do_iopm_cmd () == FAIL) {
		got_berr = sav_berr;
		emulate = ignore_it = 0;
		return(FAIL);
	}

	got_berr = sav_berr;
	emulate = ignore_it = 0;
	return(iopm_cmd->ret_code);
}

void
check_iopm_dev_type (block, size, type_expected)
uint	block;
uint	size;
uint	type_expected;
{
	IOP_COMM_PTR  iopm_cmd = (struct iop_comm *)IOPM_COMM_ADDR;

	cssmap (MAP02, css_slot, 0x0F);
	switch (type_expected) {
	case DV_IOPM_MT:
	case DV_IOPM_9T:
		if (iopm_cmd->dev_type & TAPE_DEVICE)
			printf ("Device is tape type as requested\n");
		else
			printf ("Device is not tape type as expected\n");
		break;
	case DV_IOPM_DK:
	case DV_IOPM_RV:
		if (iopm_cmd->dev_type & DISK_DEVICE)
			printf ("Device is disk type as requested\n");
		else
			printf ("Device is not disk type as expected\n");
		break;
	default:
		printf ("find_iopm_dev_type: bad boot_type.\n");
		break;
	}
}

int
iopm_init (slot)
uchar	slot;
{
	uint err = 0;
	uint cnt;
	uint *iopm_start= (uint *)IOP_RAM_START;
	uint *iopm_end = (uint *)(IOP_RAM_START + IOPM_MEM_SIZE);
	IOP_COMM_PTR  iopm_cmd = (struct iop_comm *)IOPM_COMM_ADDR;

	cssmap (MAP02, slot, 0x0F);

	for (cnt = 0; cnt != IOPM_WRITES; cnt++)
		*iopm_start = (uint)0;
	
	for (cnt = 0; cnt != IOPM_SETTLE; cnt++);
         
	for (cnt = 0; cnt != TST_PAT_SIZ; cnt++) {
		fill32 (iopm_start, iopm_end, tst_pat[cnt], TEST_INCR);
		err += check32 (iopm_start, iopm_end, tst_pat[cnt], TEST_INCR);
	}
	fill32 (iopm_start, iopm_end, 0, 0);

	iopm_cmd->iop_magic = SPM_MAGIC_NUM;

	return(0);
}

int
iopm_prom_ver (comm_str, arg_cnt)
char	*comm_str;
int	arg_cnt;
{
	uchar  sav_berr;
	char	device[8];

	IOP_COMM_PTR  iopm_cmd = (struct iop_comm *)IOPM_COMM_ADDR;

	if (arg_cnt)
		css_slot = (uchar)atox(comm_args[1]);

	if (bdhere[css_slot] != IOPHERE) {
		printf ("No IOPM in slot %x (%d).\n", css_slot, css_slot);
		return(1);
	}

	sav_berr = got_berr;
	got_berr = 0;
	emulate = ignore_it = 1;

	cssmap (MAP02, css_slot, 0x0F);

	if (iopm_cmd->istatus != (uint)CSS_OWNED) {
		printf ("IOPM Stucture in unexpected state - not CSS\n");
		printf ("Expected %d; Got %d\n", CSS_OWNED, iopm_cmd->istatus);
		got_berr = sav_berr;
		emulate = ignore_it = 0;
		return (1);
	}

	if (comm_str[1] == 'e') {
		iopm_cmd->icmd = (uint)IOPM_EEPROM_VER;
		strcpy (device, "EEPROM");
	}
	else {
		iopm_cmd->icmd = (uint)IOPM_PROM_VER;
		strcpy (device, "EPROM");
	}

	if (do_iopm_cmd () == FAIL) {
		printf ("Error getting IOPM %s version data.\n", device);
		got_berr = sav_berr;
		emulate = ignore_it = 0;
		return(FAIL);
	}
	got_berr = sav_berr;
	emulate = ignore_it = 0;

	if (iopm_cmd->ret_code) {
		printf ("Error getting IOPM %s version data.\n", device);
		return(1);
	}

	printf ("IOPM %s version:  %d.%d\n", 
		device,	iopm_cmd->fname[0], iopm_cmd->fname[1]);
	return(0);
}

void
iopm_recover (slot)
uchar	slot;
{
	int	cnt;

	cssmap(MAP00, (unsigned char)slot, 0x0f);	/* setup map for IOPM */
	ifdisable(0);				/* reset board */

	for (cnt = 0; cnt != IOPM_SETTLE; cnt++);

	ifenable(2);				/* enable interface */
	iopm_init(slot);			/* initialization routine */
	ifenable(0);				/* enable module */

	return;
}

int
do_iopm_cmd ()
{
	uint	timer = 0;
	uint	iopm_timeout = 0;
	uint	waste_time;

	IOP_COMM_PTR  iopm_cmd = (struct iop_comm *)IOPM_COMM_ADDR;

	cssmap (MAP02, css_slot, 0x0F);
	iopm_cmd->ret_code = IOPM_CMD_TIMEOUT;
	iopm_cmd->istatus = (uint)IOPM_OWNED;

	if (boot_type == DV_IOPM_RV || boot_type == DV_IOPM_DK)
		iopm_timeout = IOPM_DISK_TIMEOUT;
	else
		iopm_timeout = IOPM_TAPE_TIMEOUT;

	while (iopm_cmd->istatus != (uint)CSS_OWNED && !got_berr) {
		for (waste_time = 0; waste_time != WASTE_LIMIT; waste_time++)
			;

		if (got_berr) {
			printf ("IOPM in slot %x (%d) failed.\n", 
					css_slot, css_slot);
			printf ("Attempting recovery....reseting IOPM.\n");
			iopm_recover (css_slot);
			return(FAIL);
		}

		if (timer++ == iopm_timeout)
			return(FAIL);
	}
	return(PASS);		
}

int
check_iopm_magic ()
{
	uint	cnt;
	uchar	slot;
	IOP_COMM_PTR  iopm_cmd = (struct iop_comm *)IOPM_COMM_ADDR;

	for (cnt = 0; cnt != (IOPM_SETTLE * 20); cnt++);

	for (slot = 0; slot != Sbus_Num_Slot; slot++) {

		if (bdhere[slot] == IOPHERE) {
			
			cssmap (MAP02, slot, 0x0F);
				
			if (iopm_cmd->iop_magic != IOPM_MAGIC_NUM) {
				printf ("\nIOPM in slot %x (%d) does not respond...",
					slot, slot);
				printf ("Board halted.\n");
				cssmap(MAP00, (uchar)slot, 0x0f);

				ifdisable(0);	/* disable css slot */
				bdhere[slot] = NOBOARD;
				sf.on[slot] = 0; /* Initialize this slot flag */
			}
		}
	}
}
