/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomw.c: version 25.1 created on 11/27/91 at 14:38:45	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomw.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


#include "spm.h"
#include "misc.h"
#include "types.h"
#include "menu.h"
#include "global.h"
#include "ring.h"
#include "localmenu.h"
#include "loc_rout.h"
#include "iom.h"
#include "bus.h"


#define BUFPOINT 0x103e000

extern unsigned char *buff;

extern	char	all_flag;
extern	unsigned char	emulate;
extern  char 	got_berr;	/* set if we got bus error */
char		iom_addr_flag;
extern char iom_tst_flag;	/* added by YVC at 2/1/88 for testing IOM */
extern char io_int_test;	/* this is set to zero when we want to. */
extern char all_flag;	/* this is set to zero when we want to. */
extern unsigned char i_cnt;
extern unsigned char pwr_test;
extern unsigned int_data;
extern unsigned char myslot;


/*
 *	iom_8w(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	io8w(emory)	<slot> <addr> -  IO module loop 18 write test
 */

iom_8w(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int *mem;
	unsigned char iom_slot;


	iom_slot = (unsigned char)atox(comm_args[1]);
	mem = (unsigned int *)buff;


	if(iom_loop_8w(iom_slot,mem))
		printf("\nTest failed\n");
	else
		printf("\nTest OK\n");

	sim_off();/* set SP memory simulate off */
}


/*
 *	iom_16w(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	io16w(emory)	<slot> -  IO module loop 18 write test
 */

iom_16w(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int *mem;
	unsigned char iom_slot;


	iom_slot = (unsigned char)atox(comm_args[1]);
	mem = (unsigned int *)buff;

	io_int_test = 0xff;

	if(iom_loop_16w(iom_slot,mem))
		printf("\nTest failed\n");
	else
		printf("\nTest OK\n");

	io_int_test = 0;

	sim_off();/* set SP memory simulate off */
}



/*
 *	iom_w(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	iomw(emory)<.[bwl]> <slot> -  IO module loop write test
 */

iom_w(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	register int size;
	register char *mem;
	register unsigned char iom_slot, addr ;
	char result;

	init_css();

	iom_slot = (unsigned char)atox(comm_args[1]);

	mem = (char *)LNKCTL;		/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0xe1;			/* set IO module loop back config. */

	iom_err_rst(iom_slot);

	mem = (char *)buff;
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);

	sim_on();			/* set SP module memory simulate on */

	size = (int)0x60;
	switch(mref_siz) {
		case 'l':
			result = iom_loop_write(mem,size,0x04);
			break;
		case 'w':
			result = iom_loop_write(mem,size,0x02);
			break;
		case 'b':
			result = iom_loop_write(mem,size,0x01);
			break;
		default:
			printf("Wrong byte type\n");
			return(-1);
	}
	if (result)
		printf("\nTest failed\n");
	else
		printf("\nTest OK\n");
	sim_off();			/* set SP module memory simulate off */
}


/*      iom_loop_8w(iom_slot,lmem)   */
/*	TEST stratgy :
	1.	Set up IO module interrupt vector table & enable IOM interrupt
	2.	Set loop back configuration in the IO module
	3.	Reset test module ready count to zero, so no CSS command can
		be loop back to test module.
	4.	Issue 8 long word write commands to fill IO module command
		buffer and since test module is not ready for any CSS command
		there is no write command loop back to test module.
	5.	Increment test module ready count by 1 to start CSS operation,
		commands in the IO module command buffer start to loop back to 
		test module. Wait for a while to allow 8 write simulations to
		be completed.
	6.	Read test module local memory and verify all data is correctly
		written into the test module memory.
	7.	Loop 3 to 6 until ESC key pressed.

		If IO module hardware detects an abnormal frailure, It will
		generate an IO module interrupt to test module. The test 
		module interrupt handler routine will check and report IO
		module error condition if any.
*/
iom_loop_8w(iom_slot,lmem)
unsigned char iom_slot;
unsigned int *lmem;
{
	unsigned int *tmem,*lptr,ldata,rldata;
	unsigned counter,temp,tseed;
	int size,i,j;
	char flag;
	unsigned char addr,*cmem;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();
	
	lmem = (unsigned int *)((unsigned)lmem & 0xfffffff);
	cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0xe1;			/* set IO module loop back config. */

	iom_err_rst(iom_slot);

	flag = 0;
	tseed = 0;
	counter = 0;
	if(!pwr_test)
	printf ("IOM 8 Write test\n");
	while(!flag)	{

		iom_path_rst(iom_slot);
	
		size = 32;			/* 8 long word size */
 		ldata = (unsigned int)tseed;
		ul_inh(iom_slot);
		addr  = (unsigned char)CSSADD((unsigned)lmem);
		tmem = (unsigned int *)CSSMAP((unsigned)lmem);
		cssmap(MAP00,iom_slot,addr);
		for ( lptr=tmem; size > 0 ; ) {
			*lptr = ldata;
			lptr++;
			size -= 4;
			ldata += 4030201;
	    	}
		sim_on();	/* set SP module memory simulate on */
		for (j = 0; j < 8; j++)	{
			ul_rd_once(iom_slot);	/* rd a cmd from up link buff */
	    		for (i = 0; i < 0x100; i++)
				;
		}
		sim_off();		/* set SP memory simulate off */
		ul_inh_n(iom_slot);
		size = 32;			/* 8 long word size */
 		ldata = (unsigned int)tseed;
		/* Read local ram and compare loop */
		temp = (unsigned)lmem & 0x0fffffff;
		for ( lptr=(unsigned int *)temp; size > 0 ; ) {
			rldata = *lptr ; 
			if (rldata != ldata) {
				if (pf)	{
					  emulate = 0xff;
					  printf ("Error: addr %8x: ",lptr);
					  printf ("data is %8x: ", rldata);
					  printf ("should be %8x\n", ldata);
				}
				if (stop || all_flag)
					return(-1);
				else
					pf = 0;
			}
			lptr++;
			size -= 4;
			ldata += 4030201;
	    	}
		tseed += 10203040;
		if(ifesc())
			flag = 1;
		if (!all_flag)
			printf("\rLoop count :%08x ",counter++);
		if (all_flag)
			flag = 1;
     	}
	if (pf)
		return(0);
	else 	{
		emulate = 0x00;
		return(1);
	}
}

/*      iom_loop_16w(iom_slot,lmem)   */
/*	TEST stragey :
	1.	Set up IO module interrupt vector table & enable IOM interrupt
	2.	Set loop back configuration in the IO module
	3.	Set increment ready on command received in the IO module
	4.	Reset service module ready count to zero, so no CSS command can
		be loop back to service module.
	5.	Issue 18 long word write commands to fill IO module command
		buffer and since service module is not ready for any CSS command
		there is no write command loop back to service module.
	6.	Increment service module ready count by 1 to start CSS operation
		commands in the IO module command buffer start to loop back to 
		service module. Wait for a while to allow first 10 write simu-
		lations to be completed.
	7.	Set buffer ready enable in the IO module to allow the rest 
		commands in the command buffer to be send out back to service
		module.
	8.	Wait for a while to allow 8 write simulates to be completed.
	9.	Read test service local memory and verify all data is 
		correctly written into the service module memory.
	10.	Loop 3 to 9 until ESC key pressed.

		If IO module hardware detects an abnormal frailure, It will
		generate an IO module interrupt to service module. The service 
		module interrupt handler routine will check and report IO
		module error condition if any.
*/
iom_loop_16w(iom_slot,lmem)
unsigned char iom_slot;
unsigned int *lmem;
{
	unsigned int *tmem,*lptr,ldata,rldata;
	unsigned temp,tseed,counter;
	int size,i,j;
	char flag;
	unsigned char addr,*cmem;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();

	sp_int_set();	/* set SPM to receive int itself */
	/* initial IO module interrupt vector table */
	iom_int_tbl_init(iom_slot,0);

	lmem = (unsigned int *)((unsigned)lmem & 0xfffffff);
	cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0xe1;			/* set IO module loop back config. */

	cmem = (unsigned char *)IOMCTL; /* IOM control register */
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	*cmem = 0x20;			/* enable IO module interrupt */

	iom_err_rst(iom_slot);

	flag = 0;
	tseed = 0;
	counter = 0;
	if(!pwr_test)
	printf ("IOM 16 Write test\n");
	inc_on_rcv(iom_slot);
	while(!flag)	{
		i_cnt = 0;
		size = 64;			/* 16 long word size */
 		ldata = (unsigned int)tseed;
		ul_inh(iom_slot);
		addr  = (unsigned char)CSSADD((unsigned)lmem);
		tmem = (unsigned int *)CSSMAP((unsigned)lmem);
		cssmap(MAP00,iom_slot,addr);
		for ( lptr=tmem; size > 0 ; ) {
			*lptr = ldata;
			lptr++;
			size -= 4;
			ldata += 4030201;
			if (size == 32)		{
				dl_inh(iom_slot);
				addr  = (unsigned char)CSSADD((unsigned)lmem);
				cssmap(MAP00,iom_slot,addr);
			}
	    	}
		sim_on();	/* set SP module memory simulate on */
		for (j = 0; j < 8; j++)	{
			ul_rd_once(iom_slot);	/* rd a cmd from up link buff */
	    		for (i = 0; i < 0x100; i++);
		}
		dl_inh_n(iom_slot);	/* turn off down link inhibit bit */
		i = 200;
		while (i != 0)
			i--;
		for (j = 0; j < 8; j++)	{
			ul_rd_once(iom_slot);	/* rd a cmd from up link buff */
	    		for (i = 0; i < 0x100; i++)
				;
		}
		sim_off();		/* set SP memory simulate off */
		ul_inh_n(iom_slot);
		size = 64;			/* 16 long word size */
 		ldata = (unsigned int)tseed;
		/* Read local ram and compare loop */
		temp = (unsigned)lmem & 0x0fffffff;
		for ( lptr=(unsigned int *)temp; size > 0 ; ) {
			rldata = *lptr ; 
			if (rldata != ldata) {
				if (pf)	{
					  emulate = 0xff;
					  printf ("Error: addr %8x: ",lptr);
					  printf ("data is %8x: ", rldata);
					  printf ("should be %8x\n", ldata);
				}
				if (stop || all_flag)	{
					inc_on_rcv_n(iom_slot);
					iom_path_rst(iom_slot);
					return(-1);
				}
				else
					pf = 0;
			}
			lptr++;
			size -= 4;
			ldata += 4030201;
	    	}
		if (i_cnt)	{
			i_cnt--;
			sp_int_ack1(myslot);
			if (!(int_data & IOD_INT)) 	{/* IO device int */
			/* IO module interrupt, return error */
				printf("IOM interrupt error\n");
				iom_err(iom_slot);
			}
			else
				printf("IOM device interrupt error\n");
			return(1);
		}
		tseed += 10203040;
		if(ifesc())
			flag = 1;
		if (!all_flag)
			printf("\rLoop count :%08x ",counter++);
		if (all_flag)
			flag = 1;
     	}
	iom_path_rst(iom_slot);
	if (pf)
		return(0);
	else 	{
		emulate = 0x00;
		return(1);
	}
}


iom_loop_write(mem,count,byte)
register char *mem; int count;
unsigned char byte;
{
	register char *ptr,data,rdata;
	unsigned int *lmem,*lptr,ldata,rldata;
	unsigned short *wmem,*wptr,wdata,rwdata;
	unsigned temp,tseed,counter;
	int size;
	char flag;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();

	flag = 0;
	counter = 0;
	switch (byte)	{
	   case 01:		/* One byte write test */
		if(!pwr_test)
		printf ("IOM Write test (byte)\n");
		while(!flag)	{
			size = count;
 			data = (char)tseed;
			/* Write loop */
			for ( ptr=mem; size > 0 ; ) {
				*ptr = data;
				ptr++;
				size--;
				data += 01;
	    		}
			size = count;
 			data = (char)tseed;
			/* Read local ram and compare loop */
			temp = (unsigned)mem & 0x0fffffff;
			for ( ptr=(char *)temp; size > 0 ; ) {
				rdata = *ptr ; 
				if (rdata != data) {
					if (pf)	{
					     emulate = 0xff;
					     printf ("Error: addr %8x: ",lptr);
					     printf ("data is %2x: ",rdata);
					     printf ("should be %2x\n",data);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				ptr++;
				size--;
				data += 01;
     			}
			tseed += 40;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop count :%02x ",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;

	   case 02:		/* Two byte write test */
		if(!pwr_test)
		printf ("IOM Write test (word)\n");
		wptr = (unsigned short *)ptr;
		wmem = (unsigned short *)mem;
		while(!flag)	{
			size = count;
 			wdata = (short)tseed;
			/* Write loop */
			for ( wptr=wmem; size > 0 ; ) {
				*wptr = wdata;
				wptr++;
				size -= 2;
				wdata += 0201;
	    		}
			size = count;
 			wdata = (short)tseed;
			/* Read local ram and compare loop */
			temp = (unsigned)wmem & 0x0fffffff;
			for ( wptr=(unsigned short *)temp; size > 0 ; ) {
				rwdata = *wptr ; 
				if (rwdata != wdata) {
					if (pf)	{
					     emulate = 0xff;
					     printf ("Error: addr 0%08x: ",wptr);
					     printf ("data is 0%04x: ", rwdata);
					     printf ("should be 0%04x\n",wdata);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				wptr++;
				size -= 2;
				wdata += 0201;
     			}
			tseed += 4030;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop count :%08x ",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;

	   case 04:		/* Four byte write test */
		if(!pwr_test)
		printf ("IOM Write test (long word)\n");
		lptr = (unsigned int *)ptr;
		lmem = (unsigned int *)mem;
		while(!flag)	{
			size = count;
 			ldata = (unsigned int)tseed;
			/* Write loop */
			for ( lptr=lmem; size > 0 ; ) {
				*lptr = ldata;
				lptr++;
				size -= 4;
				ldata += 04030201;
	    		}
			size = count;
 			ldata = (unsigned int)tseed;
			/* Read local ram and compare loop */
			temp = (unsigned)lmem & 0x0fffffff;
			for ( lptr=(unsigned int *)temp; size > 0 ; ) {
				rldata = *lptr ; 
				if (rldata != ldata) {
					if (pf)	{
					     emulate = 0xff; 
					     printf ("Error: addr 0%08x: ",lptr);
					     printf ("data is 0%08x: ", rldata);
					     printf ("should be 0%08x\n",ldata);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				lptr++;
				size -= 4;
				ldata += 04030201;
     			}
			tseed += 40302010;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop count :%08x ",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;
	}
	if (pf)
		return(0);
	else 	{
		emulate = 0x00;
		return(1);
	}
}
		

/*
 *	iom_addr(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	iomadd(emory)	<slot> -  IO module loop address test
 */

iom_addr(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int *mem;
	unsigned char iom_slot;
	char result;

	if(arg_cnt < 1)	{
		return(-1);
	}

	iom_slot = (unsigned char)atox(comm_args[1]);

	iom_addr_flag = 0xff;
	result = iom_addr_test(iom_slot);
	iom_addr_flag = 0x00;
	if (result)
		printf("\nTest failed\n");
	else
		printf("\nTest OK\n");

	sim_off();/* set SP memory simulate off */
	iom_rst(iom_slot);
}



iom_addr_test(iom_slot)
unsigned char iom_slot;
{
	unsigned char	*lmem;
	unsigned char	*cmem,cnt,cnt1;
	unsigned 	addr_seed,r_addr;
	char 		flag;
	unsigned char 	addr,tseed;
	unsigned 	i,counter;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();

	tseed = 0x00000001;
	counter = 0;
	addr_seed = 0x00000001;
	cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0xe1;			/* set IO module loop back config. */
	
	iom_err_rst(iom_slot);

	flag = 0;
	sim_on();/* set SP memory simulate on */
	if(!pwr_test)
	printf("IOM Address lines ripple 1/0's test \n");
	while(!flag)	{
		/* do 32 times to go through all address lines */
		for (cnt = 0; cnt < 32; cnt++)	{
			lmem = (unsigned char *)addr_seed;
			addr  = (unsigned char)CSSADD((unsigned)lmem);
			lmem = (unsigned char *)CSSMAP((unsigned)lmem);
			cssmap(MAP00,iom_slot,addr);

			/* do 8 times to go through 8 command buffers */
			for (cnt1 = 0; cnt1 < 8; cnt1++)	{
				*lmem = tseed;
				i = 80;
				while (i != 0)
					i--;
				r_addr = addr_seed ^ (unsigned)sim_addr;
				if(r_addr)	{
					if (pf)	{
					     emulate = 0xff;
					     printf("\nRipple 1 \n");
					     printf("IOM address bits in error:%8x \n",r_addr);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
			}
			lmem = (unsigned char *)(~addr_seed & 0xffffff);
			addr  = (unsigned char)CSSADD((unsigned)lmem);
			lmem = (unsigned char *)CSSMAP((unsigned)lmem);
			cssmap(MAP00,iom_slot,addr);

			for (cnt1 = 0; cnt1 < 8; cnt1++)	{
				*lmem = tseed;
				i = 80;
				while (i != 0)
					i--;
				r_addr = (~addr_seed & 0xffffff) ^ (unsigned)sim_addr;
				if(r_addr)	{
					if (pf)	{
					     emulate = 0xff;
					     printf("\nRipple 0 \n");
					printf("IOM address bits in error:%8x \n",r_addr);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
			}
			addr_seed = addr_seed << 1;
		}
		if(all_flag)
			break;
		if (!all_flag)
			printf("\rLoop count :%08x ",counter++);
		else
			break;
		if(ifesc())
			break;
		addr_seed = 0x00000001;
	}
	if (pf)
		return(0);
	else 	{
		emulate = 0x00;
		return(1);
	}
}
		

iom_data(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int *mem;
	unsigned char iom_slot;
	char result;

	if(arg_cnt < 1)	{
		return(-1);
	}

	iom_slot = (unsigned char)atox(comm_args[1]);

	iom_addr_flag = 0xff;
	result = iom_datal_test(iom_slot);
	iom_addr_flag = 0x00;
	if (result)
		printf("\nTest failed\n");
	else
		printf("\nTest OK\n");

	sim_off();/* set SP memory simulate off */
	iom_rst(iom_slot);
}



iom_datal_test(iom_slot)
unsigned char iom_slot;
{
	unsigned 	*lmem;
	unsigned char	*cmem,cnt,cnt1;
	unsigned 	addr_seed,r_addr;
	char 		flag;
	unsigned char 	addr;
	unsigned 	tseed,r_data;
	unsigned 	i,counter;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();

	tseed = 0x00000001;
	counter = 0;
	addr_seed = 0x00000000;
	cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0xe1;			/* set IO module loop back config. */
	
	iom_err_rst(iom_slot);		/* clear iom error first */

	flag = 0;
	sim_on();/* set SP memory simulate on */
	if(!pwr_test)
	printf("IOM Data lines ripple 1/0's test \n");
	while(!flag)	{
		/* do 32 times to go through all address lines */
		for (cnt = 0; cnt < 32; cnt++)	{
			lmem = (unsigned *)addr_seed;
			addr  = (unsigned char)CSSADD((unsigned)lmem);
			lmem = (unsigned *)CSSMAP((unsigned)lmem);
			cssmap(MAP00,iom_slot,addr);

			for (cnt1 = 0; cnt1 < 8; cnt1++)	{
				*lmem = tseed;
				i = 80;
				while (i != 0)
					i--;
				r_data = tseed ^ (unsigned)sim_data;
				if(r_data)	{
					if (pf)	{
					     emulate = 0xff; 
					     printf("Ripple 1 \n");
					printf("IOM data bits in error:%8x \n",r_data);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
			}
			for (cnt1 = 0; cnt1 < 8; cnt1++)	{
				*lmem = ~tseed;
				i = 80;
				while (i != 0)
					i--;
				r_data = (~tseed ) ^ (unsigned)sim_data;
				if(r_data)	{
					if (pf)	{
					    emulate = 0xff;
					     printf("Ripple 0 \n");
					printf("IOM data bits in error:%8x \n",r_data);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
			}
			tseed = tseed << 1;
		}
		if (!all_flag)
			printf("\rLoop count :%08x ",counter++);
		else
			break;
		if(ifesc())
			break;
		tseed = 0x00000001;
	}
	if (pf)
		return(0);
	else 	{
		emulate = 0x00;
		return(1);
	}
}
		



/*
 *	iom_f(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	iomf(emory)	<slot> -  IO module loop flow control test
 */

iom_f(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int *mem;
	unsigned char iom_slot;
	char result;

	if(arg_cnt < 1) return(-1);
	iom_slot = (unsigned char)atox(comm_args[1]);
	mem = (unsigned int *)atox (comm_args[2]);
	emulate = 0xff;
	io_int_test = 0xff;
	iom_tst_flag = 0xff;
	result = iom_loop_f(iom_slot);
	emulate = 0;
	io_int_test = 0;
	iom_tst_flag = 0;
/*
	FIX THIS  The test leaves the CSS bus in such a state as to cause
		  all future iom tests to bus error, the quick fix was to
		  perform a css_reset1, same as rcss debugger command
*/
	css_reset1 ();
	if (result)
		printf("\nTest failed\n");
	else
		printf("\nTest OK\n");
}

iom_loop_f(iom_slot)
unsigned char iom_slot;
{
	unsigned int *tmem,*lmem,size;
	unsigned char addr,*cmem;

	iom_rst(iom_slot);		/* make sure iom clear */
	iom_err_rst(iom_slot);		/* make sure iom clear */

	cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0xe1;			/* set IO module loop back config. */

	cmem = (unsigned char *)IOMCTL; /* IOM control register */
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	*cmem = 0x20;			/* enable IO module interrupt */

	printf ("IOM flow control test\n");

	got_berr = 0;	/*  clear bus error flag */
	i_cnt = 0;
	sp_int_set();	/* set SPM to receive int itself */
	/* initial IO module interrupt vector table */
	iom_int_tbl_init(iom_slot,0);

	size = 36;			/* 9 long word size */
	dl_inh(iom_slot);	/* inhibit any cmd out */
	lmem = (unsigned int *)0x1002000;
	addr  = (unsigned char)CSSADD((unsigned)lmem);
	tmem = (unsigned int *)CSSMAP((unsigned)lmem);
	cssmap(MAP00,iom_slot,addr);
	for ( ; size > 0 ; ) {
			*tmem = 0;
			tmem++;
			size -= 4;
	}
	/* here... we should get bus error */
	if (!got_berr)    	{ /* if bus error */
		if (i_cnt)	{
			i_cnt--;
			sp_int_ack1(myslot);
			if (!(int_data & IOD_INT)) /* IO device int */
			/* IO module interrupt, return error */
				printf("IOM interrupt error\n");
			else
				printf("IOM device interrupt err\n");
			return(1);
		}
		else 	{
			printf("No bus error detected\n");
			return(1);
		}
	}
	iom_rst(iom_slot);
	return(0);
}


