/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomr.c: version 25.1 created on 11/27/91 at 14:38:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm.h"
#include "misc.h"
#include "types.h"
#include "menu.h"
#include "global.h"
#include "ring.h"
#include "localmenu.h"
#include "loc_rout.h"
#include "iom.h"
#include "bus.h"
#include "disp.h"


#define BUFPOINT 0x103e000
extern unsigned char *buff;
extern unsigned char emulate;
extern unsigned char bdhere[];			/* slots for CSS board's... */

unsigned char t_4_rd;
unsigned char rd_2;
unsigned char pwr_test;
char	all_flag;


/*
 *	iom_r(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	iomr(emory)<.[bwl]> <slot> <addr> <size>  -  IO module loop read test
 */

iom_r(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	register int size;
	register char *mem;
	register unsigned char iom_slot, addr ;
	char	result;

	init_css();

	iom_slot = (unsigned char)atox(comm_args[1]);

	if(bdhere[iom_slot] != IOMHERE) {
		printf("\nThis is not an IOM slot.\n");
		return(1);
	}
	mem = (char *)LNKCTL;		/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0xe1;			/* set IO module loop back config. */

	mem = (char *)IOM_ER_RST; /* IOM error reset register */
	mem = (char *)CSSMAP((unsigned)mem);
	*mem = 0x00;			/* reset IO module error */

	mem = (char *)buff;
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);

	sim_on();			/* set SP module memory simulate on */

	size = (int)0x60;
	switch(mref_siz) {
		case 't':	/* 32 bytes read */
			result = iom_loop_read(mem,size,0x20);
			break;
		case 's':	/* 16 bytes read */
			result = iom_loop_read(mem,size,0x10);
			break;
		case 'd':	/* 8 bytes read */
			result = iom_loop_read(mem,size,0x08);
			break;
		case 'l':	/* 4 bytes read */
			result = iom_loop_read(mem,size,0x04);
			break;
		case 'w':	/* 2 bytes read */
			result = iom_loop_read(mem,size,0x02);
			break;
		case 'b':	/* 1 byte read */
			result = iom_loop_read(mem,size,0x01);
			break;
		default:
			printf("Wrong byte type\n");
			return(-1);
	}
	if (result)
		printf("\nTest failed\n");
	else
		printf("\nTest OK\n");
	sim_off();			/* set SP module memory simulate off */
	iom_rst(iom_slot);
}

/*
 *	iom_4r(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	io4r(emory)	<slot> <addr> -  IO module loop 18 write test
 */

iom_4r(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned int *mem;
	unsigned char iom_slot;

	iom_slot = (unsigned char)atox(comm_args[1]);
	mem = (unsigned int *)buff;

	if (iom_loop_4r(iom_slot,mem))
		printf("\nTest failed\n");
	else	{
		printf("\nTest OK\n");
		iom_rst(iom_slot);
	}
	t_4_rd = 0x0;

	sim_off();/* set SP memory simulate off */
}

iom_loop_read(mem,count,byte)
register char *mem; int count;
unsigned char byte;
{
	register char *ptr,data,rdata;		/* byte data & ptr */
	unsigned int *lmem,*lptr,*pptr,ldata,rldata;
	unsigned short *wmem,*wptr,wdata,rwdata; /* word data &ptr */
	unsigned temp,tseed,counter;
	int i,size;
	char flag;
	unsigned char	stop;
	unsigned char	pf;

	flag = 0;
	pf = 0xff;
	counter = 0;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();
	switch (byte)	{
	   case 01:		/* One byte read test */
		if(!pwr_test)
		printf ("IOM read test (byte)\n");
		while(!flag)	{
			size = count;
 			data = (char)tseed;
			/* Write data pattern to service module local ram */
			temp = (unsigned)mem & 0x0fffffff;
			for ( ptr=(char *)temp; size > 0 ; ) {
				*ptr = data; 
				ptr++;
				size--;
				data += 01;
     			}
			size = count;
 			data = (char)tseed;
			/* Read back through IO module and compare loop */
			for ( ptr=mem; size > 0 ; ) {
				set_fake_rd(byte,(unsigned)ptr);
				*ptr = rdata;		/* fake 1 byte read */
				for (i = 0x100;i > 0; i--)
					;
				i = ((unsigned)ptr) % 8;
				switch (i)	{
	   				case 00:
						rdata = *(unsigned char *)PIPELINE;
						break;
	   				case 01:
						rdata = *(unsigned char *)(PIPELINE+1);
						break;
	   				case 02:
						rdata = *(unsigned char *)(PIPELINE+2);
						break;
	   				case 03:
						rdata = *(unsigned char *)(PIPELINE+3);
						break;
	   				case 04:
						rdata = *(unsigned char *)(PIPELINE+4);
						break;
	   				case 05:
						rdata = *(unsigned char *)(PIPELINE+5);
						break;
	   				case 06:
						rdata = *(unsigned char *)(PIPELINE+6);
						break;
	   				case 07:
						rdata = *(unsigned char *)(PIPELINE+7);
						break;
				}
				if (rdata != data) {
					if (pf)	{
					  emulate = 0xff;
					  printf ("Error: addr 0%08x: ",ptr);
					  printf ("data is 0%02x: ", rdata);
					  printf ("should be 0%02x\n", data);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				ptr++;
				size--;
				data += 01;
	    		}
			reset_fake();
			tseed += 40;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop cnt :%08x",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;

	   case 02:		/* Two byte read test */
		if(!pwr_test)
		printf ("IOM read test (word)\n");
		wptr = (unsigned short *)ptr;
		wmem = (unsigned short *)mem;
		while(!flag)	{
			size = count;
 			wdata = (short)tseed;
			/* Write data pattern to service module local ram */
			temp = (unsigned)wmem & 0x0fffffff;
			for ( wptr=(unsigned short *)temp; size > 0 ; ) {
				*wptr = wdata; 
				wptr++;
				size -= 2;
				wdata += 0201;
     			}
			size = count;
 			wdata = (short)tseed;
			/* Read back through IO module and compare loop */
			for ( wptr=wmem; size > 0 ; ) {
				set_fake_rd(byte,(unsigned)wptr);
				*wptr = rwdata;		/* fake 2 byte read */
				for (i = 0x100;i > 0; i--)
					;
				i = ((unsigned)wptr) % 8;
				switch (i)	{
	   				case 00:
						rwdata = *(unsigned short *)PIPELINE;
						break;
	   				case 02:
						rwdata = *(unsigned short *)(PIPELINE+2);
						break;
	   				case 04:
						rwdata = *(unsigned short *)(PIPELINE+4);
						break;
	   				case 06:
						rwdata = *(unsigned short *)(PIPELINE+6);
						break;
				}
				if (rwdata != wdata) {
					if (pf)	{
					emulate = 0xff; 
					printf ("Error: addr 0%08x: ",wptr);
					printf ("data is 0%04x: ", rwdata);
					printf ("should be 0%04x\n", wdata);
					return(-1);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				wptr++;
				size -= 2;
				wdata += 0201;
	    		}
			reset_fake();
			tseed += 4030;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop cnt :%08x",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;

	   case 04:		/* Four byte read test */
		if(!pwr_test)
		printf ("IOM read test (long word)\n");
		lptr = (unsigned int *)ptr;
		lmem = (unsigned int *)mem;
		while(!flag)	{
			size = count;
 			ldata = (unsigned int)tseed;
			/* Write data pattern to service module local ram */
			temp = (unsigned)lmem & 0x0fffffff;
			for ( lptr=(unsigned int *)temp; size > 0 ; ) {
				*lptr = ldata; 
				lptr++;
				size -= 4;
				ldata += 04030201;
     			}
			size = count;
 			ldata = (unsigned int)tseed;
			/* Read back through IO module and compare loop */
			for ( lptr=lmem; size > 0 ; ) {
				set_fake_rd(byte,(unsigned)lptr);
				*lptr = ldata;		
				for (i = 10;i > 0; i--)
					;
				i = ((unsigned)lptr) % 8;
				if (i==0)
					rldata = *(unsigned *)PIPELINE;
				else
					rldata = *(unsigned *)(PIPELINE+4);
				if (rldata != ldata) {
					if (pf)	{
					emulate = 0xff; 
					printf ("Error: addr 0%08x: ",lptr);
					printf ("data is 0%08x: ", rldata);
					printf ("should be 0%08x\n", ldata);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				lptr++;
				size -= 4;
				ldata += 04030201;
	    		}
			reset_fake();
			tseed += 40302010;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop cnt :%08x",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;

	   case 010:		/* Eight byte read test */
		if(!pwr_test)
		printf ("IOM read test (8 bytes)\n");
		lptr = (unsigned int *)ptr;
		lmem = (unsigned int *)mem;
		while(!flag)	{
			size = count;
 			ldata = (unsigned int)tseed;
			/* Write data pattern to service module local ram */
			temp = (unsigned)lmem & 0x0fffffff;
			for ( lptr=(unsigned int *)temp; size > 0 ; ) {
				*lptr = ldata; 
				lptr++;
				size -= 4;
				ldata += 04030201;
     			}
			size = count;
 			ldata = (unsigned int)tseed;
			/* Read back through IO module and compare loop */
			for ( lptr=lmem; size > 0 ; ) {
				set_fake_rd(byte,(unsigned)lptr);
				*lptr = rldata;		/* fake 8 byte read */
				for (i = 0x200;i > 0; i--)
					;
				rldata = *(unsigned *)PIPELINE;
				if (rldata != ldata) {
					if (pf)	{
					emulate = 0xff;
					printf ("Error: addr 0%08x: ",lptr);
					printf ("data is 0%08x: ", rldata);
					printf ("should be 0%08x\n", ldata);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				ldata += 04030201;
				rldata = *(unsigned *)(PIPELINE+4);
				if (rldata != ldata) {
					if (pf)	{
					emulate = 0xff;
					printf ("Error: addr 0%08x: ",lptr);
					printf ("data is 0%08x: ", rldata);
					printf ("should be 0%08x\n", ldata);
					}
					if (stop || all_flag)
						return(-1);
					else
						pf = 0;
				}
				lptr++;
				lptr++;
				size -= 8;
				ldata += 04030201;
	    		}
			reset_fake();
			tseed += 40302010;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop cnt :%08x",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;

	   case 16:		/* Sixteen byte read test */
		if(!pwr_test)
		printf ("IOM read test (16 bytes)\n");
		lptr = (unsigned int *)ptr;
		lmem = (unsigned int *)mem;
		while(!flag)	{
			size = count;
 			ldata = (unsigned int)tseed;
			/* Write data pattern to service module local ram */
			temp = (unsigned)lmem & 0x0fffffff;
			for ( lptr=(unsigned int *)temp; size > 0 ; ) {
				*lptr = ldata; 
				lptr++;
				size -= 4;
				ldata += 04030201;
     			}
			size = count;
 			ldata = (unsigned int)tseed;
			/* Read back through IO module and compare loop */
			for ( lptr=lmem; size > 0 ; ) {
				set_fake_rd(byte,(unsigned)lptr);
				*lptr = rldata;		/* fake 16 byte read */
				for (i = 0x200;i > 0; i--)
					;
				pptr = (unsigned int *)(PIPELINE - 8);
				for (i = 4;i > 0; i--)	{
					rldata = *pptr;	/* get return data */
					if (rldata != ldata) {
					   if (pf)	{
					     emulate = 0xff;
					     printf("Error: addr 0%08x: ",lptr);
					     printf("data is 0%08x: ", rldata);
					     printf("should be 0%08x\n", ldata);
					   }
					   if (stop || all_flag)
						return(-1);
					   else
						pf = 0;
					}
					ldata += 04030201;
					pptr++;
				}
				lptr++;lptr++;lptr++;lptr++;
				size -= 16;
	    		}
			reset_fake();
			tseed += 40302010;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop cnt :%08x",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;

	   case 32:		/* Thirty two byte read test */
		if(!pwr_test)
		printf ("IOM read test (32 bytes)\n");
		lptr = (unsigned int *)ptr;
		lmem = (unsigned int *)mem;
		while(!flag)	{
			size = count;
 			ldata = (unsigned int)tseed;
			/* Write data pattern to service module local ram */
			temp = (unsigned)lmem & 0x0fffffff;
			for ( lptr=(unsigned int *)temp; size > 0 ; ) {
				*lptr = ldata; 
				lptr++;
				size -= 4;
				ldata += 04030201;
     			}
			size = count;
 			ldata = (unsigned int)tseed;
			/* Read back through IO module and compare loop */
			for ( lptr=lmem; size > 0 ; ) {
				set_fake_rd(byte,(unsigned)lptr);
				*lptr = rldata;		/* fake 16 byte read */
				for (i = 0x200;i > 0; i--)
					;
				ldata += 04030201; /* first four bytes can't be 
						 read due hardware limitation */
				pptr = (unsigned *)(PIPELINE - 20);
				for (i = 7;i > 0; i--)	{
					rldata = *pptr;	
					if (rldata != ldata) {
					   if (pf)	{
					   emulate = 0xff; 
					   printf ("Error: addr 0%08x: ",lptr);
					   printf ("data is 0%08x: ", rldata);
					   printf ("should be 0%08x\n", ldata);
					   }
					   if (stop || all_flag)
						return(-1);
					   else
						pf = 0;
					} 
					ldata += 04030201;
					pptr++;
				}
				lptr++;lptr++;lptr++;lptr++;
				lptr++;lptr++;lptr++;lptr++;
				size -= 32;
	    		}
			reset_fake();
			tseed += 40302010;
			if(ifesc())
				flag = 1;
			if (!all_flag)
				printf("\rLoop cnt :%08x",counter++);
			if (all_flag)
				flag = 1;
     		}
		break;
	}
	if (pf)
		return(0);
	else {
		emulate = 0x00;
		return(1);
	}
}
		



iom_loop_4r(iom_slot,lmem)
unsigned char iom_slot;
unsigned int *lmem;
{
	unsigned int *tmem,*lptr,ldata,rldata,tseed;
	unsigned counter,temp,*pptr;
	int size,i,j;
	char flag;
	unsigned char addr,*cmem;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();

	lmem = (unsigned int *)((unsigned)lmem & 0xfffffff);
	cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0xe1;			/* set IO module loop back config. */

	iom_err_rst(iom_slot);

	flag = 0;
	tseed = 0;
	counter = 0;
	t_4_rd = 0xff;			/* set test flag */
	if(!pwr_test)
	printf ("IOM 4 read test\n");
	init_css();
	while(!flag)	{

		rd_2 = 0x00;	/* initialize 2nd read command flag */
		cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
		addr  = (unsigned char)CSSADD((unsigned)cmem);
		cmem = (unsigned char *)CSSMAP((unsigned)cmem);
		cssmap(MAP00,iom_slot,addr);
		*cmem = 0xe1;		/* set IO module loop back config. */

		iom_err_rst(iom_slot);
		iom_path_rst(iom_slot);

		size = 128;			/* 32 long word size */
 		ldata = tseed;
		/* Write data pattern to service module local ram */
		temp = (unsigned)lmem & 0x0fffffff;
		for ( lptr=(unsigned int *)temp; size > 0 ; ) {
			*lptr = ldata; 
			lptr++;
			size -= 4;
			ldata += 04030201;
     		}
		size = 128;			/* 32 long word size */
		ul_inh(iom_slot);
		addr  = (unsigned char)CSSADD((unsigned)lmem);
		tmem = (unsigned int *)CSSMAP((unsigned)lmem);
		cssmap(MAP00,iom_slot,addr);
		for ( lptr=tmem; size > 0 ; ) {
			set_fake_rd(0x20,(unsigned)lptr);
			*lptr = tseed;
			lptr++;lptr++;lptr++;lptr++;
			lptr++;lptr++;lptr++;lptr++;
			size -= 32;
	    	}
		reset_fake();
	/* Now we have 4 32-byte read commands in up link buffers */

		sim_on();	/* set SP module memory simulate on */
		inc_on_rcv(iom_slot);
		dl_inh(iom_slot); /* inhibit any responses at down link buff */
		ul_inh_n(iom_slot);  /* start loop read cmd back to spm */
	/* Please see simulate handler in excptions.c for detail operations */
	    	for (i = 0; i < 0xf000; i++)	/* wait for while */
			;
		lptr=(unsigned int *)temp;
	/* Now we have 8 responses in both down link and up link buffers */
 		ldata = tseed;
	/* Start read first 8 responses from up link buffers and check data */
		for (j = 8; j > 0; j--)		{
			ul_rd_once(iom_slot); /* rd a resp from up link buff */
	    		for (i = 0; i < 0x100; i++)
				;
			rldata = *(unsigned *)PIPELINE;
			if (rldata != ldata) {
				if (pf)	{
				printf ("Error0: addr 0%08x: ",lptr);
				printf ("data is 0%08x: ", rldata);
				printf ("should be 0%08x\n", ldata);
				}
				if (stop || all_flag)
					return(-1);
				else
					pf = 0;
			}
			lptr++;
			ldata += 04030201;
			rldata = *(unsigned *)(PIPELINE+4);
			if (rldata != ldata) {
				if (pf)	{
				printf ("Error1: addr 0%08x: ",lptr);
				printf ("data is 0%08x: ", rldata);
				printf ("should be 0%08x\n", ldata);
				}
				if (stop || all_flag)
					return(-1);
				else
					pf = 0;
			}
			lptr++;
			ldata += 04030201;
		}
	/* Unload 8 responses from down link buffers to up link buffers */
		dl_inh_n(iom_slot);
	    	for (i = 0; i < 0x100; i++)	/* wait for while */
			;
	/* Now we have only 8 responses in up link buffers */
	/* Start read last 8 responses from up link buffers and check data */
		for (j = 0; j < 8; j++)		{
			lptr++;
			ul_rd_once(iom_slot); /* rd a resp from up link buff */
	    		for (i = 0; i < 0x100; i++)
				;
			rldata = *(unsigned *)PIPELINE;
			if (rldata != ldata) {
				if (pf)	{
				printf ("Error2: addr 0%08x: ",lptr);
				printf ("data is 0%08x: ", rldata);
				printf ("should be 0%08x\n", ldata);
				}
				if (stop || all_flag)
					return(-1);
				else
					pf = 0;
			}
			ldata += 04030201;
			rldata = *(unsigned *)(PIPELINE+4);
			lptr++;
			if (rldata != ldata) {
				if (pf)	{
				printf ("Error3: addr 0%08x: ",lptr);
				printf ("data is 0%08x: ", rldata);
				printf ("should be 0%08x\n", ldata);
				}
				if (stop || all_flag)
					return(-1);
				else
					pf = 0;
			}
			ldata += 04030201;
		}
	/* all done for 4 32-byte read commands !! */
		sim_off();		/* set SP memory simulate off */
		ul_inh_n(iom_slot);
		tseed += 10203040;
		if(ifesc())
			break;
		if (!all_flag)
			printf("\rLoop cnt :%08x ",counter++);
		if (all_flag)
			break;
     	}
	if (pf)
		return(0);
	else 	{
		emulate = 0x00;
		return(1);
	}
}

