/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomint.c: version 25.1 created on 11/27/91 at 14:38:37	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomint.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm.h"
#include "misc.h"
#include "types.h"
#include "menu.h"
#include "global.h"
#include "ring.h"
#include "localmenu.h"
#include "loc_rout.h"
#include "iom.h"
#include "bus.h"


unsigned int_data;
extern unsigned char myslot;
extern unsigned char pwr_test;
extern unsigned char i_cnt;
unsigned char io_int_test;
extern char	all_flag;
extern char *gets();
extern unsigned char emulate;

/*
	CSS IO module interrupt test
	It tests IO module interrupt by causing IO module generate IO device
   	interrupt back to service module and check interrupt data.
	iom_int_test() -- Command syntax :
						IOI1 <iom_slot#> 
*/

iom_int_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	init_css();
	io_int_test = 0xff;
	result = iom_i_tst(iom_slot);	/* call iom interrupt test */
	io_int_test = 0x00;
	if (result)
		printf("Test failed\n");
	else	{
		printf("Test OK\n");
		iom_rst(iom_slot);
	}
}

iom_i_tst(iom_slot)
char 		iom_slot;
{
	unsigned char		*mem, addr;
	unsigned 		j, i,counter;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if(all_flag) stop = 0x1;
	else stop = checkpause();

	init_css();
	io_int_test = 0xff;
	if(!pwr_test)
	printf("IOM interrupt test\n");
	counter = 0;

	/* initial IO module interrupt vector table */
	iom_int_tbl_init(iom_slot,0);
	sp_int_set();	/* set SPM to receive int itself */

	iom_rst(iom_slot); 

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x31;			/* set IO module link config. */

	iom_err_rst(iom_slot);

	/* generate IO device interrupt */
	while(1)	{
		for (i = 0; i < 32; i++) {
		/*
		Issue interrupt request by writing I/O slot i to
		IOM address 0xfffffc00 
		*/
			mem = (unsigned char *)IOD_INT_REQ;
			addr  = (unsigned char)CSSADD((unsigned)mem);
			mem  = (unsigned char *)CSSMAP((unsigned)mem);
			cssmap(MAP00,iom_slot,addr);
			*mem = (unsigned char)i;
			/* wait for a while */
			j = 100;
			while(j) j--;

			if (i_cnt == 0x00) {  /* if cmd int happened ? */
				if(pf)	{
					emulate = 0xff;
					printf("No IOM interrupt error\n");
				}
				if(stop || all_flag) return(-1);
				else pf = 0;
			}
			else	{
				i_cnt--;
				sp_int_ack1(myslot);
				if (!(int_data & IOD_INT)) { /* IO device int */
				/* IO module interrupt, return error */
					if (pf)	{
						emulate = 0xff;
						printf("IOM interrupt type error\n");
					}
					if(stop || all_flag) return(-1);
					else pf = 0;
				}
				if ((int_data & 0x1f) != i) {
					if (pf)	{
						emulate = 0xff;
						printf("I/O slot# :%2x err\n",i);
					}
					if(stop || all_flag) return(-1);
					else pf = 0;
				}
			}
		}
		if(ifesc()) break;			/* if ESC key pressed then stop test */
		if(!all_flag) printf("\rLoop cnt :%08x",counter++);
		if(all_flag) break;
	}
	if(pf) return(0);
	else {
		emulate = 0x00;
		return(1);
	}
}



iom_int_wr(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = int_tbl_test(iom_slot);	/* call test */
	if (result)
		printf("Test failed\n");
	else	{
		printf("Test OK\n");
	}
}

int_tbl_test(iom_slot)
char iom_slot;
{
	register unsigned 	tdata, rdata;
	register unsigned 	*tp, *start, *end;
	unsigned char		addr;
	unsigned 		i,offset,counter,seed;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();

	offset = IOM_INT_V;		/* start address of interrupt vector */
	start = (unsigned *)CSSMAP(offset);
	end   = (unsigned *)(CSSMAP(offset) + INT_SIZE);
	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,iom_slot,addr);
	counter = 0;
	seed = 0;

	if(!pwr_test)
	printf ("IOM interrupt vector table w/r test\n");
	while(1)	{
	    /* Write/read/verify to IO module interrupt vector table loop */
		for (tp = start; tp < end ; ) {
			*tp = (unsigned)tp ;
			tp++;tp++;
	 	}
	 	for (tp = start; tp < end ; ) {
			tdata = (unsigned)tp | 0x000000ff;
			rdata = *tp ; 
			if (rdata != tdata) {
				if (pf)	{
					emulate = 0xff;
					printf ("Error: address 0x%08x -- ",tp);
					printf ("is 0x%08x, ", rdata);
					printf ("should be 0x%08x\n", tdata);
				}
				if (stop || all_flag)
					return(-1);
				else
					pf = 0;
			}
			tp++;tp++;
	 	}
		if (ifesc())	/* if ESC key pressed then stop test */
			break;
		if (!all_flag)
			printf("\rLoop cnt :%08x",counter++);
		if (all_flag)
			break;
		seed += 4030201;
	 }
	 if (pf)
	 	return(0);
	 else	{
		emulate = 0x00;
		return(1);
	}
}

/*
 * checkstop ()
 *
 *	Say 'stop test?' to user, return response.
 */

checkstop ()
{
	char ibuf [17];


	printf ("\nStop test? (Y/N) ");
	if ((gets (ibuf, 16) == (char *)-1)) return (-1);
	if (Yes (*ibuf) || !*ibuf) return (1);
	return (0);
}



/*
	CSS IO module interrupt counter test
	It tests IO module interrupt counter by generating 5 IO device
   	interrupts back to service module and check interrupt data.
	int_cnt_test() -- Command syntax :
						IOI2 <iom_slot#> 
*/

int_cnt_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	init_css();
	io_int_test = 0xff;
	result = iom_cnt_tst(iom_slot);	/* call int count test */
	io_int_test = 0x00;
	if (result)
		printf("Test failed\n");
	else	{
		printf("Test OK\n");
		iom_rst(iom_slot); 
	}
}


iom_cnt_tst(iom_slot)
char 		iom_slot;
{
	unsigned char		*mem, addr;
	unsigned 		j, i,counter;
	unsigned char	stop;
	unsigned char	pf;

	pf = 0xff;
	if (all_flag)
		stop = 0x1;
	else
		stop = checkpause();

	if(!pwr_test)
	printf("IOM interrupt counter test\n");
	counter = 0;	/* initialize loop counter to zero */
	while(1)	{
		init_css();
		/* Set flag to indicate to interrupt handler we are in IOM
		   interrupt testing mode, Please see autoint(level) in
		   excptions.c level 3 interrupt case
		*/  
		io_int_test = 0xff;
		/* initial IO module interrupt vector table */
		iom_int_tbl_init(iom_slot,0);

		mem = (unsigned char *)LNKCTL;	/* IOM link control register */
		mem = (unsigned char *)CSSMAP((unsigned)mem);
		*mem = 0x31;			/* set IO module link config. */
	
		iom_err_rst(iom_slot);	/* clear IOM error before test */
	
		mem = (unsigned char *)IOD_INT_REQ;
		mem  = (unsigned char *)CSSMAP((unsigned)mem);

		/* set SPM ready cnt to zero, IOM interrupt can't sent to SMP */
		rready();
		/* Now start to force IO module generates 5 interrupts */
		for (i = 0; i < 5; i++) {
			/*
			Issue interrupt request by writing I/O slot i to
			IOM address 0xfffffc00 
			*/
			*mem = (unsigned char)i;
		}
		/* Now IOM has 5 interrupts ready to sent to SPM */

		sp_int_set();	/* set SPM to receive int itself */
		i_cnt = 0;		/* Make sure interrupt count is zero */

		/* Increment SPM ready count to accept IOM interrupts */
		iready();


		for (i = 0; i < 5; i++) {	/* check all 5 IOM interrupts */

			j = 100;		/* wait for a while */
			while(j != 0)
				j--;

			if (i_cnt == 0x00) {  /* if level 3 int happened ? */
				if (pf)	{
					emulate = 0xff;
					printf("I/O slot# :%2x err\n",i);
					printf("Miss IOM int#: %2x error\n",i);
				}
				if (stop || all_flag)
					return(-1);
				else
					pf = 0;
			}
			else	{
				i_cnt--;		/* decrement int cnt */
				sp_int_ack1(myslot);	/* acknoweldege int */
			}
		}
		if (all_flag)	/* if in run all tests mode then don't loop */
			break;
		if (ifesc())	/* if ESC key pressed then stop test */
			break;
		printf("\rLoop cnt =%8x",counter++);
	}
	if (pf)
		return(0);
	else	{
		emulate = 0x00;
		return(1);
	}
}

sp_int_ack1(sp_slot)
unsigned sp_slot;
{
	register unsigned 	ack_offset, *ip;
	unsigned char		addr;

	ack_offset = (unsigned)0xffffff2c;
	addr = (unsigned char)CSSADD(ack_offset);
	cssmap(MAP00,sp_slot,addr);
	ip  = (unsigned *)CSSMAP(ack_offset);

	/*
	4 bytes css read to service module itself to 
	acknowledge interrupt to itself
	*/
	int_data = *ip; 	/* css 4 bytes read */
}


mapset(mapnum,slotnum,slotadd)
unsigned mapnum;
unsigned char slotnum,slotadd;
{
	register unsigned char* i;
 
	i=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*i = (slotnum << 4) | slotadd;
}

