/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomerr.c: version 25.1 created on 11/27/91 at 14:38:31	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomerr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm.h"
#include "global.h"
#include "ring.h"
#include "iom.h"
#include "bus.h"
#include "disp.h"

/*	CSS IO module error checking routines	*/

#define BUFPOINT 0x103e000

extern unsigned char *buff;
extern unsigned char bdhere[];

extern	char	iom_tst_flag;
char	resp_buff_ov;
char	cmd_buff_ov;
char	ioslot_err;
char	rmseq_err;
char	resp_time_out;
char	data_err;
char	type_err;
char	mis_match;		/* bus resp src mismatch */
char	dest_err;
char	source_err;
char	lk_rmseq_err;
char	lk_cmd_ov;
char	lk_resp_ov;
char	lk_dest_err;
char	lk_ioslot_err;
char	lk_type_err;
char	parity_err;		/* link data error */
char	lk_data_err;
char	time_out_flag;		/* bus grant timeout */

char	resp_ov_test;
char	err_result;
char 	no_resp;
char 	mis;
char 	free_slot;

extern char err_slot;
extern unsigned char t_4_rd;
extern unsigned char rd_2;
extern unsigned char HndlBerr;
extern unsigned char emulate;
extern unsigned int_data;
extern unsigned char i_cnt;
extern unsigned char io_int_test;
extern unsigned char myslot;
/*
extern short 		dl_state_rd();
extern short 		ul_state_rd();
*/

/*------------------------------------------------------------------------------
	CSS IO module source error test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module source error interrupt back
   	to service module and check interrupt data.
	iom_src_err() -- Command syntax :
						SRC <iom_slot#> 
------------------------------------------------------------------------------*/
iom_src_err(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = src_err(iom_slot);/* force iom source error */
	iomdiserr(iom_slot,result);
}

/*------------------------------------------------------------------------------
src_err(iom_slot)
     This routine tests IOM source error capture/report/clear function
------------------------------------------------------------------------------*/
src_err(iom_slot)
char 		iom_slot;
{
	register unsigned 	*ip;
	unsigned char		*mem, addr;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;

	iom_rst(iom_slot);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0xe1;		/* set IOM link config. to inhibit link RMSEQ error */
	iom_err_rst(iom_slot);
	/* initial IO module interrupt vector table */
	iom_int_tbl_init(iom_slot,0);

	source_err = 0x00;	/* reset source error flag to zero */
	sp_int_set();	/* set service module to receive int itself */

	/*
	force IO module down link data parity error to generate 
	IO module error interrupt.
	*/
	force_src_err(myslot,iom_slot);
	if(i_cnt == 0x00) return(1)  /* if level 3 int happened ? */;
	else	{ /* We got interrupt from IO module, Now acknowlege interrupt */
		i_cnt--;
		sp_int_ack1(myslot);

		/* Now check interrupt data sent by IO module */
		if (int_data & IOD_INT)		/* IO device interrupt */
			return(2);				/* We don't expect this type interrupt */
		else	{   /* Expected IO module interrupt */
			iom_err(iom_slot);	/* check for correct error */
			if (!source_err) return(3);
		}
	}

	iom_rst(iom_slot);				/* clear error */
	iom_err_rst(iom_slot);			/* clear error */
	source_err = 0x00;				/* reset error flag to zero */
	iom_err(iom_slot);				/* check if error is cleared */
	if(source_err) return(4);
	return(0);
}

/*------------------------------------------------------------------------------
	CSS IO module bus grant time out test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module time out error interrupt
   	back to service module and check interrupt data.
	iom_time_out() -- Command syntax :
						BTO <iom_slot#> 
------------------------------------------------------------------------------*/
bus_time_out(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = b_time_out(iom_slot);			/* call b_time_out routine */
	iomdiserr(iom_slot, result);
}

/*------------------------------------------------------------------------------
b_time_out(iom_slot)
     This routine tests IO module time out error capture/report/clear function
------------------------------------------------------------------------------*/
b_time_out(iom_slot)
char 		iom_slot;
{
	register unsigned 	*ip, j;
	unsigned char		*mem, addr;
	unsigned int  		*lptr, i;


	/* pollslot(0); */
	for( free_slot = 0xff,i = 0; i < 16; i++) {	/* loop through all slots. */
		if(bdhere[i] != NOBOARD)	/* if SOMETHING is here.. */
			continue;
		free_slot = i;
		break;						/* found a free slot */
	}
	if ( free_slot  == 0xff )  
		return (5);

	iom_tst_flag = 0xff;
	io_int_test = 0xff;
	iom_rst(iom_slot);
	mem = (unsigned char *)LNKCTL;		/* IO module link control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0xe1;		/* set IOM link config. to inhibit link RMSEQ error */
	mem = (unsigned char *)IOMCTL;		/* IOM control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0x20;						/* enable IO module interrupt */

	iom_err_rst(iom_slot);				/* clear error */
	sp_int_set();			/* set service module to receive int itself */
	/* initial IO module interrupt vector table */
	iom_int_tbl_init(iom_slot,0);

	time_out_flag = 0x00;				/* reset yime out flag to zero */
	/*
	Issue a CSS command with a non-exist slot to IO module and cause
	IO module error interrupt.
	*/
	dl_inh(iom_slot);	/* inhibit command at down link cmd buffer */
	force_sp_slot(free_slot);	/* force service module to be non-exist slot */
	lptr = (unsigned int *)buff;
	addr  = (unsigned char)CSSADD((unsigned)lptr);
	lptr = (unsigned int *)CSSMAP((unsigned)lptr);
	cssmap(MAP00,iom_slot,addr);
	*lptr = 0;				/* Issue a write command w/non-exist slot to IOM */
	force_sp_slot(myslot);	/* force service module to be self slot */
	dl_inh_n(iom_slot);		/* Now let write command loop back */
	j = 2000;
	while(j != 0) j--;		/* wait for a while */

	if (i_cnt == 0x00) return(1);	/* if level 3 int happened ? */
	else {
	/* We got interrupt from IO module, Now acknowlege interrupt */
		i_cnt--;
		sp_int_ack1(myslot);
		/* Now check interrupt data sent by IO module */
		if (int_data & IOD_INT) /* IO device interrupt */
			return(2);			/* We don't expect this type interrupt */
		else	{   /* Expected IO module interrupt */
			iom_err(iom_slot);
			if (!time_out_flag) return(3);
		}
	}
	iom_rst(iom_slot);
	time_out_flag = 0x00;	
	iom_err(iom_slot);
	if (time_out_flag)	{
		dl_inh_n(iom_slot);
		return(4);
	}
	return(0);
}

/*------------------------------------------------------------------------------
	CSS IO module response source mis_match test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module response source mis-match error interrupt
   	back to service module and check interrupt data.
	resp_mis_match() -- Command syntax :
						MIS <iom_slot#> 
------------------------------------------------------------------------------*/
resp_mis_match(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = r_mis_match(iom_slot);			/* call r_mis_match routine */
	iomdiserr(iom_slot,result);
	iom_tst_flag = 0x00;
	iom_tst_flag = 0x00;
}

/*------------------------------------------------------------------------------
r_mis_match(iom_slot)
     This routine tests IO module mis-match error capture/report/clear function
------------------------------------------------------------------------------*/
r_mis_match(iom_slot)
char 		iom_slot;
{
	register unsigned 	*ip, j;
	unsigned char		*mem, addr;
	unsigned int  		*lptr, i;


	/* pollslot(0); */
	for( free_slot = 0xff,i = 0; i < 16; i++) { /* loop through all slots */
		if(bdhere[i] != NOBOARD)	/* if SOMETHING is here.. */
			continue;
		free_slot = i;
		break;				/* found a free slot */
	}
	if ( free_slot  == 0xff )  
		return (5);

	iom_tst_flag = 0xff;
	io_int_test = 0xff;
	iom_rst(iom_slot);
	mem = (unsigned char *)LNKCTL;		/* IOM link control register. */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0xe1;		/* set IOM link to inhibit RMSEQ error. */
	iom_err_rst(iom_slot);		/* reset iom error before test. */
	sp_int_set();			/* Set SPM to receive int itself. */
	iom_int_tbl_init(iom_slot,0);	/* Init IOM int. vector table. */
	mis_match = 0x00;		/* Reset response mis-match flag. */
	/*
	Issue a CSS read command with a test flag set to inform handler to
	sent wrong slot response and cause IO module error interrupt.
	*/

	lptr = (unsigned int *)buff;
	addr  = (unsigned char)CSSADD((unsigned)lptr);
	lptr = (unsigned int *)CSSMAP((unsigned)lptr);
	cssmap(MAP00,iom_slot,addr);

	sim_on();			/* set SP module memory simulate on */
	set_fake_rd(0x4,(unsigned)lptr);
	mis = 0xff;
	emulate = 0xff;			/* turn on bus error emulate mode */
	*lptr = 0;			/* Issue a read command with mis-match flag set */
	j = 200;
	while(j--);
	emulate = 0x00;			/* turn on bus error emulate mode */
	mis = 0x00;
	reset_fake();
	sim_off();			/* set SP module memory simulate off */

	mem = (unsigned char *)IOMCTL; /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x20;			/* enable IO module interrupt */

	j = 200;
	while(j != 0) j--;					/* wait for a while */
	if (i_cnt == 0x00) return(1);		/* if level 3 int happened ? */
	else	{	/* We got interrupt from IO module, Now acknowlege interrupt */
		i_cnt--;
		sp_int_ack1(myslot);
		/* Now check interrupt data sent by IO module */
		if(int_data & IOD_INT)		/* IO device interrupt */
			return(2);				/* We don't expect this type interrupt */
		else {						/* Expected IO module interrupt */
			iom_err(iom_slot);
			if(!mis_match) return(3);
		}
	}

	iom_rst(iom_slot);
	mis_match = 0x00;	
	iom_err(iom_slot);
	if(mis_match) return(4);
	return(0);
}

/*------------------------------------------------------------------------------
	CSS IO module response time out test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module response time out error interrupt
   	back to service module and check interrupt data.
	resp_t_out() -- Command syntax :
						RTO <iom_slot#> 
------------------------------------------------------------------------------*/
resp_t_out(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = r_time_out(iom_slot);	/* call r_time_out routine */
	iomdiserr(iom_slot,result);
}

/*------------------------------------------------------------------------------
r_time_out(iom_slot)
     This routine tests IOM response time out capture/report/clear function
------------------------------------------------------------------------------*/
r_time_out(iom_slot)
char 		iom_slot;
{
	unsigned 		j;
	register unsigned 	*ip;
	unsigned char		*mem, addr;
	unsigned int  		*lptr;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;
	iom_rst(iom_slot);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0xe1;	/* set IOM link config. to inhibit link RMSEQ error */

	iom_err_rst(iom_slot);	/* clear error */

	mem = (unsigned char *)IOMCTL; /* IOM control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0x20;			/* enable IO module interrupt */

	sp_int_set();						/* set SPM to receive int itself */
	iom_int_tbl_init(iom_slot,0);	/* init IOM int. vector table */
	resp_time_out = 0x00;	/* reset response time out flag to zero */
	/*
	Issue a CSS read command with a test flag set to inform handler not to 
	sent response and casuse IO module error interrupt.
	*/

	no_resp = 0xff;		/* tell simulate handler not sent response */
	sim_on();		/* set SP module memory simulate on */
	lptr = (unsigned int *)buff;
	addr  = (unsigned char)CSSADD((unsigned)lptr);
	lptr = (unsigned int *)CSSMAP((unsigned)lptr);
	cssmap(MAP00,iom_slot,addr);
	set_fake_rd(0x4,(unsigned)lptr);
	*lptr = 0;	/* Issue a read command with no-response flag set */

	j = 200;
	while(j != 0) j--;	/* wait for a while */
	reset_fake();
	no_resp = 0x00;
	sim_off();						/* set SP module memory simulate off */
	if (i_cnt == 0x00) return(1);	/* if level 3 int happened ? */
	else	{ /* We got interrupt from IO module, Now acknowlege interrupt */
		i_cnt--;
		sp_int_ack1(myslot);
								/* Now check interrupt data sent by IO module */
		if(int_data & IOD_INT)	/* IO device interrupt */
			return(2);			/* We don't expect this type interrupt */
		else	{   /* Expected IO module interrupt */
			iom_err(iom_slot);
			if(!resp_time_out) return(3);
		}
	}
	iom_rst(iom_slot);
	resp_time_out = 0x00;	
	iom_err(iom_slot);
	if (resp_time_out) return(4);
	return(0);
}

/*------------------------------------------------------------------------------
	CSS IO module response buffer overflow test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module response buffer overflow error interrupt
   	back to service module and check interrupt data.
	iom_ov_test0() -- Command syntax :
						IOV0 <iom_slot#> 
------------------------------------------------------------------------------*/
iom_ov_test0(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char iom_slot, result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	err_result = 0;
	result = iom_ov_tst(iom_slot,2); /* call ov test */
	iomdiserr(iom_slot,result);
}

/*------------------------------------------------------------------------------
	CSS IO module command buffer overflow test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module command buffer overflow error interrupt
   	back to service module and check interrupt data.
	iom_ov_test1() -- Command syntax :
						IOV1 <iom_slot#> 
------------------------------------------------------------------------------*/
iom_ov_test1(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	err_result = 0;
	result = iom_ov_tst(iom_slot,1); /* call iom ov test routine */
	iomdiserr(iom_slot,result); 
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_data_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char iom_slot, result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	err_result = 0;
	result = iom_data_tst(iom_slot,myslot); /* call iom data test routine */
	iomdiserr(iom_slot,result);
}
/*----[tgm]---------------------------------------------------------------------
------------------------------------------------------------------------------*/
iomdiserr(slot,err_result) 
char slot, err_result;
{
	switch(err_result) {
		case 0 :
			iom_rst(slot);
			printf("Test OK\n");
			break;
		case 1 : printf("No IOM int.\n"); break;
		case 2 : printf("Error int type.\n"); break;
		case 3 : printf("No error Detected.\n"); break;
		case 4 : printf("Can't clear error.\n"); break;
		case 5 : printf("All slots are occupied.\n");
				 printf("Empty slot required for test purposes.\n"); break;
		default: printf("Got unknown error\n"); break;
	}
	io_int_test = 0x00;
	iom_tst_flag = 0x00;
}

/*------------------------------------------------------------------------------
iom_ov_tst(iom_slot,type)
     This routine tests IO module overflow error capture/report/clear function
------------------------------------------------------------------------------*/
iom_ov_tst(iom_slot,type)
char 		iom_slot,type;
{
	unsigned 		j;
	register unsigned 	*ip;
	unsigned char		*mem, addr;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;
	iom_rst(iom_slot);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0x21;	/* set IOM link config. to inhibit link RMSEQ error */

	iom_err_rst(iom_slot);					/* clear error */
	sp_int_set();						/* set SPM to receive int itself */
	iom_int_tbl_init(iom_slot,0);	/* init IOM int. vec table */
	cmd_buff_ov = 0x00;						/* Reset cmd overflow flag. */
	resp_buff_ov = 0x00;			/* reset resp overflow flag to zero */
	/*
	force IO module down link command buffer overflow to generate 
	IO module error interrupt.
	*/
	if (type == 1)	{
		dl_inh(iom_slot);
		ul_inh(iom_slot);
		force_cmd_ov(iom_slot);
	}
	if(type == 2) force_resp_ov(iom_slot);
	j = 20;
	while(j != 0) j--;				/* wait for a while */
	if (i_cnt == 0x00) { 			/* if level 3 int happened ? */
		err_result = 1;
		return;
	}
	else {				/* We got interrupt, Now acknowlege interrupt */
		i_cnt--;
		sp_int_ack1(myslot);
		/* Now check interrupt data sent by IO module */
		if (int_data & IOD_INT) { /* IO device interrupt */
			/* We don't expect this type interrupt */
			err_result = 2;
			return;
		}
		else	{   /* Expected IO module interrupt */
			iom_err(iom_slot);
			if (type == 1)
				if (!cmd_buff_ov)	{
					err_result = 3;
					return;
				}
			if (type == 2)	{
				if (!resp_buff_ov)	{
					err_result = 3;
					return;
				}
			}
		}
	}
	iom_rst(iom_slot);
	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0x21;	/* set IOM link config. to inhibit link RMSEQ error */

	iom_err_rst(iom_slot);	/* clear error */
	
	cmd_buff_ov = 0x00;	/* reset cmd overflow flag to zero */
	resp_buff_ov = 0x00;	/* reset resp overflow flag to zero */

	iom_err(iom_slot);
	if (type == 1)
		if (cmd_buff_ov)
			err_result = 4;
	if (type == 2)
		if (resp_buff_ov)
			err_result = 4;
}


/*------------------------------------------------------------------------------
iom_data_tst(iom_slot)
     This routine tests IO module data error capture/report/clear function
------------------------------------------------------------------------------*/
iom_data_tst(iom_slot)
char 		iom_slot;
{
	unsigned 		j;
	register unsigned 	*ip;
	unsigned char		*mem, addr;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;
	iom_rst(iom_slot);
	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0x21;	/* set IOM link config. to inhibit link RMSEQ error */

	iom_err_rst(iom_slot);	/* clear error */

	sp_int_set();	/* set service module to receive int itself */
	/* initial IO module interrupt vector table */
	iom_int_tbl_init(iom_slot,0);

	data_err = 0x00;	/* reset data error flag to zero */
	/*
	Issue a command with data parity error to generate 
	IO module error interrupt.
	*/
	emulate = 0xff;		/* turn on bus error emulate mode */
	force_data_err(iom_slot,0);
	emulate = 0x00;		/* turn off bus error emulate mode */
	j = 20;
	while(j != 0)	/* wait for a while */
		j--;
	if (i_cnt == 0x00) {  /* if level 3 int happened ? */
		err_result = 1;
		return;
	}
	else	{
		/*
		We got interrupt, Now acknowlege interrupt
		*/
		i_cnt--;
		sp_int_ack1(myslot);
		/*
		Now check interrupt data sent by IO module 
		*/
		if (int_data & IOD_INT) { /* IO device interrupt */
			/* We don't expect this type interrupt */
			err_result = 2;
			return;
		}
		else	{   /* Expected IO module interrupt */
			iom_err(iom_slot);
			if (!data_err)	{
				err_result = 3;
				return;
			}
		}
		iom_err_rst(iom_slot);	/* clear error */
		data_err = 0x00;	/* reset data error flag to zero */
		iom_err(iom_slot);
		if (data_err)	{
			err_result = 4;
			return;
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
force_resp_ov(iom_slot)
char 		iom_slot;
{
	unsigned char *mem, addr;
	unsigned int *lmem,*tmem;
	int size,j;

	mem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	*mem = 0xe1;		/* set IO module loop back config. */

	t_4_rd = 0x00;	/* reset test flag, make sure we do this test */
	resp_ov_test = 0xff;	/* set test flag,  */
	rd_2 = 0;

	size = 96;			/* three 32 byte read commands */
	ul_inh(iom_slot);
	lmem = (unsigned int *)buff;
	addr  = (unsigned char)CSSADD((unsigned)lmem);
	tmem = (unsigned int *)CSSMAP((unsigned)lmem);
	cssmap(MAP00,iom_slot,addr);
	for ( ; size > 0 ; ) {
		set_fake_rd(0x20,(unsigned)tmem);
		*tmem = 0;
		tmem++;tmem++;tmem++;tmem++;
		tmem++;tmem++;tmem++;tmem++;
		size -= 32;
	}
	reset_fake();

	sim_on();	/* set SP module memory simulate on */
	dl_inh(iom_slot); /* inhibit any responses at down link buff */
	ul_inh_n(iom_slot);  /* start loop read cmd back to spm */
	j = 0x1000;
	while(j != 0)	/* wait for a while */
		j--;
	sim_off();

	mem = (unsigned char *)IOMCTL; /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x20;			/* enable IO module interrupt */

	resp_ov_test = 0x00;
}



force_cmd_ov(iom_slot)
char 		iom_slot;
{
	unsigned int  *lptr, ldata;
	unsigned char *mem, addr;
	int size;

	mem = (unsigned char *)IOMCTL; /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x60;			/* enable IO module interrupt */
					/* force increment ready on receive */
	
	lptr = (unsigned int *)buff;
	size = 36;			/* 9 long word size */
 	ldata = (unsigned int)0;
	addr  = (unsigned char)CSSADD((unsigned)lptr);
	lptr = (unsigned int *)CSSMAP((unsigned)lptr);
	cssmap(MAP00,iom_slot,addr);
	for ( ; size > 0 ; ) {
		*lptr = ldata;
		lptr++;
		size -= 4;
	}
}

/*------------------------------------------------------------------------------
			force SPM to pretend to be slot
------------------------------------------------------------------------------*/
force_sp_slot(slot)
unsigned slot;
{
	*WRCNTL0 = (*WRCNTL0 & ~WR0_PRETEND_MASK) |
			   ((slot << WR0_PRETEND_SH) & 0x00ffffff);
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) | ((~slot << 20) & 0x00ffffff) |
		   	   ((slot << 16) & 0x00ffffff);
}

/* force to set source complement error */
force_src_err(slot,iom_slot)
char	 iom_slot;
unsigned slot;
{
	unsigned int  *lptr, ldata;
	unsigned char *mem, addr;


	/* force SPM to generate bad source slot */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_PRETEND_MASK) | ((slot << WR0_PRETEND_SH) & 0x00ffffff);
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) | ((slot << 20) & 0x00ffffff) | ((slot << 16) & 0x00ffffff);

 	ldata = (unsigned int)0;
	lptr = (unsigned int *)buff;
	addr  = (unsigned char)CSSADD((unsigned)lptr);
	lptr = (unsigned int *)CSSMAP((unsigned)lptr);
	cssmap(MAP00,iom_slot,addr);
	*lptr = ldata;

	/* recover SPM slot */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_PRETEND_MASK) | ((slot << WR0_PRETEND_SH) & 0x00ffffff);
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) | ((~slot << 20) & 0x00ffffff) | ((slot << 16) & 0x00ffffff);

	mem = (unsigned char *)IOMCTL; /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x20;			/* enable IO module interrupt */
}

/* force to set data parity error by setting even parity on selected byte */
force_data_err(iom_slot,byte)
char iom_slot,byte;
{
	unsigned int  *lptr, ldata;
	unsigned char *mem, addr;

	if (byte == 0)
		*WRCNTL1 = *WRCNTL1 & 0xfffffffe;
	if (byte == 1)
		*WRCNTL1 = *WRCNTL1 & 0xfffffffd;
	if (byte == 2)
		*WRCNTL1 = *WRCNTL1 & 0xfffffffb;
	if (byte == 3)
		*WRCNTL1 = *WRCNTL1 & 0xfffffff7;
	if (byte == 4)
		*WRCNTL1 = *WRCNTL1 & 0xffffffef;
	if (byte == 5)
		*WRCNTL1 = *WRCNTL1 & 0xffffffdf;
	if (byte == 6)
		*WRCNTL1 = *WRCNTL1 & 0xffffffbf;
	if (byte == 7)
		*WRCNTL1 = *WRCNTL1 & 0xffffff7f;

	lptr = (unsigned int *)buff;
 	ldata = (unsigned int)0;
	addr  = (unsigned char)CSSADD((unsigned)lptr);
	lptr = (unsigned int *)CSSMAP((unsigned)lptr);
	cssmap(MAP00,iom_slot,addr);
	*lptr = ldata;

	*WRCNTL1 = *WRCNTL1 | 0x000000ff;	/* recover data error */

	mem = (unsigned char *)IOMCTL; /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x20;			/* enable IO module interrupt */

}


/*====================================================================*/
/*
	CSS IO module ioslot error test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module ioslot error interrupt back
   	to service module and check interrupt data.
	iom_iosloat_tset() -- Command syntax :
						IOS <iom_slot#> 
*/

/******************************/
iom_ioslot_test(comm_str,arg_cnt)
	char *comm_str;
	int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);	 /* get iom slot # */
	err_result = 0;
	result = iom_ioslot_tst(iom_slot); /* call iom ioslot test routine */
	iomdiserr(iom_slot,result);
}

/*------------------------------------------------------------------------------
			IO module ioslot error capture/report/clear function test
------------------------------------------------------------------------------*/
iom_ioslot_tst(iom_slot)
char 		iom_slot;
{
	unsigned 		j;
	register unsigned 	*ip;
	unsigned char		*mem, addr;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;

	iom_rst(iom_slot);					/* reset iom/ioa */
	iom_err_rst(iom_slot);	

	mem = (unsigned char *)LNKCTL;		/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0xe1;		/* set IOM link config. to inhibit link RMSEQ error */
	sp_int_set();	/* set service module to receive int itself */
	iom_int_tbl_init(iom_slot,0); 	
				/* initial IO module interrupt vector table */
	ioslot_err = i_cnt = 0x00;

	/* Issue a command w/ ioslot error to generate IOM err interrupt.  */
	force_ioslot_err(iom_slot);	/* generate an ioslot error */

	for (j = 8000; j >0; j--) ;	/* s/w timer to wait */
	if (i_cnt == 0x00) {
		err_result = 1;			/* level 3 interrupt not happen */
		return;
	}
	else {						/* We got interrupt, Now acknowlege interrupt */
		i_cnt--;				/* decrease int count */
		sp_int_ack1(myslot);	/* int ack */

								/* Now check interrupt data sent by IO module */
		if(int_data & IOD_INT) {	/* IO device interrupt */
			err_result = 2;			/* We don't expect this type interrupt */
			return;
		}
		else {						/* Expected IO module interrupt */
			iom_err(iom_slot);
			if(!ioslot_err) {
				err_result = 3;
				return;
			}
		}
		iom_err_rst(iom_slot);		/* clear error */
		ioslot_err = 0x00;			/* reset ioslot error flag to zero */
		iom_err(iom_slot);
		if(ioslot_err)	{
			err_result = 4;
			return;
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
force_ioslot_err(iom_slot)
char iom_slot;
{
	unsigned char 	addr, *lptr,ldata;
	unsigned int	*llptr, dummy, i;

	addr  = (unsigned char)CSSADD((unsigned)IOMSLOT_REG);
	cssmap(MAP00,iom_slot,addr);
	lptr = (unsigned char *)CSSMAP((unsigned)IOMSLOT_REG);
	*lptr = 0x40; 			/* force sbus ioslot parity error */
	sim_on();				/* issue a fake read command */
	addr  = (unsigned char)CSSADD((unsigned)buff);
	cssmap(MAP07,iom_slot,addr);
	llptr = (unsigned int *)CSSMAP7((unsigned)buff);
	set_fake_rd(0x4,(unsigned)llptr);
	*llptr = (unsigned int)0;
	for (i = 8000; i > 0; i--) ;
	reset_fake();
	sim_off();
	addr  = (unsigned char)CSSADD((unsigned)IOMSLOT_REG);
	cssmap(MAP00,iom_slot,addr);
	lptr = (unsigned char *)CSSMAP((unsigned)IOMSLOT_REG);
	*lptr = 0x00; 		/* clear sbus ioslot parity error */
	addr  = (unsigned char)CSSADD((unsigned)IOMCTL);
	cssmap(MAP00,iom_slot,addr);
	lptr = (unsigned char *)CSSMAP((unsigned)IOMCTL);
	*lptr = 0x20; 		/* enable IO module interrupt */
}

/*------------------------------------------------------------------------------
	CSS IO module type error test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module type error interrupt back
   	to service module and check interrupt data.
	iom_type_test() -- Command syntax :
						TYP <iom_slot#> 
------------------------------------------------------------------------------*/
iom_type_test(comm_str,arg_cnt)
char 	*comm_str;
int 	arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);	 /* get iom slot # */
	err_result = 0;
	result = iom_type_tst(iom_slot); /* call iom type test routine */
	iomdiserr(iom_slot,result);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_type_tst(iom_slot)
char 		iom_slot;
{
	unsigned j;
	register unsigned *ip;
	unsigned char *mem, addr;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;
	iom_rst(iom_slot);				/* reset iom/ioa */
	iom_err_rst(iom_slot);	
	iom_int_tbl_init(iom_slot,0); 	
								/* initial IO module interrupt vector table */
	sp_int_set();			/* set service module to receive int itself */

	addr = (unsigned char)CSSADD((unsigned)LNKCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)LNKCTL);
/* FIXME */
	*mem = 0xe1;		/* set IOM link config. to inhibit link RMSEQ error */

	type_err = i_cnt = 0x00;	/* clear type error flag */
		/* Issue a command w/ sbus type error to gen IOM err interrupt */
	ul_inh(iom_slot);
	force_type_err(iom_slot);	/* generate an sbus type err */

	for (j = 1000; j > 0; j--);			/* s/w timer to wait */
										/* ul_inh_n(iom_slot); */
	if (i_cnt == 0x00) {
		err_result = 1;					/* level 3 interrupt not happen */
		return;
	}
	else	{				/* We got interrupt, Now acknowlege interrupt */
		i_cnt--;						/* decrease int count */
		sp_int_ack1(myslot);			/* int ack */
								/* Now check interrupt data sent by IO module */
		if (int_data & IOD_INT) {	/* IO device interrupt */
			err_result = 2;			/* We don't expect this type interrupt */
			return;
		}
		else {	    				/* Expected IO module interrupt */
			iom_err(iom_slot);
			if(!type_err) {
				err_result = 3;
				return;
			}
		}
		iom_err_rst(iom_slot);		/* clear error */
		type_err = 0x00;			/* reset type error flag to zero */
		iom_err(iom_slot);
		if(type_err) {
			err_result = 4;			/* cannot clear err */
			return;
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
force_type_err(iom_slot)
	char iom_slot;
{
	/*
	 * force to set type error by setting even parity on type field
	 */
	unsigned int  j, *lptr, ldata;
	unsigned char *mem, addr;

	*WRCNTL1 &= 0xffefffff;		/* set type field even par */

	/* issue a write command */
/*
	sim_on();
	addr  = (unsigned char)CSSADD((unsigned)buff);
	cssmap(MAP07,iom_slot,addr);
	lptr = (unsigned int *)CSSMAP7((unsigned)buff);
	set_fake_rd(0x4,(unsigned)lptr);
	*lptr = (unsigned int)0;
	for (j = 1000; j > 0; j--);
	reset_fake();
	sim_off();
*/
	addr  = (unsigned char)CSSADD((unsigned)buff);
	cssmap(MAP07,iom_slot,addr);
	lptr = (unsigned int *)CSSMAP7((unsigned)buff);
	*lptr = (unsigned int)0;

	for (j = 1000; j > 0; j--);
	*WRCNTL1 |= 0x00100000;		/* recover type parity */

	/* enable IO module int */
	addr  = (unsigned char)CSSADD((unsigned)IOMCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)IOMCTL);
	*mem = 0x20;			/* enable IO module interrupt */
}

/*------------------------------------------------------------------------------
	CSS IO module link type error test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module link type error interrupt back
   	to service module and check interrupt data.
	lk_type_test() -- Command syntax :
						DLT <iom_slot#> 
------------------------------------------------------------------------------*/
lk_type_test(comm_str,arg_cnt)
char 	*comm_str;
int 	arg_cnt;
{
	char iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);	 /* get iom slot # */
	err_result = 0;
	result = lk_type_tst(iom_slot);			/* call iom type test routine */
	iomdiserr(iom_slot,result);
}

/*------------------------------------------------------------------------------
	 IO module link type error capture/report/clear function test
------------------------------------------------------------------------------*/
lk_type_tst(iom_slot)
char iom_slot;
{
	unsigned 		j;
	register unsigned 	*ip;
	unsigned char		*mem, addr;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;

	iom_rst(iom_slot);		/* reset iom/ioa */
	iom_err_rst(iom_slot);	

	addr  = (unsigned char)CSSADD((unsigned)LNKCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)LNKCTL);
	*mem = 0xe1;	/* set IOM link config. to inhibit link RMSEQ error */
	iom_int_tbl_init(iom_slot,0); 	
				/* initial IO module interrupt vector table */
	sp_int_set();	/* set service module to receive int itself */
	lk_type_err = i_cnt = 0x00;
	ul_inh(iom_slot);
	force_lk_type_err(iom_slot,0);

	for (j = 1000; j >0; j--);		/* s/w timer to wait */
	ul_inh_n(iom_slot);
	if(i_cnt == 0x00) {
		err_result = 1;				/* level 3 interrupt not happen */
		return;
	}
	else	{					/* We got interrupt, Now acknowlege interrupt */
		i_cnt--;				/* Decrease int count */
		sp_int_ack1(myslot);	/* int ack */
								/* Now check interrupt data sent by IO module */
		if(int_data & IOD_INT) { 		/* IO device interrupt */
			err_result = 2;			/* We don't expect this type interrupt */
			return;
		}
		else {						/* Expected IO module interrupt */
			iom_err(iom_slot);
			if (!lk_type_err) {
				err_result = 3;
				return;
			}
		}
		iom_err_rst(iom_slot);			/* clear error */
		lk_type_err = 0x00;				/* reset ioslot error flag to zero */
		iom_err(iom_slot);
		if (lk_type_err) {
			err_result = 4;
			return;
		}
	}
}

/*------------------------------------------------------------------------------
	 force to set link type error in IOM link control register
------------------------------------------------------------------------------*/
force_lk_type_err(iom_slot,byte)
char iom_slot,byte;
{
	unsigned int  j, *lptr, ldata;
	unsigned char *mem, addr;

	addr  = (unsigned char)CSSADD((unsigned)LNKCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)LNKCTL);
	*mem |= 0x08;	/* force link type error */

	/*
	 * issue a write command
	 */
/*
	sim_on();
	addr  = (unsigned char)CSSADD((unsigned)buff);
	cssmap(MAP07,iom_slot,addr);
	lptr = (unsigned int *)CSSMAP7((unsigned)buff);
	set_fake_rd(0x4,(unsigned)lptr);
	*lptr = (unsigned int)0;
	reset_fake();
	sim_off();
*/

	addr  = (unsigned char)CSSADD((unsigned)buff);
	cssmap(MAP07,iom_slot,addr);
	lptr = (unsigned int *)CSSMAP7((unsigned)buff);
	*lptr = (unsigned int)0;
	for (j = 1000; j > 0; j--) ;

	addr  = (unsigned char)CSSADD((unsigned)LNKCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)LNKCTL);
	*mem &= 0xf7;	/* clear link type error */

	/*
	 * enable IO module int
	 */
	addr  = (unsigned char)CSSADD((unsigned)IOMCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)IOMCTL);
	*mem = 0x20;			/* enable IO module interrupt */
}

/*------------------------------------------------------------------------------
	CSS IO module down link parity error test
	It tests IO module error capture/report/clear function by causing 
	IO module generate IO module down link parity error interrupt back
   	to service module and check interrupt data.
	iom_dl_parity() -- Command syntax :
						DLE <iom_slot#> 
------------------------------------------------------------------------------*/
iom_dl_parity(comm_str,arg_cnt)
char 	*comm_str;
int 	arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = dl_parity_err(iom_slot,myslot);/* force iom dl parity error */
	if (result == 0x00)
	{
		iom_rst(iom_slot);
		printf("Test OK\n");
	}
	else
	{
		if (result == 1)
			printf("No IOM int\n");
		if (result == 2)
			printf("Error int type\n"); 
		if (result == 3)
			printf("No parity error\n");
		if (result & 0x10)
		{
			printf("Data parity error: ");
			if (!(result & 0x01))
				printf("byte 0   ");
			if (!(result & 0x02))
				printf("byte 1   ");
			if (!(result & 0x04))
				printf("byte 2   ");
			if (!(result & 0x08))
				printf("byte 3   ");
			printf("\n");
		}
		if (result == 5)
			printf("Can't clear parity error\n");
	}
	iom_tst_flag = 0x00;
	io_int_test = 0x00;
}

/******************************/
dl_parity_err(iom_slot)
char iom_slot;
{
	/*
	 * IOM down link parity error capture/report/clear function test
	 */
	unsigned 		j;
	register unsigned 	*ip;
	unsigned char		*mem, addr, bdata1;

	iom_tst_flag = 0xff;
	io_int_test = 0xff;

	iom_rst(iom_slot);
	iom_err_rst(iom_slot);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0xe1;	/* set IOM link config. to inhibit link RMSEQ error */

	iom_int_tbl_init(iom_slot,0);
			/* initial IO module interrupt vector table */

	parity_err = 0x00;	/* reset parity error flag to zero */
	sp_int_set();	/* set service module to receive int itself */

	/*
	 * force IO module down link data parity error to generate 
	 * IO module error interrupt.
	 */
	force_parity_err(iom_slot);

	j = 10;
	while(j != 0)	/* wait for a while */
		j--;

	if (i_cnt == 0x00) {  /* if level 3 int happened ? */
		return(1);
	}
	else	{
	/*
	We got interrupt from IO module, Now acknowlege interrupt
	*/
		
		i_cnt--;
		sp_int_ack1(myslot);
		/*
		Now check interrupt data sent by IO module 
		*/
		if (int_data & IOD_INT) /* IO device interrupt */
			/* We don't expect this type interrupt */
			return(2);
		else	{   /* Expected IO module interrupt */
			iom_err(iom_slot);	/* check for correct error */
			if (!parity_err)
				return(3);
		}
	}

	/*
	 * whether all data bytes error
	 */
	mem = (unsigned char *)IOM_LK_ERR2;	
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	bdata1 = *mem & 0x0f;	/* get data err bytes */
	if (bdata1 != 0x0f)
		return( 0x10 | bdata1 );

	iom_err_rst(iom_slot);	/* clear error */
	parity_err = 0x00;	/* reset parity error flag to zero */
	iom_err(iom_slot);	/* check if error is cleared */
	if (parity_err)
		return(5);
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
force_parity_err(iom_slot)
char 		iom_slot;
{
	unsigned int	*lptr, ldata;
	unsigned char	*mem, addr;
	
	mem = (unsigned char *)IOMCTL; /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x3f;	/* force down link parity error on all bytes */

	/*
	 * issue a write command
	 */
	lptr = (unsigned int *)buff;
 	ldata = (unsigned int)0;
	addr  = (unsigned char)CSSADD((unsigned)lptr);
	lptr = (unsigned int *)CSSMAP7((unsigned)lptr);
	cssmap(MAP00,iom_slot,addr);
	*lptr = ldata;

	mem = (unsigned char *)IOMCTL; /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x20;			/* enable IO module interrupt */
}

/*===================================================================
 * DL & UL command/response buffer pointer/counter test
 *=================================================================*/

/*
	CSS IO module DL command buffer counter test
	dl_cmd_cnt_test() -- Command syntax :
						CNT1 <iom_slot#>
*/

/********************************/
dl_cmd_cnt_test(comm_str,arg_cnt)
	char 	*comm_str;
	int	arg_cnt;
{
	char		i, j, iom_slot;
	unsigned char	tvalue;
	int		err = 0;
	unsigned	wdata, addr;
	unsigned  	hdata;

	iom_slot = (unsigned char)atox(comm_args[1]);
	i_cnt = 0;
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot,0);

	/*
	 * DL cmd buffer cnt reset test
	 */
	iom_rst(iom_slot);
	hdata = dl_state_rd(iom_slot);			/* rd DL_STATE reg */
	if (tvalue = (unsigned char)(hdata>>28) & 0x0f) {
		printf("Error: DL cmd buf count rst error: Expected = 0x00; Actual = 0x%2x\n",
		tvalue);
		err = 1;
	}
	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err int */
	ul_ctl_wr(iom_slot, 0x20);	/* inh UL read */
	dl_ctl_wr(iom_slot, 0x20);	/* inh DL read */

	for (i = 1; err == 0 && i <= 8; i++) {
		addr  = (unsigned char)CSSADD((unsigned)buff);
		cssmap(MAP00,iom_slot,addr);
		addr = (unsigned int)CSSMAP((unsigned)buff);
		*((unsigned int *)addr) = 0;					/* wrt */
		for (j = 1000; j > 0; j--);						/* timer */
		hdata = dl_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(hdata>>28) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: DL cmd buf count inc error; Expected=0x%2x; Actual=0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}
	for (i = 7; err == 0 && i >= 0; i--) {
		dl_rd_once(iom_slot);
		for (j = 1000; j > 0; j--);			/* timer */
		hdata = dl_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(hdata>>28) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: DL cmd buf count dec error; Expected=0x%2x; Actual=0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}
	iom_rst(iom_slot);
	io_int_test = 0x00;
	if (!err)
		printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
	CSS IO module UL command buffer counter test
	ul_cmd_cnt_test() -- Command syntax :
						CNT2 <iom_slot#>
------------------------------------------------------------------------------*/
ul_cmd_cnt_test(comm_str,arg_cnt)
char 	*comm_str;
int	arg_cnt;
{
	char		i, j, iom_slot;
	unsigned char	tvalue;
	int		err = 0;
	unsigned	wdata, addr;
	unsigned  	hdata;

	iom_slot = (unsigned char)atox(comm_args[1]);
	i_cnt = 0;
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot, 0);

	/* * UL cmd buffer cnt reset test */
	iom_rst(iom_slot);
	hdata = ul_state_rd(iom_slot);	/* rd UL_STATE reg */
	if (tvalue = (unsigned char)(hdata>>28) & 0x0f) {
		printf("Error: UL cmd buf count rst error; Expected = 0x00; Actual = 0x%2x\n",
		tvalue);
		err = 1;
	}
	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa * int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err * int */
	ul_ctl_wr(iom_slot, 0x20);	/* inh UL read */

	for (i = 1; err == 0 && i <= 8; i++) {
		addr  = (unsigned char)CSSADD((unsigned)buff);
		cssmap(MAP07,iom_slot,addr);
		addr = (unsigned int)CSSMAP7((unsigned)buff);
		*((unsigned int *)addr) = i;	/* wrt */
		for (j = 1000; j > 0; j--);
		hdata = ul_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(hdata>>28) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: UL cmd buf count inc error; Expected = 0x%2x; Actual = 0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}
	for (i = 7; err == 0 && i >= 0; i--) {
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 8000; j > 0; j--);
		sim_off();
		hdata = ul_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(hdata>>28) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: UL cmd buf count dec error; Expected = 0x%2x; Actual = 0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}

	iom_rst(iom_slot);
	io_int_test = 0x00;
	if (!err)
		printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
	CSS IO module DL response buffer counter test
	dl_resp_cnt_test() -- Command syntax :
						CNT3 <iom_slot#>
------------------------------------------------------------------------------*/
dl_resp_cnt_test(comm_str,arg_cnt)
	char 	*comm_str;
	int	arg_cnt;
{
	char		i, j, iom_slot;
	unsigned char	tvalue;
	int		err = 0;
	unsigned	wdata, addr;
	unsigned  	hdata;

	iom_slot = (unsigned char)atox(comm_args[1]);
	i_cnt = 0;
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot, 0);

	/*
	 * DL resp buffer cnt reset test
	 */
	iom_rst(iom_slot);
	hdata = dl_state_rd(iom_slot);	/* rd DL_STATE reg */
	if (tvalue = (unsigned char)(hdata>>24) & 0x0f) {
		printf("Error: DL resp buf count rst error; Expected = 0x00; Actual = 0x%2x\n",
		tvalue);
		err = 1;
	}
	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa * int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err * int */
	ul_ctl_wr(iom_slot, 0x20);	/* inh UL read */

	for (i = 1; err == 0 && i <= 8; i++) {
		addr  = (unsigned char)CSSADD((unsigned)buff);
		cssmap(MAP07,iom_slot,addr);
		addr = (unsigned int)CSSMAP7((unsigned)buff);
		set_fake_rd(0x04, (unsigned)addr);
		*(unsigned int *)addr = i;
		for (j = 1000; j > 0; j--)	/* timer */
			;
		reset_fake();
	}
	dl_ctl_wr(iom_slot, 0x20);	/* inh DL read */
	for (i = 1; err == 0 && i <= 8; i++) {
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 8000; j > 0; j--);
		sim_off();
		hdata = dl_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(hdata>>24) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: DL resp buf count inc error; Expected = 0x%2x; Actual = 0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}
	for (i = 7; err == 0 && i >= 0; i--) {
		dl_rd_once(iom_slot);
		for (j = 1000; j > 0; j--);		/* timer */
		hdata = dl_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(hdata>>24) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: DL resp buf count dec error; Expected = 0x%2x; Actual = 0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}

	iom_rst(iom_slot);
	io_int_test = 0x00;
	if (!err)
		printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
	CSS IO module UL resp buffer counter test
	ul_resp_cnt_test() -- Command syntax :
						CNT4 <iom_slot#>
------------------------------------------------------------------------------*/
ul_resp_cnt_test(comm_str,arg_cnt)
char *comm_str;
int	arg_cnt;
{
	char		i, j, iom_slot;
	unsigned char	tvalue;
	int		err = 0;
	unsigned wdata, addr;

	iom_slot = (unsigned char)atox(comm_args[1]);
	i_cnt = 0;
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot, 0);

	iom_rst(iom_slot);			/* DL resp buffer cnt reset test */
	wdata = ul_state_rd(iom_slot);	/* rd UL_STATE reg */
	if (tvalue = (unsigned char)(wdata>>24) & 0x0f) {
		printf("Error: UL resp buf count rst error; Expected = 0x00; Actual = 0x%2x\n",
		tvalue);
		err = 1;
	}
	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa * int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err * int */
	ul_ctl_wr(iom_slot, 0x20);	/* inh UL read */

	for (i = 1; err == 0 && i <= 8; i++) {
		addr  = (unsigned char)CSSADD((unsigned)buff);
		cssmap(MAP07,iom_slot,addr);
		addr = (unsigned int)CSSMAP7((unsigned)buff);
		set_fake_rd(0x04, (unsigned)addr);
		*(unsigned int *)addr = i;
		for (j = 8000; j > 0; j--);			/* timer */
		reset_fake();
	}

	dl_ctl_wr(iom_slot, 0x20);	/* inh DL read */
	for (i = 1; err == 0 && i <= 8; i++) {
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 8000; j > 0; j--);			/* timer */
		sim_off();
	}
	for (i = 1; err == 0 && i <= 8; i++) {
		dl_rd_once(iom_slot);
		for (j = 8000; j > 0; j--);				/* timer */
		wdata = ul_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(wdata>>24) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: UL resp buf count inc error; Expected = 0x%2x; Actual = 0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}
	for (i = 7; err == 0 && i >= 0; i--) {
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 8000; j > 0; j--);					/* timer */
		sim_off();
		wdata = ul_state_rd(iom_slot);
		if ((tvalue = (unsigned char)(wdata>>24) & 0x0f) != i)	/* cmd cnt */
		{
			printf("Error: UL resp buf count dec err; Expected = 0x%2x; Actual = 0x%2x\n",
			i, tvalue);
			err = 1;
		}
	}

	iom_rst(iom_slot);
	io_int_test = 0x00;
	if (!err)
		printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
	CSS IO module DL command buffer pointer test
	dl_cmd_ptr_test() -- Command syntax :
						PTR1 <iom_slot#>
------------------------------------------------------------------------------*/
dl_cmd_ptr_test(comm_str,arg_cnt)
char *comm_str;
int	arg_cnt;
{
	char		i, j, iom_slot;
	unsigned char	tvalue;
	int		err = 0;
	unsigned wdata, addr;

	iom_slot = (unsigned char)atox(comm_args[1]);

	/* * DL cmd buffer ptr reset test */
	i_cnt = 0;
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot, 0);

	iom_rst(iom_slot);
	dl_ctl_wr(iom_slot, 0xf2);		/* select cmd wrt ptr */
	wdata = dl_state_rd(iom_slot);
	if (tvalue = (unsigned char)(wdata>>16) & 0x0f)
	{
		printf("Error: DL cmd buffer write ptr rst error; Expected value = 0x00; Actual value = 0x%2x\n", tvalue);
		err = 1;
	}
	dl_ctl_wr(iom_slot, 0xf3);		/* select cmd rd ptr */
	wdata = dl_state_rd(iom_slot);
	if (tvalue = (unsigned char)(wdata>>16) & 0x0f)
	{
		printf("Error: DL cmd buffer read ptr rst error; Expected = 0x00; Actual = 0x%2x\n", tvalue);
		err = 1;
	}

	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa * int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err * int */
	ul_ctl_wr(iom_slot, 0x20);	/* read inh */

	for (i = 1; err == 0 && i <= 17; i++) {
		dl_ctl_wr(iom_slot, 0xe2);	/* cmd buf wrt ptr; inh */
		addr = CSSADD((unsigned)buff);
		cssmap(MAP07,iom_slot,(unsigned char)addr);
		addr = (unsigned int)CSSMAP7((unsigned)buff);
		*(unsigned int *)addr = i;	/* wrt */
		for (j = 1000; j > 0; j--)	/* timer */
			;
		tvalue = (unsigned char)(dl_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x0f) != i%16)
		{
			printf("Error: DL cmd buf write ptr inc error; Expected value = 0x%2x; Actual value = 0x%2x\n", i, tvalue);
			err = 1;
		}
		dl_ctl_wr(iom_slot, 0xe3);	/* cmd rd ptr */
		dl_rd_once(iom_slot);
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 1000; j > 0; j--);		/* timer */
		sim_off();
		tvalue = (unsigned char)(dl_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x0f) != i%16)
		{
			printf("Error: DL cmd buf read ptr inc error; Expected value = 0x%2x; Actual value = 0x%2x\n", i, tvalue);
			err = 1;
		}
	}

	iom_rst(iom_slot);
	io_int_test = 0x00;
	if (!err)
		printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
	CSS IO module UL command buffer pointer test
	ul_cmd_ptr_test() -- Command syntax :
						PTR2 <iom_slot#>
------------------------------------------------------------------------------*/
ul_cmd_ptr_test(comm_str,arg_cnt)
char 	*comm_str;
int	arg_cnt;
{
	char i, j, iom_slot;
	unsigned char	tvalue;
	int	err = 0;
	unsigned wdata, addr;

	iom_slot = (unsigned char)atox(comm_args[1]);

	/* UL cmd buffer ptr reset test */
	i_cnt = 0;
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot, 0);

	iom_rst(iom_slot);
	ul_ctl_wr(iom_slot, 0xf2);		/* select cmd wrt ptr */
	wdata = ul_state_rd(iom_slot);
	if (tvalue = (unsigned char)(wdata>>16) & 0x0f) {
		printf("Error: UL cmd buffer write ptr rst error; Expected value = 0x00; Actual value = 0x%2x\n", tvalue);
		err = 1;
	}
	ul_ctl_wr(iom_slot, 0xf3);		/* select cmd rd ptr */
	wdata = ul_state_rd(iom_slot);
	if (tvalue = (unsigned char)(wdata>>16) & 0x0f) {
		printf("Error: UL cmd buffer read ptr rst error; Expected value = 0x00; Actual value = 0x%2x\n", tvalue);
		err = 1;
	}

	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa * int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err * int */

	for (i = 1; err == 0 && i <= 17; i++) {
		ul_ctl_wr(iom_slot, 0xe2);	/* read inh */
		addr = CSSADD((unsigned)buff);
		cssmap(MAP07,iom_slot,(unsigned char)addr);
		addr = (unsigned int)CSSMAP7((unsigned)buff);
		*(unsigned int *)addr = i;	/* wrt */
		for (j = 1000; j > 0; j--);
		tvalue = (unsigned char)(ul_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x0f) != i%16) {
			printf("Error: UL cmd buf write ptr inc error; Expected value = 0x%2x; Actual value = 0x%2x\n", i, tvalue);
			err = 1;
		}
		ul_ctl_wr(iom_slot, 0xe3);	/* cmd rd ptr */
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 1000; j > 0; j--);
		sim_off();
		tvalue = (unsigned char)(ul_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x0f) != i%16)
		{
			printf("Error: UL cmd buf read ptr inc error; Expected value = 0x%2x; Actual value = 0x%2x\n", i, tvalue);
			err = 1;
		}
	}

	iom_rst(iom_slot);
	io_int_test = 0x00;
	if (!err) printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
	CSS IO module DL response buffer pointer test
	dl_resp_ptr_test() -- Command syntax :
						PTR3 <iom_slot#>
------------------------------------------------------------------------------*/
dl_resp_ptr_test(comm_str,arg_cnt)
char *comm_str;
int	arg_cnt;
{
	char		i, j, iom_slot;
	unsigned char	tvalue;
	int		err = 0;
	unsigned wdata, addr;

	iom_slot = (unsigned char)atox(comm_args[1]);

	i_cnt = 0;					/* DL resp buffer ptr reset test */
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot, 0);

	iom_rst(iom_slot);
	dl_ctl_wr(iom_slot, 0xf0);		/* select resp wrt ptr */
	wdata = dl_state_rd(iom_slot);
	if (tvalue = (unsigned char)(wdata>>16) & 0x0f) {
		printf("Error: DL resp buffer write ptr rst error; Expected value = 0x00; Actual value = 0x%2x\n", tvalue);
		err = 1;
	}
	dl_ctl_wr(iom_slot, 0xf1);		/* select resp rd ptr */
	wdata = dl_state_rd(iom_slot);
	if(tvalue = (unsigned char)(wdata>>16) & 0x0f) {
		printf("Error: DL resp buffer read ptr rst error; Expected value = 0x00; Actual value = 0x%2x\n", tvalue);
		err = 1;
	}

	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa * int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err * int */
	dl_ctl_wr(iom_slot, 0x00);
	ul_ctl_wr(iom_slot, 0x20);	/* read inh */

	for (i = 1; err == 0 && i <= 8; i++) {
		addr = (unsigned char)CSSADD((unsigned)buff);
		cssmap(MAP07,iom_slot,(unsigned char)addr);
		addr = (unsigned int)CSSMAP7((unsigned)buff);
		set_fake_rd(0x04, (unsigned)addr);
		*(unsigned int *)addr = i;
		for (j = 1000; j > 0; j--);		/* timer */
		reset_fake();
	}
	dl_ctl_wr(iom_slot, 0x20);	/* resp buf wrt ptr; inh */
	for (i = 1; err == 0 && i <= 8; i++) {
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 8000; j > 0; j--);
		sim_off();
		dl_ctl_wr(iom_slot, 0xe0);
		tvalue = (unsigned char)(dl_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x07) != i%8) {
			printf("Error: DL resp buf write ptr inc err; Expected value = 0x%2x; Actual value = 0x%2x\n", i, tvalue);
			err = 1;
		}
		dl_ctl_wr(iom_slot, 0x20);
	}
	for (i = 1; err == 0 && i <= 8; i++) {
		sim_on();
		dl_rd_once(iom_slot);
		for (j = 1000; j > 0; j--);
		sim_off();
		dl_ctl_wr(iom_slot, 0xe1);
		tvalue = (unsigned char)(dl_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x07) != i%8) {
			printf("Error: DL resp buf read ptr inc error; Expected value = 0x%2x; Actual value = 0x%2x\n", i, tvalue);
			err = 1;
		}
		dl_ctl_wr(iom_slot, 0x21);
	}

	iom_rst(iom_slot);
	io_int_test = 0x00;
	if (!err)
		printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
	CSS IO module UL response buffer pointer test
	ul_resp_ptr_test() -- Command syntax :
						PTR4 <iom_slot#>
------------------------------------------------------------------------------*/
ul_resp_ptr_test(comm_str,arg_cnt)
char *comm_str;
int	arg_cnt;
{
	char		i, j, iom_slot;
	unsigned char	tvalue;
	int		err = 0;
	unsigned	wdata, addr;

	iom_slot = (unsigned char)atox(comm_args[1]);

	/* UL resp buffer ptr reset test */
	i_cnt = 0;
	io_int_test = 0xff;
	sp_int_set();
	iom_int_tbl_init(iom_slot, 0);

	iom_rst(iom_slot);
	ul_ctl_wr(iom_slot, 0xf0);		/* select resp wrt ptr */
	wdata = ul_state_rd(iom_slot);
	if (tvalue = (unsigned char)(wdata>>16) & 0x0f)
	{
		printf("Error: UL resp buffer write ptr rst error; Expected value = 0x00; Actual value = 0x%2x\n", tvalue);
		err = 1;
	}
	ul_ctl_wr(iom_slot, 0xf1);		/* select resp rd ptr */
	wdata = ul_state_rd(iom_slot);
	if (tvalue = (unsigned char)(wdata>>16) & 0x0f)
	{
		printf("Error: UL resp buffer read ptr rst error; Expected value = 0x00; Actual value = 0x%2x\n", tvalue);
		err = 1;
	}

	lk_ctl_wr(iom_slot, 0xe1);	/* loopback, inh ioa, inh ioa * int */
	iom_ctl_wr(iom_slot, 0x40);	/* force sbus rdy,disable err * int */
	dl_ctl_wr(iom_slot, 0x00);
	ul_ctl_wr(iom_slot, 0x20);	/* read inh */

	for (i = 1; err == 0 && i <= 8; i++) {
		addr = (unsigned char)CSSADD((unsigned)buff);
		cssmap(MAP07,iom_slot,(unsigned char)addr);
		addr = (unsigned int)CSSMAP7((unsigned)buff);
		set_fake_rd(0x04, (unsigned)addr);
		*(unsigned int *)addr = i;
		for (j = 1000; j > 0; j--)	/* timer */
			;
		reset_fake();
	}
	dl_ctl_wr(iom_slot, 0x20);	/* resp buf wrt ptr; inh */
	for (i = 1; err == 0 && i <= 8; i++) {
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 8000; j > 0; j--) ;
		sim_off();
	}
	for (i = 1; err == 0 && i <= 8; i++) {
		sim_on();
		dl_rd_once(iom_slot);
		for(j = 8000; j > 0; j--);
		sim_off();
		ul_ctl_wr(iom_slot, 0xe0);
		tvalue = (unsigned char)(ul_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x07) != i%8) {
			printf("Error: UL resp buf write ptr inc error; Expected = 0x%2x; Actual=0x%2x\n", i, tvalue);
			err = 1;
		}
		ul_ctl_wr(iom_slot, 0x20);
	}
	for (i = 1; err == 0 && i <= 8; i++) {
		sim_on();
		ul_rd_once(iom_slot);
		for (j = 1000; j > 0; j--);
		sim_off();
		ul_ctl_wr(iom_slot, 0xe1);
		tvalue = (unsigned char)(ul_state_rd(iom_slot) >> 16);
		if ((tvalue &= 0x07) != i%8)
		{
			printf("Error: UL resp buf read ptr inc error; Expected value = 0x%2x; Actual value = 0x%2x\n", i, tvalue);
			err = 1;
		}
		ul_ctl_wr(iom_slot, 0x21);
	}
	iom_rst(iom_slot);
	io_int_test = 0x00;
	if(!err) printf("Test OK\n");
	return(err);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_ctl_wr(iom_slot, byte)
char iom_slot;
unsigned char 	byte;
{
	unsigned char	addr;
	unsigned char	*mem;

	addr = (unsigned char)CSSADD((unsigned)IOMCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)IOMCTL);
	*mem = (unsigned char)byte;
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
lk_ctl_wr(iom_slot, byte)
char iom_slot;
unsigned char byte;
{
	unsigned char	addr;
	unsigned char	*mem;

	addr = (unsigned char)CSSADD((unsigned)LNKCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)LNKCTL);
	*mem = (unsigned char)byte;
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
ul_ctl_wr(iom_slot, byte)
char iom_slot;
unsigned char byte;
{
	unsigned char	addr;
	unsigned char	*mem;

	addr = (unsigned char)CSSADD((unsigned)ULCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)ULCTL);
	*mem = (unsigned char)byte;
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
dl_ctl_wr(iom_slot, byte)
char iom_slot;
unsigned char byte;
{
	unsigned char	addr;
	unsigned char	*mem;

	addr = (unsigned char)CSSADD((unsigned)DLCTL);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned char *)CSSMAP((unsigned)DLCTL);
	*mem = (unsigned char)byte;
}

/*------------------------------------------------------------------------------
			return DL_STATE reg info
------------------------------------------------------------------------------*/
dl_state_rd(iom_slot)
char iom_slot;
{
	unsigned char	addr;
	unsigned int	*mem;

	addr = (unsigned char)CSSADD((unsigned)DL_STATE);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned int *)CSSMAP((unsigned)DL_STATE);
	return(*mem);
}

/*------------------------------------------------------------------------------
			return UL_STATE reg info
------------------------------------------------------------------------------*/
ul_state_rd(iom_slot)
char iom_slot;
{
	unsigned char	addr;
	unsigned int	*mem;

	addr = (unsigned char)CSSADD((unsigned)UL_STATE);
	cssmap(MAP00,iom_slot,addr);
	mem = (unsigned int *)CSSMAP((unsigned)UL_STATE);
	return(*mem);
}
/*----------------------------------------------------------------------------*/

