/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomall.c: version 25.1 created on 11/27/91 at 14:38:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomall.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm.h"
#include "misc.h"
#include "types.h"
#include "menu.h"
#include "global.h"
#include "ring.h"
#include "iom.h"
#include "bus.h"
#include "disp.h"

#define BUFPOINT 0x103e000

extern unsigned char *buff;
extern char	all_flag;
extern char	iom_addr_flag;
extern unsigned char	t_4_rd;
extern unsigned char bdhere[];			/* slots for CSS board's... */

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_pwr_test()
{
	char 		iom_slot;
	short		i;
	
	printf("\nI/O Module Power-Up Test\n");
	for(i = 0; i < MAX_CSS_SLOT; i++)	/* find IO module */
	{
		if(bdhere[i] == IOMHERE)
		{
			iom_slot = (char)i;
			if(iom1test(iom_slot))
				printf("IOM power-up failed.\n");
			else 
				printf("IOM power-up passed.\n");
		}
	}
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom1test(iom_slot)
char iom_slot;
{
	short i;

	all_flag = 0xff;
	if(int_tbl_test(iom_slot))	{
		printf("Interrupt w/r test failed.\n");
		return(-1);
	}
	if(iom_reg_test(iom_slot))	{
		printf("IOM reg w/r test failed.\n");
		return(-1);
	}
	if(iom_i_tst(iom_slot))	{
		printf("IOM device interrupt test failed.\n");
		return(-1);
	}
	if(iom_cnt_tst(iom_slot))	{
		printf("IOM interrupt counter test failed.\n");
		return(-1);
	}
	init_css();
	iom_rst(iom_slot); 
	sim_on();						/* set SP module memory simulate on */
	if(iom_loop_test(iom_slot))	{
		sim_off();					/* set SP module memory simulate off */
		printf("IOM loop test failed.\n");
		return(-1);
	}
	sim_off();						/* set SP module memory simulate off */
	all_flag = 0x00;
	init_css();
	iom_rst(iom_slot);
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
all_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char iom_slot,result,loop;

	iom_slot = (unsigned char)atox(comm_args[1]);
	init_css();
	all_flag = 0xff;
	loop = checkloop();
	while(!ifesc())	{
		if(int_tbl_test(iom_slot))	{
			printf("Interrupt w/r test failed.\n");
			break;
		}
		if(ifesc()) break;
		if(iom_reg_test(iom_slot)) {
			printf("IOM reg w/r test failed.\n");
			break;
		}
		if(ifesc()) break;
		if(iom_i_tst(iom_slot)) {
			printf("IOM device interrupt test failed.\n");
			break;
		}
		if(ifesc()) break;
		if(iom_cnt_tst(iom_slot)) {
			printf("IOM device interrupt counter test failed.\n");
			break;
		}
		if(ifesc()) break;
		init_css();
		iom_rst(iom_slot); 
		sim_on();		/* set SPM memory simulate on */
		result=iom_loop_test(iom_slot);
		sim_off();		/* set SPM memory simulate off */
		if(result == 0x1b) { result=0; break; }
		if(result)	{
			printf("Test failed\n");
			break;
		}
		if(ifesc()) break;
		if(!loop) break;
	}
	all_flag = 0x00;
	if(!result) printf("Test OK\n");
	iom_rst(iom_slot);
}

iom_loop_test(iom_slot)
char iom_slot;
{
	register int size;
	register char *mem;
	register unsigned char addr ;
	char result;

	mem = (char *)LNKCTL;		/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0xe1;			/* set IO module loop back config. */

	mem = (char *)buff;
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	size = (int)0x80;

	if(iom_loop_write(mem,size,0x01)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_write(mem,size,0x02)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_write(mem,size,0x04)) return(1);
	if(ifesc()) return(0x1b);
	iom_addr_flag = 0xff;
	if(ifesc()) return(0x1b);
	result = iom_addr_test(iom_slot);
	iom_addr_flag = 0x00;
	if(result) return(1);
	iom_addr_flag = 0xff;
	result = iom_datal_test(iom_slot);
	iom_addr_flag = 0x00;
	if(result) return(1);
	if(iom_loop_read(mem,size,0x01)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_read(mem,size,0x02)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_read(mem,size,0x04)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_read(mem,size,0x08)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_read(mem,size,0x10)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_read(mem,size,0x20)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_8w(iom_slot,(unsigned int *)mem)) return(1);
	if(ifesc()) return(0x1b);
	if(iom_loop_16w(iom_slot,(unsigned int *)mem)) return(1);
	if(ifesc()) return(0x1b);
	result = iom_loop_4r(iom_slot,(unsigned int *)mem);
	t_4_rd = 0x0;
	sim_off();						/* set SP memory simulate off */
	if(result) return(1);
	return(0);
}


