/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iom.c: version 25.1 created on 11/27/91 at 14:38:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iom.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "spm.h"
#include "misc.h"
#include "types.h"
#include "menu.h"
#include "global.h"
#include "ring.h"
#include "localmenu.h"
#include "loc_rout.h"
#include "iom.h"
#include "ioa0.h"
#include "bus.h"


/*	CSS IO module debug command routines	*/



extern unsigned char MemSimFlag;
extern unsigned char pwr_test;
extern char all_flag;
int errstore;
char err_slot;
char lk_data_err;

	
	struct init_menu iom_debugger [] = {
	"ioi0", "slot",
	"IOM interrupt vector table w/r loop", 'c', 1, 1, iom_int_wr, (char *)0,
	
	"ioi1", "slot",
	"IOM interrupt test loop", 'c', 1, 1, iom_int_test, (char *)0,
	
	"ioi2", "slot",
	"IOM interrupt counter test loop", 'c', 1, 1, int_cnt_test, (char *)0,
	
	"iov0", "slot",
	"IOM resp overflow test ", 'c', 1, 1, iom_ov_test0, (char *)0,
	
	"iov1", "slot",
	"IOM cmd overflow test ", 'c', 1, 1, iom_ov_test1, (char *)0,
	
	"dlt", "slot",
	"IOM down link type err test", 'c', 1, 1, lk_type_test, (char *)0,
	
	"ios", "slot",
	"IOM ioslot error test ", 'c', 1, 1, iom_ioslot_test, (char *)0,
	
	"datae","slot",
	"IOM data error test ", 'c', 1, 1, iom_data_test, (char *)0,
	
	"dle",  "slot",
	"IOM down link parity test ", 'c', 1, 1, iom_dl_parity, (char *)0,
	
	"bto",  "slot",
	"IOM bus grant time out test ", 'c', 1, 1, bus_time_out, (char *)0,
	
	"rto",  "slot",
	"IOM response time out test ", 'c', 1, 1, resp_t_out, (char *)0,
	
	"mis",  "slot",
	"IOM response source mis-match test",'c',1,1,resp_mis_match,(char *)0,
	
	"src",  "slot",
	"IOM source slot error test ", 'c', 1, 1, iom_src_err, (char *)0,
	
	"iomw<.[bwl]>", "slot",
	"loop write IO module test", 'c', 1, 1, iom_w, (char *)0,
	
	"iomr<.[bwldst]>", "slot",
	"loop read IOM test", 'c', 1, 1, iom_r, (char *)0,
	
	"iom8w","slot",
	"IOM 8 write cmd loop test", 'c', 1, 1, iom_8w, (char *)0,
	
	"iom16w","slot",
	"IOM 18 write cmd loop test", 'c', 1, 1, iom_16w, (char *)0,
	
	"iom4r","slot",
	"IOM 4 read cmd loop test", 'c', 1, 1, iom_4r, (char *)0,
	
	"iome", "slot",
	"Check IOM error registers", 'c', 1, 1, iomerr, (char *)0,
	
	"add", "slot",
	"IOM address lines test", 'c', 1, 1, iom_addr, (char *)0,
	
	"data", "slot",
	"IOM data lines test", 'c', 1, 1, iom_data, (char *)0,
	
	"cnt1", "slot",
	"IOM DL cmd buf cnt test", 'c', 1, 1, dl_cmd_cnt_test, (char *)0,
	
	"cnt2", "slot",
	"IOM UL cmd buf cnt test", 'c', 1, 1, ul_cmd_cnt_test, (char *)0,
	
	"cnt3", "slot",
	"IOM DL resp buf cnt test", 'c', 1, 1, dl_resp_cnt_test, (char *)0,
	
	"cnt4", "slot",
	"IOM UL resp buf cnt test", 'c', 1, 1, ul_resp_cnt_test, (char *)0,
	
	"ptr1", "slot",
	"IOM DL cmd buf ptr test", 'c', 1, 1, dl_cmd_ptr_test, (char *)0,
	
	"ptr2", "slot",
	"IOM UL cmd buf ptr test", 'c', 1, 1, ul_cmd_ptr_test, (char *)0,
	
	"ptr3", "slot",
	"IOM DL resp buf ptr test", 'c', 1, 1, dl_resp_ptr_test, (char *)0,
	
	"ptr4", "slot",
	"IOM UL resp buf ptr test", 'c', 1, 1, ul_resp_ptr_test, (char *)0,
	
	"iomf", "slot",
	"IOM flow control test", 'c', 1, 1, iom_f, (char *)0,
	
	"sim", "",
	"Display memory simulation information", 'c', 0, 0, simmsg, (char *)0,
	
	"iomg", "slot",
	"IOM registers w/r test", 'c', 1, 1, iom_reg_wr, (char *)0,
	
	"all", "slot",
	"IOM all test ", 'c', 1, 1, all_test, (char *)0,
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
};

iom_reg_wr(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = iom_reg_test(iom_slot);	/* call iom register test */
	if (result)
		printf("Test failed\n");
	else	{
		printf("Test OK\n");
	}
}


iom_reg_test(iom_slot)
char	iom_slot;
{
	register unsigned char	tdata, rdata;
	register unsigned char	*test_addr;
	unsigned char		addr,i;


	if(!pwr_test)
	printf ("IOM reg test\n");
	for (i=0;i<0x1;i++)	{
	/* Write/read/verify to IO module registers */
 		tdata = i;
		test_addr = (unsigned char *)CSSMAP(IOMCTL);
		addr  = (unsigned char)CSSADD(IOMCTL);
		addr = addr & 0x0f;
		cssmap(MAP00,iom_slot,addr);
		tdata = tdata & 0xe0; 
		*test_addr = tdata; 
		rdata = *test_addr ; 
		if (rdata != tdata) {
			printf ("Error: CTL reg 0x%08x -- ",test_addr);
			return(0xff);
		} 
		test_addr = (unsigned char *)CSSMAP(DLCTL);
		*test_addr = tdata;
		rdata = *test_addr ; 
		if (rdata != tdata) {
			printf ("Error: DL reg 0x%08x - ",test_addr);
			return(0xff);
		}
		test_addr = (unsigned char *)CSSMAP(ULCTL);
		*test_addr = tdata;
		rdata = *test_addr ; 
		if (rdata != tdata) {
			printf ("Error: UL reg 0x%08x - ",test_addr);
			return(0xff);
		}
		test_addr = (unsigned char *)CSSMAP(LNKCTL);
		tdata = tdata & 0xc0;
		*test_addr = tdata;
		rdata = *test_addr ; 
		if (rdata != tdata) {
			printf ("Error: Link CTL reg %08x - ",test_addr);
			return(0xff);
		}
	}
	test_addr = (unsigned char *)CSSMAP(IOMCTL);
	*test_addr = 00;
	test_addr = (unsigned char *)CSSMAP(ULCTL);
	*test_addr = 00;
	test_addr = (unsigned char *)CSSMAP(DLCTL);
	*test_addr = 00;
	test_addr = (unsigned char *)CSSMAP(LNKCTL);
	*test_addr = 00;
	iom_rst(iom_slot);
	return(0);
}


cssmap(mapnum,slotnum,slotadd)
register unsigned mapnum;
register unsigned char slotnum,slotadd;
{
	register unsigned char* i;
 
	i=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*i = (slotnum << 4) | slotadd;
}


reset_fake()
{
	/* *WRCNTL1 &= ~WR1_FRC_RST_RCV; */
	*WRCNTL1 |= WR1_DATYPE; /* reset accept any type mode */
	*WRCNTL1 |= WR1_UFTYPE; /* reset use force type mode */
}


set_fake_wr(byte,addr)
unsigned char byte;
unsigned addr;
{
	*WRCNTL1 |= WR1_FRC_RST_RCV;
	*WRCNTL1 &= ~WR1_DATYPE; /* accept any type */
	*WRCNTL1 &= ~WR1_UFTYPE; /* use force type */
	switch (byte)	{
	   case 1:		/* One byte write */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (WR_1BYTE & 0x00ffffff);
		break;
	   case 2:		/* Two byte write */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (WR_2BYTE & 0x00ffffff);
		break;
	   case 3:		/* Three byte write */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (WR_3BYTE & 0x00ffffff);
		break;
	   case 4:		/* Four byte write */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (WR_4BYTE & 0x00ffffff);
		break;
	}
	*WRCNTL0 = (*WRCNTL0 & ~WR0_FADD01_MASK) | ((addr << WR0_FADD01_SH) & 
		    WR0_FADD01_MASK);
}


set_fake_rd(byte,addr)
unsigned char byte;
unsigned addr;
{
	*WRCNTL1 |= WR1_FRC_RST_RCV;
	*WRCNTL1 &= ~WR1_DATYPE; /* accept any type */
	*WRCNTL1 &= ~WR1_UFTYPE; /* use force type */
	switch (byte)	{
	   case 1:		/* One byte read */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (RD_1BYTE & 0x00ffffff);
		break;
	   case 2:		/* Two byte read */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (RD_2BYTE & 0x00ffffff);
		break;
	   case 3:		/* Three byte write */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (RD_3BYTE & 0x00ffffff);
		break;
	   case 4:		/* Four byte read */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (RD_4BYTE & 0x00ffffff);
		break;
	   case 8:		/* Eight byte read */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (RD_8BYTE & 0x00ffffff);
		break;
	   case 16:		/* Sixteen byte read */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (RD_16BYTE & 0x00ffffff);
		break;
	   case 32:		/* Thirty two byte read */
		*WRCNTL0 = (*WRCNTL0 & 0xffffffc0) | (RD_32BYTE & 0x00ffffff);
		break;
	}
	*WRCNTL0 = (*WRCNTL0 & ~WR0_FADD01_MASK) | ((addr << WR0_FADD01_SH) & 
		    WR0_FADD01_MASK);
}


/* simmsg():	Print last memory simulation information		*/

simmsg()
{
	register unsigned type,bytes;
	register unsigned char dest,src;
	char	bdata;
	short	wdata;
	unsigned	data;

	/* get destination */
	dest = (errstore & DEST_MASK)>>DEST_SH;
	printf("Dest slot: %02x  ", dest);
	src = (errstore & SRC_MASK)>>SRC_SH;
	printf("Src slot: %02x \n", src);
	type = (errstore & TYPE_MASK) >> TYPE_SH;
	bytes = (errstore & SIZE_MASK) >> SIZE_SH;
	switch (type)	{
		case BUSRD:
			if (bytes == BYT1)	{	/* read one byte */
				printf("1 byte read at %8x ", sim_addr);
			}
			else if (bytes == BYT2) {	/* read two bytes */
				printf("2 bytes read at %8x ", sim_addr);
			}
			else if (bytes == BYT3)	{ /* read 3 bytes */
				printf("3 bytes read at %8x ", sim_addr);
			}
			else if (bytes == BYT4) {	/* read 4 bytes */
				printf("4 bytes read at %8x ", sim_addr);
			}
			else if (bytes == EIGHT)	{ /* read 8 bytes */
				printf("8 bytes read at %8x ", sim_addr);
			}
			else if (bytes == SIXTEEN)	{ /* read 16 bytes */
				printf("16 bytes read at %8x ", sim_addr);
			}
			else if (bytes == THIRTY_TWO)	{ /* read 32 bytes */
				printf("32 bytes read at %8x ", sim_addr);
			}
			else 
				printf("Invalid byte size\n");
			break;
		case BUSWR:
			if (bytes == BYT1)	{
				bdata = (char)sim_data;
				printf("1 byte write at %8x ", sim_addr);
				printf("Data = %2x \n",bdata);
			}
			else if (bytes == BYT2)	{
				wdata = (short)sim_data;
				printf("2 bytes written at %8x ", sim_addr);
				printf("data = %4x \n",wdata);
			}	
			else if (bytes == BYT3)	{
				printf("3 bytes written at %8x ", sim_addr);
				printf("data = %8x \n",sim_data);
			}
			else if (bytes == BYT4)	{
				printf("4 bytes written at %8x ", sim_addr);
				printf("data = %8x \n",sim_data);
			}
			else 
				printf("Invalid byte size\n");
			break;
		case BUSRESP:
			printf("Resp\n");
			break;
	}
}

sim_on()
{
	MemSimFlag = TRUE;
	*WRCNTL1 &= ~WR1_DIAG_ANY_TYPE;
	*WRCNTL1 &= ~WR1_CSSRD_MASK;
	*WRCNTL1 |= WR1_RD32;
	/* turn off interrupt dispatcher in memory simulation mode */
	*WRCNTL1 &= ~WR1_DREQ;
}

sim_off()
{
	MemSimFlag = FALSE;
	*WRCNTL1 |= WR1_DIAG_ANY_TYPE;
	*WRCNTL1 &= ~WR1_CSSRD_MASK;
	*WRCNTL1 |= WR1_4BYTE_RD;
	/* turn on interrupt dispatcher after memory simulation mode */
	*WRCNTL1 &= ~WR1_FRC_RST_ACK;
	*WRCNTL1 |= WR1_FRC_RST_ACK;
	*WRCNTL1 |= WR1_DREQ;
}


iom_rst(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;
	cmem = (unsigned char *)IOMRST; /* IOM reset register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0;		/* reset IOM */
}

dl_rd_once(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;

	cmem = (unsigned char *)DLONCE;	 /* down link read once register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x00;			/* IOM down link read once */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
ul_rd_once(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr;
	unsigned int *cmem;

	cmem = (unsigned int *)ULONCE;	 /* up link read once register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned int *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x00;			/* IOM up link read once */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
ul_inh(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;

	cmem = (unsigned char *)ULCTL;	 /* up link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x20;			/* set IOM up link buff read inhibit */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
ul_inh_n(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;

	cmem = (unsigned char *)ULCTL;	 /* up link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x0;			/* reset IOM up link buf read inhibit */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
dl_inh(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;

	cmem = (unsigned char *)DLCTL;	 /* down link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x20;		/* set IOM down link buf read inhibit */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
dl_inh_n(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;

	cmem = (unsigned char *)DLCTL;	 /* down link control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x0;	/* reset IOM down link buf read inhibit */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
inc_on_rcv(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;

	cmem = (unsigned char *)IOMCTL;	 /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x40;		/* increment ready on receive */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
inc_on_rcv_n(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;

	cmem = (unsigned char *)IOMCTL;	 /* IOM control register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0x0;		/* reset increment ready on receive */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_err_rst(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;
	cmem = (unsigned char *)IOM_ER_RST; /* IOM error reset register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP((unsigned)cmem);
	cssmap(MAP00,iom_slot,addr);
	*cmem = 0;		/* reset IOM error */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iom_path_rst(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;
		cmem = (unsigned char *)PATHRST; /* IOM path reset register */
		addr  = (unsigned char)CSSADD((unsigned)cmem);
		cmem = (unsigned char *)CSSMAP((unsigned)cmem);
		cssmap(MAP00,iom_slot,addr);
		*cmem = 0;		/* reset IOM path config. */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
iominit(iom_slot)
unsigned char iom_slot;
{
	unsigned char addr,*cmem;
	unsigned           *wmem;

	cmem = (unsigned char *)IOM_ER_RST;	 /* IOM error reset register */
	addr  = (unsigned char)CSSADD((unsigned)cmem);
	cmem = (unsigned char *)CSSMAP7((unsigned)cmem);
	cssmap(MAP07,iom_slot,addr);
	*cmem = 0;			/* reset IOM error */

	cmem = (unsigned char *)LNKCTL;	 /* IOM link control register */
	cmem = (unsigned char *)CSSMAP7((unsigned)cmem);
	*cmem = 0x11;			/* IOA interrupt request enable */
							/* normal LED on */

	cmem = (unsigned char *)IOMCTL;	 /* IOM control register */
	cmem = (unsigned char *)CSSMAP7((unsigned)cmem);
	*cmem = 0x20;			/* IOM interrupt enable */

	wmem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	wmem = (unsigned *)CSSMAP7((unsigned)wmem);
		/* IOA interrupt enable */
/*	*wmem = DTB_EN ; /* */
	*wmem = IOA_INT_EN | DTB_EN ; /* */
}

