/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ioa2.c: version 25.1 created on 11/27/91 at 14:38:16	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ioa2.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "spm.h"
#include "types.h"
#include "global.h"
#include "ring.h"
#include "iom.h"
#include "ioa0.h"




dtb_fifo_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		mem_slot,iom_slot,result;
	unsigned 	raddr,waddr,count;
	unsigned char	woo,woo_f;
	unsigned char	addr,*mem;

	iom_slot = (unsigned char)atox(comm_args[1]);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x11;			/* set IO module link config. */

	if((mem_slot = findmem(1)) == 0x18)
		return(1);
	init_css();
	printf("IOA DTB channels FIFO test\n");
	count = 0;
	woo = checkloop();
	if (woo)
		printesc();
	woo_f = 0xff;		/* loop test flag */
	while (woo_f)	{
		woo_f = woo;
		result = dtb_fifo(mem_slot,iom_slot);
		if (result)	{
			printf("Test failed\n");
			return;
		}
		printf("\rLoop cnt: %8x \r",count);
		count++;
	  	if (ifesc())
			break;
	}
	printf("\nTest OK\n");
}


dtb_fifo(mslot,iom_slot)
char		iom_slot,mslot;
{
unsigned	 *m0,*m1,*m2,*m3;
unsigned	 *dcw00,*dcw01,*dcw10,*dcw11;
unsigned	 *dcw20,*dcw21,*dcw30,*dcw31;
unsigned 	 *cmd,tseed;
char		 addr;
int		 i;

	tseed = 0x00000001;

	cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);
	*cmd = DTB_EN | DTB_TEST;

	cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);

	dcw00 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH0 << ID_SH));
	dcw01 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH0 << ID_SH));
	dcw10 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH1 << ID_SH));
	dcw11 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH1 << ID_SH));
	dcw20 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH2 << ID_SH));
	dcw21 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH2 << ID_SH));
	dcw30 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH3 << ID_SH));
	dcw31 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH3 << ID_SH));

	m0 = (unsigned *)0;
	addr  = (unsigned char)CSSADD((unsigned)m0);
	m0 = (unsigned *)CSSMAP((unsigned)m0);
	cssmap(MAP00,mslot,addr);

	for(i=0; i<0x200; i++)
		*m0++ = (unsigned)tseed++;

	*dcw00 = ~DMA_W & ((mslot<<MEM_SH) | (CH1<<IO_SH) | 0x100);

	/* wait for DTB ack */
	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x Read to ch: %2x\n",CH0,CH1);
		printf("Setup word 0 \n");
		return(2);
	}

	*dcw01 = (unsigned)0;

	/* wait for DTB ack */
	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x Read to ch: %2x\n",CH0,CH1);
		printf("Setup word 1\n");
		return(2);
	}

	if(ck_act(iom_slot,CH0))
		return(1);

	*dcw20 = ~DMA_W & ((mslot<<MEM_SH) | (CH3<<IO_SH) | 0x100);

	/* wait for DTB ack */
	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x Read to ch: %2x\n",CH2,CH3);
		printf("Setup word 0 \n");
		return(2);
	}

	*dcw21 = (unsigned)0x4000;

	/* wait for DTB ack */
	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x Read to ch: %2x\n",CH2,CH3);
		printf("Setup word 1\n");
		return(2);
	}

	if(ck_act(iom_slot,CH2))
		return(1);

	*dcw10 = DMA_W | (mslot << MEM_SH) | (0xf << IO_SH) | 0x100;

	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x write \n",CH1);
		printf("Setup word 0\n");
		return(2);
	}

	*dcw11 = 0x400000;

	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x write \n",CH1);
		printf("Setup word 1\n");
		return(2);
	}

	if(ck_act(iom_slot,CH1))
		return(1);

	*dcw30 = DMA_W | (mslot << MEM_SH) | (0xf << IO_SH) | 0x100;

	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x write \n",CH3);
		printf("Setup word 0\n");
		return(2);
	}

	*dcw31 = 0x404000;
	if(dtb_cmd_ack(iom_slot)){
		printf("Ch: %2x write \n",CH3);
		printf("Setup word 1\n");
		return(2);
	}


	if(ck_act(iom_slot,CH3))
		return(1);

	tseed = 0x00000001;

	m1 = (unsigned *)0x400000;
	addr  = (unsigned char)CSSADD((unsigned)m1);
	m1 = (unsigned *)CSSMAP((unsigned)m1);
	cssmap(MAP00,mslot,addr);
	i = 0x1000;
	while (i)
		i--;

	for(i=0; i<0x200; i++)	{
		if(*m1 != (unsigned)tseed)	{
		  printf("Addr :%8x \n",m1);
		  printf("Got data :%8x Expected data :%8x\n",*m1,tseed);
		  return(3);
		}
		m1++;
		tseed++;
	}
	return(0);
}

