/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ioa1.c: version 25.1 created on 11/27/91 at 14:38:11	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ioa1.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "spm.h"
#include "types.h"
#include "global.h"
#include "ring.h"
#include "iom.h"
#include "ioa0.h"


dtb_addr_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		mem_slot,iom_slot,result;
	unsigned char	rch,wch;
	unsigned 	raddr,waddr,count;
	unsigned char	woo,woo_f;
	unsigned char	addr,*mem;

	iom_slot = (unsigned char)atox(comm_args[1]);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x11;			/* set IO module link config. */

	if((mem_slot = findmem(1)) == 0x18)
		return(1);
	init_css();
	printf("IOA DTB channels address ripple 1/0's test\n");
	count = 0;
	woo = checkloop();
	if (woo)
		printesc();
	woo_f = 0xff;		/* loop test flag */
	while (woo_f)	{
		woo_f = woo;
		rch = 0;
		for (wch = 1; wch < 4; wch++)	{
			result = dtb_addr(mem_slot,iom_slot,rch,wch);
			if (result)	{
				printf("Read  channel: %2x \n",rch);
				printf("Write channel: %2x \n",wch);
				printf("Test failed\n");
				return;
			}
		}
		printf("\rLoop cnt: %8x \r",count);
		count++;
	  	if (ifesc())
			break;
	}
	io_rst(iom_slot);
	printf("\nTest OK\n");
}


dtb_addr(mslot,iom_slot,rch,wch)
char		iom_slot,mslot;
unsigned char	rch,wch;
{
unsigned	 *m1,status,size;
unsigned	 *dcwr0,*dcwr1,*dcww0,*dcww1;
unsigned 	 *cmd,addr_seed;
char		 addr;

	m1 = (unsigned *)0xfffffffc;	/* memory module status register */
	addr  = (unsigned char)CSSADD((unsigned)m1);
	m1 = (unsigned *)CSSMAP((unsigned)m1);
	cssmap(MAP00,mslot,addr);

	status = *m1;
	status = (status & 0x00000300) >> 8;
	if ((status < 1) || (status > 3))	{
		printf("Unknown memory size");
		return;
	}
	
	switch (status)	{
		case 1:			/* 8M memory */
			size = 0x800000;
			break;
		case 2:			/* 16M memory */
			size = 0x1000000;
			break;
		case 3:			/* 32M memory */
			size = 0x2000000;
			break;
	}
	addr_seed = 0x00000004;

	for( ; addr_seed < size ; )	{
		m1 = (unsigned *)addr_seed;	/* test seed address */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);
		*m1 = (unsigned)0;		/* initialize memory */
		addr_seed = addr_seed << 1;
	}

	cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);
	*cmd = DTB_EN | DTB_TEST;

/* dma channel 0 read from system memory to dma channel 1 */
	cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);

	dcwr0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (rch << ID_SH));
	dcwr1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (rch << ID_SH));
	dcww0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (wch << ID_SH));
	dcww1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (wch << ID_SH));
	addr_seed = 0x00000004;

	for( ; addr_seed < size ; )	{

		m1 = (unsigned *)0;	/* address 0 for dma read */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		*m1 = (unsigned)addr_seed;

		*dcwr0 = ~DMA_W & ((mslot<<MEM_SH) | (wch<<IO_SH) | 2);

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 0 \n");
			return(2);
		}

		*dcwr1 = (unsigned)0;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,rch))
			return(1);

		/* dma channel 1 write to system memory */
		*dcww0 = DMA_W | (mslot << MEM_SH) | (0xf << IO_SH) | 2;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 0\n");
			return(2);
		}

		*dcww1 = addr_seed;
		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,wch))
			return(1);
		addr_seed = addr_seed << 1;
	}

	addr_seed = 0x00000004;

	for( ; addr_seed < size ; )	{
		m1 = (unsigned *)addr_seed;	/* test seed address */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		if(*m1 != ((unsigned)m1 & 0xfffffff))	{
			printf("\nAddress error\n");
			printf("Addr :%8x \n",m1);
			printf("Got data :%8x Expected data :%8x\n",*m1,m1);
			return(3);
		}

		addr_seed = addr_seed << 1;
	}

	/* ripple 0 */
	addr_seed = 0x00000008;

	for( ; addr_seed < size ; )	{
		m1 = (unsigned *)(~addr_seed & 0xfffffff8 & (size -1));
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);
		*m1 = (unsigned)0;		/* initialize memory */
		addr_seed = addr_seed << 1;
	}

	cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);
	*cmd = DTB_EN | DTB_TEST;

/* dma channel 0 read from system memory to dma channel 1 */
	cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);

	dcwr0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (rch << ID_SH));
	dcwr1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (rch << ID_SH));
	dcww0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (wch << ID_SH));
	dcww1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (wch << ID_SH));
	addr_seed = 0x00000008;

	for( ; addr_seed < size ; )	{

		m1 = (unsigned *)0;	/* address 0 for dma read */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		*m1 = (unsigned)addr_seed;

		*dcwr0 = ~DMA_W & ((mslot<<MEM_SH) | (wch<<IO_SH) | 2);

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 0 \n");
			return(2);
		}

		*dcwr1 = (unsigned)0;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,rch))
			return(1);

		/* dma channel 1 write to system memory */
		*dcww0 = DMA_W | (mslot << MEM_SH) | (0xf << IO_SH) | 2;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 0\n");
			return(2);
		}

		*dcww1 = ~addr_seed & 0xfffffff8 & (size -1);
		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,wch))
			return(1);
		addr_seed = addr_seed << 1;
	}

	addr_seed = 0x00000008;

	for( ; addr_seed < size ; )	{
		m1 = (unsigned *)(~addr_seed & 0xfffffff8 & (size -1));
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		if(*m1 != addr_seed)	{
			printf("\nAddress error\n");
			printf("Addr :%8x \n",m1);
			printf("Got data :%8x Expected data :%8x\n",*m1,addr_seed);
			return(3);
		}

		addr_seed = addr_seed << 1;
	}
	return(0);
}



dtb_data_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		mem_slot,iom_slot,result;
	unsigned char	rch,wch;
	unsigned 	raddr,waddr,count;
	unsigned char	woo,woo_f;
	unsigned char	addr,*mem;

	iom_slot = (unsigned char)atox(comm_args[1]);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x11;			/* set IO module link config. */

	if((mem_slot = findmem(1)) == 0x18)
		return(1);
	init_css();
	printf("IOA DTB channels data ripple 1/0's test\n");
	count = 0;
	woo = checkloop();
	if (woo)
		printesc();
	woo_f = 0xff;		/* loop test flag */
	while (woo_f)	{
		woo_f = woo;
		rch = 0;
		for (wch = 1; wch < 4; wch++)	{
			result = dtb_data(mem_slot,iom_slot,rch,wch);
			if (result)	{
				printf("Read  channel: %2x \n",rch);
				printf("Write channel: %2x \n",wch);
				printf("Test failed\n");
				return;
			}
		}
		printf("\rLoop cnt: %8x \r",count);
		count++;
	  	if (ifesc())
			break;
	}
	io_rst(iom_slot);
	printf("\nTest OK\n");
}


dtb_data(mslot,iom_slot,rch,wch)
char		iom_slot,mslot;
unsigned char	rch,wch;
{
unsigned	 *m1;
unsigned	 *dcwr0,*dcwr1,*dcww0,*dcww1;
unsigned 	 *cmd,tseed;
char		 addr;
int		 i;

	tseed = 0x00000001;

	cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);
	*cmd = DTB_EN | DTB_TEST;

/* dma channel 0 read from system memory to dma channel 1 */
	cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);

	dcwr0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (rch << ID_SH));
	dcwr1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (rch << ID_SH));
	dcww0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (wch << ID_SH));
	dcww1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (wch << ID_SH));

	for( i = 0; i < 32 ; i++ )	{

		m1 = (unsigned *)0;	/* address 0 for dma read */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		*m1 = (unsigned)tseed;

		*dcwr0 = ~DMA_W & ((mslot<<MEM_SH) | (wch<<IO_SH) | 2);

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 0 \n");
			return(2);
		}

		*dcwr1 = (unsigned)0;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,rch))
			return(1);

		/* dma channel 1 write to system memory */
		*dcww0 = DMA_W | (mslot << MEM_SH) | (0xf << IO_SH) | 2;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 0\n");
			return(2);
		}

		*dcww1 = 0x100;
		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,wch))
			return(1);


		m1 = (unsigned *)0x100;	/* address 0x100 for dma write */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		if(*m1 != ((unsigned)tseed))	{
			printf("\nData ripple 1 error\n");
			printf("Addr :%8x \n",m1);
			printf("Got data :%8x Expected data :%8x\n",*m1,tseed);
			return(3);
		}

		tseed = tseed << 1;
	}

	tseed = 0x00000001;

	for( i = 0; i < 32 ; i++ )	{

		m1 = (unsigned *)0;	/* address 0 for dma read */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		*m1 = (unsigned)~tseed;

		*dcwr0 = ~DMA_W & ((mslot<<MEM_SH) | (wch<<IO_SH) | 2);

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 0 \n");
			return(2);
		}

		*dcwr1 = (unsigned)0;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,rch))
			return(1);

		/* dma channel 1 write to system memory */
		*dcww0 = DMA_W | (mslot << MEM_SH) | (0xf << IO_SH) | 2;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 0\n");
			return(2);
		}

		*dcww1 = 0x100;
		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch: %2x write \n",wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,wch))
			return(1);


		m1 = (unsigned *)0x100;	/* address 0x100 for dma write */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		if(*m1 != ((unsigned)~tseed))	{
			printf("\nData ripple 0 error\n");
			printf("Addr :%8x \n",m1);
			printf("Got data :%8x Expected data :%8x\n",*m1,~tseed);
			return(3);
		}

		tseed = tseed << 1;
	}
	return(0);
}



dtb_cnt_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		mem_slot,iom_slot,result;
	unsigned char	rch,wch;
	unsigned 	raddr,waddr,count;
	unsigned char	woo,woo_f;
	unsigned char	addr,*mem;

	iom_slot = (unsigned char)atox(comm_args[1]);

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x11;			/* set IO module link config. */

	if((mem_slot = findmem(1)) == 0x18)
		return(1);
	init_css();
	printf("IOA DTB channels counter test\n");
	count = 0;
	woo = checkloop();
	if (woo)
		printesc();
	woo_f = 0xff;		/* loop test flag */
	while (woo_f)	{
		woo_f = woo;
		rch = 0;
		for (wch = 1; wch < 4; wch++)	{
			result = dtb_cnt(mem_slot,iom_slot,rch,wch);
			if (result)	{
				printf("Read  channel: %2x \n",rch);
				printf("Write channel: %2x \n",wch);
				printf("Test failed\n");
				return;
			}
		}
		printf("\rLoop cnt: %8x \r",count);
		count++;
	  	if (ifesc())
			break;
	}
	printf("\nTest OK\n");
}


dtb_cnt(mslot,iom_slot,rch,wch)
char		iom_slot,mslot;
unsigned char	rch,wch;
{
unsigned	 *m1,*m2;
unsigned	 *dcwr0,*dcwr1,*dcww0,*dcww1;
unsigned 	 *cmd,tseed;
char		 addr;
unsigned	 i,counter;

	cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);
	*cmd = DTB_EN | DTB_TEST;

/* dma channel 0 read from system memory to dma channel 1 */
	cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);

	dcwr0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (rch << ID_SH));
	dcwr1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (rch << ID_SH));
	dcww0 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (wch << ID_SH));
	dcww1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (wch << ID_SH));

	for( counter = 2; counter < 0x1000 ; counter++ )	{

		tseed = 0x00000001;

		m1 = (unsigned *)0;	/* address 0 for dma read */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		for (i = 0; i < counter; i++)	{
			*m1 = (unsigned)tseed;
			tseed += 1;
			m1++;
		}

		m2 = (unsigned *)0x40000;	/* 0x40000 for dma write */
		addr  = (unsigned char)CSSADD((unsigned)m2);
		m2 = (unsigned *)CSSMAP((unsigned)m2);
		cssmap(MAP00,mslot,addr);

		for (i = 0; i < counter; i++)	{
			*m2 = 0;
			tseed += 1;
			m2++;
		}

		*dcwr0 = ~DMA_W & ((mslot<<MEM_SH) | (wch<<IO_SH) | counter);

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Counter: %8x \n",counter);
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 0 \n");
			return(2);
		}

		*dcwr1 = (unsigned)0;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Counter: %8x \n",counter);
			printf("Ch: %2x Read to ch: %2x\n",rch,wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,rch))
			return(1);

		/* dma channel 1 write to system memory */
		*dcww0 = DMA_W | (mslot << MEM_SH) | (0xf << IO_SH) | counter;

		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Counter: %8x \n",counter);
			printf("Ch: %2x write \n",wch);
			printf("Setup word 0\n");
			return(2);
		}

		*dcww1 = 0x40000;
		/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Counter: %8x \n",counter);
			printf("Ch: %2x write \n",wch);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,wch))
			return(1);

		m1 = (unsigned *)0x40000;  /* address 0x40000 for dma write */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mslot,addr);

		tseed = 0x00000001;
		for (i = 0; i < counter; i++)	{
			if(*m1 != ((unsigned)tseed))	{
			   printf("Error counter: %8x \n",counter);
			   printf("Addr :%8x \n",m1);
			   printf("Got data:%8x Expected data:%8x\n",*m1,tseed);
	  		   if (ifesc())
			   	return(3);
			}
			tseed += 1;
			m1++;
		}
	  	if (ifesc())
			break;
	}
	return(0);
}


printesc()
{
	printf("Press <ESC> to stop loop\n");
}
