/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ioa0.c: version 25.1 created on 11/27/91 at 14:38:06	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ioa0.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm.h"
#include "misc.h"
#include "types.h"
#include "menu.h"
#include "global.h"
#include "ring.h"
#include "localmenu.h"
#include "loc_rout.h"
#include "routines.h"
#include "iom.h"
#include "ioa0.h"
#include "bus.h"


extern char emulate;			/* Interrupt handling stuff. */
extern unsigned char pwr_test;		/* Interrupt handling stuff. */
extern unsigned char myslot;		/* Contains current SPM slot. */

	
	struct init_menu ioa_debugger [] = {
	"ioareg", "slot",
	"Test IOA command registers",'c',1,1,ioa_cmd_test,(char *)0,
	
	"icbd", "slot",
	"Test IOA ICB data bus",'c',1,1,icb_data_test,(char *)0,
	
	"icba", "slot",
	"Test IOA ICB addr bus",'c',1,1,icb_addr_test,(char *)0,
	
	"icbs", "slot",
	"Test IOA ICB data strobe",'c',1,1,icb_str_test,(char *)0,
	
	"ioai", "slot",
	"IOA interrupt test ", 'c', 1, 1, ioa_int_test, (char *)0,
	
	"dtba", "slot",
	"DTB address test ", 'c', 1, 1, dtb_addr_test, (char *)0,
	
	"dtbd", "slot",
	"DTB data    test ", 'c', 1, 1, dtb_data_test, (char *)0,
	
	"iorst", "slot",
	"Reset I/O system ", 'c', 1, 1, ioa_rst, (char *)0,
	
	"ioad", "slot mslot",
	"IOA 4 DMA channels test ", 'c', 2, 2, ioa_dma_test, (char *)0,
	
	"ioad2", "slot mslot rch wch raddr waddr size",
	"IOA DMA test ", 'c', 7, 7, ioa_dma_test2, (char *)0,
	
	"ioar", "slot",
	"IOA cmd reg read loop ", 'c', 1, 1, rd_cmd_loop, (char *)0,
	
	"icbl", "slot",
	"IOA icb w/r loop ", 'c', 1, 1, icb_wr_loop, (char *)0,
	
	"ts", "dr#",
	"Read tape status ", 'c', 1, 1,tape_status, (char *)0,
	
	"tb", "dr#",
	"Tape rewind ", 'c', 1, 1,tape_rewind, (char *)0,
	
	"trf", "dr#",
	"Tape read  EOF ", 'c', 1, 1,tape_rd_eof, (char *)0,
	
	"twf", "dr#",
	"Tape write EOF ", 'c', 1, 1,tape_wr_eof, (char *)0,
	
	"tr", "maddr dr# size",
	"Tape read ", 'c', 3, 3,tape_rd, (char *)0,
	
	"tw", "maddr dr# size",
	"Tape write ", 'c', 3, 3,tape_wr, (char *)0,
	
	"dr", "maddr dr# size blk",
	"Disk read ", 'c', 4, 4,disk_rd, (char *)0,
	
	"dw", "maddr dr# size blk",
	"Disk write ", 'c', 4, 4,disk_wr, (char *)0,
	
	"iop", "",
	"Poll I/O system slots ", 'c', 0, 0,poll_io, (char *)0,
	
	"iot", "",
	"Show I/O system config ", 'c', 0, 0,iotbl, (char *)0,
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
};

extern	unsigned int_data;
extern unsigned char i_cnt;
extern	unsigned char	io_int_test;


/* This test is used for hardware trouble shooting */
icb_wr_loop(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot;

	iom_slot = (unsigned char)atox(comm_args[1]);
	icb_loop(iom_slot);	/* call test */
	io_rst(iom_slot);
}

icb_loop(iom_slot)
char 		iom_slot;
{
	unsigned 	*cmd_mem, cmd_data;
	char 		*loop_mem, loop_data;
	unsigned char 	addr,woo;

	printesc();

	cmd_mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd_mem);
	cmd_mem = (unsigned *)CSSMAP7((unsigned)cmd_mem);
	cssmap(MAP07,iom_slot,addr);

	woo = 0xff;
	emulate = 0xff;
	while (woo)	{
	  cmd_data = (0x00000006 << IOA_INT_TEST_SH);
	  *cmd_mem = cmd_data;
	  cmd_data = (0x0000001e << IOA_INT_TEST_SH);
	  *cmd_mem = cmd_data;	/* To assert ICB.DTACK* */

	  loop_mem = (char *)S_LOOP_ADDR;
	  addr  = (unsigned char)CSSADD((unsigned)loop_mem);
	  loop_mem = (char *)CSSMAP((unsigned)loop_mem);
	  cssmap(MAP00,iom_slot,addr);
	  *loop_mem = 0;	/* Write test seed to loop test address */

	  cmd_data = *cmd_mem & 0xecff0000;
	  *cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to special diag mode */

	  loop_data = *loop_mem;  /* Read test seed from loop test address */
	  iom_rst(iom_slot);
	  if (ifesc())
		woo = 0;
	  printf("\r.\r");
	}
	return(0);
}
	
rd_cmd_loop(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	rd_cmd_reg(iom_slot);	/* call test */
	io_rst(iom_slot);
}

rd_cmd_reg(iom_slot)
char iom_slot;
{
	unsigned 	*mem,cmd_data;
	unsigned char 	addr;
	char		woo;


	woo = 0;
	while (!woo)	{
		emulate = 0xff;
		mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
		addr  = (unsigned char)CSSADD((unsigned)mem);
		mem = (unsigned *)CSSMAP((unsigned)mem);
		cssmap(MAP00,iom_slot,addr);
		cmd_data = *mem;	/* read IOA command register */
		iom_rst(iom_slot);
		if (ifesc())
			woo = 0xff;
		printf("\r.\r");
	}
}



ioa_cmd_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = ioa_cmd_reg(iom_slot);	/* call test */
	if (result == 0x00)	{
		printf("Test OK\n");
		io_rst(iom_slot);
	}
	else
		printf("Test failed\n");
}

ioa_cmd_reg(iom_slot)
char iom_slot;
{
	unsigned 	*mem, cmd_data, seed, tdata;
	unsigned char 	addr;
	int		i;

	iom_rst(iom_slot);

	if (ck_5v(iom_slot))	{	/* check for IOA 5V is OK */
		printf("No IOA 5V\n");
		return(1);
	}
	mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	cmd_data = *mem;	/* read IOA command register */
	if (cmd_data & MOD_TYPE)	{	/* check for correct type */
		printf("IOA module type error\n");
		printf("IOA cmd reg: %8x\n", cmd_data);
		return(2);
	}
	seed = 0x00010000;	/* lower two bytes are not tested */
	for (i=0; i< 16; i++)	{
		/* bits 12, 9 and 8 are not tested */
		if ((i != 12) && (i != 8) && (i != 9))	{
			*mem = seed;
			cmd_data = *mem & 0xecff0000;
			if(seed != cmd_data)	{
				printf("IOA cmd reg w/r failed\n");
				printf("Seed:%8x Cmd reg:%8x\n",seed,cmd_data);
				return(3);
			}
		}
		seed = seed << 1;
	}
	seed = 0x00010000;	/* lower two bytes are not tested */
	for (i=0; i< 16; i++)	{
		/* bits 12, 9 and 8 are not tested */
		if ((i != 12) && (i != 8) && (i != 9))	{
			tdata = ~seed & 0x6cff0000;
			*mem = tdata;
			cmd_data = *mem & 0x6cff0000;
			if((tdata) != cmd_data)	{
				printf("IOA cmd reg w/r failed\n");
			    printf("Tdata:%8x Cmd reg:%8x\n",tdata,cmd_data);
				return(3);
			}
		}
		seed = seed << 1;
	}
	return(0);
}


icb_data_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = data_test(iom_slot);	/* call test */
	if (result == 0x00)	{
		printf("Test OK\n");
		iom_rst(iom_slot);
		io_rst(iom_slot);
	}
	else
		printf("Test failed\n");
}

data_test(iom_slot)
char 		iom_slot;
{
	unsigned 	*cmd_mem, cmd_data;
	char 		*loop_mem, loop_data, seed;
	unsigned char 	addr;
	int		i;

	if(!pwr_test)

	if (ck_5v(iom_slot))	{	/* check for IOA 5V is OK */
		printf("No IOA 5V\n");
		return(1);
	}
	cmd_mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd_mem);
	cmd_mem = (unsigned *)CSSMAP7((unsigned)cmd_mem);
	cssmap(MAP07,iom_slot,addr);

	seed = 0x00000001;

	/* ICB data bus ripple 1 and 0 test */
	for (i=0; i<32; i++)	{
	  /* ripple 1 */
	  cmd_data = (0x00000006 << IOA_INT_TEST_SH);
	  *cmd_mem = cmd_data;
	  cmd_data = (0x0000001e << IOA_INT_TEST_SH);
	  *cmd_mem = cmd_data;	/* To assert ICB.DTACK* */

	  loop_mem = (char *)S_LOOP_ADDR;
	  addr  = (unsigned char)CSSADD((unsigned)loop_mem);
	  loop_mem = (char *)CSSMAP((unsigned)loop_mem);
	  cssmap(MAP00,iom_slot,addr);
	  *loop_mem = seed;	/* Write test seed to loop test address */

	  cmd_data = *cmd_mem & 0xecff0000;
	  *cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to special diag mode */

	  loop_data = *loop_mem;  /* Read test seed from loop test address */
	  if(ck_cmd_bit(iom_slot,ICB_RD))	{
		printf("No ICB read\n");
		return(1);
	  }

	  if (loop_data != seed)	{
		  printf("Read data:%8x Seed:%8x\n",loop_data,seed);
		  return(1);
	  }

	  /* ripple 0 */
	  cmd_data = (0x00000006 << IOA_INT_TEST_SH);
	  *cmd_mem = cmd_data;
	  cmd_data = (0x0000001e << IOA_INT_TEST_SH);
	  *cmd_mem = cmd_data;	/* To assert ICB.DTACK* */

	  loop_mem = (char *)S_LOOP_ADDR;
	  addr  = (unsigned char)CSSADD((unsigned)loop_mem);
	  loop_mem = (char *)CSSMAP((unsigned)loop_mem);
	  cssmap(MAP00,iom_slot,addr);
	  *loop_mem = ~seed;	/* Write test seed to loop test address */

	  cmd_data = *cmd_mem & 0xecff0000;
	  *cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to special diag mode */

	  loop_data = *loop_mem;  /* Read test seed from loop test address */

	  if (loop_data != ~seed)	{
		  printf("Read data:%8x Seed:%8x\n",loop_data,~seed);
		  return(1);
	  }
	  seed = seed << 1;
	}
	return(0);
}
	

icb_str_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = data_str_test(iom_slot);	/* call test */
	if (result == 0x00)	{
		printf("Test OK\n");
		iom_rst(iom_slot);
		io_rst(iom_slot);
	}
	else
		printf("Test failed\n");
}


data_str_test(iom_slot)
char 		iom_slot;
{
	unsigned 	*cmd_mem, cmd_data;
	char 		*bmem, bdata;
	short 		*wmem, wdata;
	unsigned 	*lmem, ldata, seed;
	unsigned char 	addr;
	int		i;


	if (ck_5v(iom_slot))	{	/* check for IOA 5V is OK */
		printf("No IOA 5V\n");
		return(1);
	}
	cmd_mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd_mem);
	cmd_mem = (unsigned *)CSSMAP7((unsigned)cmd_mem);
	cssmap(MAP07,iom_slot,addr);

	/* byte operation */
	for (i=0; i<2; i++)	{
		cmd_data = (0x00000006 << IOA_INT_TEST_SH);
		*cmd_mem = cmd_data;
		cmd_data = (0x0000001e << IOA_INT_TEST_SH);
		*cmd_mem = cmd_data;	/* To assert ICB.DTACK* */

		if(i==0)
			bmem = (char *)S_LOOP_ADDR;
		else
			bmem = (char *)S_LOOP_ADDR+1;
		addr  = (unsigned char)CSSADD((unsigned)bmem);
		bmem = (char *)CSSMAP((unsigned)bmem);
		cssmap(MAP00,iom_slot,addr);
		*bmem = (char)seed;	/* Write seed to loop test address */

		cmd_data = *cmd_mem & 0xecff0000;
		*cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to diag mode */

		bdata = *bmem;  /* Read test seed from loop test address */

	  	if(i == 0)	{
	  		if(!(ck_cmd_bit(iom_slot,ICB_UDS)))	{
				printf("ICB UDS* inactive error\n");
				return(1);
	  		}
	  		if(ck_cmd_bit(iom_slot,ICB_LDS))	{
				printf("ICB LDS* active error\n");
				return(1);
	  		}
	  	}
	  	else 	{
	  		if(ck_cmd_bit(iom_slot,ICB_UDS))	{
				printf("ICB UDS* active error\n");
				return(1);
	  		}
	  		if(!(ck_cmd_bit(iom_slot,ICB_LDS)))	{
				printf("ICB LDS* inactive error\n");
				return(1);
	  		}
		}
		if (bdata != (char)seed)	{
			printf("byte ");
		  	printf("Read data:%2x Seed:%2x\n",bdata,(char)seed);
		  	return(1);
		}
	}

	/* long word operation */
	cmd_data = (0x00000006 << IOA_INT_TEST_SH);
	*cmd_mem = cmd_data;
	cmd_data = (0x0000001e << IOA_INT_TEST_SH);
	*cmd_mem = cmd_data;	/* To assert ICB.DTACK* */

	lmem = (unsigned *)S_LOOP_ADDR;
	addr  = (unsigned char)CSSADD((unsigned)lmem);
	lmem = (unsigned *)CSSMAP((unsigned)lmem);
	cssmap(MAP00,iom_slot,addr);
	*lmem = seed;	/* Write seed to loop test address */

	cmd_data = *cmd_mem & 0xecff0000;
	*cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to diag mode */

	ldata = *lmem;  /* Read test seed from loop test address */

	if(!(ck_cmd_bit(iom_slot,ICB_UDS)))	{
		printf("ICB UDS* inactive error\n");
		return(1);
	}
	if(!(ck_cmd_bit(iom_slot,ICB_LDS)))	{
		printf("ICB LDS* inactive error\n");
		return(1);
	}
	if (ldata != seed)	{
		printf("Long ");
		printf("Read data:%2x Seed:%2x\n",ldata,seed);
		return(1);
	}

	/* Three bytes operation */
	cmd_data = (0x00000006 << IOA_INT_TEST_SH);
	*cmd_mem = cmd_data;
	cmd_data = (0x0000001e << IOA_INT_TEST_SH);
	*cmd_mem = cmd_data;	/* To assert ICB.DTACK* */

	lmem = (unsigned *)(S_LOOP_ADDR);
	addr  = (unsigned char)CSSADD((unsigned)lmem);
	lmem = (unsigned *)CSSMAP((unsigned)lmem);
	cssmap(MAP00,iom_slot,addr);
	set_fake_wr(3,(unsigned)lmem);
	*lmem = seed;	/* Write seed to loop test address */
	reset_fake();

	cmd_data = *cmd_mem & 0xecff0000;
	*cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to diag mode */

	sim_on();
	set_fake_rd(3,(unsigned)lmem);
	*lmem = ldata ;	/* Issue three byte read by using fake read */
	reset_fake();
	sim_off();

	if(!(ck_cmd_bit(iom_slot,ICB_UDS)))	{
		printf("ICB UDS* inactive error\n");
		return(1);
	}
	if(ck_cmd_bit(iom_slot,ICB_LDS))	{
		printf("ICB LDS* active error\n");
		return(1);
	}
	return(0);
}
	
icb_addr_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	result = addr_test(iom_slot);	/* call test */
	if (result == 0x00)	{
		printf("Test OK\n");
		iom_rst(iom_slot);
		io_rst(iom_slot);
	}
	else
		printf("Test failed\n");
}


addr_test(iom_slot)
char 		iom_slot;
{
	unsigned 	*cmd_mem, cmd_data, addr_seed;
	char 	*loop_mem, loop_data, seed;
	unsigned char 	addr,huu;
	int		i;

	if(!pwr_test)

	if (ck_5v(iom_slot))	{	/* check for IOA 5V is OK */
		printf("No IOA 5V\n");
		return(1);
	}
	cmd_mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd_mem);
	cmd_mem = (unsigned *)CSSMAP7((unsigned)cmd_mem);
	cssmap(MAP07,iom_slot,addr);

	seed = 0x5a;
	addr_seed = 0x00000002;

	/* ICB address bus ripple 1 */
	for(i=0; i<19; i++)	{
		cmd_data = (0x00000006 << IOA_INT_TEST_SH);
		*cmd_mem = cmd_data;
		cmd_data = (0x0000001e << IOA_INT_TEST_SH);
		*cmd_mem = cmd_data;	/* To assert ICB.DTACK* */
		loop_mem = (char *)(S_LOOP_ADDR | addr_seed);
		addr  = (unsigned char)CSSADD((unsigned)loop_mem);
		loop_mem = (char *)CSSMAP((unsigned)loop_mem);
		cssmap(MAP00,iom_slot,addr);
		*loop_mem = seed;	/* Write test seed to loop test address */
		cmd_data = *cmd_mem & 0xecff0000;
		*cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to special diag mode */
		loop_data = *loop_mem;  /* Read test seed from loop test address */
		if(ck_error(iom_slot,(((unsigned)loop_mem) & 0x7ffffffe)))
			return(1);
		if(loop_data != seed)	{
			printf("Address:%8x \n",loop_mem);
			printf("Read data:%8x Seed:%8x\n",loop_data,seed);
			return(2);
		}
		addr_seed = addr_seed << 1;
	}
	addr_seed = 0x00000002;
	addr_seed = 0x00000001;

	for(i=0; (i<20) && (!ifesc()); i++)	{		/* ICB address bus ripple 0 */
		cmd_data = (0x00000006 << IOA_INT_TEST_SH);
		*cmd_mem = cmd_data;
		cmd_data = (0x0000001e << IOA_INT_TEST_SH);
		*cmd_mem = cmd_data;	/* To assert ICB.DTACK* */

		loop_mem = (char *)((S_LOOP_ADDR | ~addr_seed) & E_LOOP_ADDR);
		addr  = (unsigned char)CSSADD((unsigned)loop_mem);
		loop_mem = (char *)CSSMAP((unsigned)loop_mem);
		cssmap(MAP00,iom_slot,addr);
		*loop_mem = seed;	/* Write test seed to loop test address */
		cmd_data = *cmd_mem & 0xecff0000;
		*cmd_mem = cmd_data | IOA_DIAG_RD; /* Set IOA to special diag mode */

		loop_data = *loop_mem;  /* Read test seed from loop test address */
		if(ifesc()) break;
		if(ck_error(iom_slot,(((unsigned)loop_mem) & 0x7ffffffe)))
			return(1);
		if(loop_data != seed)
			printf("\nFAILED: Read data:%8x Seed:%8x\n",loop_data,seed);
		addr_seed = addr_seed << 1;
	}
	return(0);
}

/*----------------------------------------------------------------------------*/

/*
	IO adapter interrupt test
	It tests IO adapter interrupt by causing IO adapter generate IO device
   	interrupt back to service module and check interrupt data.
	ioa_int_test() -- Command syntax:
						IOAI <iom_slot#> 
*/

ioa_int_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;

	iom_slot = (unsigned char)atox(comm_args[1]);
	init_css();
	io_int_test = 0xff;
	result = ioa_i_tst(iom_slot);	/* call IOA interrupt test */
	io_int_test = 0x00;
	if (result)
		printf("Test failed\n");
	else	{
		printf("Test OK\n");
		iom_rst(iom_slot);
		io_rst(iom_slot);
	}
}

ioa_i_tst(iom_slot)
char 		iom_slot;
{
	unsigned 		*cmd_mem, cmd_data;
	unsigned char		*mem, addr;
	unsigned 		j, i;
	char			huu;
	unsigned		pf;

	if(!pwr_test)	{
	}
	pf = 0;
	huu = 0;

	/* initial IO module interrupt vector table */
	iom_int_tbl_init(iom_slot,0);
	sp_int_set();	/* set SPM to receive int itself */

	iom_rst(iom_slot); 

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x11;			/* set IO module link config. */

	cmd_mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd_mem);
	cmd_mem = (unsigned *)CSSMAP7((unsigned)cmd_mem);
	cssmap(MAP07,iom_slot,addr);
	i_cnt = 0;

	/* Force IOA generate IO device interrupt */
	while(!huu)	{
		if (pwr_test)
			huu = 1;
		for (i = 18; i > 0; i--) {
			if (pf)
				i = pf;
		/*
		Issue interrupt request by writing I/O slot i to
		IOA command register 
		*/
		/* IOA interrupt enable */
	  	*cmd_mem = IOA_INT_EN;
/*		___________
		|d|d|o|o|o|
		-----------
		  |    |
		  |    |
		  |    ----------out#
		  ---------------decoder#
*/
		/* select out# */
	  	cmd_data = (i & 0x07) << IOA_INT_TEST_SH;
	  	*cmd_mem = (*cmd_mem & 0x4000ffff) | cmd_data;

		/* select decoder# and out# */
	  	cmd_data = ((i & 0x1f) + 8) << IOA_INT_TEST_SH;
	  	*cmd_mem = (*cmd_mem & 0x4000ffff) | cmd_data;

		j = 0x5;	/* wait for while */
		while(j != 0)
			j--;

		/* select out# */
	  	cmd_data = (i & 0x07) << IOA_INT_TEST_SH;
	  	*cmd_mem = (*cmd_mem & 0x4000ffff) | cmd_data;

		j = 0x10;	/* wait for while */
		while(j != 0)
			j--;

		if (i_cnt == 0x00) {  /* if int happened ? */
			if(pwr_test)	{
				printf("No IOA int#:%2x \n",i);
				return(-1);
			}
			if (!pf)	{
			printf("No IOA int#:%2x \n",i);
			printf("Loop on error\n");
			printesc();
			}
			pf = i;
		}
		else	{
			i_cnt--;
			sp_int_ack1(myslot);
			if (!(int_data & IOD_INT)) { /* IO device int */
			/* IO module in trouble interrupt, return error */
				iom_err(iom_slot);
				return(1);
			}
			if ((int_data & 0x1f) != i) {
				if(pwr_test)	{
					printf("Error IOA slot#:%x \n",i);
					return(-1);
				}
				printf("Error IOA slot#:%2x \n",i);
				printf("Loop on error\n");
				printesc();
				pf = i;
			}
		}
		if(!pwr_test)	{
			if(ifesc())
				return(pf);
			printf("\r.\r");
		}
	}
	if(!pwr_test)	{
		printf("\r.\r");
		if(ifesc())
			return(pf);
		}
	}
	return(0);
}

ioa_rst(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 			iom_slot;

	iom_slot = (unsigned char)atox(comm_args[1]);
	io_rst(iom_slot);
}

io_rst(iom_slot)
char 			iom_slot;
{
	unsigned 		*cmd_mem;
	unsigned char		*mem, addr;
	unsigned 		j;

	mem = (unsigned char *)IOMRST;	/* IO module reset register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0;			/* Issue IO module reset */

	cmd_mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd_mem);
	cmd_mem = (unsigned *)CSSMAP7((unsigned)cmd_mem);
	cssmap(MAP07,iom_slot,addr);
	*cmd_mem = 0x80000000;		/* set IO adaptor reset bit active */
	j = 0x8000;	/* wait for while */
	while(j != 0)
		j--;
	*cmd_mem = 0;			/* inactive IO adaptor reset bit */
}

ioa_dma_test2(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;
	unsigned 	mem_slot,rch,wch;
	unsigned 	raddr,waddr,cnt;

	iom_slot = (unsigned char)atox(comm_args[1]);
	mem_slot = (unsigned)atox(comm_args[2]);
	rch = (unsigned)atox(comm_args[3]);
	wch = (unsigned)atox(comm_args[4]);
	raddr = (unsigned)atox(comm_args[5]);
	waddr = (unsigned)atox(comm_args[6]);
	cnt = (unsigned)atox(comm_args[7]);
	if (rch == wch )	{
		printf("Please use different DMA channel # for read/write \n");
		return;
	}
	if ((rch > 3) || (wch > 3))	{
		printf("DMA channel # has to be less than 4\n");
		return;
	}
	init_css();
	result = ioa_dma_tst2(mem_slot,iom_slot,rch,wch,raddr,waddr,cnt);
	if (result)
		printf("Test failed\n");
	else	{
		printf("Test OK\n");
	}
}



ioa_dma_test(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	char 		iom_slot,result;
	unsigned 	mem_slot;

	iom_slot = (unsigned char)atox(comm_args[1]);
	mem_slot = (unsigned)atox(comm_args[2]);
	init_css();
	result = ioa_dma_tst(mem_slot,iom_slot); /* call IOA dma test */
	if (result)
		printf("Test failed\n");
	else	{
		printf("Test OK\n");
		/* iom_rst(iom_slot); */
	}
}


/*
 * checkpause ()
 *
 *	Say 'pause?' to user, return response.
 */

checkpause ()
{
	char ibuf [17];


	printf ("\nStop on error? (Y/N) ");
	if ((gets (ibuf, 16) == (char *)-1)) return (-1);
	if (Yes (*ibuf) || !*ibuf) return (1);
	return (0);
}

ioa_dma_tst(mem_slot,iom_slot)
char		iom_slot;
unsigned 	mem_slot;
{
register	unsigned	 *dcw1,*dcw2;
unsigned	 *m1,*m2,*m3,*m4;
unsigned	 i;
unsigned 	 *cmd,seed;
char		 addr;
unsigned char	woo,woo_f;

	if(!pwr_test)	{
		woo = checkloop();
		if (woo)
			printesc();
	}
	else	{
		woo = 0;
	}
	woo_f = 0xff;		/* loop test flag */
	seed = 0;
	while (woo_f)	{
		woo_f = woo;
		m1 = (unsigned *)(MEM1+(65536 * iom_slot));	/* memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
/*		m3 = (unsigned *)MEM3;	/* memory base address */
		m3 = (unsigned *)(MEM3+(65536 * iom_slot));	/* memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m3);
		m3 = (unsigned *)CSSMAP((unsigned)m3);
		cssmap(MAP00,mem_slot,addr);

	/* init 0x1000 of memory to known pattern */
		for(i=0; i<0x100; i++)
			*m1++ = seed;
		for(i=0; i<0x100; i++)
			*m3++ = seed++;
		cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
		addr  = (unsigned char)CSSADD((unsigned)cmd);
		cmd = (unsigned *)CSSMAP7((unsigned)cmd);
		cssmap(MAP07,iom_slot,addr);
		*cmd = DTB_EN | DTB_TEST;

/* dma channel 0 read from system memory 0x1000 0x0800 bytes to dma channel 1 */
		cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
		addr  = (unsigned char)CSSADD((unsigned)cmd);
		cmd = (unsigned *)CSSMAP7((unsigned)cmd);
		cssmap(MAP07,iom_slot,addr);
		dcw1 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH0 << ID_SH));
		dcw2 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH2 << ID_SH));
		*dcw1 = ~DMA_W & ((mem_slot << MEM_SH) | (CH1 << IO_SH) | 0x100);

	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x Read to ch:%2x\n",CH0,CH1);
			printf("Setup word 0 \n");
			return(2);
		}

/* dma channel 2 read from system memory 0x3000 0x0800 bytes to dma channel 3 */
		*dcw2 = ~DMA_W & ((mem_slot << MEM_SH) | (CH3 << IO_SH) | 0x100);

	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x Read to ch:%2x\n",CH2,CH3);
			printf("Setup word 0 \n");
			return(2);
		}

		dcw1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH0 << ID_SH));
		dcw2 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH2 << ID_SH));
		*dcw1 = (unsigned)(MEM1+(65536 * iom_slot));	/* memory base address */

	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x Read to ch:%2x\n",CH0,CH1);
			printf("Setup word 1\n");
			return(2);
		}

		*dcw2 = (unsigned)(MEM3+(65536 * iom_slot));	/*memory base address */

	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x Read to ch:%2x\n",CH2,CH3);
			printf("Setup word 1\n");
			return(2);
		}

/* dma channel 1 write to system memory 0x2000 for 0x0800 bytes */
		dcw1 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH1 << ID_SH));
		*dcw1 = DMA_W | (mem_slot << MEM_SH) | (0xf << IO_SH) | 0x100;
	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x write \n",CH1);
			printf("Setup word 0\n");
			return(2);
		}

/* dma channel 3 write to system memory 0x4000 for 0x100 bytes */
		dcw2 = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (CH3 << ID_SH));
		*dcw2 = DMA_W | (mem_slot << MEM_SH) | (0xf << IO_SH) | 0x100;
	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x write \n",CH3);
			printf("Setup word 0\n");
			return(2);
		}
		dcw1 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH1 << ID_SH));
		dcw2 = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (CH3 << ID_SH));

		*dcw1 = (unsigned)(MEM2+(65536 * iom_slot));	/*memory base address */
	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x write \n",CH1);
			printf("Setup word 1\n");
			return(2);
		}

		*dcw2 = (unsigned)(MEM4+(65536 * iom_slot));	/*memory base address */
	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("Ch:%2x write \n",CH3);
			printf("Setup word 1\n");
			return(2);
		}

		if(ck_act(iom_slot,CH1))
			return(1);

		if(ck_act(iom_slot,CH3))
			return(1);
		m1 = (unsigned *)(MEM1+(65536 * iom_slot));	/*memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		m2 = (unsigned *)(MEM2+(65536 * iom_slot));	/*memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m2);
		m2 = (unsigned *)CSSMAP((unsigned)m2);
		cssmap(MAP00,mem_slot,addr);
		for(i=0; i<0x100; i++)
		   if(*m1++ != *m2++ )  {
			printf("\nData compare error\n");
			printf("Ch:%2x read Ch:%2x write\n",CH0,CH1);
			printf("Rd addr:%8x Wt addr:%8x\n",m1,m2);
			printf("Rd data:%8x Wt data:%8x\n",*m1,*m2);
			return(3);
		   }
		m3 = (unsigned *)(MEM3+(65536 * iom_slot));	/*memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m3);
		m3 = (unsigned *)CSSMAP((unsigned)m3);
		m4 = (unsigned *)(MEM4+(65536 * iom_slot));	/*memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m4);
		m4 = (unsigned *)CSSMAP((unsigned)m4);
		cssmap(MAP00,mem_slot,addr);
		for(i=0; i<0x100; i++)	{
		   if(*m3++ != *m4++)  {
			printf("\nData compare error\n");
			printf("Ch:%2x read Ch:%2x write\n",CH2,CH3);
			printf("Rd addr:%8x Wt addr:%8x\n",m3,m4);
			printf("Rd data:%8x Wt data:%8x\n",*m3,*m4);
			return(3);
		   }
		}
		if(!pwr_test)	{
	  		if (ifesc())
				woo_f = 0;
			printf("\rIOA 4 DMA's loop test seed: %8x \r",seed);
			seed += 10203040;
		}
	}
	return(0);
}



ioa_dma_tst2(mem_slot,iom_slot,rdch,wtch,rdaddr,wtaddr,count)
char		iom_slot;
unsigned 	mem_slot,rdch,wtch;
unsigned 	rdaddr,wtaddr,count;
{
unsigned	 *m1,*m2,*dcw,i;
unsigned 	 *cmd,seed;
char		 addr;
unsigned char	woo,woo_f;

	woo = checkloop();
	if (woo)
		printesc();
	woo_f = 0xff;		/* loop test flag */
	seed = 0;
	while (woo_f)	{
		woo_f = woo;
		m1 = (unsigned *)rdaddr;	/* memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		cssmap(MAP00,mem_slot,addr);

	/* init 0x1000 of memory to known pattern */
		for(i=0; i<count; i++)	{
			*m1 = seed;
			m1++;
		}

		cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
		addr  = (unsigned char)CSSADD((unsigned)cmd);
		cmd = (unsigned *)CSSMAP7((unsigned)cmd);
		cssmap(MAP07,iom_slot,addr);
		*cmd = DTB_EN | DTB_TEST;

/* dma channel 0 read from system memory to dma channel 1 */
		cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
		addr  = (unsigned char)CSSADD((unsigned)cmd);
		cmd = (unsigned *)CSSMAP7((unsigned)cmd);
		cssmap(MAP07,iom_slot,addr);
		dcw = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (rdch << ID_SH));
		*dcw = ~DMA_W & ((mem_slot << MEM_SH) | (wtch << IO_SH) | count);

	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("1");
			return(2);
		}

		dcw = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (rdch << ID_SH));
		*dcw = rdaddr;

	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("2");
			return(2);
		}

	if(ck_act(iom_slot,rdch))
		return(1);

/* dma channel 1 write to system memory */
		dcw = (unsigned *)((unsigned)cmd | (WD0 << FNC_SH) | (wtch << ID_SH));
		*dcw = DMA_W | (mem_slot << MEM_SH) | (0xf << IO_SH) | count;
	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("3");
			return(2);
		}

		dcw = (unsigned *)((unsigned)cmd | (WD1 << FNC_SH) | (wtch << ID_SH));
		*dcw = wtaddr;
	/* wait for DTB ack */
		if(dtb_cmd_ack(iom_slot)){
			printf("4");
			return(2);
		}

		if(ck_act(iom_slot,wtch))
			return(1);
		m1 = (unsigned *)rdaddr;	/* memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m1);
		m1 = (unsigned *)CSSMAP((unsigned)m1);
		m2 = (unsigned *)wtaddr;	/* memory base address */
		addr  = (unsigned char)CSSADD((unsigned)m2);
		m2 = (unsigned *)CSSMAP((unsigned)m2);
		cssmap(MAP00,mem_slot,addr);
		for(i=0; i<count; i++)	{
		   if(*m1 != *m2)  {
			printf("\nData compare error\n");
			printf("Rd addr:%8x Wt addr:%8x\n",m1,m2);
			printf("Rd data:%8x Wt data:%8x\n",*m1,*m2);
			return(3);
		   }
		   m1++; m2++;
		}
	  	if (ifesc())
			woo_f = 0;
		printf("\rIOA DMA loop test seed: %8x \r",seed);
		seed += 10203040;
	}
	return(0);
}


dtb_cmd_ack(iom_slot) /* return 1 if dtb command ack, 0 if no ack */
char		iom_slot;
{
	unsigned 	*cmd;
	int		cnt;
	char		addr;


	cmd = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);

	cnt = 0x40;
	while(cnt-- != 0)	{
		if(*cmd & DTB_DIAG_ACK)	{
			return(0);
		}
	}
	printf("No DTB command ACK error \n");
	return(1);
}


ck_act(iom_slot,chan) /* return 1 if not active , 0 if active */
char		iom_slot;
unsigned	chan;
{
	unsigned 	*cmd,*dcw,status;
	int		cnt;
	char		 addr;

	cmd = (unsigned *)DTB_DIAG_CMD;	/* IOA dtb diagnostic command */
	addr  = (unsigned char)CSSADD((unsigned)cmd);
	cmd = (unsigned *)CSSMAP7((unsigned)cmd);
	cssmap(MAP07,iom_slot,addr);
	dcw = (unsigned *)((unsigned)cmd | (WD2 << FNC_SH) | (chan << ID_SH));

	status = *dcw;

	if(dtb_cmd_ack(iom_slot)){
		printf("4");
		return(2);
	}

	/* printf("DCW addr:%8x DMA status: %8x \n",dcw,status); */
	cnt = 0x40000;
	while(cnt-- != 0)	{
		status = *dcw;
		if(!((status & CH_LK_ACT) || (status & CH_DTB_ACT)))
			return(0);	/* ok */
	}
	printf("Time-out DMA status: %8x \n",status);
	return(1);	/* time out */
}

ck_5v(iom_slot)
{
	unsigned char	bdata,*addr;	
	unsigned offset;
	unsigned char	up_addr;

	offset = IOM_ERR;	/* IO module error register */
	addr = (unsigned char *)CSSMAP(offset);
	up_addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,iom_slot,up_addr);
	bdata = *addr;		/* read IO module error register */
	if (bdata & 0x08)
		return(0);
	else 
		return(1);

}

ck_error(iom_slot,addr)
unsigned char iom_slot;
unsigned	addr;
{
	unsigned 	*mem, err_data, latch_addr;
	unsigned char 	up_4bit_addr;

	mem = (unsigned *)IOA_ERR_REG;	/* IOA error latch register */
	up_4bit_addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned *)CSSMAP7((unsigned)mem);
	cssmap(MAP07,iom_slot,up_4bit_addr);

	err_data = *mem;	/* read IOA error latch register */
	latch_addr = 0;
	latch_addr |= err_data & 0x1ffffe;	/* mask addr 0 to 20 */
	if (latch_addr != addr)		{
		printf("latch_addr: %8x\n",latch_addr);
		printf("Expected addr: %8x\n",addr);
		return(1);
	}
	return(0);
}

ck_cmd_bit(iom_slot,ck_data_bit)
unsigned char iom_slot;
unsigned	ck_data_bit;
{
	unsigned 	*mem, cmd_data, latch_addr;
	unsigned char 	up_4bit_addr;

	mem = (unsigned *)IOA_CMD_REG;	/* IOA command register */
	up_4bit_addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned *)CSSMAP7((unsigned)mem);
	cssmap(MAP07,iom_slot,up_4bit_addr);
	cmd_data = *mem;	/* read IOA command register */

	
	/* printf("Cmd reg = %8x check data = %8x\n",cmd_data,ck_data_bit); */
	if (cmd_data & ck_data_bit)	
		return(0);
	else
		return(1);
}
