#	START NEW ARIX SCCS HEADER
#
#	@(#) initimage.s: version 25.1 created on 11/27/91 at 14:38:01
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)initimage.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

#various equates for the Service Processor Module 

set	prom_size,		0x3ffff			# monitor prom size is 256k
set	static_start,	0x01000000		# static ram
set	data_start,		0x1000400
set	static_size,	0x3ffff		
set	static_ov,		0x010000a8
set	stack_size,		0x3fff0
set	stack,			static_start+stack_size  # stack starts at top of static ram
set	map_start,		0x480000		# secondary mapper
set	map_size,		0xffff			# mapper size is 64k
set	sccb,			0x02800800		# scc device
set	scca,			0x02800820		# scc device
set	statusreg,		0x070000a0
set	css_err_reg,	0x070000c0
set	cio,			0x02800200		# cio device
set	cioreg,			0x02800205		# cio device
set	queue_ram,		0x0c000000
set	queue_size,		0x1000
set	clkcntl,		0x5000000
set	wrcntl0,		0x07000000
set	wrcntl1,		0x07000020
set	notIrdy,		0xbfffffff
set	setIrdy,		0x40000000
set	novram,			0x030007f0		# test byte for non-vol ram
set	wrcntl2,		0x07000040		# write control register 2
set	NULL,			0x00

# The following added 870710 for floppy debugger commands
#set 	FDISP,0x10004				# the dispatcher jump address
#set 	MIGRATE,0x1000a				# move the VBR and the floppy handler to ram

set ADC_CNTL,	0x02800102		# control port, adc.
set ADC_ADATA,	0x02800100		# data port, adc.
set ADC_SC,		0x0100			# start command, adc.
set ADC_CH0,	0x0000			# measures +5v for master system
set ADC_CH1,	0x0001			# reference voltage 4.5v must read FF
set ADC_EOC,	0x8000			# if set, valid data in lower bits.
set ADC_MASK,	0x00ff			# mask for valid data.
set DATA,		0x9000001 		# data register
set MSR,		0x9000000 		# master status register (ro)*/
set DelCnt,		0x060

set	A7S,	0x0001
set	A6S,	0x0002
set	A5S,	0x0004
set	A4S,	0x0008
set	A3S,	0x0010
set	A2S,	0x0020
set	A1S,	0x0040
set	A0S,	0x0080
set	D7S,	0x0100
set	D6S,	0x0200
set	D5S,	0x0400
set	D4S,	0x0800
set	D3S,	0x1000
set	D2S,	0x2000
set	D1S,	0x4000
set	D0S,	0x8000
set	D0R,	0x0001
set	D1R,	0x0002
set	D2R,	0x0004
set	D3R,	0x0008
set	D4R,	0x0010
set	D5R,	0x0020
set	D6R,	0x0040
set	D7R,	0x0080
set	A0R,	0x0100
set	A1R,	0x0200
set	A2R,	0x0400
set	A3R,	0x0800
set	A4R,	0x1000
set	A5R,	0x2000
set	A6R,	0x4000
set	A7R,	0x8000

# SCC goodies
set	WR0_RSTINT,	0x10		# Reset external status interrupts
set	WR0_SHL,	0x02		# Shift left mode
set	WR1_RXALL,	0x10		# Rx int on all or special condition
set	WR1_EXTEN,	0x01		# External ints enable
set	SCCSTVECT,	0x10		# Int vector
set	WR3_RX8,	0xc0		# Transmit 8 bits
set	WR3_RXEN,	0x01		# Reciever enable
set	WR4_1STOP,	0x04		# Async 1 stop bit/character
set	WR4_16CLOCK,0x40		# x16 clock mode
set	WR5_DTR,	0x80		# Data terminal ready
set	WR5_TX8,	0x60		# 8 tx bits
set	WR5_RTS,	0x02		# Request to send
set	WR5_TXEN,	0x08		# Transmitter enable
set	WR9_HRST, 	0xc0		# Hardware reset
set	WR9_NV,	  	0x02		# No vector
set	WR9_MIE,	0x08		# Master interrupt enable
set	WR11_RCGO,	0x40		# Use baud gen for recieve clock
set	WR11_TCGO,	0x10		# Use baud gen for transmit clock
set	BDRT9600,	0x0a		# 9600 baud time constant
set	WR14_ENABD,	0x01		# Enable baud rate generator
set	WR14_PCLK,	0x02		# PCLK is source for baud generator
set	WR14_LLBK,	0x10		# Local loopback mode	
set	WR14_ECHO,	0x08		# Auto echo
set	WR15_DCDIE,	0x08		# DCD interrupt enable


global _restart
global _cache
global end
global BusFault
global fIrdy
global migrate,fboot
global cmpblk
global _reloc_code, reloc_code
global vbrmv, trap1, trap2

	text

	long	stack			# (0) Reset stack pointer.
	long	diagstart		# (1) Reset program counter.
	long	BusError		# (2) Bus error handler.
	long	AddressError	# (3) Address error.
	long	BadInst			# (4) Illegal instruction.
	long	ZeroDivide		# (5) Zero divide
	long	Chkinstru		# (6) Chk instruction
	long	Trapv			# (7) Trapv instruction
	long	PrivError		# (8) Privilege violation
	long	TraceIn			# (9) Trace
	long	Line1010em		# (10) Line 1010 emulator
	long	Line1111em		# (11) Line 1111 emulator
	long	Unasint			# (12) Unassigned interrupt
	long	Cproviol		# (13) Coprocessor protocol violaton	
	long	FormatError		# (14) Format error
	long	Uninitint		# (15) Unintialized interrupt

	long	Unassign		# (16) Unassigned interrupt
	long	Unassign		# (17) Unassigned interrupt
	long	Unassign		# (18) Unassigned interrupt
	long	Unassign		# (19) Unassigned interrupt
	long	Unassign		# (20) Unassigned interrupt
	long	Unassign		# (21) Unassigned interrupt
	long	Unassign		# (22) Unassigned interrupt
	long	Unassign		# (23) Unassigned interrupt
	long	Spurint			# (24) Spurious interrupt
	long	AutoVec1		# (25) ICB request level 1 routine
	long	AutoVec2		# (26) ICB request level 2 routine
	long	AutoVec3		# (27) ICB request level 3 routine
	long	AutoVec4		# (28) ICB level 4 and 8030 int routine
	long	AutoVec5		# (29) ICB level 5 and IRQ to slave routine
	long	jerror			# (30) Returned to older code for now...
	long	AutoVec7		# (31) CSS error 

	long	Trap0			# (32) Trap 0
	long	Trap1			# (33) Trap 1
	long	Trap2			# (34) Trap 2
	long	Trap3			# (35) Trap 3
	long	Trap4			# (36) Trap 4
	long	Trap5			# (37) Trap 5
	long	Trap6			# (38) Trap 6
	long	Trap7			# (39) Trap 7
	long	Trap8			# (40) Trap 8
	long	Trap9			# (41) Trap 9
	long	Trap10			# (42) Trap 10 
	long	Trap11			# (43) Trap 11 
	long	Trap12			# (44) Trap 12 
	long	Trap13			# (45) Trap 13 
	long	Trap14			# (46) Trap 14 
	long	Trap15			# (47) Trap 15 

	long	FPCP_bosu		# (48) FPCP branch or set on unordered cond. 
	long	FPCP_inex		# (49) FPCP inexact result 
	long	FPCP_zdiv		# (50) FPCP divide by zero 
	long	FPCP_uflow		# (51) FPCP underflow 
	long	FPCP_operr		# (52) FPCP operand error
	long	FPCP_ovflw		# (53) FPCP overflow
	long	FPCP_snan		# (54) FPCP signaling NAN
	long	Unasint			# (55) Unassigned interrupt
	long	PMMU_conf		# (56) PMMU configuration
	long	PMMU_illop		# (57) PMMU illegal operation 
	long	PMMU_aviol		# (58) PMMU access violation
	long	Unasint			# (59) Unassigned interrupt
	long	Unasint			# (60) Unassigned interrupt
	long	Unasint			# (61) Unassigned interrupt
	long	Unasint			# (62) Unassigned interrupt
	long	Unasint			# (63) Unassigned interrupt

	long	LCIOt3int		# (64) User defined 0 Counter/Timer 3
	long	Userdef			# (65) User defined 1
	long	LCIOt2int		# (66) User defined 2 Counter/Timer 2
	long	Userdef			# (67) User defined 3
	long	LCIOt1int		# (68) User defined 4 Counter/Timer 1
	long	Userdef			# (69) User defined 5
	long	LCIOerr			# (70) User defined 6 Error
	long	Userdef			# (71) User defined 7
	long	Userdef			# (72) User defined 8
	long	Userdef			# (73) User defined 9
	long	Userdef			# (74) User defined 10
	long	Userdef			# (75) User defined 11
	long	Userdef			# (76) User defined 12
	long	Userdef			# (77) User defined 13
	long	Userdef			# (78) User defined 14
	long	Userdef			# (79) User defined 15
	long	Userdef			# (80) User defined 16
	long	Userdef			# (81) User defined 17
	long	Userdef			# (82) User defined 18
	long	Userdef			# (83) User defined 19
	long	Userdef			# (84) User defined 20
	long	Userdef			# (85) User defined 21
	long	Userdef			# (86) User defined 22
	long	Userdef			# (87) User defined 23
	long	Userdef			# (88) User defined 24
	long	Userdef			# (89) User defined 25
	long	Userdef			# (90) User defined 26
	long	Userdef			# (91) User defined 27
	long	Userdef			# (92) User defined 28
	long	Userdef			# (93) User defined 29
	long	Userdef			# (94) User defined 30
	long	Userdef			# (95) User defined 31

	long	Userdef			# (96) User defined 32
	long	Userdef			# (97) User defined 33
	long	Userdef			# (98) User defined 34
	long	Userdef			# (99) User defined 35
	long	Userdef			# (100) User defined 36
	long	Userdef			# (101) User defined 37
	long	Userdef			# (102) User defined 38
	long	Userdef			# (103) User defined 39
	long	Userdef			# (104) User defined 40
	long	Userdef			# (105) User defined 41
	long	Userdef			# (106) User defined 42
	long	Userdef			# (107) User defined 43
	long	Userdef			# (108) User defined 44
	long	Userdef			# (109) User defined 45
	long	Userdef			# (110) User defined 46
	long	Userdef			# (111) User defined 47

	long	Userdef			# (112) User defined 48
	long	Userdef			# (113) User defined 49
	long	Userdef			# (114) User defined 50
	long	Userdef			# (115) User defined 51
	long	Userdef			# (116) User defined 52
	long	Userdef			# (117) User defined 53
	long	Userdef			# (118) User defined 54
	long	Userdef			# (119) User defined 55
	long	Userdef			# (120) User defined 56
	long	Userdef			# (121) User defined 57
	long	Userdef			# (122) User defined 58
	long	Userdef			# (123) User defined 59
	long	Userdef			# (124) User defined 60
	long	Userdef			# (125) User defined 61
	long	Userdef			# (126) User defined 62
	long	Userdef			# (127) User defined 63

# these are the start of the scc interrupt vectors.

	long	Xtx0b%			# (128) T-com 0 B xmit
	long	Userdef			# (129) 
	long	Xex0b%			# (130) T-com 0 B external
	long	Userdef			# (131)
	long	Xrx0b%			# (132) T-com 0 B receive
	long	Userdef			# (133) 
	long	Xsp0b%			# (134) T-com 0 B special
	long	Userdef			# (135) 
	long	Xtx0a%			# (136) T-com 0 A xmit
	long	Userdef			# (137) 
	long	Xex0a%			# (138) T-com 0 A external
	long	Userdef 		# (139) 
	long	Xrx0a%			# (140) T-com 0 A recieve
	long	Userdef			# (141) 
	long	Xsp0a%			# (142) T-com 0 A special
	long	Userdef			# (143) 

	long	Xtx1b%			# (144) T-com 1 B xmit
	long	Userdef			# (145) 
	long	Xex1b%			# (146) T-com 1 B external
	long	Userdef			# (147) 
	long	Xrx1b%			# (148) T-com 1 B receive
	long	Userdef			# (149) 
	long	Xsp1b%			# (150) T-com 1 B special
	long	Userdef			# (151) 
	long	Xtx1a%			# (152) T-com 1 A xmit
	long	Userdef			# (153) 
	long	Xex1a%			# (154) T-com 1 A external
	long	Userdef			# (155) 
	long	Xrx1a%			# (156) T-com 1 A receive
	long	Userdef			# (157) 
	long	Xsp1a%			# (158) T-com 1 A special
	long	Userdef			# (159) 

	long	Xporta0%		# (160) Parallel port 1, A
	long	Userdef			# (161)
	long	Xportb0%		# (162) Parallel port 1, B
	long	Userdef			# (163)
	long	ctint%			# (164) Counter timer 1

	long	Userdef			# (165) User defined 101
	long	Userdef			# (166) User defined 102
	long	Userdef			# (167) User defined 103
	long	Userdef			# (168) User defined 104
	long	Userdef			# (169) User defined 105
	long	Userdef			# (170) User defined 106
	long	Userdef			# (171) User defined 107
	long	Userdef			# (172) User defined 108
	long	Userdef			# (173) User defined 109
	long	Userdef			# (174) User defined 110
	long	Userdef			# (175) User defined 111
	long	Userdef			# (176) User defined 112
	long	Userdef			# (177) User defined 113
	long	Userdef			# (178) User defined 114
	long	Userdef			# (179) User defined 115
	long	Userdef			# (180) User defined 116
	long	Userdef			# (181) User defined 117
	long	Userdef			# (182) User defined 118
	long	Userdef			# (183) User defined 119
	long	Userdef			# (184) User defined 120
	long	Userdef			# (185) User defined 121
	long	Userdef			# (186) User defined 122
	long	Userdef			# (187) User defined 123
	long	Userdef			# (188) User defined 124
	long	Userdef			# (189) User defined 125
	long	Userdef			# (190) User defined 126
	long	Userdef			# (191) User defined 127
	long	Userdef			# (192) User defined 128
	long	Userdef			# (193) User defined 129
	long	Userdef			# (194) User defined 130
	long	Userdef			# (195) User defined 131
	long	Userdef			# (196) User defined 132
	long	Userdef			# (197) User defined 133
	long	Userdef			# (198) User defined 134
	long	Userdef			# (199) User defined 135
	long	Userdef			# (200) User defined 136
	long	Userdef			# (201) User defined 137
	long	Userdef			# (202) User defined 138
	long	Userdef			# (203) User defined 139
	long	Userdef			# (204) User defined 140
	long	Userdef			# (205) User defined 141
	long	Userdef			# (206) User defined 142
	long	Userdef			# (207) User defined 143
	long	Userdef			# (208) User defined 144
	long	Userdef			# (209) User defined 145
	long	Userdef			# (210) User defined 146
	long	Userdef			# (211) User defined 147
	long	Userdef			# (212) User defined 148
	long	Userdef			# (213) User defined 149
	long	Userdef			# (214) User defined 150
	long	Userdef			# (215) User defined 151
	long	Userdef			# (216) User defined 152
	long	Userdef			# (217) User defined 153
	long	Userdef			# (218) User defined 154
	long	Userdef			# (219) User defined 155
	long	Userdef			# (220) User defined 156
	long	Userdef			# (221) User defined 157
	long	Userdef			# (222) User defined 158
	long	Userdef			# (223) User defined 159
	long	Userdef			# (224) User defined 160
	long	Userdef			# (225) User defined 161
	long	Userdef			# (226) User defined 162
	long	Userdef			# (227) User defined 163
	long	Userdef			# (228) User defined 164
	long	Userdef			# (229) User defined 165
	long	Userdef			# (230) User defined 166
	long	Userdef			# (231) User defined 167
	long	Userdef			# (232) User defined 168
	long	Userdef			# (233) User defined 169
	long	Userdef			# (234) User defined 170
	long	Userdef			# (235) User defined 171
	long	Userdef			# (236) User defined 172
	long	Userdef			# (237) User defined 173
	long	Userdef			# (238) User defined 174
	long	Userdef			# (239) User defined 175
	long	Userdef			# (240) User defined 176
	long	Userdef			# (241) User defined 177
	long	Userdef			# (242) User defined 178
	long	Userdef			# (243) User defined 179
	long	Userdef			# (244) User defined 180
	long	Userdef			# (245) User defined 181
	long	Userdef			# (246) User defined 182
	long	Userdef			# (247) User defined 183
	long	Userdef			# (248) User defined 184
	long	Userdef			# (249) User defined 185
	long	Userdef			# (250) User defined 186
	long	Userdef			# (251) User defined 187
	long	Userdef			# (252) User defined 188
	long	Userdef			# (253) User defined 189
	long	Userdef			# (254) User defined 190
	long	Userdef			# (255) User defined 191

diagstart:
	mov.w	&0x2700,%sr			# Set the interrupt mask
	mov.b	0x9000000,%d0		# Stop floppy interrupt
	mov.l	&diagstart,%d0		# get my address.
	and.l	&0xffff0000,%d0 	# strip junk.
	mov.l	%d0,%d1 			# save for ram configuration.
	mov.l	%d0,%vbr			# Point to ram base
	mov.l	&stack,%sp			# Setup stack pointer
	mov.l	&0x08,%d0
	mov.l	%d0,%cacr			# Clear the instruction cache
	mov.l	&0x01,%d0
	mov.l	%d0,%cacr			# Enable on-chip cache	
	mov.l	&stack,%d0			# Stack address
	mov.l	%d0,%usp			# Set user stack pointer
	mov.l	%d0,%msp			# Set master stack pointer
	mov.l	%d0,%isp			# Set interrupt stack pointer

	jsr		init_buf		# initilze the macro buffer.
	jsr		init_monitor 		# init pointers and things.
	jsr		main1		 	# init cio's and data fields.
	jsr		start_main	 	# go startup the main routines.

# if start_main returns; enter monitor.
mon_start1:
	jsr	version
	jsr	init_monitor			# init pointers and things.
mon_entry:
	jsr	main				# init cio's and data fields.
	jsr	monitor

	bra.b	mon_start1

_restart:
	jsr	main1				# init data fields.
	bra.b	mon_entry

_reloc_code:
reloc_code:
	mov.l	&stack,%sp		# Setup stack pointer again.
	jsr		load_ram		# go attempt the download.
	jmp		mon_start1		# if returned, go to monitor

trap1:
	trap	&1				# Initiate an exception process #1.
	rts

trap2:
	trap	&2				# Initiate an exception process #1.
	rts

#-------------------------------------------------------------------------------
#			move prom vector table to ram at newloc
#-------------------------------------------------------------------------------
migrate:
	movm.l	&D0S+A0S+A1S,-(%sp)		# save some registers
	mov.l	%vbr,%a0				# aim at base of old vector table
	mov.l	&0x1000000,%a1			# load new base address
	mov.w	&0xff,%d0				# size of vector table in longs
mi2:
	mov.l	(%a0)+,(%a1)+
	dbf	%d0,mi2

	mov.l	&0x1000000,%a0			# load new vector address
	mov.l	&jerror,0x78(%a0)		# put handler addr into vector table
	mov.l	%a0,%vbr				# aim at new table.
	movm.l	(%sp)+,&D0R+A0R+A1R		# get back the saved registers
	rts

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
	global  softreset
softreset:
	mov.w	&0x2700,%sr
	mov.l	&100,%d0		#do many resets
srst:
	reset
	dbra	%d0,srst
	mov.l	0,%sp
	mov.l	4,%a0
	jmp		(%a0)

#change interrupt level to value passed on stack and return old level
global chgint
chgint:
	mov.l	4(%sp),%d0	#get desired level (from stack)
	lsl.l	&8,%d0		#get level info into position
	mov.w	%sr,%d1		#get present level
	and.w	&0xf8ff,%d1	#strip out int level
	or.l	%d0,%d1		#fill in desired level
	mov.w	%sr,%d0		#get present level again (for return)
	lsr.l	&8,%d0		# shift level
	and.l	&0x7,%d0	#save interrupt level info only
	mov.w	%d1,%sr		#update status register with desired level
	rts			#with original level in d0


_cache:
	mov.l	4(%sp),%d0
	and.l	&0x01,%d0
	mov.l	&0x08,%d1
	mov.l	%d1,%cacr
	mov.l	%d0,%cacr
	rts

Trap6:
	jsr	PrintStr
	rte

#-------------------------------------------------------------------------------
# print a string
#
# entry: %a1 = address of null terminated string
#-------------------------------------------------------------------------------
PrintStr:
	movm.l	&D0S+A2S,-(%sp)
	mov.l	&scca,%a2
Rdchar:
	mov.b	(%a1)+,%d0
	cmp.b	%d0,&0x00
	beq.b	Prdone

Print1:
	btst	&2,(%a2)
	beq.b	Print1	

send:
	mov.b	%d0,(%a2,16.w)
	bra.b	Rdchar
Prdone:
	movm.l	(%sp)+,&D0R+A2R
	rts

#-------------------------------------------------------------------------------
# print a byte 
#
# entry: %d0 = byte to print
#-------------------------------------------------------------------------------
Print:
	mov.l	&scca,%a2

Prt1:	btst	&2,(%a2)
	beq.b	Prt1	

send1:
	mov.b	%d0,(%a2,16.w)
Prdn:
	rts

#-------------------------------------------------------------------------------
#
# 		Interrupt Routines 
#
#-------------------------------------------------------------------------------
fIrdy:
	mov.l	&wrcntl1,%a0
	mov.l	(%a0),%d0
	bclr	&30,%d0
	mov.l	%d0,(%a0)
	bset	&30,%d0
	mov.l	%d0,(%a0)
	rts

AutoVec1:
	mov.l	&1,-(%sp)
	bra.b	AutoVec

AutoVec2:
	mov.l	&2,-(%sp)
	bra.b	AutoVec

AutoVec3:
	mov.l	&3,-(%sp)
	bra.b	AutoVec

AutoVec4:
	mov.l	&4,-(%sp)
	bra.b	AutoVec

AutoVec5:
	mov.l	&5,-(%sp)
	bra.b	AutoVec

AutoVec6:
	mov.l	&6,-(%sp)
	bra.b	AutoVec

AutoVec7:
	mov.l	&7,-(%sp)

AutoVec:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	autoint	
#	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
#	bne.b	AVx
	addq.l	&4,%sp			# Throw away int number
	rte
AVx:
	addq.l	&4,%sp			# Adjust stack
	bra	mon_entry

LCIOerr:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIO_err
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte
LCIOt3int:
	bra	BadExcept
LCIOt2int:
	bra	BadExcept
LCIOt1int:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIOt1_int	
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#-------------------------------------------------------------------------------
# Bus error interrupts vector to here 
#-------------------------------------------------------------------------------
BusError:
	mov.b	&0x1,got_berr		# Got it...
	tst.b	emulate			# Do we want to emulate bus error ?
	beq.w	more_berr
	subq.l	&4,%sp
	mov.l	%a0,(%sp)		# Save a0
	subq.l	&4,%sp
	mov.l	%d0,(%sp)		# Save d0
	subq.l	&4,%sp
	mov.l	%d1,(%sp)		# Save d1
	mov.w	(0x16.w,%sp),%d0	# Get the ssw
	and.w	0x0040,%d0		# check for read/write bus error
	beq.w	rd_emulate
wr_emulate:
	mov.l	(0x1c.w,%sp),%d0	# Get access address
#	mov.l	&0x1004000,%d0		# fake address
	lea.l	em_addr,%a0		# fake address
#	mov.l	%d0,%a0			# move addr 
	mov.l	(0x24.w,%sp),%d0	# Get data from data output buffer
	mov.w	(0x16.w,%sp),%d1	# Get the ssw to check size
	and.w	&0x0030,%d1		# mask off size
	cmp.w	%d1,&0x0000		# long word
	bne.b	size1			# check the rest size
	mov.l	%d0,(%a0)		# write long word to fake address
	bra	back
size1:
	cmp.w	%d1,&0x0030		# 3 byte
	bne.b	size2			# check the rest size
	mov.l	%d0,(%a0)		# write long word to fake address
	bra	back
size2:
	cmp.w	%d1,&0x0020		# word
	bne.b	size3			# check the rest size
	mov.w	%d0,(%a0)		# write word to fake address
	bra	back
size3:
	mov.b 	%d0,(%a0)		# write byte to fake address
	bra	back
rd_emulate:
	mov.l	(0x1c.w,%sp),%d0	# Get access address
#	mov.l	&0x1004000,%d0		# fake address
	lea.l	em_addr,%a0		# fake address
#	mov.l	%d0,%a0			# move addr 
	mov.w	(0x16.w,%sp),%d1	# Get the ssw to check size
	and.w	&0x0030,%d1		# mask off size
	cmp.w	%d1,&0x0000		# long word
	bne.b	r_size1			# check the rest size
	mov.l	(%a0),%d0		# read from fake address
	mov.l	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
r_size1:
	cmp.w	%d1,&0x0030		# 3 byte
	bne.b	r_size2			# check the rest size
	mov.l	(%a0),%d0		# read from fake address
	mov.l	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
r_size2:
	cmp.w	%d1,&0x0020		# word
	bne.b	r_size3			# check the rest size
	mov.w	(%a0),%d0		# read from fake address
	mov.w	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
r_size3:
	mov.b	(%a0),%d0		# read from fake address
	mov.b	%d0,(0x38.w,%sp)	# Put fake data into data input buffer
	bra	back
back:
	mov.w	(0x16.w,%sp),%d0	# Get the ssw again
	and.w	&0xfeff,%d0		# clear re-run flag in ssw
	mov.w	%d0,(0x16.w,%sp)	# Replace the ssw
	mov.l	(%sp),%d1		# Restore d1
	addq.l	&4,%sp
	mov.l	(%sp),%d0		# Restore d0
	addq.l	&4,%sp
	mov.l	(%sp),%a0		# Restore a0
	addq.l	&4,%sp
	bra	return
more_berr:
	subq.l	&2,%sp			# Align stack so C understands this
	movm.l	&0xffff,-(%sp)		# Move all registers onto stack
	jsr	buserr
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	BE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
return:
	rte		
BE:
	addq.l	&2,%sp			# Adjust stack
	bra	mon_entry



#-------------------------------------------------------------------------------
# Bad instruction error interrupts vector to here 
#-------------------------------------------------------------------------------
BadInst:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)	# To print all the regs
	jsr	badinst				# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff	# Restore
	bne.b	BI				# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
BI:
	addq.l	&2,%sp			# Adjust stack
	bra	mon_entry

#-------------------------------------------------------------------------------
# Zero divide error interrupts vector to here 
#-------------------------------------------------------------------------------
ZeroDivide:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	zerodivide		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	ZD			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
ZD:
	addq.l	&2,%sp			# Adjust stack
	bra	mon_entry


#-------------------------------------------------------------------------------
# Privilege violation error interrupts vector to here 
#-------------------------------------------------------------------------------
PrivError:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	priverror		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	PE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
PE:
	addq.l	&2,%sp			# Adjust stack
	bra	mon_entry

#-------------------------------------------------------------------------------
# Address error interrupts vector to here 
#-------------------------------------------------------------------------------
AddressError:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	addresserror		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	AE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
AE:
	addq.l	&2,%sp			# Adjust stack
	bra	mon_entry

#-------------------------------------------------------------------------------
# format error interrupts vector to here 
#-------------------------------------------------------------------------------
FormatError:
	subq.l	&2,%sp			# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	formaterror		# Go high level
	cmp.b	%d0,&0x00		# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	AE			# Skip if enter monitor
	addq.l	&2,%sp			# Adjust stack
	rte		
FE:
	addq.l	&2,%sp			# Adjust stack
	bra	mon_entry

#-------------------------------------------------------------------------------
# Bad exception interrupts vector to here 
#-------------------------------------------------------------------------------
BadExcept:
Chkinstru:
Trapv:
Line1010em:
Line1111em:
Unasint:
Cproviol:
Uninitint:
Unassign:
Spurint:
TraceIn:
Trap0:
Trap1:
Trap2:
Trap3:
Trap4:
Trap5:
Trap7:
Trap8:
Trap9:
Trap10:
Trap11:
Trap12:
Trap13:
Trap15:
FPCP_bosu:
FPCP_inex:
FPCP_zdiv:
FPCP_uflow:
FPCP_operr:
FPCP_ovflw:
FPCP_snan:
PMMU_conf:
PMMU_illop: 
PMMU_aviol:
Userdef:
	subq.l	&2,%sp				# Make the pushed SR a long for "C" jsr 
	movm.l	&0xffff,-(%sp)		# To print all the regs
	jsr	badexcept				# Go high level
	cmp.b	%d0,&0x00			# Go to monitor if non-zero 
	movm.l	(%sp)+,&0xffff		# Restore
	bne.b	BEX					# Skip if enter monitor
	addq.l	&2,%sp				# Adjust stack
	rte		
BEX:
	addq.l	&2,%sp			# Adjust stack
	bra	mon_entry

# used to return to system state from user
Trap14:
	or.w	&0x2000,(%sp)		# System flag 
	rte


# chkclok  Check which clock we are on
# returns 0 for css clock, 1 for local clock.
#
global chkclok
global _chkclok
chkclok:
_chkclok:
	mov.l	&0x0,%d0		# pre-set as good..
	btst	&5,statusreg	# Check clock bit
	beq.b	clok1			# good.. we are on css clock.
	mov.l	&0xffffffff,%d0	# bad..
clok1:
	rts

# Mainpow:  check to see if main power is on, so clock is valid.
#
global powmain
global _powmain
powmain:
_powmain:
	mov.l	%d1,-(%sp)
	mov.l	%d2,-(%sp)

	mov.w	&0x0100, ADC_CNTL	# setup. Start conversion, chan 0 (main +5).
	mov.l	&0xffff, %d1		# setup for loops.
powm1a:
	mov.l	&0xffff, %d2		# setup for loops.
powm1:
	mov.w	ADC_ADATA, %d0		# ok, read this.
	btst	&15, %d0			# test to see if bit 7 is high yet.
	bne.b	powm2
	dbne	%d2,powm1			# sigh.. inside loop.
	dbne	%d1,powm1a			# Skip if no

powm1b:	# bad exit.
	mov.l	&0xffffffff, %d0	# return status here.
powmexit:  # exit.
	mov.l	(%sp)+,%d2
	mov.l	(%sp)+,%d1
	rts

powm2:
	and.w	&0x00ff, %d0			# isolate lower word.
	cmp.w	%d0, &0x0080		# ok, is it valid?
	blt.b	powm1b				# if it's bad, continue.
	mov.l	&0x00000000, %d0	# sigh. bad.
	bra.b	powmexit

#
#	cmpblk.s  ->  compares a 512 byte block of memory with another.
#	returns either 512 if all bytes match, or 0-511, the offset of
#	the first byte that fails the match.
#		res = cmpblk(src_addr,tst_addr)

cmpblk:
	mov.l	%a0,-(%sp)
	mov.l	%a1,-(%sp)
	mov.l	%d1,-(%sp)

	mov.l	16(%sp),%a0			# get the source address
	mov.l	20(%sp),%a1			# get the destination address
	mov.l	&512,%d1			# size of a sector

	clr.l	%d0
cb1:
	cmp.b	(%a0)+,(%a1)+		# do a cmpm.b command
	bne.b	cbx					# branch if fail

	add.l	&1,%d0				# keep track of who's next
	dbf		%d1,cb1				# go around again

cbx:
	mov.l	(%sp)+,%d1
	mov.l	(%sp)+,%a1
	mov.l	(%sp)+,%a0

	rts


#   map.s
#
#	mtinit: Put a bit of code into the main memory ram, call it.
#
#	maptest: Code that runs in memory under test.
#	It should run, print, then move itself upwards in
#	main memory and run again.  This process should continue
#	until ram is exhausted.
# 	Enter with d2=memsize/mysize.
#	Print address of execution, perhaps.
#

global mtinit
set mysize,32
set mainmem,0x80000000

mtinit:						# move the program
	movm.l	&0xe0c0,-(%sp)	# save needed registers
	mov.l	24(%sp),%d2		# laps to do
	lea.l	maptest,%a0
	mov.l	&mysize,%d0
	mov.l	&mainmem,%a1
mtilp:
	mov.b	(%a0)+,(%a1)+
	dbra	%d0,mtilp
	mov.l	&mainmem,%a0
	jsr		(%a0)
	movm.l	(%sp)+,&0x0307
	rts

printlx:
	mov.l	(%sp)+,%a0		# get back the callers address
	mov.l	(%sp)+,%d0		# get the argument
	jmp		(%a0)			# go back without doing anything

maptest:
#	mov.l	%a0,-(%sp)		# push the present working address
#	jsr		printlx			# print the address
	nop
	nop
	mov.l	%a0,%a1			# copy the base address
	mov.w	&mysize,%d0		# how big this prog is.
	mov.l	%d0,%d1			# copy it
mtlp:
	mov.b	(%a0)+,0(%d0,%a1)
	add.l	&1,%d0
	sub.l	&1,%d1
	bne.b	mtlp
	sub.l	&1,%d2			# how many times should this be done?
	bne.b	mtlpend
	rts						# return if done
mtlpend:					# trick part: fall through to a copy of this
	nop
	nop
	nop


# attempt to clear a floppy error of unknown type.
# Remember: if you read DATA when none's available, you have to do
# a MSR,DATA pair until bit 6 of MSR goes low.
jerror:
	mov.l	%d0,-(%sp)		# save d0
	mov.l	%d1,-(%sp)		# save d1 for crash counter.
	mov.l	&0x20,%d1		# load a count.
	# Read data, set flag, return
	mov.b	MSR,%d0			# read the status. Must do one lap to clear int.
jerr1:
	jsr		adelay2			# wait for a bit
	mov.b	DATA,%d0		# get the data.
	jsr		adelay2			# wait for a bit
	sub.l	&1,%d1			# decrement the count
	beq.b	jerrxit			# leave if exhausted
	btst	&6,MSR			# is there data to be read?
 	bne.b	jerr1			# yes, read the data. Go back again.
jerrxit:
	mov.l	(%sp)+,%d1		# put back  d1
#	mov.w	&0x01,Eflag		# indicate an error
#	mov.w	%d0,E2flag		# save the data
#	clr.w	FCPend			# indicate no expected interrupts
	mov.l	(%sp)+,%d0
	rte

#***********************************
#  Function: adelay using DelCnt as loopcount
#
global adelay2
adelay2:
				# approx. 10 clocks/us
	mov.l	%d1,-(%sp)	# save d1
	mov.l	&DelCnt,%d1	# load count
adl1:
	nop			# (2/2/3) clocks
	dbne.w	%d1,adl1		# do it DelCnt number of times (3/6/9)

	mov.l	(%sp)+,%d1	# get back d1
	rts			#(26/37/45) + (5/8/12) * cnt
				# yields b/c/w lapcounts of 47/28/18 for 26us

#**************************************
#   Function: fboot.  Boot 3 sectors from the floppy. Jump to them
#
fboot:
	rts

#-------------------------------------------------------------------------
#handle our scc transmitter interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code
#-------------------------------------------------------------------------

Xtx0a%:
	mov.l	&0,-(%sp)
	bra.b	transint%
Xtx0b%:
	mov.l	&1,-(%sp)
	bra.b	transint%
Xtx1a%:
	mov.l	&2,-(%sp)
	bra.b	transint%
Xtx1b%:
	mov.l	&3,-(%sp)
transint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	txint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our scc receiver interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xrx0a%:
	mov.l	&0,-(%sp)
	bra.b	recvint%
Xrx0b%:
	mov.l	&1,-(%sp)
	bra.b	recvint%
Xrx1a%:
	mov.l	&2,-(%sp)
	bra.b	recvint%
Xrx1b%:
	mov.l	&3,-(%sp)
recvint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	rxint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our scc external/status interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xex0a%:
	mov.l	&0,-(%sp)
	bra.b	exstint%
Xex0b%:
	mov.l	&1,-(%sp)
	bra.b	exstint%
Xex1a%:
	mov.l	&2,-(%sp)
	bra.b	exstint%
Xex1b%:
	mov.l	&3,-(%sp)
exstint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	exint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our scc special interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xsp0a%:
	mov.l	&0,-(%sp)
	bra.b	specint%
Xsp0b%:
	mov.l	&1,-(%sp)
	bra.b	specint%
Xsp1a%:
	mov.l	&2,-(%sp)
	bra.b	specint%
Xsp1b%:
	mov.l	&3,-(%sp)
specint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	spint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#-------------------------------------------------------------------------
#handle our cio port A bit interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code
#-------------------------------------------------------------------------
Xporta0%:
	mov.l	&0,-(%sp)
	bra.b	portaint%
Xporta1%:
	mov.l	&1,-(%sp)
	bra.b	portaint%
Xporta2%:
	mov.l	&2,-(%sp)
	bra.b	portaint%
Xporta3%:
	mov.l	&3,-(%sp)
	bra.b	portaint%
Xporta4%:
	mov.l	&4,-(%sp)
	bra.b	portaint%
Xporta5%:
	mov.l	&5,-(%sp)
	bra.b	portaint%
Xporta6%:
	mov.l	&6,-(%sp)
	bra.b	portaint%
Xporta7%:
	mov.l	&7,-(%sp)
portaint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	pportaint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our cio port B bit interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code

Xportb0%:
	mov.l	&0,-(%sp)
	bra.b	portbint%
Xportb1%:
	mov.l	&1,-(%sp)
	bra.b	portbint%
Xportb2%:
	mov.l	&2,-(%sp)
	bra.b	portbint%
Xportb3%:
	mov.l	&3,-(%sp)
	bra.b	portbint%
Xportb4%:
	mov.l	&4,-(%sp)
	bra.b	portbint%
Xportb5%:
	mov.l	&5,-(%sp)
	bra.b	portbint%
Xportb6%:
	mov.l	&6,-(%sp)
	bra.b	portbint%
Xportb7%:
	mov.l	&7,-(%sp)
portbint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	pportbint
	movm.l	(%sp)+,&0x0303	#restore our registers
	addq.l	&4,%sp		#throw away interrupt number
	rte

#handle our cio timer interrupt vectors
#save registers a0, a1, d0, d1, and jump to C code
#note: funnel all vectors to one routine - read vector register for status

Xctcerr%:
#	movl	#0,sp@-
#	bras	ctint
Xctc1%:
#	movl	#1,sp@-
#	bras	ctint
Xctc2%:
#	movl	#2,sp@-
#	bras	ctint
Xctc3%:
#	movl	#3,sp@-
ctint%:
	movm.l	&0xc0c0,-(%sp)	#save some registers
	jsr	ctint
	movm.l	(%sp)+,&0x0303	#restore our registers
	rte

global which, _which
_which:
which:
	mov.l	&diagstart,%d0		# get my address.
	and.l	&0xffff0000,%d0 	# strip junk.
	bne.b	lwhich
	mov.l	&0, %d0
	rts
lwhich:
	mov.l	&1, %d0
	rts

#-------------------------------------------------------------------------------
#	vbrmv(location);	move the vbr pointer.
#-------------------------------------------------------------------------------
vbrmv:
	mov.l	4(%sp),%d0		# Get the address.
	mov.l	%d0,%vbr		# Load vector base register.
	rts

