/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iddiag.c: version 25.1 created on 11/27/91 at 14:37:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iddiag.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "spm.h"
#include "types.h"
#include "menu.h"
#include "global.h"
#include "routines.h"

extern dmem(),fmem(),init_css(),jsr(),mmem(),nov_tst();
extern init_dispatcher();
extern unsigned char LastCpu;
int	mybdid();
extern unsigned char myslot;			/* This is where I am. */
extern char emulate;		/* added by YVC at 2/1/88 for testing IOM */
extern char got_berr;		/* added by YVC at 2/1/88 for testing IOM */

struct init_menu id_diagnostics [] = {
	"idm(em)<.[bwl]>", "<addr <count>>",
	"Display Dispatcher memory", 'c', 0, 2, idmem, (char *)0,
	
	"imm(em)<.[bwl]>", "<addr <data>>",
	"Modify Dispatcher memory", 'c', 0, 2, immem, (char *)0,
	
#ifdef    REMOVE
	"rb(oard)", "",
	"Reset Board",'c',0,0,rboard, (char *)0,
#endif
	
	"rdid(l)", "",
	"Read my own Board ID",'c', 0, 0,mybdid, (char *)0,
	
	"req(uest)", "cpu (0-e)",
	"Request a cpu interrupt service",'c', 1, 1,request, (char *)0,
	
	"qs(tatus)", "cpu(0-e) <level>",
	"Display Queue Status",'c',1,2,qstat, (char *)0,
	
	"ints", "",
	"Fill Queue Ram with Int Requests",'c',0,0,irequests, (char *)0,
	
	"int", "cpu (0-e) level (0-5)",
	"Receive an Interrupt Request",'c', 2, 2,irequest, (char *)0,
	
	"ack", "level",
	"Acknowledge an Interrupt", 'c', 1,1, ack_int, (char *)0,
	
	"nov(l)", "",
	"Test Novram (looping).", 'c', 0,0, nov_tst, (char *)0,
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
};

mybdid(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned *j1 = (unsigned *)0x8ffffffc;	/* setup command pointer. */
	register unsigned i1, i2=0, loop;

	if(clokpr(0)) return;					/* must be on system clock.. */
	if(comm_str[4] == 'l') loop = 1;		/* we want looping operation. */

	cssmap(MAP00,(unsigned char)myslot,(unsigned char)0x0f); /*slot to ack*/
	emulate = 1;					/* tell bus error to emulate for us. */
	got_berr = 0;
	if(loop)						/* if looping mode. */
	{
		while(loop)
		{
			i1 = *j1;	/* read our own board id. */
			if(got_berr) break;	/* failed. */
			if(i1 & 0x000000ff) /* if it's failed. */
			{
				emulate = 0;	/* clear this again. */
				printf("Failed ID read.\n");
				return(1);
			} /* */
			if(ifesc())  break;	/* pressed escape. */
			if(i2++ == 400)  /* if four hundred passes. */
			{
				printf("."); /* show it. */
				i2 = 0;
			}
		}
		printf("\n");	/* next line for menu. */
	}
	else
		i1 = *j1;	/* read our own board id. */
	emulate = 0;	/* clear this again. */
	if(got_berr)	/* failed. */
	{
		printf("Failed to read own board ID. (bus error)\n");
		return(1);
	}
	if(i1 & 0x000000ff) /* if it's failed. */
	{
		printf("Failed ID read.(%08X)\n", i1);
		return(1);
	}
	return(0);
}


ack_int(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned mapnum=0,*addr;
	register unsigned slotadd=0xf,slotnum,level;
	register unsigned char *i;

	slotnum=LastCpu;
	level = (unsigned)atox(comm_args[1]);
	i=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*i = (slotnum << 4) | slotadd;
	addr=(unsigned *)(0x8fffff04 | (level << 3));
	printf("\nInterrupt data = %8x\n",*addr);
}

struct int_data {
	unsigned char vector;
	unsigned char level;
	unsigned char ds_slot;
	unsigned char io_slot;
};


qstat(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned char *i,vector,dest_slot,src_slot,lvl,io_src_slot;
	register unsigned cpu_num,level,*pntr_addr,queue_data;
	register unsigned in_pntr,out_pntr;
	register struct int_data *queue_addr;

	cpu_num = (unsigned)atox(comm_args[1]);
	if((cpu_num > 0x0e) || (cpu_num < 0)) {
		printf("\nInvalid CPU\n");
		return;
	}
	if(arg_cnt > 1) {
		level = (unsigned)atox(comm_args[2]);
		if(level <= 3) {
			printf("\nThis command functions only with directed level interrupts.\n");
			return;
		}
		if((level != 5) && (level != 4)) {
			printf("\nInvalid level\n");
			return;
		}
	}
	/* request rams */
	*WRCNTL1 &= ~WR1_DREQ;
	if(level == 4) {
		pntr_addr = POINTER_RAM + cpu_num;
		queue_addr = (struct int_data *)(0x0c002000 | (cpu_num << 8));
	}
	else {
		pntr_addr = POINTER_RAM + (cpu_num + 0x10);
		queue_addr = (struct int_data *)(0x0c003000 | (cpu_num << 8));
	}
	/* look at the pointer value */
	in_pntr = *pntr_addr;
	in_pntr = (in_pntr >> IN_PNTR_SH) & 0x3f;
	out_pntr = *pntr_addr;
	out_pntr = (out_pntr >> OUT_PNTR_SH) & 0x3f;
	if(in_pntr == out_pntr)
		printf("\nCPU %2x has no interrupts in queue for level %2x\n",cpu_num,level);
	else {
	    for( ;out_pntr != in_pntr; ) {
		if(out_pntr == 0)
			out_pntr=0x3f;
		out_pntr--;
		vector = (queue_addr+out_pntr)->vector;
		lvl = (queue_addr+out_pntr)->level;
		dest_slot = ((queue_addr+out_pntr)->ds_slot) >> 4;
		src_slot = ((queue_addr+out_pntr)->ds_slot) & 0x0f;
		io_src_slot = ((queue_addr+out_pntr)->io_slot) & 0x7f;
		printf("\nCPU %2x level %2x vector %2x dest %2x src %2x i/o src %2x ",
		       	cpu_num,level,vector,dest_slot,src_slot,io_src_slot);
	    }
	    printf("\n");
	}
	*WRCNTL1 |= WR1_DREQ;
}

rboard(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	*WRCNTL2 &= ~WR2_BDRST;
	*WRCNTL2 |= WR2_BDRST;
	_restart();
}


immem(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	if(clokpr(0))
		return;
	/* request the dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ;
	mmem(comm_str,arg_cnt);
	*WRCNTL1 |= WR1_DREQ;
}

idmem(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	if(clokpr(0))
		return;
	/* request the dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ;
	dmem(comm_str,arg_cnt);
	*WRCNTL1 |= WR1_DREQ;
}

request(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned *i,j;
	register unsigned cpu_num;

	cpu_num = (unsigned)atox(comm_args[1]);
	if((cpu_num > 0x0e) || (cpu_num < 0)) {
		printf("\nInvalid CPU\n");
		return;
	}
	/* request the dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ;
	/* fill cfig ram with requested cpu number */
	for(i=MISC_RAM; i<MISC_RAM + CONFIG_LWORDS; i++) {
		j = *i;
		/* check that if the count is foxed then bit 10 is zero,
		otherwise write a one */
		if((j & CNTR_MASK) == 0x3ff)
			j &= ~CNTR_ZERO_BIT;
		else
			j |= CNTR_ZERO_BIT;
		*i = (j & ~CONFIG_MASK) | (cpu_num << CONFIG_SH);
	}
	/* reset dispatcher hardware */
	*WRCNTL1 &= ~WR1_ID_RST; 
	*WRCNTL1 |= WR1_ID_RST; 
	/* force SPM to pretend to be the requested cpu */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_PRETEND_MASK) | (cpu_num << WR0_PRETEND_SH);
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) | ((~cpu_num & 0x0f) << 20) | (cpu_num << 16);
	*WRCNTL1 &= ~WR1_FINTREC;
	*WRCNTL1 |= WR1_DREQ;
	LastCpu = cpu_num;
}


irequest(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned char *i;
	register unsigned cpu_num,level;

	cpu_num = (unsigned)atox(comm_args[1]);
	if((cpu_num > 0x0e) || (cpu_num < 0)) {
		printf("\nInvalid CPU\n");
		return;
	}
	level = (unsigned)atox(comm_args[2]);
	if((level > 5) || (level < 0)) {
		printf("\nInvalid level\n");
		return;
	}
	send_int(0, cpu_num,level,cpu_num);
}

irequests(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned cpu_num,level,int_num;
	register unsigned char *i;

	i=(unsigned char*)((unsigned)MAPBASE);
	*i=(0x0b << 4) | 0x0f;
	cpu_num=0;
	/* requests for non-directed interrupts */
/*	for(level=0; level<3; level++) {
		for(int_num=0; int_num<0x7f; int_num++) {	
			send_int(0, cpu_num,level,int_num);
		}
	}		*/
	/* requests for directed interrupts */
	for(level=4; level<6; level++) {
		for(cpu_num=0; cpu_num<0x0f; cpu_num++) {
			for(int_num=0; int_num<0x3f; int_num++) {	
				send_int(0, cpu_num,level,int_num);
			}
		}
	}		
}	


send_int(self,cpu,level,num)
int self;	/* if set, sending to spm. */
unsigned cpu,level,num;
{
	register unsigned *INTREQ = (unsigned *)(0x8fffffa0);

	if(level > 0x03)
		level = (level & 0x03) | 0x80;	/* directed bit set */
	*INTREQ = (num << 24) | (level << 16) | (cpu << 12) |  cpu; 
}
	
