/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) vac.h: version 25.1 created on 11/27/91 at 14:37:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)vac.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


/*			VME Adaptor Card - vac 				*/
/*
 *	vac memory map - for a detailed description refer to vac_desc.h
*/

/*	define a memory map structure for vac 				*/ 
struct vac
{
	/*		vac memory					*/
        unsigned vme_w0[0x2000];	/* i/o window 0 0x0-0x7fff	*/
	unsigned vme_w1[0x1c00];	/* i/o window 1 0x8000-0xefff   */
   	unsigned vac_map[0x200];	/* mapping reg 0xf000-0xf800	*/
 	char	 vac_unused[0x7f4];	/* vac unused area		*/	
	
	/*		vac registers					*/	
	short    vac_addr_mod0;		/* 0xfff4 - 0xfff5 (WO)        	*/
	short    vac_addr_mod1;		/* 0xfff6 - 0xfff7 (WO)		*/
	short    vac_irq_sam;		/* 0xfff8 - 0xfff9 (WO)		*/
	short    vac_irq_ack;		/* 0xfffa - 0xfffb (RO)		*/
	short	 vac_icb_stat;		/* 0xfffc - 0xfffd (RO)		*/
	short	 vac_reset_id;		/* 0xfffe - 0xffff (WO)		*/
};		

/* *******************	define error codes  ***************************	 */

#define INTERRUPT_RECVD		0X0001	/* received an interrupt	 */
#define ICBLVL_ERR1		0x0002	/* received wrong icb rupt level */
#define SIP_ERR1		0X0004	/* expected SIP bit to be set    */
#define SIP_ERR2		0x0008	/* expected SIP bit to be reset  */
#define V_INT_ERR0		0x0010
#define V_INT_ERR1		0x0020
#define V_INT_ERR2		0x0040

/* *******************  define global variables  *********************** */

	struct	vac	*vacptr;
	unsigned char VACFlag,VACIntFlag,VACMode,VACExpInt,VACIntlvl;
	unsigned short Virqreg,VRSTID,Verrcnt,Vmap_acc_wdata;
	unsigned Vsysmem,Vacnt,*v_map;
	unsigned char VACIntRecvd,Vme_int,Vprint,Vauto,VMEFlag,Vmapread;
	unsigned char Vprintloop;

/* ********************************************************************* */

#define CNTL_A			0x01
#define CNTL_E			0x05

#define VME0_BASE		0x0000
#define VME0_END		0x8000

#define VME1_BASE        	0x8000
#define VME1_END        	0xf000


#define VAC_MAP_BASE		0xf000
#define VAC_MAP_END		0xf800
#define VAC_MAP_LENGTH		0x0800

 
#define VAC_MAM_ADD_0		0xfff4
#define VAC_MAM_ADD_1		0xfff6

#define VAC_MAM_MASK          0x001f

/* N_LWORD_0 bit 06 */

#define VAC_N_LWORD	        0x0040
#define VAC_N_LWORD_0_SHIFT	0x6


/* VA15_23_0 bits 07 thru 15 */

#define VAC_VA15_23_MASK	0xff80
#define VAC_VA15_23_SHIFT	0x7

#define VAC_MAM_SHNP	        0x0029 /* short non_privilege - 29 */
#define VAC_MAM_SHS	   	0x002d /* short supervisory - 2D */
#define VAC_MAM_STND	  	0x0039 /* standard non_privilege - 39 */
#define VAC_MAM_STNP	  	0x003a /* standard non_prv program - 3A */
#define VAC_MAM_STSD	  	0x003d /* standard supervisory data - 3D */
#define VAC_MAM_STSP	  	0x003e /* standard supervisory program - 3E */
#define VAC_MAM_D1	  	0x001c /* user defined, use for diagnostics */
				       /* Also see SAM_DIAG  */

#define VAC_IRQ_SAM		0xfff8

/* SAM_x , slave address modifiers,
	   bits 00 thru 05, the following represent the actual valid codes */ 

#define VAC_SAM_MASK            0x001f

#define VAC_SAM_STSB  	        0x003f /* standard supervisory block xfer -3F */
#define VAC_SAM_STNPB    	0x003b /* standard non_privil. block xfer -3B */
#define VAC_SAM_EXSB    	0x000f /* extended supervisory block xfer -0F */
#define VAC_SAM_EXNPB    	0x000b /* extended non_privil. block xfer -0B */
#define VAC_SAM_D1	        0x001c /* user defined, use for diagnostics   */ 

/* TST_HI bit 06 */

#define VAC_TST_HI		0x0040
#define VAC_TST_HI_SHIFT	0x6


/* SINGLE_XFR bit 07 */

#define VAC_SXFR		0x0080
#define VAC_SXFR_SHIFT		0x7


/* GEN_IRQ bit 08 */ 

#define VAC_GEN_IRQ		0x0100
#define VAC_GEN_IRQ_SHIFT	0x8

/* INT_EN bit 09 */

#define VAC_INT_EN		0x0200
#define VAC_INT_EN_SHIFT 	0x9


/* ICB_IRQ_x bits 10-12 */

#define VAC_ICB_IRQ_MASK	0x1c00
#define VAC_ICB_IRQ_SHIFT	0xa

#define VAC_ICB_IRQ1     	0x0400          /* lowest priority  */
#define VAC_ICB_IRQ2     	0x0800
#define VAC_ICB_IRQ3     	0x0c00
#define VAC_ICB_IRQ4     	0x1000
#define VAC_ICB_IRQ5     	0x1400
#define VAC_ICB_IRQ6     	0x1800
#define VAC_ICB_IRQ7     	0x1c00		/* highest priority */
 
/* VME_IRQ_x bits 13-15 */

#define VME_IRQ_MASK		0xe000
#define VME_IRQ_SHIFT		0xd

#define VME_IRQ1     		0x2000		/* lowest priority */
#define VME_IRQ2     		0x4000
#define VME_IRQ3     		0x6000
#define VME_IRQ4     		0x8000
#define VME_IRQ5     		0xa000
#define VME_IRQ6     		0xc000
#define VME_IRQ7     		0xe000		/* highest priority */

#define VME_IRQ_ACK		0xfffa

#define VAC_ICB_RD_STAT		0xfffc

 
/* VME_BERR bit 00 */
#define VAC_VME_BERR     	0x0001

/* LINK_ACTV bit 01 */
#define VAC_LINK_ACTV    	0x0002 
#define VAC_LINK_SHIFT    	0x1 

/* CH_FIFO_EMPT bit 02 */
#define VAC_FIFO_EMPT      	0x0004
#define VAC_FIFO_EMPT_SHIFT 	0x2
 
/* LINK_N_ACK_NACK bit 03 */
#define VAC_LINK_N_ACK_NACK    	0x0008
#define VAC_LINK_N_ACK_NACK_SHIFT      	0x3
 
/* LINK_NAK_RCVD bit 04 */
#define VAC_LINK_NAK_RCVD      	0x0010
#define VAC_LINK_NAK_RCVD_SHIFT	0x4
 
/* CH_ERR_RCVD bit 05 */
#define VAC_CH_ERR_RCVD		0x0020
#define VAC_CH_ERR_RCVD_SHIFT	0x5
 
/* CH_DTB_ACTV bit 06 */
#define VAC_CH_DTB_ACTV		0x0040
#define VAC_CH_DTB_ACTV_SHIFT	0x6
 
/* SYS_OK bit 07 */
#define VAC_SYS_OK     		0x0080
#define VAC_SYS_OK_SHIFT     	0x7

/* BD_TYP bits 08-12 */
#define VAC_BD_TYP 		0x1100
#define VACBDTYP_MASK		0x1f00
#define VACBDTYP_SHIFT   	0x8

 
/* SLV_INT_PEND bit 14 */
#define VAC_SLV_INT_PEND     	0x4000
#define VAC_SLV_INT_PEND_SHIFT 	0xe

#define VAC_RESET_ID	       0xfffe

/* reset/id register contains 13 bits of control information.

/* SEL_MAP_BANK bits 02,03 */
#define VAC_BANK_MASK		0x000c 
#define VAC_BANK_SHIFT		0x2

#define VAC_BANK_0		0x0000 
#define VAC_BANK_1		0x0004 
#define VAC_BANK_2		0x0008 
#define VAC_BANK_3		0x000c 

/* SYS_90X bit 04 */
#define VAC_90X			0x0010 
#define VAC_90X_SHIFT		0x4

/*   FLT_LED bit 05 */ 
#define VAC_FLT_LED		0x0020
#define VAC_FLT_LED_SHIFT	0x5

/*   NRM_LED bit 06 */
#define VAC_NRM_LED		0x0040
#define VAC_NRM_LED_SHIFT	0x6

/*   RUN_LED bit 07 */ 
#define VAC_RUN_LED		0x0080
#define VAC_RUN_LED_SHIFT	0x7

/*   DTB_MSTR_ID bits 08-11 */ 
#define VAC_M_ID_MASK		0x0f00
#define VAC_M_ID_SHIFT		0x8

#define VAC_M_ID4		0x0400
#define VAC_M_ID5		0x0500
#define VAC_M_ID6		0x0600
#define VAC_M_ID7		0x0700

#define VAC_M_ID8		0x0800
#define VAC_M_ID9		0x0900
#define VAC_M_IDA		0x0a00
#define VAC_M_IDB		0x0b00
#define VAC_M_IDC		0x0c00
#define VAC_M_IDD		0x0d00
#define VAC_M_IDE		0x0e00

/*   DTB_SLV_ID bits 12,13 */ 
#define VAC_S_ID_MASK		0x3000
#define VAC_S_ID_SHIFT		0xc

#define VAC_S_ID0		0x0000
#define VAC_S_ID1		0x1000
#define VAC_S_ID2		0x2000
#define VAC_S_ID3		0x3000

/*   CATCH_BERR bit 14 */
#define VAC_BERR		0x4000
#define VAC_BERR_SHIFT		0xe

/*   SOFT_RST bit 15 */ 
#define VAC_SRST		0x8000 
#define VAC_SRST_SHIFT		0xf







