/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) rwicio.h: version 25.1 created on 11/27/91 at 14:37:13	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)rwicio.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
*************************************************************************fil**
**		 ARETE SYSTEMS CORPORATION CONFIDENTIAL AND PROPRIETARY
**	This source is the sole property of ARETE SYSTEMS CORPORATION
**	Reproduction or utilization of this source in whole or in part
**	is forbiden whithout the written consent of 
**	ARETE SYSTEMS CORPORATION.
******************************************************************************
**
**			(c) Copyright ARETE SYSTEMS CORPORATION 1988
**			    All Rights Reserved.
******************************************************************************
**
**	FILE NAME:	rwicio.h
**	TYPE:		C header file
**
**	DESCRIPTION:	This file contains definitions for the CIO chip 
**			Z8036 Z-CIO Counter Timer and Parallel I/O Unit
**			
**
**
******************************************************************************
*/



/*******************************************************************
 *
 *			C   I   O
 *
 *******************************************************************/
struct cio_reg {
	unsigned char reg;
	unsigned char filler;
};

struct cio {
	unsigned char mic;		/* master interrupt control */
	unsigned char fil00;
	unsigned char mcc;		/* master configuration control */
	unsigned char fil10;
	struct cio_reg pivect[2];	/* parallel port interrupt vectors */
	unsigned char ctivect;		/* counter timer interrupt vector */
	unsigned char fil30;
	unsigned char pcdpp;		/* port C data path polarity */
	unsigned char fil40;
	unsigned char pcdd;		/* port C data direction */
	unsigned char fil50;
	unsigned char pcsc;		/* port C special control */
	unsigned char fil60;
	struct cio_reg portcs[2];	/* port command status */
	struct cio_reg ctcs[3];		/* counter timer command status */
	struct cio_reg portdata[3];	/* port data */
	struct ct_cc {
		unsigned char ccmsb;	/* current count MSB */
		unsigned char fila0;
		unsigned char cclsb;	/* current count LSB */
		unsigned char filb0;
	} ctcc[3];
	struct ct_tc {
		unsigned char tcmsb;	/* terminal count MSB */
		unsigned char filc0;
		unsigned char tclsb;	/* terminal count LSB */
		unsigned char fild0;
	} cttc[3];
	struct cio_reg ctmode[3];	/* counter timer mode specification */
	unsigned char curvect;		/* current interrupt vector */
	unsigned char filf0;
	struct cio_port {
		unsigned char pmode;	/* port mode specification */
		unsigned char filg0;
		unsigned char phndshk;	/* port handshake specification */
		unsigned char filh0;
		unsigned char dppolar;	/* data path polarity */
		unsigned char fili0;
		unsigned char dpdir;	/* data path direction */
		unsigned char filj0;
		unsigned char spcntrl;	/* special i/o control */
		unsigned char filk0;
		unsigned char patpolar;	/* pattern polarity */
		unsigned char fill0;
		unsigned char pattrans;	/* pattern transition */
		unsigned char film0;
		unsigned char patmask;	/* pattern mask */
		unsigned char filn0;
	} cioport[2];
};

/******************************************************************************
 *
 * mic --- master interrupt control register (r/w)
 *
 ******************************************************************************/
#define C_RESET    0x01  /* reset the cio chip */
/*#define C_RJUST  0x02  /* right justified addresses */
#define C_RJUST    0x00  /* leave as this for now.. left adjust address. */
#define C_CTVIS    0x04  /* counter timer vector includes status */
#define C_PBVIS    0x08  /* port B vector includes status */
#define C_PAVIS    0x10  /* port A vector includes status */
#define C_NVECT    0x20  /* no vector */
#define C_DLC      0x40  /* disable lower chain */
#define C_MIE      0x80  /* master interrupt enable */

/******************************************************************************
 *
 * mcc --- master configuration control register (r/w)
 *
 ******************************************************************************/
#define C_DISALL   0x00  /* disable all */
#define C_LCMSK    0x03  /* link control mask */
#define C_LCCTI    0x00  /* link control counter timers independant */
#define C_LC1G2    0x01  /* link control counter ct1 out gates ct2 */
#define C_LC1T2    0x02  /* link control counter ct1 out triggers ct2 */
#define C_LC1I2    0x03  /* link control counter ct1 out is ct2 count input */
#define C_PAE      0x04  /* port A enable */
#define C_PLC      0x08  /* port link control */
#define C_PCCT3E   0x10  /* port C and counter timer 3 enable */
#define C_CT2E     0x20  /* counter timer 2 enable */
#define C_CT1E     0x40  /* counter timer 1 enable */
#define C_PBE      0x80  /* port B enable */

/******************************************************************************
 *
 * portcs --- port command status registers (read/partial write)
 *
 ******************************************************************************/
#define P_IOE      0x01  /* interrupt on error */
#define P_PMF      0x02  /* pattern match flag (read only) */
#define P_IRF      0x04  /* input register full (read only) */
#define P_ORE      0x08  /* output register empty (read only) */
#define P_IERR     0x10  /* interrupt error (read only) */
#define P_ICMSK    0xe0  /* interrupt control mask (see interrupt control) */

/******************************************************************************
 *
 * ctcs --- counter timer command status registers (read/partial write)
 *
 ******************************************************************************/
#define CT_CIP     0x01  /* count in progress */
#define CT_TCB     0x02  /* trigger command bit (write only/read 0) */
#define CT_GCB     0x04  /* gate command bit */
#define CT_RCC     0x08  /* read counter control */
#define CT_IERR    0x10  /* interrupt error (read only) */
#define CT_ICMSK   0xe0  /* interrupt control mask (see interrupt control) */

/******************************************************************************
 *
 * ctmode --- counter timer mode specification registers (read/write)
 *
 ******************************************************************************/
#define CT_ODCMSK  0x03  /* output duty cycle */
#define CT_PULSE   0x00  /* pulse output */
#define CT_1SHOT   0x01  /* one-shot output */
#define CT_SQWAV   0x02  /* square wave output */
#define CT_NSPEC   0x03  /* do not specify output */
#define CT_REB     0x04  /* retrigger enable bit */
#define CT_EGE     0x08  /* external gate enable bit */
#define CT_ETE     0x10  /* external trigger enable bit */
#define CT_ECE     0x20  /* external count enable bit */
#define CT_EOE     0x40  /* external output enable bit */
#define CT_CONT    0x80  /* continuous/single cycle* operation */

/******************************************************************************
 *
 * pmode --- port mode specification registers (read/write)
 *
 ******************************************************************************/
#define P_LPM      0x01  /* latch on pattern match */
#define P_PMMSK    0x06  /* pattern mode mask */
#define P_DISPM    0x00  /* disable pattern match */
#define P_ANDMD    0x02  /* and mode */
#define P_ORMD     0x04  /* or mode */
#define P_OPEVM    0x06  /* or-priority encoded vector mode */
#define P_IMO      0x08  /* interrupt on match only */
#define P_SBM      0x10  /* single buffered mode */
#define P_ITB      0x20  /* interrupt on two bytes */
#define P_TYPSEL   0xc0  /* port type select */
#define P_BIT      0x00  /* bit port */
#define P_INPUT    0x40  /* input port */
#define P_OUTPUT   0x80  /* output port */
#define P_BIDIR    0xc0  /* bidirectional port */

/******************************************************************************
 *
 * phndshk --- port handshake specification registers (read/write)
 *
 ******************************************************************************/
#define P_DTSMSK   0x07  /* deskew time specification mask */
#define P_RWSMSK   0x38  /* request/wait* specification mask */
#define P_DISRW    0x00  /* disable request/wait */
#define P_OUTW     0x08  /* output wait */
#define P_INPW     0x18  /* input wait */
#define P_SPRQ     0x20  /* special request */
#define P_OUTRQ    0x28  /* output request */
#define P_INPRQ    0x38  /* input request */
#define P_HTS      0xc0  /* handshake type specification */
#define P_HINTL    0x00  /* interlocked handshake */
#define P_HSTROBD  0x40  /* strobed handshake */
#define P_HPULSED  0x80  /* pulsed handshake */
#define P_H3WIRE   0xc0  /* three wire handshake */

/******************************************************************************
 *
 * interrupt control (read and write)
 *
 ******************************************************************************/
/* read */
#define ICR_IP     0x20  /* interrupt pending */
#define ICR_IED    0x40  /* interrupt enabled */
#define ICR_IUS    0x80  /* interrupt under service */
/* write */
#define ICW_NULL   0x00  /* null code */
#define ICW_CPUS   0x20  /* clear interrupt pending and int under service */
#define ICW_SIUS   0x40  /* set interrupt under service */
#define ICW_CIUS   0x60  /* clear interrupt under service */
#define ICW_SIP    0x80  /* set interrupt pending */
#define ICW_CIP    0xa0  /* clear interrupt pending */
#define ICW_SIE    0xc0  /* set interrupt enable */
#define ICW_CIE    0xe0  /* clear interrupt enable */

/*
 * Define Port Name
 *
 */
#define	PORTA	0
#define PORTB	1
#define	PORTC	2


/* 
 * CIO bit assignment for CIO.0 and CIO.1
 */
/*
 * CIO.0 Port A
 */
#define	PS_0_PF		0x01		/* PA0	In */
#define PS_1_PF		0x02		/* PA1	In */
#define PS_2_PF		0x04		/* PA2 	In */
#define PS_3_PF		0x08		/* PA3 	In */
#define PS_4_PF		0x10		/* PA4 	In */	
#define UPS_AC_FAIL	0x20		/* PA5 	In */
#define	UPS_LOW_BATTERY	0x40		/* PA6 	In */	
#define OFF_SW_COPY	0x80		/* PA7 	In  connected  */

/*
 * CIO.0 Port B
 */
#define SSR_0_ON	0x01		/* PB0	Out */
#define SSR_1_ON	0x02		/* PB1	Out */
#define SSR_2_ON	0x04		/* PB2	Out */
#define SSR_3_ON	0x08		/* PB3	Out */
#define SSR_4_ON	0x10		/* PB4	Out */
#define SSR_5_ON	0x20		/* PB5	Out */
#define SSR_6_ON	0x40		/* PB6 	Out */
#define UPS_OFF		0x80		/* PB7	Out */

/*
 * CIO.0 Port C
 */
#define ON_SW		0x01		/* PC0 	In */
#define OFF_SW		0x02		/* PC1 	In */
#define ADTYP		0x04		/* PC2 	In not connected */
					/* PC3 	In not connected */
/*
 * CIO.1 Port A
 * in rev 2B the only bits used in this port 
 * are for the RWI board type at bit 0-2
 */
					/* PA0 In */
					/* PA1 In */
					/* PA2 In */
#define	RWI_TYPE	0x07		/* mask to isolate bit 0-2 */
					/* PA3 	In not connected */
					/* PA4 	In not connected */
					/* PA5 	In not connected */
					/* PA6 	In not connected */
#define	FANALARM	0x80 		/* PA7 	In */
/*
 * CIO.1 Port B
 */
#define	PS_0_MARGIN_POS	0x01		/* PB0 Out */
#define	PS_1_MARGIN_POS	0x02		/* PB1 Out */
#define	PS_2_MARGIN_POS	0x04		/* PB2 Out */
#define	PS_3_MARGIN_POS	0x08		/* PB3 Out */
#define	PS_4_MARGIN_POS	0x10		/* PB4 Out */
#define	PS_0_MARGIN_NEG	0x20		/* PB5 Out */
#define	PS_1_MARGIN_NEG	0x40		/* PB6 Out */
#define	PS_2_MARGIN_NEG	0x80		/* PB7 Out */
/*
 * CIO.1 Port C
 */
#define	PS_3_MARGIN_NEG	0x01		/* PC0 Out */
#define	PS_4_MARGIN_NEG	0x02		/* PC1 Out */
#define WARNING_LITE	0x04		/* PC2 Out */
#define	SYS_ON_LITE		0x08		/* PC3 Out */


#define PWR_TC 		0x73bd		/* 16 ms time delay for pwr on */
#define TIME_OUT	8000		/* time out value for CIO timer */

/*
*************************************************************************end**
**		 ARETE SYSTEMS CORPORATION CONFIDENTIAL AND PROPRIETARY
**	This source is the sole property of ARETE SYSTEMS CORPORATION
**	Reproduction or utilization of this source in whole or in part
**	is forbiden whithout the written consent of 
**	ARETE SYSTEMS CORPORATION.
******************************************************************************
*/ 

#define RWI_CIO0 ((struct cio *)(0x02800a00))
#define RWI_CIO1 ((struct cio *)(0x02800c00))
#define	RWI_CIO0_PORTA	((unchar *)(0x02800a1a))
#define	RWI_CIO0_PORTB	((unchar *)(0x02800a1c))
#define	RWI_CIO0_PORTC	((unchar *)(0x02800a1e))
#define	RWI_CIO1_PORTA	((unchar *)(0x02800c1a))
#define	RWI_CIO1_PORTB	((unchar *)(0x02800c1c))
#define	RWI_CIO1_PORTC	((unchar *)(0x02800c1e))

#define POWR_LED_ON	 *RWI_CIO1_PORTC = (*RWI_CIO1_PORTC & 0x0f) | SYS_ON_LITE
#define POWR_LED_OFF *RWI_CIO1_PORTC = (*RWI_CIO1_PORTC & 0x0f) & ~SYS_ON_LITE
#define WARN_LED_ON  *RWI_CIO1_PORTC = (*RWI_CIO1_PORTC & 0x0f) | WARNING_LITE
#define WARN_LED_OFF *RWI_CIO1_PORTC = (*RWI_CIO1_PORTC & 0x0f) & ~WARNING_LITE

/*
 *	key position defines
 */

#define		KEY_OFF		0
#define		KEY_ON		1


#define	ACRW_HERE ((unsigned char)(struct cio *)RWI_CIO1->portdata[PORTA].reg &\
			(unsigned char)ACRW)

