/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mac.h: version 25.1 created on 11/27/91 at 14:36:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mac.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * M A C - Multibus Adapter Card
 *
 * description of MAC board and definitions to that affect
 */

struct mac_int {
	short type;	/* interrupt type */
	short value;	/* interrupt value */
};

struct mac {
	char	shram[0x7ffb];	/* shared ram (static) */
	struct	mac_int intrpt;	/* interrupt synchronization */
	char	mbram[0x4000],	/* multibus external ram (may not be there) */
		mbios[0x3ff8];	/* multibus I/O space (may not be there) */
	unsigned
	short	intreg,		/* interrupt control register (WO) */
		basreg,		/* ram base address registers (WO) */
		stsreg,		/* status register (RO) */
		rstreg;		/* reset register (WO) */
};

/*
 * MAC ioctl call definitions
 */
#define	MAC_INTREG 0	/* ioctl( fd, MAC_INTREG, (MACRESET|...|MACMTRLA) ) */
#define	MAC_BASREG 1	/* ioctl( fd, MAC_BASREG, &short_int ) */
#define	MAC_STSREG 2	/* ioctl( fd, MAC_STSREG, &short_int ) */
#define	MAC_RESET  3	/* ioctl( fd, MAC_RESET, 0 ) */
#define	MAC_WAIT   4	/* ioctl( fd, MAC_WAIT, &short_int ) */

/*
 * the definition of mbios structure is left to Multibus specific
 * include files
 */

/*
 * the structure of intreg is as follows:
 *
 *	+-------------------------------+-------------------------------+
 *	|   | 4 | 2 | 1 |   |   |   |   |             UNUSED            |
 *	+-^---^---^---^---^---^---^---^-+-------------------------------+
 *        |   |   |   |   |   |   |   |
 *        |   +---+---+   |   |   |   |
 *	  |       |       |   |   |   Motorola/Intel
 *        |       |       |   |   LED 0
 *        |       |       |   LED 1
 *        |       |       Unused
 *        |       Interrupt Level
 *        Interrupt Enable
 */
#define	MACINTENB	0x8000
#define	MACINTPRI	(((VECMAC) & 7) << 4)
#define	MACGRNLED	0x0400
#define	MACREDLED	0x0200
#define	MACINTEL	0x0100
#define	MACYLWLED	0x0000
#define	MACMTRLA	0x0000

/*
 *
 * the structure of basreg is as follows:
 *
 *	+-----------------------+-----------------------+
 *	|21|20|19|18|17|16|15|  |21|20|19|18|17|16|15|14|
 *	+-----------------------+-----------------------+
 *         Shared Ram Base         IEEE 796 memory base
 *
 * ICB access to shared ram (IEEE-796 address)
 *
 *  +-----------------------------------------------------------------------+
 *  |23|22|21|20|19|18|17|16|15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
 *  |0 |0 |shared ram base addr|         ICB address                     |  |
 *  +-----------------------------------------------------------------------+
 *
 * ICB access to IEEE-796 ram (IEEE-796 address)
 *
 *  +-----------------------------------------------------------------------+
 *  |23|22|21|20|19|18|17|16|15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
 *  |0 |0 | IEEE-796 base addr    |      ICB address                     |  |
 *  +-----------------------------------------------------------------------+
 *
 * ICB access to IEEE-796 I/O (IEEE-796 address)
 *  +-----------------------------------------------------------------------+
 *  |23|22|21|20|19|18|17|16|15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
 *  |0 |0 |0 |0 |0 |0 |0 |0 |0 |0 |      ICB address                     |  |
 *  +-----------------------------------------------------------------------+
 *
 * IEEE-796 access to shared ram(IEEE-796 address)
 *
 *  +-----------------------------------------------------------------------+
 *  |23|22|21|20|19|18|17|16|15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
 *  |0 |0 |shared ram base addr|         IEEE-796 address                |  |
 *  +-----------------------------------------------------------------------+
 */

/*
 * the structure of stsreg is as follows:
 *
 *	+-----------------------+-----------------------+
 *	|0 |  |0 |  BOARD TYPE  |         UNUSED        |
 *	+---^-------------------+-----------------------+
 *	    |
 *	    Interrupt received/pending (to cpu)
 */
#define	MACGETBRD(x)	(((x) & 0x1f00) >> 8)
#define	MACINTPDG(x)	((x) & 0x4000)

/*
 * the structure of rstreg is as follows:
 *
 *	+-----------------------+-----------------------+
 *	|  |                 UNUSED                     |
 *	+^----------------------+-----------------------+
 * 	 |
 *	 Reset Board ( must be asserted for >= 5ms )
 */
#define	MACRESET	0x8000
