/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ioa0.h: version 25.1 created on 11/27/91 at 14:36:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ioa0.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* ioa0.h */

/* IOA addresses of interest */

/* IOA COMMAND REGISTER */
#define IOA_CMD_REG (0xffffeff4)	/* r/w IOA command register */
#define MOD_TYPE 	0x00000007	/* module type */
#define ICB_ADDR_21	0x00000008	/* ICB address 21 */
#define ICB_ADDR_22	0x00000010	/* ICB address 22 */
#define ICB_RD		0x00000020	/* ICB read bit */
#define ICB_UDS		0x00000040	/* ICB upper data strobe */
#define ICB_LDS		0x00000080	/* ICB lower data strobe */
#define DTB_SLV_BID	0x00000f00	/* DTB Slave Board ID mask */
#define DTB_BID_SH	8
#define DTB_FNC		0x0000f000	/* DTB function mask */
#define DTB_FNC_SH 	12
#define DTB_POLL_MASK	0x00070000	/* polling mode mask */
#define	DTB_TEST	0x00060000	/* DTB test polling mode */
#define DTB_POLL_SH 	16
#define IOA_INT_TEST_SH 19		/* 5 bits */
#define DN_LK_ERR	0x00100000	/* Down link command Error */
#define ICB_TIME_OUT	0x00200000	/* ICB timeout error */
#define ICB_BUS_ERR	0x00400000	/* ICB bus error */
#define DTB_DIAG_ACK	0x10000000	/* DTB diagnostic command ACK */
#define DMA_LK_Q_OFF	0x02000000	/* DMA link queue hold off */
#define IOA_DIAG_RD 	0x04000000	/* ICB diagnostic read mode */
#define ADDR_MODE	0x08000000	/* Addr mode, LK is 28/32 bit */
#define FRC_BAD_LK_CMD	0x10000000	/* DTB command ACK */
#define DTB_EN		0x20000000	/* DTB enable */
#define IOA_INT_EN	0x40000000	/* Interrupt enable */
#define IOA_RESET	0x80000000	/* reset adapter */



/* ICB error status latch masks, shifts, functions, etc. */

#define IOA_ERR_REG	0xffffeff8  	/* read this to clear errors */
#define DN_LK_CMD_ERR	0x00000001	/* down link command error */

#define ERR_OV_RUN	0x80000000	/* error overrun */

#define SLOT_MASK	0x78000000	/* Sbus slot that requested operation */
#define SLOT_SH 	27
#define SBUS_SLOT(x)  	((x & SLOT_MASK) >> SLOT_SH)

#define LK_CMD_MASK	0x07e00000	/* Link command type */
#define LK_CMD_SH 	21
#define LINK_CMD(x)  	((x & LK_CMD_MASK) >> LK_CMD_SH)
#define ICB_ADDR_MASK 	0x001ffffe



/* DTB diagnostic command write */
/*    address range: ffffe000 - ffffe3fc
33         2         1
10987654321098765432109876543210
1111111111111111111000xxxxyyyy00
                        |  |
                        |  +--- DTB Slave Board ID
                        |
                        +----- DTB Function
*/
#define DTB_DIAG_CMD	0xffffe000
#define FNC_SH  	6
#define ID_SH	  	2

/* board id's used... */

/* Loop back test area */
#define S_LOOP_ADDR 	0x130000	/* Start address of loop test area */
#define E_LOOP_ADDR 	0x13ffff	/* End   address of loop test area */


#define MAX_IO_SLOT	0x13		/* maximum IOSS slots */
#define MAX_SSIO	0x04		/* maximum IOSS systems */
#define IO_BDID_MASK	0x1f00		/* maximum IOSS systems */

#define RW_SH		30		/* Sbus read/write bits shift */
#define RD_SBUS		0		/* read	 Sbus */
#define WR_SBUS		1		/* write Sbus */

#define MEM1	 	0x1000
#define MEM2		0x2000
#define MEM3	 	0x3000
#define MEM4		0x4000
#define LEN  		0x1000

#define WD1	 	2
#define WD0	 	1
#define WD2	 	9
#define DTB_RST		4
#define DMA_W 		0x80000000	/* write */
#define IO_SH   	24		/* IO board DTB ID number */
#define MEM_SH  	20		/* memory board slot number shift */
#define CH_LK_ACT	0x04000000	/* channel link active */
#define CH_DTB_ACT	0x80000000	/* channel DTB  active */
#define CH0		0x00000000	/* dma channel 0 */
#define CH1		0x00000001	/* dma channel 1 */
#define CH2		0x00000002	/* dma channel 2 */
#define CH3		0x00000003	/* dma channel 3 */
