/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dev.h: version 25.1 created on 11/27/91 at 14:35:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dev.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ifndef DEV_H
#define DEV_H

/*
 * defines for device types
 */

#define	DV_EDT	0x100
#define DV_SCSI	0x200
#define DV_IOPM	0x400

#define DV_DK		0x01
#define DV_RV		0x02
#define DV_MT		0x03
#define DV_9T		0x04
#define DV_FLP		0x0F

#define DV_NO_DEV	0x00
#define DV_HELP_REQUEST 0xff
#define	BOOT_TYPE_MASK	0xFF

#define DV_EDT_DK	(DV_EDT | DV_DK)
#define DV_EDT_RV	(DV_EDT | DV_RV)
#define DV_EDT_MT	(DV_EDT | DV_MT)
#define DV_EDT_9T	(DV_EDT | DV_9T)

#define DV_SCSI_DK	(DV_SCSI | DV_DK)
#define DV_SCSI_RV	(DV_SCSI | DV_RV)
#define DV_SCSI_MT	(DV_SCSI | DV_MT)
#define DV_SCSI_9T	(DV_SCSI | DV_9T)

#define DV_IOPM_DK	(DV_IOPM | DV_DK)
#define DV_IOPM_RV	(DV_IOPM | DV_RV)
#define DV_IOPM_MT	(DV_IOPM | DV_MT)
#define DV_IOPM_9T	(DV_IOPM | DV_9T)


/*	iob.i_unit
 *         format: xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
 *		   css_slot sub_slot   pd #     ld_# 
 *
 *	controller number is used as an index into the dev_slot array.
 */
#define	I_UNIT_CSS_SLOT		0
#define	I_UNIT_SUB_SLOT		1
#define	I_UNIT_PD_NUM		2
#define	I_UNIT_LD_NUM		3

#define	I_UNIT_CONTROLLER	0x10
#define	I_UNIT_DEV_NUM		0x11

#define NO_SUB_SLOT		((uchar)0xff)

#define	RV_STRING		"rv"
#define DEV_NAMLEN		80

#define	MAX_DEV			64

struct dev_slot {
	ushort	dev_id;		/* DV_EDT, DV_SCSI, DV_IOPM, DV_??? */
	uchar	css_slot;
	uchar	sub_slot;	/* icb slot for iom, NO_SUB_SLOT otherwise */
	union {
		struct icb_config	*icb;
		struct css_config	*css;
	} board;
} ; 


#endif /* DEV_H */
