/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) excpt_img.c: version 25.1 created on 11/27/91 at 14:35:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)excpt_img.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*------------------------------------------------------------------------------
	This module contains the interrupt service routines for the Service
	Processor board.
------------------------------------------------------------------------------*/

#include "globl.h"
#include "misc.h"
#include "spm.h"
#include "ascc.h"
#include "rwicio.h"
#include "bus.h"
#include "iom.h"
#include "types.h"
#include "ring.h"
#include "disp.h"

struct ring ringer[MAXRING];	/* allow lots of them.. */
char int_head;			/* global pointer into ringer */
char int_tail;			/* global pointer into ringer */
char int_flag;			/* global int counter. */

char iom_addr_flag;	/* global int counter. */
char l5int;		/* global interrupt flag */
char dummiebd;		/* this is set if we DON'T want to increment ready. */
char cpuack;		/* set if we want to only print out junk. */
char cpuacked;		/* set if we were acked by a cpu. */
char got_berr;		/* set if we got bus error */
char berr_cnt;		/* set if we got bus error */
char emulate;		/* set if we want recover bus error */
unsigned char	dtcintp;

extern unsigned char bdhere[];			/* slots for CSS board's... */
extern char ignore_it;	/* If set, ignore CSS bus errors. */
char ignored;	/* If set, we ignored a bus error. */
extern char cputest2;	/* If set, we ignored a bus error. */
extern char disptest;	/* set if we want to only ack ourselves.. */
extern char ack5;	/* set if we want to only ack ourselves.. */
extern char ack6;	/* set if we want to only ack ourselves.. */
extern int  acks5;	/* number of ack's already. */
extern int  acks6;	/* number of ack's already. */
extern unsigned *jack5;	/* pointer to ack level 5's. */
extern unsigned *jack6;	/* pointer to ack level 5's. */
extern int ackdat5;	/* data from ack level. */
extern int ackdat6;	/* data from ack level. */
extern unsigned char io_int_test; /* io interrupt test flag */
extern char diskflg;	/* if doing disk reads,set this. */
extern char booting;

unsigned char i_cnt;	/* global int counter. */

#define ctl_S 0x13
#define ctl_Q 0x11
#define ctl_Z 0x1a

int stack_ptr;
union location *sim_addr;
unsigned	sim_data;
extern unsigned char HndlBerr,MemSimFlag;
extern char edactest;
extern char ipcctest;		/* if set, in special ipcc test mode. tgm. */
extern char overflow;		/* if set, in special dispatcher test mode. */
extern char resp_ov_test;	/* if set, in special simulation test mode. */
extern char no_resp;		/* if set, in special simulation test mode. */
extern char mis;		/* if set, in special simulation test mode. */
extern char iom_tst_flag;	/* if set, in special simulation test mode. */
extern char tstdisp;		/* this is set to zero when we want to. */
extern char badcss;		/* if in test mode, and we got one of these.. */
extern char tsterrs;		/* this is set to zero when we want to. */
extern char free_slot;		/* this is set to 0xff when slot not use. */

buserr(d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,PC,internal6,internal10,internal14,internal18)
unsigned d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,internal6;
unsigned internal10,internal14,internal18;
unsigned short *PC;
{
	register copy_from, copy_to;
	register unsigned char value;
	register unsigned fault_addr,mapnum;
	register unsigned char slotnum,slotadd,size;
	register unsigned char *i;
	register int	 	errdata;
	unsigned short 		ssw;

	errdata = *CSSERROR;
	*WRCNTL0 &= ~WR0_FRC_INH7; /* disable it.. eh? */
	switch(HndlBerr)
	{
	case TRUE:
		if(ifesc())
			value=IntToMon;
		else	{
			value= 0;	/* repeat bus error cycle */
		}
		break;
	case FALSE:
		fault_addr = ( (internal14 << 16) | (internal18 >> 16) );
		printf("\nData cycle fault address = %x\n", fault_addr);
		if ( (fault_addr >> 31) == 1 )
		{
			printf("CSS bus time-out error\n");
			mapnum = ( (fault_addr & 0x70000000) >> 28 );
			printf("Map#: %x",mapnum);
			i =(unsigned char *)((unsigned)MAPBASE | (mapnum <<28));
			slotadd = (*i & 0x0f);
			slotnum = (*i >> 4) & 0x0f;
			printf("  Map slot :%x  Map address :%x\n",slotnum,slotadd);
		}
		else
		{
			printf("\nBus time-out error\n");
		}
		ssw = internal10 >> 16 ;
		if (ssw & 0x0040)
			printf("\nREAD");
		else
			printf("\nWRITE");
		size = ( (ssw & 0x0030) >> 4 );
		switch(size)
		{
			case 0:
				printf(" 4 byte");
				break;
			case 1:
				printf(" 1 byte");
				break;
			case 2:
				printf(" 2 byte");
				break;
			case 3:
				printf(" 3 byte");
				break;
		}
		report(internal6,PC,SR,&d0);
		dobufprint();	/* go do a print routine. */
		value=IntToMon;
		break;
	}
	/* check what type of stack frame */
	if ((internal6 & 0xf0000000) == 0xa0000000) 
	{
		/* short stack frame so change stack frame to 4 word */
		asm("mov.l	%sp,stack_ptr");
		internal6 = internal6 & 0x0fffffff;
		copy_from = (int)&internal6;
		copy_to = (int)copy_from + 24;
		while (copy_from >= stack_ptr)  {
			*(short *)copy_to=*(short *)copy_from;
			copy_to -= 2;
			copy_from -= 2;
		}
		asm("mov.l	%sp,%d0");
		asm("add.l	&24,%d0");
		asm("mov.l	%d0,%sp");
		asm("mov.l	%a6,%d0");
		asm("add.l	&24,%d0");
		asm("mov.l	%d0,%a6");
	}
	else if ((internal6 & 0xf0000000) == 0xb0000000) 
	{              /* long stack frame */
		asm("mov.l	%sp,stack_ptr");
					/* change stack frame to 4 word */
		internal6 = internal6 & 0x0fffffff;
		copy_from = (int)&internal6;
		copy_to = (int)copy_from + 84;
		while (copy_from >= stack_ptr)  {
			*(short *)copy_to=*(short *)copy_from;
			copy_to -= 2;
			copy_from -= 2;
		}
		asm("mov.l	%sp,%d0");
		asm("add.l	&84,%d0");
		asm("mov.l	%d0,%sp");
		asm("mov.l	%a6,%d0");
		asm("add.l	&84,%d0");
		asm("mov.l	%d0,%a6");
	}
	*WRCNTL0 |= WR0_FRC_INH7; /* enable it.. eh? */
	return(value);
}

badinst(d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,PC,internal6)
unsigned d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,internal6;
unsigned short *PC;
{
	rprintf("\nIllegal instruction");
	report(internal6,PC,SR,&d0);
	dobufprint();	/* go do a print routine. */
	return(IntToMon);
}

badexcept(d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,PC,internal6)
unsigned d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,internal6;
unsigned short *PC;
{
	rprintf("\nBad exception");
	report(internal6,PC,SR,&d0);
	dobufprint();	/* go do a print routine. */
	return(IntToMon);
}

zerodivide(d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,PC,internal6)
unsigned d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,internal6;
unsigned short *PC;
{
	rprintf("\nZero divide");
	report(internal6,PC,SR,&d0);
	dobufprint();	/* go do a print routine. */
	return(IntToMon);
}

priverror(d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,PC,internal6)
unsigned d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,internal6;
unsigned short *PC;
{
	rprintf("\nPrivilege violation");
	report(internal6,PC,SR,&d0);
	dobufprint();	/* go do a print routine. */
	return(IntToMon);
}

addresserror(d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,PC,internal6)
unsigned d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,internal6;
unsigned short *PC;
{
	rprintf("\nAddress error");
	report(internal6,PC,SR,&d0);
	dobufprint();	/* go do a print routine. */
	return(IntToMon);
}

formaterror(d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,PC,internal6)
unsigned d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,SR,internal6;
unsigned short *PC;
{
	rprintf("\nFormat error");
	report(internal6,PC,SR,&d0);
	dobufprint();	/* go do a print routine. */
	return(IntToMon);
}


/*
 * handle autovectors
 */

autoint(d0,d1,a0,a1,level)
register unsigned level;
{
	register unsigned css_level,err,disp_err;
	register i, i1, i2;
/*	con_out('A');	/* show here. */
	switch(level)
	{
	case 1:	/* dispatcher error */
/*		con_out('B');	/* show here. */
		disp_err = *DISPERROR;
		err = (disp_err >> DISP_ERR_SH) & 0x07;
		switch(err)
		{
		case 1:	/* insane ack error */
/*			con_out('C');	/* show here. */
			*WRCNTL1 &= ~WR1_DREQ;
			*WRCNTL1 &= ~WR1_FRC_RST_ACK;
			*WRCNTL1 |= WR1_FRC_RST_ACK;
			*WRCNTL1 |= WR1_DREQ;
			if(booting)
			{
				iready(); /* increment the ready, since this is excpected.*/
				break; /* and exit this routine. */
			}
			printf("\nACK (with no purpose)");
			break;
		case 2: /* request with no int. pending */
/*			con_out('D');	/* show here. */
			printf("\nHardware failure (request with none pending");
			*WRCNTL1 &= ~WR1_DREQ;
			break;
		case 5:	/* timeout on ack response */
/*			con_out('E');	/* show here. */
			printf("\nACK (bus error on ACK response)");
			*WRCNTL1 &= ~WR1_FRC_RST_ACK;
			*WRCNTL1 |= WR1_FRC_RST_ACK;
			*WRCNTL1 &= ~WR1_DREQ;
			iready();
			break;
		case 6:	/* timeout on request */
/*			con_out('F');	/* show here. */
			printf("\nRequest error");
			*WRCNTL1 &= ~WR1_DREQ;
			break;
		case 3: /* undefined error is now receive error. */
/*			con_out('G');	/* show here. */
		case 7:	/* receive error */
/*			con_out('H');	/* show here. */
			if(!tstdisp)
				printf("\nReceive error (queue full)");
			else
				overflow++;	/* increment the dispatcher error counter. */
			*WRCNTL1 &= ~WR1_FRC_RST_RCV; /* */
			*WRCNTL1 |= WR1_FRC_RST_RCV; /* Clear out the received error. */
			*WRCNTL1 &= ~WR1_DREQ;  /* then reset the dispatcher, */
			*WRCNTL1 |= WR1_DREQ;  /*  and start it up again. */

			iready();
			break;
		default:
/*			con_out('I');	/* show here. */
			printf("\nUndefined dispatcher error");
			*WRCNTL1 &= ~WR1_DREQ;
			break;
		}
		if(!tstdisp)
			printf("\nDispatcher error register = %8x\n",disp_err);
		break;
	case 2:	/* CSS command register write */
/*tgm		con_out('J');	/* show here. */

		if(tsterrs && (!ipcctest))	/* if in test mode, skip this.. eh? */
		{
#ifdef DEBUG
	printf("Autovec2: tsterr=%x\n",tsterrs);
#endif
			badcss++;		/* show we got one here. */
			i = *STATUSREG;		/* get command data */
			i = *CSSERROR;		/* get error data. */
			i = *CSSCMD;		/* get command data. */
			iready();		/* all done.. quick! */
			break;
		}

		if(cpuack && !((*STATUSREG >> 8) & 0xff)) /* Yes, we want this.. */
		{
#ifdef DEBUG
	printf("Autovec2: cpuack = %x\n",cpuack);
#endif
			*WRCNTL0 &= ~WR0_FRC_INH7; /* disable it.. eh? */
			i = *STATUSREG;		/* get command data */
			i = *CSSERROR;		/* get error data. */
			i = *CSSCMD;		/* get command data. */
			cpuacked= 1;		/* show we where here. */
			if(!dummiebd)		/* if we want this.. */
				iready();	/* all done.. quick! */
			*WRCNTL0 |= WR0_FRC_INH7; /* enable it.. eh? */
			break;
		}

		if(ipcctest) {			/* I was expecting this to happen. */
#ifdef DEBUG
	printf("Autovec2: ipcctest=%x\n",ipcctest);
#endif
			ipccint();			/* Service the interrupt. */
			iready();			/* all done.. quick! */
			break;
		}

		if(edactest)	/* edac testing is in progress. */
		{
#ifdef DEBUG
	printf("Autovec2: edac = %x\n",edactest);
#endif
			syndr();
			i = *CSSCMD; /* get command data. */
			break;
		}

		if(!io_int_test)
			int_flag++;		/* show one more command here.*/

		*WRCNTL0 &= ~WR0_FRC_INH7;					/* disable it.. eh? */
		ringer[int_head].intcmd = *CSSCMD;			/* save command data. */
		ringer[int_head].intstatus = *STATUSREG;	/* save command data */
		ringer[int_head].interr = *CSSERROR;		/* save error data. */
		int_head++;						/* now leave room for next one. */
		if(int_head == MAXRING)			/* if it's at the limit.. */
			int_head = 0;				/* reset to start of limit. */
		*WRCNTL0 |= WR0_FRC_INH7;		/* enable it.. eh? */
		if(!dummiebd)					/* if we want this.. */
			iready();					/* all done.. quick! */
		break;

	case 3:					/* nothing */
/*		con_out('K');		/* show here. */
		dtcintp++;
		if(disptest)		/* if we are testing dispatcher. */
		{
			if(ack5)	/* if we are to ack level 5's.. */
			{
				ackdat5 = *jack5;	/* ack this level.. */
				acks5++;	/* count number of times in here. */
			}
			else if(ack6)	/* if we are to ack level 6's.. */
			{
				ackdat6 = *jack6;	/* ack this level.. */
				acks6++;	/* count number of times in here. */
			}
		}
		else
		{
			if (!io_int_test && !diskflg)
				int_flag++;  /* show one more command here..*/
			if (io_int_test)
				i_cnt++;   /* increment iom interrupt count */
			if (iom_tst_flag)
				iom_berr();
		}
		break;
	case 4:
/*		con_out('L');	/* show here. */
	case 5:	/* peripherial int */
/*		con_out('M');	/* show here. */
		l5int = 1;
		break;
	case 6:	/* floppy */
/*		con_out('N');	/* show here. */
		printf("\nAuto vector level %x",level);
		break;
	case 7:	/* CSS bus error */
/*		con_out('O');	/* show here. */
		if(tsterrs || cputest2)	/* If we are doing things. */
		{
			if(!ignore_it)	/* if we are to ignore this.. */
			{
				if (!io_int_test && !cputest2)
					int_flag++;	/* show one more command here..*/
			}
			else
				ignored++;	/* show I was here. */
			*WRCNTL0 &= ~WR0_FRC_INH7; /* disable it.. eh? */
			ringer[int_head].intcmd = *CSSCMD; /* save command data. */
			ringer[int_head].intstatus = *STATUSREG; /* save command data */
			ringer[int_head].interr = *CSSERROR; /* save error data. */
			if(!ignore_it)
				if(!cputest2)
				   int_head++;	/* now leave room for next one. */
			if(int_head == MAXRING) /* if it's at the limit.. */
				int_head = 0;	/* reset to start of limit. */
			*WRCNTL0 |= WR0_FRC_INH7; /* enable it.. eh? */
			iready();	/* all done.. quick! */
			break; /* exit the routine.. */
		}
		if(MemSimFlag)
			handle_msim();
		else
			if(iom_tst_flag || HndlBerr)
				iom_berr();
			else
				handle_berr();
		break;
	default:
/*		con_out('P');	/* show here. */
		printf("\nAuto vector level out of range (%8d)",level);
		break;
	}
}


extern unsigned char t_4_rd;
extern unsigned char rd_2;
extern int errstore;
handle_msim()
{
	register union location *addr;
	register unsigned char offset,*dataptr,count;
	register unsigned type,size,dl0,dl4,*dlm4;
	unsigned data;
	register unsigned char dest,src;
	unsigned char maddr,*cmem;

	errstore = *CSSERROR;		/* read err reg */
	/* get destination */
	dest = (errstore & DEST_MASK)>>DEST_SH;
	src = (errstore & SRC_MASK)>>SRC_SH;
	type = (errstore & TYPE_MASK) >> TYPE_SH;
	size = (errstore & SIZE_MASK) >> SIZE_SH;
	switch(type) {
	case BUSRD:
		addr = (union location *)(*(unsigned *)PIPEADDR);
		addr = (union location *)((unsigned)addr & 0xfffffff8);
		sim_addr = addr;	/* save addr for debug purpose */
		if(size <= 4)
			count = 1;
		else if(size == 5)
			count = 2;
		else if(size == 6)
			count = 4;
		else {
			iready();
			break;
		}

		if (!no_resp)	{
			if(mis)		/* if resp src mis-match test flag ? */
			   force_sp_slot(free_slot); /* force SPM non-exist slot */
			for(;count >0 ; count--) {
				dl0 = addr->lword;
				addr = (union location *)((unsigned *)addr+1);
				dl4 = addr->lword;
				addr = (union location *)((unsigned *)addr+1);
				/* set forced type to data response */
				*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | DATARESP;
				/* set forced response low */
				*WRCNTL1 &= ~WR1_FRES;
				/* use forced type */
				*WRCNTL1 &= ~WR1_UFTYPE;
				*WRCNTL0 = (*WRCNTL0 & ~WR0_FADD01_MASK) |
			    	((dl4 << WR0_FADD01_SH) & WR0_FADD01_MASK);
				*MAP7 = (unsigned char)((src << 4)|((dl4 & 0xf0000000) >> 28));
				dlm4 = (unsigned *)((dl4 & 0xfffffffc) | 0xf0000000);
				*dlm4 = dl0;
			}
			*WRCNTL1 |= WR1_UFTYPE;
			*WRCNTL1 |= WR1_FRES;
			if(mis)		/* if resp src mis-match test flag ? */
			   force_sp_slot(dest); /* recover SPM slot */
			if (t_4_rd)	{ /* added by YVC at 2/1/88 for testing IOM */
				rd_2 += 1;
				if (rd_2 == 2) {
				   cmem = (unsigned char *)ULCTL;
				   maddr = (unsigned char)CSSADD((unsigned)cmem);
				   cmem = (unsigned char *)CSSMAP((unsigned)cmem);
				   cssmap(MAP00,src,maddr);
				   *cmem = 0x20;

					/* ul_inh(src); */
					/* dl_inh_n(src); */
				   cmem = (unsigned char *)DLCTL;
				   cmem = (unsigned char *)CSSMAP((unsigned)cmem);
				   *cmem = 0x0;
					count = 5;
					while (count)
						count--;
					/* dl_inh(src); */
				   *cmem = 0x20;
				}
			}
			if (resp_ov_test)	{
				rd_2 += 1;
				if (rd_2 == 3) 	{
					sim_off();
				}
			}
		}
		iready();
		break;
	case BUSWR:
		addr = (union location *)(*(unsigned *)PIPEADDR);
		sim_addr = addr;	/* save addr for debug purpose */
		data = *(unsigned *)PIPEDATA;
		sim_data = data;	/* save data for debug */
		dataptr = (unsigned char *)&data;
		offset = (unsigned)addr & 0x03;
		if (iom_addr_flag)	{
			iready();
			return;
		}
		switch(size) {
		case BYT4:
			if(offset == 0)
				addr->lword = *(unsigned *)dataptr;
			iready();
			break;
		case BYT3:
			if((offset == 0) || (offset == 1)) {
				addr->word = *((unsigned short*)(dataptr + offset));
				addr = 
				  (union location *)((unsigned short *)addr+1);
				offset = offset+2;
				addr->byte = *((unsigned char*)(dataptr + offset));
			}
			iready();
			break;
		case BYT2:
			if(offset != 3)
				addr->word = *((unsigned short *)(dataptr+ offset));
			iready();
			break;
		case BYT1:
			addr->byte = *((unsigned char*)(dataptr + offset));
			iready();
			break;
		default:
			iready();
			break;
		}
	case BUSRESP:
	case BUSCWR:
	default:
		break;
	}
}

char *amsg[] = { /* response message table. */
	"ERROR",
	"ILLEGAL",
	"ERROR DATA 0",
	"ERROR DATA 1",
	"DATA",
	"ILLEGAL",
	"ILLEGAL",
	"ILLEGAL",
};

char *bmsg[] = {	/* read or write message table. */
	"4 byte",
	"1 byte",
	"2 bytes",
	"3 bytes",
	"8 bytes",
	"16 bytes",
	"32 bytes",
	"ILLEGAL",
};

char *cmsg[] = { /* control write message table. */
	"ILLEGAL",
	"ILLEGAL",
	"module DISABLED",
	"module ENABLED",
	"module interface DISABLED",
	"module interface ENABLED",
	"ILLEGAL",
	"ILLEGAL",
};

char *dmsg[] = { /* buss type message table.. */
	"Response: ",
	"",
	"",
	"Read: ",
	"",
	"Write: ",
	"Control write type:",
	"ILLEGAL BIT VALUE",
};

iom_berr()
{
	register unsigned fault,status,i;

	/* printf("\nCSS bus error\n"); */
	status = *STATUSREG; /* read status reg first */
	fault = *CSSERROR;
}

handle_berr()
{
	register unsigned fault,status,i;

	rprintf("\nCSS bus error\n");
	*WRCNTL0 &= ~WR0_FRC_INH7; /* disable it.. eh? */
	status = *STATUSREG; /* read status reg first */
	fault = *CSSERROR;
	if(++berr_cnt < 4)	/* If number of errors is greater than 3, skip. */
		*WRCNTL0 |= WR0_FRC_INH7; /* enable it.. eh? */
	rprintf("Status register = %8x\n",status);
	rprintf("CSS error register = %8x\n",fault);
	if(status & 0x00000001) /* bus nack signal. */
		rprintf("*bus NACK\n");
	if(!(status & 0x00000002)) /* Bus ack signal. */
		rprintf("*NO bus ACK\n");
	if(!(status & 0x00000004)) /* Grant error */
		rprintf("Arbiter grant error\n");
	if(status & 0x00000008) /* detected a CSS bus protocol violation */
		rprintf("SPM detected a protocol violation.\n");
	else
		rprintf("No protocol violation\n");
	if(!(status & 0x00000010)) /* Burst present during error */
		rprintf("Burst is active\n");

	if((fault >> DERR) & 0x01)
		rprintf("Destination error\n");
	if((fault >> SERR) & 0x01)
		rprintf("Source error\n");
	rprintf("Destination = %2x\n",(fault >>DEST_SH) & MASK4);
	rprintf("Source = %2x\n",(fault >>SRC_SH) & MASK4);
	i = ((fault >> 11) & 0x07);
		rprintf("Bus type is %s ", dmsg[i]);	/* show what type */
	if(i == 0)
		rprintf("%s\n", amsg[((fault >> 8) & 0x07)]); /* response type .*/
	else if(i == 3 || i == 5)
		rprintf("%s\n", bmsg[((fault >> 8) & 0x07)]); /* read or write type. */
	else if(i == 6)
		rprintf("%s\n", cmsg[((fault >> 8) & 0x07)]); /* control write type. */
	rprintf("Bus type parity = %1x\n",(fault >> BPAR_SH) & MASK1);
	dobufprint();	/* go do a print routine. */
	berr_cnt--;	/* now, remove this one from stack.. since we printed it. */
	*WRCNTL0 |= WR0_FRC_INH7; /* enable it.. eh? */
}

LCIO_err()
{
	register struct cio *cioptr = LOCCIO;

#ifdef DEBUG
	printf("LOCIO_err:\n");
#endif
	if(cioptr -> ctcs[0].reg & ICR_IP)   /* timer 1 int?*/
		cioptr -> ctcs[0].reg = ICW_CPUS | CT_GCB;
	if(cioptr -> ctcs[1].reg & ICR_IP)   /* timer 2 int?*/
		cioptr -> ctcs[1].reg = ICW_CPUS | CT_GCB;
	if(cioptr -> ctcs[2].reg & ICR_IP)   /* timer 3 int?*/
		cioptr -> ctcs[2].reg = ICW_CPUS | CT_GCB;
}

LCIOt1_int()
{
	register struct cio *cioptr = LOCCIO;

#ifdef DEBUG
	printf("LOCIOt1_int:\n");
#endif
	if(cioptr -> ctcs[0].reg & ICR_IP) {  /* timer 1 int?*/
		cioptr -> ctcs[0].reg = ICW_CPUS | CT_GCB;
		if(++IntCounter == 50) { /* 1 sec */
			IntCounter = 0;
			switch((*WRCNTL2 >> WR2_LED01_SH) & 0x03) {
			case 0x00:
				*WRCNTL2 = (*WRCNTL2 | (WR2_LED0 | WR2_LED1));
				break;
			case 0x01:
				*WRCNTL2 = (*WRCNTL2 | (WR2_LED0 | WR2_LED1))
				    & ~WR2_LED1;
				break;
			case 0x02:
				*WRCNTL2 = (*WRCNTL2 | (WR2_LED0 | WR2_LED1))
				    & (~WR2_LED1 & ~WR2_LED0);
				break;
			case 0x03:
				*WRCNTL2 = (*WRCNTL2 & ~WR2_LED0);
				break;
			}
			++Seconds;
		}
		return;
	}
	printf("Spurious local CIO level 4 interrupt\n");
}

report(internal6,PC,SR,r)
register unsigned *r;
{
	rprintf("\nVector offset = %08x at PC = %08x\nformat = %08x status register = %08x",
		 (internal6>>16) & 0x0fff, PC,(internal6>>28) & 0x0f, (SR & 0xffff));
	rprintf("\nData: %08x %08x %08x %08x ", r[0],r[1],r[2], r[3]);
	rprintf("%08x %08x %08x %08x", r[4],r[5],r[6], r[7]);
	rprintf("\nAddr: %08x %08x %08x %08x ", r[8],r[9],r[10],r[11]);
	rprintf("%08x %08x %08x %08x ", r[12],r[13],r[14],r[15]);
}


togglerte()
{
	if(IntToMon == TRUE) {
		IntToMon = FALSE;
		printf("Exceptions will execute normally\n");
	}
	else {
		printf("Exceptions will enter the monitor\n");
		IntToMon = TRUE;
	}
}


cmd_int_poll()
{
	register unsigned level;

	if (int_flag != 0x00)	{	/* if command interrupt happened ? */
		int_flag--;	/* take one command off here..*/
		level = (ringer[int_tail].intcmd >> 24 ) & 0x07;
		if(!cputest2)
			printf("\nInterrupt received: CSS level= %02x\n",level);
		int_tail++;	/* process one command */
		if(int_tail == MAXRING) /* if it's at the limit.. */
			int_tail = 0;	/* reset to start of limit. */
	}
}

