/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) errs.c: version 25.1 created on 11/27/91 at 14:35:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)errs.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
	force errors file.  Used to force and detect all kinds of errors on spm. 
*/

#include "types.h"
#include "spm.h"
#include "ring.h"

extern struct ring ringer[];  /* allow lots of them.. */

char tsterrs;	/* global int counter. */
char badcss;	/* global cmd failed. */
extern char emulate;	/* set if we want recover bus error */

errs(comm_str, arg_cnt) /* simply test all error generation abilities. */
char *comm_str;
int arg_cnt;
{
	int	oops=0, lop=0;	/* our toggle flag.. eh? */
	int	looping = 0;
	int	er_code;	/* our error code. */
	register char slot;

	slot = (char)(((*STATUSREG&STAT_SLOTMASK) >> STAT_SLOTSH)&0x0f);
	cssmap(MAP00,slot,(char)0x0f); /* map our slot for commands. */
	int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */

	tsterrs = 1;
	emulate = 1;	/* tell it to not proccess bus errors. */

	int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
	if(comm_str[3] == 'l') /* check looping */
		looping = 1;	 

	do {
		if(er_code = err_ack(oops))	/* test free ack. */
			break;
		oops = ~oops;	/* flip it .*/
		if(er_code = err_ack(oops))	/* test free ack. */
			break;
		oops = ~oops;	/* flip it .*/
		if(er_code = err_dest())	/* test destination error */
			break;	/* */
		if(er_code = err_grant())	/* check for a grant error. */
			break;
		if(er_code = err_par())	/* test parity error bits. */
			break;	/* */
		if(er_code = err_type())	/* test parity type bits. */
			break;	/* */
		if(er_code = err_misack())	/* test missing ack. */
			break;	/* */
		if(er_code = err_srcmatch())	/* test mis-match error. */
			break;	/* */
		if(ifesc())   break;	/* let's leave now. */
		if(++lop == 50) /* if 50 times around loop. */
		{
			printf(".");
			lop = 0;
		}
	} while (looping);

	switch(er_code)	/* ok, let's figure this one out.. */
	{
	case 0:	/* no error. */
		printf("\n");
		break;
	case 1:	/* ack/nack failed. */
		printf("%s forced error failed.\n", (oops)? "NACK": "ACK");
		break;
	case 2:	/* dest failed. */
		printf("Dest forced error failed.\n");
		break;
	case 3:	/* grant failed. */
		printf("Grant forced error failed.\n");
		break;
	case 4: /* failed parity bit detection. */
		printf("Data parity bits failed.\n");
		break;
	case 5: /* failed parity type detection. */
		printf("Type parity bits failed.\n");
		break;
	case 6: /* failed illegal type detection. */
		printf("Illegal command type failed.\n");
		break;
	case 7: /* failed missing ack detection. */
		printf("Detect missing ACK failed.\n");
		break;
	case 8: /* if source mismatch failed. */
		printf("Source mismatch failed.\n");
		break;
	default:
		printf("Program returned :%d:. Invalid return code.\n", er_code);
		break;
	}
	tsterrs = 0;
}

err_srcmatch()	/* test mis-match error. */
{
	int i, i1;

	for(i = 0; i < 4; i++)	/* loop through blasted thing, 1 bit at a time */
	{
		*WRCNTL0 = (*WRCNTL0 ^ (0x01 << (i+16))); /* clear one bit. */
		*((unsigned *)(0x8fffff80)) = 0; /* send a command to hit it.*/
		*WRCNTL0 = (*WRCNTL0 ^ (0x01 << (i+16))); /* set it back. */
		for(i1 = 0; i1 < 100; i1++) ;
		if(!int_flag)	/* never got one.. */	
			return(8);	/* failed. */
		int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
		if(!(ringer[int_tail].interr & 0x00004000)) /* src failed bit not set*/
			return(8);	/* failed here. */
	}
	return(0);
}

err_misack()	/* test for missing ack.. hmmm... */
{
	int	i, i1;
	register char slot;

	slot = (char)(((*STATUSREG&STAT_SLOTMASK) >> STAT_SLOTSH)&0x0f);
						/* corrupt our slot */
	*WRCNTL0 = (*WRCNTL0 & 0xffff0fff) | ((slot ^ 0x1) << 12);
	*((unsigned *)(0x8fffff80)) = 0; /* send a command to hit it.*/
	*WRCNTL0 = (*WRCNTL0 & 0xffff0fff) | (slot << 12);	/* re-build our slot */
	for(i1 = 0; i1 < 100; i1++) ;
	if(!int_flag) return(7);	/* fiailed. */
	int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
	if(ringer[int_tail].intstatus & 0x02)	/* sigh. */
	{ /* if failed to detect missing ack.. */
		return(7);	/* failed here. */
	}
	return(0);
}


err_type()	/* do parity errors stuff. */
{
	int	i1;

	*WRCNTL1 &= ~WR1_TPOL; /* clear one bit. */
	*((unsigned *)(0x8fffff80)) = 0; /* send a command to hit it.*/
	*WRCNTL1 |= WR1_TPOL; /* set it back. */
	for(i1 = 0; i1 < 100; i1++) ;
	if(!int_flag)	return(5);	/* never got one.. failed. */
	int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
	if(ringer[int_tail].interr & BPAR_MASK)
	{ /* if type parity not set. */
		printf("Bus type parity bit not set.\n");
		return(5);	/* failed here. */
	}
	return(0);	/* passed, this time.. */
}

err_par()	/* do parity errors stuff. */
{
	int	i, i1;

	for(i = 0; i < 8; i++)	/* loop through blasted thing, 1 bit at a time */
	{
/*		iready(); /* just for test.*/
		if(i > 8)	printf("Program error, loop count > 8. (%d)\n", i);
		*WRCNTL1 &= ~(0x01 << i); /* clear one bit. */
		*((unsigned *)(0x8fffff80)) = 0; /* send a command to hit it.*/
		*WRCNTL1 |= (0x01 << i); /* set it back. */
		for(i1 = 0; i1 < 100; i1++) ;
		if(!int_flag)
		{
			printf("Never got interrupt (bit:%d) ", i);
			return(4);	/* if never got one.. failed. */
		}
		int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
		if(ringer[int_tail].interr & (0x01 << i)) /* if dest bit is not set*/
		{
			printf("Parity bit set in error reg. (%d)\n", i);
			return(4);	/* failed here. */
		}
		if(!(ringer[int_tail].interr & (~(0x01 << i) & 0xff)))
		{ /* if there are not others set.. */
			printf("Multiple parity bits set in error reg.(%d)\n", i);
			return(4);	/* failed here. */
		}
	}
	return(0);	/* passed, this time.. */
}

err_ack(oops)	/* assert, then deassert forc.ack.err* bit. */
int	oops;	/* if set, do nack instead. */
{
	int i;

	if(oops)	/* other one.. */
		*WRCNTL1 &= ~WR1_DIAG_ANY_TYPE; /* clear this. */
	*WRCNTL0 |=  WR0_FRC_ACK; /* set the force grant bit. */
	*WRCNTL0 &= ~WR0_FRC_ACK; /* clear the force grant bit. */
	for(i = 0; i < 100; i++)	; /* sigh. */
	*WRCNTL1 |= WR1_DIAG_ANY_TYPE; /* set this back to normal. */
	if(int_flag)	/* if we actually got one here.. */
	{
		int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
		if(oops)
		{
			if(!(ringer[int_tail].intstatus & 0x00000001)) /* testing nack */
			{
				printf("Failed NACK bit 1 = 0.\n");
				return(1);	/* failed here. */
			}
		}
		else
			if(!(ringer[int_tail].intstatus & 0x00000002)) /* testing ack. */
			{
				printf("Failed ACK bit 2 = 0.\n");
				return(1);	/* failed here. */
			}
		if(ringer[int_tail].intstatus & 0x00000020) /* testing active. */
		{
			printf("Active was on in ACK test.\n");
			return(1);	/* failed here. */
		}
		return(0);	/* it's ok! */
	}
	return(1);
}

err_dest()	/* assert, then deassert forc.dest.err* bit. */
{
	int i;

	*WRCNTL0 |=  WR0_FRC_DEST; /* set the force grant bit. */
	*((unsigned *)(0x8fffff80)) = 0; /* send a command to hit it.*/
	*WRCNTL0 &= ~WR0_FRC_DEST; /* clear the force grant bit. */
	for(i = 0; i < 100; i++)	; /* sigh. */
	if(int_flag)	/* if we actually got one here.. */
	{
		int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
		if(!(ringer[int_tail].interr & 0x00008000)) /* if dest bit is not set*/
		{
			printf("No dest bit in error reg.\n");
			return(2);	/* failed here. */
		}
		if(!(ringer[int_tail].intstatus & 0x00000020)) /* testing active. */
		{
			printf("Active was off in dest test.\n");
			return(2);	/* failed here. */
		}
		return(0);
	}
	return(2);
}

err_grant()	/* assert, then deassert forc.granterr* bit. */
{
	int i;

	*WRCNTL0 |=  WR0_FRC_GRANT; /* set the force grant bit. */
	*WRCNTL0 &= ~WR0_FRC_GRANT; /* clear the force grant bit. */
	for(i = 0; i < 100; i++)	; /* sigh. */
	if(int_flag)	/* if we actually got one here.. */
	{
		int_flag = int_head = int_tail = 0;	/* make sure we clear this out. */
		if(ringer[int_tail].interr & 0x00000004) /* save error data. */
		{
			printf("Grant line was high.\n");
			return(3);
		}
		if(ringer[int_tail].intstatus & 0x00000020) /* testing active. */
		{
			printf("Active was on in grant test.\n");
			return(3);	/* failed here. */
		}
		return(0);
	}
	return(3);
}

