/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) edtmem.c: version 25.1 created on 11/27/91 at 14:34:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)edtmem.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


/******************************************************************************
 *
 * request the service of a DTB block device through the vreg structure
 *
 ******************************************************************************/
#include "types.h"
#include "icb.h"
#include "spm.h"
#include "devcmd.h"
#include "vreg.h"
#include "icb_config.h"
#include "rtb.h"
#include "misc.h"
#include "disp.h"

struct		icb_config	*edt_icb_ptr[18];
struct 		devq		devqq;
extern unsigned char bdhere[];			/* slots for CSS board's... */
extern struct icb_config	io_conf[][MAXSLOTS];

find_edt()	/* find edt board */
{
	short		i,j;
	unsigned char	id,io_num;
	struct	 icb_config	*icb_ptr;

	io_num = 0;
	for(i = 0; i < 0x14; i++)	/* initial edt_icb_ptr to zero */
	{
		edt_icb_ptr[i] = (struct icb_config *)0;
		
	}
	for(i = 0; i < 0x10; i++)	/* find IO module */
	{
		if(bdhere[i] == IOMHERE)
		{
/*			printf("IOM in slot: %x\n",i); /* */
			for(j = 0; j < 0x14; j++)
			{ /* check io slot */
				icb_ptr = &io_conf[io_num][j];
				id = icb_ptr->icb_slot_id;	/* Bd id info */
				if ((id == EDT) || (id == HSDT) || (id == SCSI))
				{
					edt_icb_ptr[j] = icb_ptr;
				}
			}
			io_num++;
		}
	}
}

