/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) edac.c: version 25.1 created on 11/27/91 at 14:34:52	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)edac.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* edac.c :
   tests the "error detection and correction" circuitry on the memory module.
   Single bit errors should be corrected and should cause an interrupt.
   Multiple bit errors should cause a bus error and interrupt.

   It also contains routines to decode syndrome error information from
   EDAC AS632 circuits.
   Syndrome information is read from the memory module error register at address
   0xffffffec.
*/

#include "types.h"
#include "globl.h"
#include "global.h"
#include "spm.h"

#define UNCORRECT	0xc0
#define DOUBLE		0x80
#define CHKBIT		0x40
#define DATABIT		0x00
#define SBIT_0 		0x80000000	/* single bit error in array 0 */
#define SBIT_1		0x00008000	/* single bit error in array 1 */
#define MBIT_0		0x00800000  /* multiple bit error in array 0 */
#define MBIT_1		0x00000080  /* multiple bit error in array 1 */
#define SYN_0		0x7f000000	/* mask of array 0 syndrome */
#define SYN_1		0x00007f00	/* mask of array 1 syndrome */
#define INFO_0		0x007f0000	/* mask of array 0 error information */
#define INFO_1		0x0000007f	/* mask of array 1 error information */
#define MEM_SLOT	0x00 		/* memory slot address */
#define ZERO		0x00 
#define FOUR		0x00 
#define ONE		0x01 
#define READ		0x18 
#define TESTMOD		0x79 	/* diagnostic, EDAC and interrupt enable */
#define TEST1MOD	0x6a 	/* diagnostic, EDAC and test bit rams instead */
#define TEST2MOD	0x78 	/* EDAC and int enabled */
#define TEST3MOD	0x7a 	/* EDAC and int enabled, and test bit rams */
#define TEST4MOD	0x62 	/* diagnostic, test bit rams instead */
#define WRITE		0x28 
#define INT_INFO	5 

int int_slot;	/* send command to css command register. */

int value;
extern char dummiebd;
char bytsize;	/* this defines 8, 16, or 32 byte reads. */
extern char tsterrs;	/* this is set to zero when we want to. */
extern char cpuack;	/* set if we want to only print out junk */
extern char emulate;	/* set if ignore bus errors */
extern char ipcctest;	/* set to zero to ignore IPCC handler */

char	edactest;	/* set if in test mode */

/* note: the following is setup as map 1 referenced only! */
unsigned int	*ERR_INFO_REG= 	(unsigned int *)0x9fffffec;
unsigned int	*ERR_ADDR_REG= 	(unsigned int *)0x9ffffff4;
unsigned int	*INT_INFO_REG= 	(unsigned int *)0x9fffffc4;
unsigned int	*STAT_REG =		(unsigned int *)0x9ffffffc;
unsigned char	*CHKBIT_REG= 	(unsigned char *)0x9fffffe7;
unsigned char	*CTL_REG =		(unsigned char *)0x9fffffe4;
unsigned pat[] = {
	0x55555555,
	0xffffffff,
	0x55555555,
	0xaaaaaaaa
};

/*
   Use syndrome information to get a byte from syndrome table as below.
   The byte from syndrome table decodes as following:

   _________________________________________________________________
   | Bit 7 | Bit 6 | Bit 5 | Bit 4 | Bit 3 | Bit 2 | Bit 1 | Bit 0 |
   -----------------------------------------------------------------
      1       1   Uncorrectable multi-bit error
      1       0   Double bit error
      0       1   error in check bit (Bit0 - Bit5 represent bit location)
      0       0   error in data bit  (Bit0 - Bit5 represent bit location)
*/

unsigned char syntab[128] =	{
	0xc0, 0x80, 0x80, 0xc0, 0x80, 0xc0, 0xc0, 0x80, /* 0 - 7 */
	0x80, 0xc0, 0x1f, 0x80, 0xc0, 0x80, 0x80, 0x1e, /* 8 - F */
	0x80, 0xc0, 0x1d, 0x80, 0x1c, 0x80, 0x80, 0x1b, /* 10 - 17 */
	0x1a, 0x80, 0x80, 0x19, 0x80, 0x18, 0xc0, 0x80, /* 18 - 1F */
	0x80, 0xc0, 0x07, 0x80, 0x06, 0x80, 0x80, 0x05, /* 20 - 27 */
	0x04, 0x80, 0x80, 0x03, 0x80, 0x02, 0xc0, 0x80, /* 28 - 2F */
	0x00, 0x80, 0x80, 0xc0, 0x80, 0x01, 0xc0, 0x80, /* 30 - 37 */
	0x80, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0x46, /* 38 - 3F */

	0x80, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0xc0, /* 40 - 47 */
	0xc0, 0x80, 0x80, 0x0f, 0x80, 0xc0, 0x0e, 0x80, /* 48 - 4F */
	0xc0, 0x80, 0x80, 0x0d, 0x80, 0x0c, 0x0b, 0x80, /* 50 - 57 */
	0x80, 0x0a, 0x09, 0x80, 0x08, 0x80, 0x80, 0x45, /* 58 - 5F */
	0xc0, 0x80, 0x80, 0x17, 0x80, 0x16, 0x15, 0x80, /* 60 - 67 */
	0x80, 0x14, 0x13, 0x80, 0x12, 0x80, 0x80, 0x44, /* 68 - 6F */
	0x80, 0x10, 0xc0, 0x80, 0x11, 0x80, 0x80, 0x43, /* 70 - 77 */
	0xc0, 0x80, 0x80, 0x42, 0x80, 0x41, 0x40, 0xff, /* 78 - 7F */
};

unsigned long syn1tab[32] = {
	0x00000001, 0x00000002, 0x00000004, 0x00000008,
	0x00000010, 0x00000020, 0x00000040, 0x00000080,
	0x00000100, 0x00000200, 0x00000400, 0x00000800,
	0x00001000, 0x00002000, 0x00004000, 0x00008000,
	0x00010000, 0x00020000, 0x00040000, 0x00080000,
	0x00100000, 0x00200000, 0x00400000, 0x00800000,
	0x01000000, 0x02000000, 0x04000000, 0x08000000,
	0x10000000, 0x20000000, 0x40000000, 0x80000000
};

unsigned char syn2tab[7] = {
	0x00000001, 0x00000002, 0x00000004, 0x00000008,
	0x00000010, 0x00000020, 0x00000040
};


/* usage: ledac slot start_address [length] */
edac_it(comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	register int  st_art;
	register int  leng;
	unsigned int size;
	unsigned int i = 0;
	char esc;
	char flag=1;
	char  slot;

	if(clokpr(0))	/* check if we are on proper clock */
		return(-1);	/* not on css clock */

	if (*comm_str == 'l')
		flag = 0;

	if(!arg_cnt)
		st_art = 0;	/* default starts from 0 */
	else
		st_art = (unsigned char)atox(comm_args[1]); /* get slot number*/
	if(arg_cnt > 1)
		leng = (unsigned)atox(comm_args[2]); /* get address */
	else leng = 1;
	if(arg_cnt > 2)
		slot = (unsigned char)atox(comm_args[3]); /* get slot number */
	else 	/* use auto-finder */
		 /* find first memory card */
		if((slot = (unsigned char)findmem(1)) == 18) 
			return;
	if(!leng) leng++;  /* make sure we do at least one word */
         /* move it over */ 
	int_slot= 0x80000f80 |((*STATUSREG & STAT_SLOTMASK) >> 12); 
	bytsize=0;

	do {
		if(edac_test(slot, st_art, leng) == -1)
			return(-1);	/* allows skipping if bad command */

		esc = (char)ifesc();

		printf (".");
	} while(!flag && !esc);	/* forever */
	printf("\n");
	return(0);
}

edac_test(slot, st_art, leng)
register int slot; /* memory card slot */
register int st_art; /* starting point in memory */
register int leng; /* number of words (4 bytes) to do */
{
	register unsigned bit1, bit2, pno, x;
	register unsigned char chkbits;
	register unsigned x1, st, er, addr;
	unsigned char x2;

	ipcctest = tsterrs = cpuack = 0;
	x2  = (unsigned char)CSSADD(st_art);
	cssmap(MAP00,slot,x2);	/* convert to nibblized address and slot */
	addr = CSSMAP(st_art); /* convert address to be 0x8xxxxxxx */
	cssmap(MAP01,slot,0x0f);	/* don't forget addr! */

	if(st_art & 0x00000003) /* if odd boundary */
	{
		printf("\nCommand not valid on non-long word boundries.\n");
		return(-1);
	}
	init_css();
	rready();
	iready();

	if(bytsize)	/* if non-4 word reads */
		;
	edactest = 1;	/* turn on the edac testing bit for int handler */
	for (st=addr; st<(addr+leng); st+=4) /* */
	{
		pno = 0;
		*CTL_REG = ZERO;   /* test mode*/
/* now, initilize both halves of array; since memory is 8 bytes wide */
		if(st & 0x00000004) /* if odd address, write previous address */
			*((unsigned *)(st-4)) = pat[pno];  /* write data */
		else
			*((unsigned *)(st+4)) = pat[pno];  /* write data */
		*((unsigned *)st) = pat[pno];  /* write data */
		value = *STAT_REG;  /* read check bits */

		value = (value & 0x007f0000) >> 16; /* save the chkbits value */
		chkbits = (unsigned char)value;		/* convert to char */

		/* testing single bad bits in long word */

		for (x1=0,bit1=1; x1++ < 32; bit1 <<= 1) /* 31 times */
		{     /* test for single bit errors */
			if(er=s_bit(st,(pat[pno] ^ bit1),chkbits,bit1,pat[pno],0))
				break;
		}

		for (bit1=1; bit1<0x80; bit1 <<= 1)
		{  /* testing single bit errors in check bits. */
			if(er=s_bit(st,pat[pno],(chkbits ^ bit1),bit1,pat[pno],1))
				break;
		}

		/* testing double bad bits in long word */
		for (bit1=1; bit1 != 0; bit1 <<= 1)
		{
			for (bit2=1; bit2 != 0; bit2 <<= 1)
				if (bit1 != bit2)
				{ /* change pattern to be two bits bad */
					x = pat[pno] ^ (bit1 | bit2); 
					if(er=d_bit(st,x,chkbits,(bit1 | bit2), pat[pno],0))
						break;
				} /* */
			if(er) break;
		}

		/* testing double bad bits in check bits */
		for (bit1=1; bit1<0x80; bit1 <<= 1) /* */
		{
			for (bit2=1; bit2<0x80; bit2 <<= 1) /* */
				if (bit1 != bit2) /* */
				{ /* */
					x = chkbits ^ (bit1 | bit2); /* */
					if(er=d_bit(st,pat[pno],x,(bit1 | bit2), pat[pno],1)) /* */
						break; /* */
				} /* */
			if(er) break;
		}
	}
	*CTL_REG = ZERO;   /* test mode */
	edactest = 0;	/* clear it now, shows not in test mode any more */
	*CTL_REG = ZERO;   /* test mode */
	return(er);	/* no error */
}


/* private variables for the routines below */
static unsigned int err_addr;
static unsigned int err_info;
static unsigned int int_info;
static unsigned int offset;
static char synbitint;
static char err_array;
static char err_stat;

/* subroutine to cause and handle a single bit memory error */

s_bit(taddr,tdata,chkbits,errbits,expected,which)
register unsigned tdata,errbits,expected,*taddr,which;
unsigned char chkbits;
{
	register unsigned x;
	register unsigned x1;
	register unsigned x2;

	edactest = 1;  /* */
	synbitint = 0;	/* clear for bit test */

	*CTL_REG = TESTMOD;   /* test mode */
	*CHKBIT_REG = chkbits;   /* set check bits */
	*INT_INFO_REG = int_slot;   /* set int info */
	*taddr = tdata; /*write loc with err bit toggled */
	x = *taddr;   /* read back pattern */
	iready();	/* this might not be needed */

	/* above operation should cause an int and no bus error */

	for(x1 = 0; x1<200; x1++) ;	/* wait for a while */

	if(!synbitint)	/* no int generated */
	{
		printf("Did not generate single bit interrupt:  (bit: %8X) (Address: %8X)\n",errbits,err_addr);
		return(1); /* */
	}

	if(x != expected)	/* if data was not corrected properly */
	{
		printf("Data was not corrected. should be:%8X: was:%8X:\n",expected,x);
	}
         /* if data was not corrected properly */
	if((unsigned)taddr & 0x0fffffff != err_addr)	
	{
		printf("Address was incorrect: should be:%8X: was:%8X:\n",((unsigned)taddr&0x0fffffff),err_addr);
	}

	if(!err_array && !(err_info & SBIT_0)) /* single error in second bank */
		offset = (err_info & SYN_0) >> 24;  /* convert to offset */
	else if(err_array && !(err_info & SBIT_1)) /* single error in 1st bank*/
		offset = (err_info & SYN_1) >> 8;  /* convert to offset */
	else
	{
		printf("Generated error in array %d, when testing other array.\n",
				(err_array)? 0:1);
		return(1);
	}

	x2 = offset;	/* save it */
	offset = syntab[offset]; /* get error type now true for both types */

	if((offset & 0xc0) == 0xc0) /* if uncorrectable */
	{
		if(which)
			printf("Bad checkbit error: (chkbits: %2X) (Address: %8X)\n",x2,err_addr);
		else
			printf("Uncorrectable multi-bit error in single bit test:\n\
			  (bit: %8X) (Address: %8X)\n",errbits,err_addr);
		return(1); /* */
	}

	if(offset&0x80)  /* if double bit error */
	{ /* must be double, since this bit say's no single errors encountered.. */
		if(which)
			printf("Bad checkbit error: (chkbits: %2X) (Address: %8X)\n",x2,err_addr);
		else
			printf("Double-bit error in single bit test: (bit: %8X) (Address: %8X)\n",errbits,err_addr);
		return(1);
	}

	if(((offset & 0xc0)==0x40) && !which) /* or chkbits were bad..*/
	{
		printf("Checkbits failed instead of data:  (bit: %8X) (Address: %8X)\n",errbits,err_addr);
		printf("err_info: %8X\n", err_info);
		return(1);
	}
	if(which)	 /* if checking chkbits instead of data..*/
	{
		if(errbits != syn2tab[(offset &0x1f)]) /* if bit failed wrong..*/
		{
			printf("Checkbits failed: (bit: %2X) (Address: %8X)\n", errbits,err_addr);
			printf("err_info: %8X\n", err_info);
			return(1);
		}
	}
	else	/* we are checking out the data now..*/
	{
		if(errbits != syn1tab[(offset &0x1f)]) /* if bit failed wrong..*/
		{
			printf("EDAC reported wrong bit failed.\n");
			printf("err_info: %8X\n", err_info);
			return(1);
		}
	}
	if(err_stat & 0x04) /* was supposed to be during a read.. */
		printf("Return code is write command, during read command.\n");
	if(bytsize)	/* we wanted other than 8 byte read. */
	{
		if(!(err_stat &0x02)) /* was a 16 byte read. */
			printf("16 byte function\n");
		if(!(err_stat &0x01)) /* was a 32 byte read. */
			printf("32 byte function\n");
	}
	else
		if((err_stat &0x03) != 0x03)  /* if not an 8 byte read. */
		{
			printf("Status is Non-8 byte read. :%2X:\n",err_stat&0x03);
			return(1);
		}
	*CTL_REG = ZERO;   /* test mode*/
	*taddr = 0;  /* write data */
	return(0);
}

syndr()
{
	unsigned tmp;

	synbitint = 1;	/* show got here. */
	tmp = *WRCNTL1;	/* save it. */
	*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
	err_addr = (*ERR_ADDR_REG &0x0fffffff);	/* upper 4 bits mean nothing. */
	err_array = (err_addr & 0x00000004) >> 2; /* isolate addr bit 2 */
	err_info = *ERR_INFO_REG;
	err_stat = ((err_array)? (*ERR_INFO_REG>>4):(*ERR_INFO_REG>>20)) &0x07;
	*WRCNTL1 = tmp;  /* restore what mode it was. */
	return;
}


/* subroutine to cause and handle a double bit memory error */

d_bit(taddr,tdata,chkbits,errbits,expected,which)
register unsigned *taddr,tdata,errbits,which;
register unsigned short chkbits;
{
	register unsigned x;
	register unsigned x1;

	edactest = 1;  /* shit. */
	synbitint = 0;	/* clear for bit test. */

	*CTL_REG = TESTMOD;   /* test mode*/
	*CHKBIT_REG = chkbits;   /* set check bits */
	*INT_INFO_REG = int_slot;   /* set int info */
	*taddr = tdata; /*write loc with err bit toggled*/
	emulate = 1; /* ignore css bus error that WILL occur. */
	x = *taddr;   /* read back pattern */
	emulate = 0;	/* clear it. */
	iready();

	/* above operation should cause an int and no bus error */

	for(x1 = 0; x1<20; x1++) ;	/* wait for a while */

	if(!synbitint)	/* no int generated..*/
	{
		printf("Did not generate double bit interrupt.(%8X)\n",errbits);
		return(1); /* */
	}

	if(!err_array && !(err_info & MBIT_0)) /* single error in second bank */
		offset = (err_info & SYN_0) >> 24;  /* convert to offset. */
	else if(err_array && !(err_info & MBIT_1)) /* single error in first bank */
		offset = (err_info & SYN_1) >> 8;  /* convert to offset. */
	else
	{
		printf("Generated error in array %d, when testing other array.\n",
														(err_array)? 0:1);
		return(1);
	}
	offset = syntab[offset];	/* get error type now.. true for both types */

	if((offset & 0xc0)!=0x80)  /* or chkbits were bad..*/
	{
		printf("Single bit error instead of double: (bit: %8X) (Address: %8X)\n",errbits,err_addr);
		printf("err_info: %8X\n", err_info);
		return(1);
	}
	return(0);
}

redac_it(comm_str, arg_cnt) 	/* check for int pending stuff. */
char *comm_str;
int arg_cnt;
{
	register slot, i=0;
	char	flag = 1;
	char	esc;

	if(clokpr(0)) /* Check if we are on proper clock. */
		return(-1);

	if (*comm_str == 'l')
		flag = 0;

	if(arg_cnt)
		slot = (unsigned char)atox(comm_args[1]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) 
			return;

	signal(0);	/* initialize LED */

	int_slot= 0x80000f80 |((*STATUSREG & STAT_SLOTMASK) >> 12); /*move it over*/
	do {
		if((i++ % 100) == 0)  /* 25 loops through, dot it. */
			printf(".");
		

		redac_test(slot);

		signal(0);

		esc = (char)ifesc();
			
	} while (!flag && !esc);
	printf("\n");
	return(0);
}

redac_test(slot)	/* check for int pending stuff. */
register int slot; /* memory card slot. */
{
	register unsigned bit1, bit2, pno, x;
	register unsigned char chkbits;
	register unsigned x1, st, er, addr;
	unsigned char x2;

	cssmap(MAP00,slot,0x0);	/* setup data map, if needed. */
	addr = CSSMAP(0); /* convert address to be 0x8xxxxxxx */
	cssmap(MAP01,slot,0x0f);	/* setup the second one.. */

	init_css();
	rready();	/* reset ready count.(if it works!) */
	iready();	/* fix for both types of boards. */
	dummiebd = 1; /* set to no increment ready.. */

	tsterrs = cpuack = 0;
	edactest = 1;	/* turn on the edac testing bit for int handler. */
	st = 0x80000000;

	pno = 0;
	*CTL_REG = ZERO;   /* test mode*/
	*((unsigned *)(st+8)) = pat[pno];  /* write data */
	*((unsigned *)(st+12)) = pat[pno];  /* write data */
	*((unsigned *)(st+4)) = pat[pno];  /* write data */

	*INT_INFO_REG = int_slot;   /* set int info */

	setmodify(); /* set the forced modify bit (in switches.c) */

	*((unsigned *)st) = pat[pno];  /* write data */
	value = *STAT_REG;  /* read check bits */

	value = (value & 0x007f0000) >> 16;  	/* save the chkbits value..*/
	chkbits = (unsigned char)value;		/* convert to char..*/

	emulate = 1;	/* ignore css buss errors. */
	*((unsigned *)st) = (pat[pno] ^ 1); /*write loc with err bit toggled*/
	*CTL_REG = TEST1MOD;   /* Shift it to the other test mode. */
	*((char *)st) = chkbits;   /* set check bits */

	*CTL_REG = TEST2MOD;   /* Shift to edac enabled and interrupt only */

	clrmodify(); /* clear the forced modify bit (in switches.c) */

/* here, generates error.  so, read the error registers, then enable ints. */
	syndr();	/* read all data, but ignore results. */

	x = *((unsigned *)st);   /* read back pattern, to generate an interrupt */
							/* but, since I can't reset the ready count.. */
/*----[ tgm ]-----------------------------------------------------------------*/
/*	for(x1 = 0; x1<8; x1++) ;	/* wait for a while to clear interrupt. */
	for(x1 = 0; x1 < 4; x1++) ;	/* wait for a while to clear interrupt. */

	synbitint = 0;	/* clear since I know it was set.. */

	x = *((unsigned *)st);   /* read back pattern for REAL. */
	for(x1 = 0; x1<8; x1++) ;	/* wait for a while */
	emulate = 0;
/*
  now: we have an error generated, and pending.  make sure we can read
  other data.
 */
	if(synbitint)	/* make sure clear for bit test. */
		printf("Program received interrupt when not expected.\n");

	if((x = *((unsigned *)(st+8))) != pat[pno])
		printf("Failed read of the normal memory.\n");

	dummiebd = 0;	/* ok, clear this flag, to allow normal proccesing.. */
	iready();	/* and enable the command, to receive the interrupt. */

/*----[ tgm ]-----------------------------------------------------------------*/
/*	for(x1 = 0; x1<8; x1++) ;	/* wait for a while */
	for(x1 = 0; x1 < 4; x1++) ;	/* wait for a while */

	if(!synbitint) { /* clear for bit test. */
/*----[ tgm ]-----------------------------------------------------------------*/
		signal(1);			/* Turn on the led. */
/*----------------------------------------------------------------------------*/
		printf("Never got interrupt after enabled.\n");
	}
	*CTL_REG = ZERO;   /* disable edac mode*/
	edactest = 0;	/* clear it now. show's not in test mode any more */
	*CTL_REG = ZERO;   /* disable edac mode*/
	return;
}

/* usage: cedac slot   checks the checkbits function of a slot. */
cedac_it(comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	register int  slot, leng, start;
	unsigned int i;
	char	loop = 0;
	char	esc;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */

	if (*comm_str == 'l')
		loop = 1;

	if(!arg_cnt)
		start = 0;
	else
		start = (int)atox(comm_args[1]); /* get start address. */
	if(arg_cnt > 1)
		leng = (int)atox(comm_args[2]); /* get length. */
	else leng = 1;
	if(arg_cnt > 2)
		slot = (int)atox(comm_args[3]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (int)findmem(1)) == 18) /*find first memory card*/
			return(-1);
	int_slot= 0x80000f80 |((*STATUSREG & STAT_SLOTMASK) >> 12); /*move it over*/
	if (cedac_test(slot, start, leng, loop) == -1)
		return(-1);

	printf ("\n");
	return(0);
}


/* check the checkbits memory bits.. uses edac in test mode */
cedac_test(slot, start, size, loop)
int slot; /* memory card slot. */
int start; /* starting point in memory. */
int size; /* number of words (4 bytes) to do */
char loop;
{
	unsigned offset;
	unsigned tseed;
	unsigned tdata, rdata;
	register char  addr, er;
	char esc = 1;
	int i = 0;
	char  *mp, *tmp;

	init_css();	/* initilze it, just in case. */
	rready();	/* reset it.. this WILL work in future boards. */
	iready();	/* and tell it we are ready to go. */

	tsterrs = cpuack = 0;

	offset  = (unsigned char)CSSADD(start);
	cssmap(MAP00, slot, offset);
	tmp = mp = (char *)CSSMAP(start); 

	offset  = CSSMAP(start); 
	cssmap(MAP01, slot, (unsigned char)0x0f);	

	printf ("Checkbits test on CSS block, press <ESC> to stop\n");
	printf ("slot = 0x%x, addr = 0x%08x, size = 0x%08x\n", slot, (offset &0x0fffffff), size); 

	er = 0;
	edactest = 1;	/* turn on the edac testing bit for int handler. */
	*CTL_REG = TEST4MOD;    /* enable test mode */

	if (loop)
		esc = 0;

	tseed = 1;	/* data starts here. */
	while (!esc) {	/* loops forever.. yes? */
	
	    tdata = tseed;		/* Write loop */
	    for (mp = tmp; mp < (char *)(offset + size);) {

			*(unsigned char *)mp = (unsigned char)tdata;
			mp += 4;	

			if(ifesc()) {
				esc = 1;
				break;
			}
	    }

	    for (mp = tmp; mp < (char *)(offset + size);) {

			if (esc) 
				break;

			rdata = ((unsigned)(*(unsigned char *)mp) &0x3f);
			if (rdata != (tdata & 0x3f)) {	/* only save chkbits. */
				printf ("Error: address 0x%08x -- ", mp);
/*				printf ("is 0x%02x, ", ((unsigned char)rdata) &0x3f); /* */
				printf ("is 0x%08x, ", rdata);
/*				printf ("should be 0x%02x\n", (unsigned char)tdata); /* */
				printf ("should be 0x%02x\n", tdata); /* */
			}

			mp += 4;
			if(ifesc()) {
				esc = 1;
				break;
			}
	    }

	    tseed = ((tseed * 2) & 0x03f); /* make it twice. */
	    if(!tseed) tseed++;	/* make it 1. */

	    if ((i++ % 50) == 0)
	    	printf(".");	/* show a dot. */
	}
	printf("\n");
	*CTL_REG = ZERO;   /* disable test mode*/
	edactest = 0;	/* clear it now. show's not in test mode any more */
	*CTL_REG = ZERO;   /* disable test mode*/
	return(0);
}

bedac_it(comm_str, arg_cnt)  /* loop test 8,16,32 byte read indicators. */
char *comm_str;
int arg_cnt;
{
	register slot;
	register i;
	char	flag = 1;
	char	esc;
	int	j = 0;

	if(clokpr(0))	/* check if we are on proper clock. */
		return(-1);	/* not on css clock. */

	if (*comm_str == 'l')
		flag = 0;

	if(arg_cnt)
		slot = (unsigned char)atox(comm_args[1]); /* get slot number. */
	else 	/* use auto-finder.. */
		if((slot = (unsigned char)findmem(1)) == 18) 
			return(0);

	int_slot= 0x80000f80 |((*STATUSREG & STAT_SLOTMASK) >> 12); /*move it over*/
	do {
		for(i = 0; i < 3; i++) {
			bedac_test(slot, 0, i);	/* test low word, */
			bedac_test(slot, 1, i);	/* test high word. */
		}
		esc = ifesc();
			
		if ((j++ % 50) == 0)
			printf(".");

	} while (!flag && !esc);
	printf("\n");
	return(0);
}

bedac_test(slot, wh, siz)	/* check for 8,16, and 32 byte reads. */
register int slot; /* memory card slot. */
register int wh;	/* which side.. low word, or high word. */
register int siz;	/* which size.. 0 = 8, 1 = 16, 2 = 32. */
{
	register unsigned bit1, bit2, pno, x;
	register unsigned char chkbits;
	register unsigned x1, st, er, addr;
	register i1, lim;
	unsigned char x2;

	cssmap(MAP00,slot,0x0);	/* setup data map, if needed. */
	addr = CSSMAP(0); /* convert address to be 0x8xxxxxxx */
	cssmap(MAP01,slot,0x0f);	/* setup the second one.. */

	init_css();
	rready();	/* reset ready count.(if it works!) */
	iready();	/* fix for both types of boards. */

	tsterrs = cpuack = 0;
	edactest = 1;	/* turn on the edac testing bit for int handler. */
	st = 0x80000000;	/* fix up starting address.. always here. */

	pno = 0;	/* use pattern zero.. */
	*CTL_REG = ZERO;   /* test mode*/
	*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
	switch(siz)  /* now, was it 8, 16, or 32 byte reads to do? */
	{
	case 2:
		lim=32;	/* make it 32 bytes. */
		break;
	case 1:
		lim=16; /* make it 16 bytes. */
		break;
	case 0:
		lim=8;	/* make it 8 bytes. */
		break;
	}
	for(i1 = 0; i1 < lim; i1+=4)	/* write out patterns, filling memory. */
		*((unsigned *)(st+i1)) = pat[pno];  /* write data */

	*INT_INFO_REG = int_slot;   /* set int info */

	if(wh) st+= 4;	/* switch to other side.. yes? */

	*((unsigned *)st) = pat[pno];  /* write good data */
	value = *STAT_REG;  /* read check bits */

	value = (value & 0x007f0000) >> 16;  	/* save the chkbits value..*/
	chkbits = (unsigned char)value;		/* convert to char..*/

	*CTL_REG = TESTMOD;   /* test mode*/
	*CHKBIT_REG = chkbits;   /* set check bits */
	*((unsigned *)st) = (pat[pno] ^ 1); /*write loc with err bit toggled*/
	for(x1 = 0; x1< 8; x1++) ; /* pause just awhile.. */

	synbitint = 0;	/* clear for bit test. (since writing to chkbits set it) */
	switch(siz)  /* now, was it 8, 16, or 32 byte reads to do? */
	{
	case 2:
		*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
		*WRCNTL1 |= WR1_32BYTE_RD;  /* set bits to 32 byte reads. */
		break;
	case 1:
		*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
		*WRCNTL1 |= WR1_16BYTE_RD;  /* set bits to 4 byte reads. */
		break;
	case 0:
		*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
		*WRCNTL1 |= WR1_8BYTE_RD;  /* set bits to 8 byte reads. */
		break;
	}

	if(wh) st -= 4;	/* back to ground zero.. */
	x = *((unsigned *)st);   /* read back pattern for REAL. Fills pipeline. */
	for(x1 = 0; x1<8; x1++) ;	/* wait for a while */

	if(!synbitint)	/* cleared before bit test. */
	{
		printf("Never got interrupt.\n");
		*CTL_REG = ZERO;   /* disable edac mode*/
		*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
		return;
	}

	if(wh)	/* if we are testing high byte, isolate 1.info.. */
		x2 = (err_info >> 4) & 0x07; 	/* save only read, and byte size. */
	else	/* isolate 0.info.  */
		x2 = (err_info >> 20) & 0x07; 	/* save only read, and byte size. */

	if(x2 & 0x04)	/* if didn't happen during a read.. */
		printf("Did not report READ ERROR on bank %d.\n", wh);

	x2 &= 0x03;	/* isolate only size of read now. */

	switch(siz)	/* what size do we expect? */
	{
	case 2:	/* was a 32 byte read. */
		if(x2 != 0x02) /* if does not say it's a 32 byte read. */
			printf("Failed: does not say 32 byte read. (result:%d:)\n", x2);
		break;
	case 1:	/* was a 16 byte read. */
		if(x2 != 0x01) /* if does not say it's a 16 byte read. */
			printf("Failed: does not say 16 byte read. (result:%d:)\n", x2);
		break;
	case 0:	/* was an 8 byte read. */
		if(x2 != 0x03) /* if does not say it's a 8 byte read. */
			printf("Failed: does not say 8 byte read. (result:%d:)\n", x2);
		break;
	}

	*CTL_REG = ZERO;   /* disable edac mode*/
	*WRCNTL1 &= ~WR1_32BYTE_RD;  /* clear bits to 4 byte reads. */
	edactest = 0;	/* clear it now. show not in test mode any more. */
	return;
}

