/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dslot.c: version 25.1 created on 11/27/91 at 14:34:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dslot.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "global.h"
#include "types.h"
#include "disp.h"

extern unsigned char bdhere[];			/* slots for CSS board's... */
extern struct slotst sf;
/*------------------------------------------------------------------------------
	chkslot : Is slot ok, returns the enable/disable flag status.
------------------------------------------------------------------------------*/
chkslot(x) char x; 
{
	return(sf.on[x]);			/* Return slot status. */	
}

/*------------------------------------------------------------------------------
	togslot : Toggles the slots disable or enable.
			  And return the current setting.
------------------------------------------------------------------------------*/
togslot(x)
char x;
{
	if(bdhere[x] != CPUHERE) {
		printf("\nInvalid PM slot.\n");
		return;
	}
	cssmap(MAP00,(uchar)x,(uchar)0x0f);
	if(sf.on[x]) {
		ifdisable(0);					/* Disable it. */
		sf.on[x] = 0;				/* Remember this slot's status. */
	}
	else {
		ifenable(0);					/* Enable it. */
		sf.on[x] = 1;				/* Enable this slot. */
	}
	return(sf.on[x]);				/* Return slot status. */	
}

/*------------------------------------------------------------------------------
	ck_css_config : Check to see minimum and maximum configuration has
					been met.
------------------------------------------------------------------------------*/
ck_css_config()
{
	int	i;
	unsigned char i1;
	int 	pmbd, iobd, iopbd, spmbd, membd;

	pmbd = iobd = spmbd = membd = iopbd = 0;

	for(i = 0; i < 16; i++)				/* loop through all slots. */
	{
		if(bdhere[i] != NOBOARD) {		/* if SOMETHING is here.. */
			switch(bdhere[i] & BDCLASSMASK)	{
				case SPMTYPE: spmbd++; break;
				case CPUTYPE: pmbd++; break;
				case DPMTYPE: pmbd+=2; break;
				case IOMTYPE: iobd++; break;
				case IOPTYPE: iopbd++; break;
				case MEMTYPE: membd++; break;
				default : break;
			}
		}
	}
	if(!membd) {
		printf("\nNo memory board in the system.\n");
		return(0xFF);
	}
	if(!iobd && !iopbd) {
		printf("\nNo I/O board in the system.\n");
		return(0xFF);
	}
	if(!pmbd) {
		printf("\nNo PM board in the system.\n");
		return(0xFF);
	}
/* FIX THIS  What is the max limit of io class boards. */
	if(iobd > 4) {
		printf("\nToo many IOM boards in the system.\n");
		return(0xFF);
	}
	if(pmbd > 8) {
		printf("\nToo many PM boards in the system.\n");
		return(0xFF);
	}
	if(membd > 8) {
		printf("\nToo many memory boards in the system.\n");
		return(0xFF);
	}
	return(iobd);
}

ck_dpm_present()
{
	int 	i;

	for(i = 0; i < 16; i++)	  /* loop through all slots. */
		if(bdhere[i] == DPMHERE){
			return(1);
		}
	return(0);
}
