/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dram.c: version 25.1 created on 11/27/91 at 14:34:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dram.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "misc.h"
#include "globl.h"
#include "spm.h"


dram()
{
	dram_access(0);
#ifdef	REMOVE
	if( dram_access(0) ) {
		printf("\r\nUnable to access Dispatcher RAMs.");
		printf("\r\nDispatcher RAM tests skipped.\r\n");
		return;
	}
#endif
	/* cpu has access to dispatcher rams now */
	queue_ram_dripple();
	queue_ram_aripple();
	queue_ram_content();
	counter_ram_dripple();
	counter_ram_aripple();
	counter_ram_content();
	service_ram_aripple();
	service_ram_content();
	config_ram_dripple();
	config_ram_aripple();
	config_ram_content();
	pointer_ram_dripple();
	pointer_ram_aripple();
	pointer_ram_content();
		
	/* turn off the request now */
	dram_access(1);
}

queue_ram_dripple()
{
	register unsigned tstpat,readback;
	char *msg;

	msg = "Queue Ram Data Ripple";
	/* ripple a one bit in first location */
	for(tstpat=0x00000001; tstpat>0; tstpat = tstpat << 1) {
		*QUEUE_RAM = tstpat;
		readback = *QUEUE_RAM;
		if(readback != tstpat) {
			print_err(msg,(unsigned)QUEUE_RAM,tstpat,readback);
			return;
		}
	}
	/* ripple a zero bit through first location */
	for(tstpat=0xfffffffe; tstpat != 0xffffffff; tstpat = (tstpat << 1) | 0x00000001) {
		*QUEUE_RAM = tstpat;
		readback = *QUEUE_RAM;
		if(readback != tstpat) {
			print_err(msg,(unsigned)QUEUE_RAM,tstpat,readback);
			return;
		}
	}
}

queue_ram_aripple()
{
	register unsigned *addr,readback,offadd;
	char *msg;
	unsigned pat1=0x00000000;
	unsigned pat2=0x55555555;
	unsigned pat3=0xaaaaaaaa;

	msg = "Queue Ram Address Ripple";
	for(offadd=0x00000800; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)QUEUE_RAM + offadd);
		*addr = pat1;
	}
	for(offadd=0x00000800; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)QUEUE_RAM + offadd);
		readback = *addr;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}

queue_ram_content()
{
	register unsigned readback,*addr;
	char *msg;
	register unsigned pat1=0x55555555;
	register unsigned pat2=0xaaaaaaaa;
	register unsigned pat3=0x00000000;

	msg = "Queue Ram Content";
	for(addr=QUEUE_RAM; addr < QUEUE_RAM + QUEUE_LWORDS ; addr++) {
		*addr = pat1;
		readback = *addr;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
	}
	for(addr=QUEUE_RAM; addr < QUEUE_RAM + QUEUE_LWORDS ; addr++) {
		readback = *addr;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
	}
	for(addr=QUEUE_RAM; addr < QUEUE_RAM + QUEUE_LWORDS ; addr++) {
		readback = *addr;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}

counter_ram_dripple()
{
	register unsigned tstpat,readback;
	char *msg;

	msg = "Counter Ram Data Ripple";
	/* ripple a one bit in first location */
	for(tstpat=0x00000001; tstpat<0x00000400; tstpat = tstpat << 1) {
		*MISC_RAM = tstpat;
		readback = *MISC_RAM & CNTR_MASK;
		if(readback != tstpat) {
			print_err(msg,(unsigned)MISC_RAM,tstpat,readback);
			return;
		}
	}
	/* ripple a zero bit through first location */
	for(tstpat=0x000003fe; tstpat != 0x000003ff;tstpat=((tstpat<<1) | 0x00000001) & CNTR_MASK) {
		*MISC_RAM = tstpat;
		readback = *MISC_RAM & CNTR_MASK;
		if(readback != tstpat) {
			print_err(msg,(unsigned)MISC_RAM,tstpat,readback);
			return;
		}
	}
}

counter_ram_aripple()
{
	register unsigned *addr,readback,offadd;
	char *msg;
	unsigned pat1=0x00000000;
	unsigned pat2=0x00000155;
	unsigned pat3=0x000002aa;

	msg = "Counter Ram Address Ripple";
	for(offadd=0x00000010; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)MISC_RAM + offadd);
		*addr = pat1;
	}
	for(offadd=0x00000010; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)MISC_RAM + offadd);
		readback = *addr & CNTR_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & CNTR_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr & CNTR_MASK;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}

counter_ram_content()
{
	register unsigned readback,*addr;
	char *msg;
	register unsigned pat1=0x00000155;
	register unsigned pat2=0x000002aa;
	register unsigned pat3=0x00000000;

	msg = "Counter Ram Content";
	for(addr=MISC_RAM; addr < MISC_RAM + CNTR_LWORDS ; addr++) {
		*addr = pat1;
		readback = *addr & CNTR_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
	}
	for(addr=MISC_RAM; addr < MISC_RAM + CNTR_LWORDS ; addr++) {
		readback = *addr & CNTR_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & CNTR_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
	}
	for(addr=MISC_RAM; addr < MISC_RAM + CNTR_LWORDS ; addr++) {
		readback = *addr & CNTR_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr & CNTR_MASK;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}

service_ram_aripple()
{
	register unsigned *addr,readback,offadd;
	char *msg;
	unsigned pat1=0x00000000;
	unsigned pat2=0x00008000;

	msg = "Service Pending Ram Address Ripple";
	for(offadd=0x00000100; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)MISC_RAM + offadd);
		*addr = pat1;
	}
	for(offadd=0x00000100; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)MISC_RAM + offadd);
		readback = *addr & SERV_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & SERV_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
	}
}

service_ram_content()
{
	register unsigned readback,*addr;
	char *msg;
	register unsigned pat1=0x00008000;
	register unsigned pat2=0x00000000;

	msg = "Service Pending Ram Content";
	for(addr=MISC_RAM; addr < MISC_RAM + SERV_LWORDS ; addr++) {
		*addr = pat1;
		readback = *addr & SERV_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
	}
	for(addr=MISC_RAM; addr < MISC_RAM + SERV_LWORDS ; addr++) {
		readback = *addr & SERV_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & SERV_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
	}
}

config_ram_dripple()
{
	register unsigned tstpat,readback;
	char *msg;

	msg = "Configuration Ram Data Ripple";
	/* ripple a one bit in first location */
	for(tstpat=0x01000000; tstpat<0x10000000; tstpat = tstpat << 1) {
		*MISC_RAM = tstpat;
		readback = *MISC_RAM & CONFIG_MASK;
		if(readback != tstpat) {
			print_err(msg,(unsigned)MISC_RAM,tstpat,readback);
			return;
		}
	}
	/* ripple a zero bit through first location */
	for(tstpat=0x0e000000; tstpat != 0x0f000000;tstpat=((tstpat<<1) | 0x01000000) & CONFIG_MASK) {
		*MISC_RAM = tstpat;
		readback = *MISC_RAM & CONFIG_MASK;
		if(readback != tstpat) {
			print_err(msg,(unsigned)MISC_RAM,tstpat,readback);
			return;
		}
	}
}

config_ram_aripple()
{
	register unsigned *addr,readback,offadd;
	char *msg;
	unsigned pat1=0x00000000;
	unsigned pat2=0x05000000;
	unsigned pat3=0x0a000000;

	msg = "Configuration Ram Address Ripple";
	for(offadd=0x00000010; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)MISC_RAM + offadd);
		*addr = pat1;
	}
	for(offadd=0x00000010; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)MISC_RAM + offadd);
		readback = *addr & CONFIG_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & CONFIG_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr & CONFIG_MASK;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}

pointer_ram_dripple()
{
	register unsigned tstpat,readback;
	char *msg;

	msg = "Pointer Ram Data Ripple";
	/* ripple a one bit in first location */
	for(tstpat=0x00010000; tstpat<0x80000000; tstpat = tstpat << 1) {
		if(tstpat == 0x00800000)
			tstpat=tstpat << 1;
		*POINTER_RAM = tstpat;
		readback = *POINTER_RAM & POINTER_MASK;
		if(readback != tstpat) {
			print_err(msg,(unsigned)POINTER_RAM,tstpat,readback);
			return;
		}
	}
	/* ripple a zero bit through first location */
	for(tstpat=0xfffe0000; tstpat != 0xffff0000;tstpat=(tstpat<<1) | 0x00010000) {
		*POINTER_RAM = tstpat;
		readback = *POINTER_RAM & POINTER_MASK;
		if(readback != (tstpat & POINTER_MASK)) {
			print_err(msg,(unsigned)POINTER_RAM,(tstpat & POINTER_MASK),readback);
			return;
		}
	}
}

pointer_ram_aripple()
{
	register unsigned *addr,readback,offadd;
	char *msg;
	unsigned pat1=0x00000000;
	unsigned pat2=0x55550000;
	unsigned pat3=0x2a2a0000;

	msg = "Pointer Ram Address Ripple";
	for(offadd=0x00000080; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)POINTER_RAM + offadd);
		*addr = pat1;
	}
	for(offadd=0x00000080; offadd >= 0x00000004 ; offadd = offadd >> 1) {
		addr = (unsigned *)((unsigned)POINTER_RAM + offadd);
		readback = *addr & POINTER_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & POINTER_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr & POINTER_MASK;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}

pointer_ram_content()
{
	register unsigned readback,*addr;
	char *msg;
	register unsigned pat1=0x55550000;
	register unsigned pat2=0x2a2a0000;
	register unsigned pat3=0x00000000;

	msg = "Pointer Ram Content";
	for(addr=POINTER_RAM; addr < POINTER_RAM + POINTER_LWORDS ; addr++) {
		*addr = pat1;
		readback = *addr & POINTER_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
	}
	for(addr=POINTER_RAM; addr < POINTER_RAM + POINTER_LWORDS ; addr++) {
		readback = *addr & POINTER_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & POINTER_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
	}
	for(addr=POINTER_RAM; addr < POINTER_RAM + POINTER_LWORDS ; addr++) {
		readback = *addr & POINTER_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr & POINTER_MASK;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}

config_ram_content()
{
	register unsigned readback,*addr;
	char *msg;
	register unsigned pat1=0x05000000;
	register unsigned pat2=0x0a000000;
	register unsigned pat3=0x00000000;

	msg = "Configuration Ram Content";
	for(addr=MISC_RAM; addr < MISC_RAM + CONFIG_LWORDS ; addr++) {
		*addr = pat1;
		readback = *addr & CONFIG_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
	}
	for(addr=MISC_RAM; addr < MISC_RAM + CONFIG_LWORDS ; addr++) {
		readback = *addr & CONFIG_MASK;
		if(readback != pat1) {
			print_err(msg,addr,pat1,readback);
			return;
		}
		*addr = pat2;
		readback = *addr & CONFIG_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
	}
	for(addr=MISC_RAM; addr < MISC_RAM + CONFIG_LWORDS ; addr++) {
		readback = *addr & CONFIG_MASK;
		if(readback != pat2) {
			print_err(msg,addr,pat2,readback);
			return;
		}
		*addr = pat3;
		readback = *addr & CONFIG_MASK;
		if(readback != pat3) {
			print_err(msg,addr,pat3,readback);
			return;
		}
	}
}
	
print_err(msg,addr,expvalue,readvalue)

	unsigned *msg,addr,expvalue,readvalue;
{
	printf("\r\n%s Test failed.",msg);
	printf("\r\nAddress = %8x, Expected: %8x, Read: %8x\r\n",addr,expvalue,readvalue);
}

dram_access(flag)
	register unsigned char flag;
{
	register unsigned i;

	*WRCNTL1 |= WR1_ID_RST;
	if(flag)	
		/* turn the request off */
		*WRCNTL1 |= WR1_DREQ;
	else {	
		*WRCNTL1 &= ~WR1_DREQ;		/* cpu wants access to rams */
		for(i=0; i<0x20000; i++) {	/* wait for cpu signal */
			if(!(*STATUSREG & STAT_REG_IDRAM))
			break;
		}
		if(i < 0x20000)
			return(0);
		else
			return(1);
	}
}	


