/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dnld.c: version 25.1 created on 11/27/91 at 14:34:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dnld.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "spm.h"
#include "global.h"
#include "types.h"
#include "ascc.h"
#include "misc.h"
#include "filehdr.h"
#include "scnhdr.h"
#include "aouthdr.h"
#include "a.out.h"
/*
 * 	RECEIVE
 *		an xmodem protocol receiver program. Only gets a file
 *		in binary format, CRC.
 *		19.2K buad rate and 1K data block
*/


#define TRUE            1               
#define FALSE           0
#define CNT_Z		0x1A	/* continue the download process */
#define CNT_D		0x04	/* Exit from download and back to monitor */
#define CNT_Q		0x04	/* Enable transmission from host computer */
#define CNT_S		0x11	/* Stop transmission from host computer */
#define CNT_C		0x03
#define SOH             001
#define EOT             004
#define ACK             006
#define LF              012     /* Unix LF/NL */
#define CR              015
#define NAK             025
#define CAN             030
#define TIMEOUT         -1
#define ERRORMAX        10      /* maximum errors tolerated */
#define RETRYMAX        10      /* maximum retries to be made */
#define BBUFSIZ         1024     /* buffer size -- do not change! */
#define BITMASK		0xff	/* removes extra bits from int */
#define iqsize		1024

/*  UMODEM Constants  */
#define		 CRCCHR		'C'	/* CRC request character */
/*
 CRC-16 constants:
*/
/* the CRC polynomial. */
#define P	0x1021
/* number of bits in CRC */
#define W	16
/* number of bits per char */
#define B	8

/* crctab as calculated by initcrctab() */
unsigned short crctab[1<<B] = {
	0x0000,  0x1021,  0x2042,  0x3063,  0x4084,  0x50a5,  0x60c6,  0x70e7,
	0x8108,  0x9129,  0xa14a,  0xb16b,  0xc18c,  0xd1ad,  0xe1ce,  0xf1ef,
	0x1231,  0x0210,  0x3273,  0x2252,  0x52b5,  0x4294,  0x72f7,  0x62d6,
	0x9339,  0x8318,  0xb37b,  0xa35a,  0xd3bd,  0xc39c,  0xf3ff,  0xe3de,
	0x2462,  0x3443,  0x0420,  0x1401,  0x64e6,  0x74c7,  0x44a4,  0x5485,
	0xa56a,  0xb54b,  0x8528,  0x9509,  0xe5ee,  0xf5cf,  0xc5ac,  0xd58d,
	0x3653,  0x2672,  0x1611,  0x0630,  0x76d7,  0x66f6,  0x5695,  0x46b4,
	0xb75b,  0xa77a,  0x9719,  0x8738,  0xf7df,  0xe7fe,  0xd79d,  0xc7bc,
	0x48c4,  0x58e5,  0x6886,  0x78a7,  0x0840,  0x1861,  0x2802,  0x3823,
	0xc9cc,  0xd9ed,  0xe98e,  0xf9af,  0x8948,  0x9969,  0xa90a,  0xb92b,
	0x5af5,  0x4ad4,  0x7ab7,  0x6a96,  0x1a71,  0x0a50,  0x3a33,  0x2a12,
	0xdbfd,  0xcbdc,  0xfbbf,  0xeb9e,  0x9b79,  0x8b58,  0xbb3b,  0xab1a,
	0x6ca6,  0x7c87,  0x4ce4,  0x5cc5,  0x2c22,  0x3c03,  0x0c60,  0x1c41,
	0xedae,  0xfd8f,  0xcdec,  0xddcd,  0xad2a,  0xbd0b,  0x8d68,  0x9d49,
	0x7e97,  0x6eb6,  0x5ed5,  0x4ef4,  0x3e13,  0x2e32,  0x1e51,  0x0e70,
	0xff9f,  0xefbe,  0xdfdd,  0xcffc,  0xbf1b,  0xaf3a,  0x9f59,  0x8f78,
	0x9188,  0x81a9,  0xb1ca,  0xa1eb,  0xd10c,  0xc12d,  0xf14e,  0xe16f,
	0x1080,  0x00a1,  0x30c2,  0x20e3,  0x5004,  0x4025,  0x7046,  0x6067,
	0x83b9,  0x9398,  0xa3fb,  0xb3da,  0xc33d,  0xd31c,  0xe37f,  0xf35e,
	0x02b1,  0x1290,  0x22f3,  0x32d2,  0x4235,  0x5214,  0x6277,  0x7256,
	0xb5ea,  0xa5cb,  0x95a8,  0x8589,  0xf56e,  0xe54f,  0xd52c,  0xc50d,
	0x34e2,  0x24c3,  0x14a0,  0x0481,  0x7466,  0x6447,  0x5424,  0x4405,
	0xa7db,  0xb7fa,  0x8799,  0x97b8,  0xe75f,  0xf77e,  0xc71d,  0xd73c,
	0x26d3,  0x36f2,  0x0691,  0x16b0,  0x6657,  0x7676,  0x4615,  0x5634,
	0xd94c,  0xc96d,  0xf90e,  0xe92f,  0x99c8,  0x89e9,  0xb98a,  0xa9ab,
	0x5844,  0x4865,  0x7806,  0x6827,  0x18c0,  0x08e1,  0x3882,  0x28a3,
	0xcb7d,  0xdb5c,  0xeb3f,  0xfb1e,  0x8bf9,  0x9bd8,  0xabbb,  0xbb9a,
	0x4a75,  0x5a54,  0x6a37,  0x7a16,  0x0af1,  0x1ad0,  0x2ab3,  0x3a92,
	0xfd2e,  0xed0f,  0xdd6c,  0xcd4d,  0xbdaa,  0xad8b,  0x9de8,  0x8dc9,
	0x7c26,  0x6c07,  0x5c64,  0x4c45,  0x3ca2,  0x2c83,  0x1ce0,  0x0cc1,
	0xef1f,  0xff3e,  0xcf5d,  0xdf7c,  0xaf9b,  0xbfba,  0x8fd9,  0x9ff8,
	0x6e17,  0x7e36,  0x4e55,  0x5e74,  0x2e93,  0x3eb2,  0x0ed1,  0x1ef0
};

char 	*tail,*head;
char 	input_q[iqsize];
char 	newdnld;
extern char comm_args[][MAXARGSIZE];

#ifdef	SPM_IMAGE
char    macbuf[(BBUFSIZ + 1)*2];	/* give me a large one. */
#endif

#define BUFPOINT 0x103e000
unsigned char *buff=(unsigned char *)BUFPOINT;	/*8k down from top of ram.*/

#define loadpoint	0x1000000
#define oloadpoint	0x100ff08

int     delay=3;

struct fhdr {
	FILHDR filhdr;
	AOUTHDR saouthdr;
	SCNHDR sctnhdr[6];
};


#ifdef	SPM_PROM
dnfile1(singdnld)	/* this does the download. */
int singdnld;
{
	unsigned long *ptr; /* clear memory, before downloading. */

/* Here, we can clear all of memory, since if it fails, it will return
   and start the monitor over again (which re-initilizes memory).  Needed
   by the OS group.
*/
	for(ptr = (unsigned long *)0x1000000; ptr < (unsigned long *)0x103a000;)
		*ptr++ = 0;	/* clear's all of the bss stuff. */
	if(rfile((char *)0, singdnld))	/* sigh.. it failed downloads. */
	{
		if(!singdnld)
			printf("Download failed.\n\r");
		return(1); /* returns to local monitor only. */
	}
	if(!singdnld)
		printf("\rDownload complete.\n\r");
	return(0);	 /* tell program ok to execute. */
}
#endif


/**  receive a file  **/
rfile(bufferadd, singdnld)
unsigned char *bufferadd;
int singdnld;
{
	unsigned char *mem=bufferadd;	/* pointer to memory on char array */
	register struct scnhdr *scnptr;
	register struct fhdr *fhptr;
	int j, firstchar, sectnum=0, sectcurr;
	int sectcomp, errors=0, errorflag;
	register int bufctr, checksum;
	register int c, firstsec=0;
	int fatalerror=FALSE, inchecksum;
	int             cnt,lowlim;

	sendbyte(CRCCHR, singdnld);	/* CRC startup, in place of NAK. */
	do
	{   
		errorflag = FALSE;	/* clear errors. */
		do {
			firstchar = readbyte(6, singdnld); /* wait for char. */
		} while ((firstchar != SOH) && (firstchar != EOT)
				&& (firstchar != TIMEOUT));
		if (firstchar == TIMEOUT)	/* timed out.. next loop.*/
			errorflag = TRUE;

		if (firstchar == SOH)	/* if char was SOH byte, start block. */
		{
			sectcurr = readbyte(delay, singdnld); /* get blk # */
			sectcomp = readbyte(delay, singdnld); /*inverse blk # */

			if ((sectcurr + sectcomp) == BITMASK) /* BYTE Addition*/
			{ /* now check that this is the block you wish..*/
				if (sectcurr == ((sectnum + 1) % 256) & BITMASK)
				{
					checksum = 0;
					bufctr = 0;
					for (j = 0; j < BBUFSIZ; j++)
					{
						c = readbyte(delay, singdnld);
						buff[bufctr] = (char)c;
checksum = (checksum<<8) ^ crctab[((((checksum>>(8))&0x00ff) ^ (c & 0x00ff))&0x00ff)];
						bufctr++;
					}
					checksum &= 0xffff;	/* strip it.*/
					inchecksum = readbyte(3, singdnld);
					/* get 16 bit CRC */
					inchecksum = ((inchecksum<<8) | readbyte(3, singdnld)) & 0xffff;
					if (checksum == inchecksum)  
					/* good checksum */
					{
						errors = 0;
						sectnum = sectcurr;  /* update sector counter */
						if(!firstsec && !mem) 
						/* if the first sector */
						{
							firstsec++;	/* never go here twice. */
							fhptr = (struct fhdr *)buff; /* always here now.*/
							if(fhptr->filhdr.f_magic == A68020MAGIC)
							{
								scnptr=fhptr->sctnhdr;
								cnt = scnptr->s_scnptr;	/* set buffer point. */
								if(!mem) /* it's null,so get from file */
									mem = (unsigned char *)scnptr->s_paddr;
							}
							else
								cnt = 0;
							for(; cnt < BBUFSIZ; cnt++)
								*mem++ = buff[cnt];	/* put it in memory..*/
						}
						else
							for(cnt = 0; cnt < BBUFSIZ; cnt++)
								*mem++ = buff[cnt];	/* put it in memory..*/
						*mem = 0; /* make sure it's cleared out for getmac */
						if(!singdnld)
							putline("\r%03d", sectcurr); /* */
						sendbyte(ACK, singdnld);	/* got a good block now. */
						signal(sectnum);
					}
					else
					{
						errorflag = TRUE; /* checksum failed.. bad block. */
 					}
				}
				else
				{ /* if this is the same block we got a second ago, it's ok.*/
					if (sectcurr == (sectnum % 256) & BITMASK)
					{	/* wait until end of block, then just ack it. */
						while(readbyte(3, singdnld) != TIMEOUT);
						if(!singdnld) /*no printf's in dnld.*/
							putline("duplicate sector.\n\r");
						sendbyte(ACK, singdnld); /* note: we just dump the data. */
					}
					else /*if not previous block, not this block, then bad.*/
					{
						if(!singdnld) /*no printf's in dnld.*/
							putline("Fatal error \n\r"); /*no prints in dnld.*/
						errorflag = TRUE;
						fatalerror = TRUE;	/* abort transfer. */
						sendbyte(CAN, singdnld);	/* show sender we died. */
					}
				}
			}
			else /* block number and inverse block number bad. */
			{ /* set error to ignore the block. */
				errorflag = TRUE;
			}
		}
		if (errorflag == TRUE)
		{
			errors++;	/* show we had an error. */
			while (readbyte(3, singdnld) != TIMEOUT);	/* wait until bytes stop. */
			sendbyte(NAK, singdnld);	/* tell sender we failed block read. */
		}
	} while ((firstchar != EOT) && (errors != ERRORMAX) && !fatalerror);
	sendbyte(ACK, singdnld);
	if ((firstchar == EOT) && (errors < ERRORMAX))
		return(0);	/* ok. If here, we are all done!  */
	else /* errors were to much for us, then give up and return to the monitor*/
		return(1);
}

/* get a byte from channel 1 -- timeout if "seconds" elapses */
/*      NOTE, however, that this function returns an INT, not a BYTE!!!  */
readbyte(seconds, singdnld)
unsigned        seconds;
int	singdnld;
{
	int     count,c;
	register struct ascc *sccbptr;

	if(singdnld)
		sccbptr = AUXASCC0A;
	else
		sccbptr = AUXASCC0B;
	count = seconds * 0x10000;
	while(1)	{
		if(sccbptr->reg[0].reg & RR0_RX) { 	/* data available */
			c = sccbptr->reg[8].reg; 	/* read it */
			break;
		}
		else	{
			if (count) {
				count--;
			}
			else
				break;
		}
	}
	if (count == 0)
		return(TIMEOUT);
	else
		return(c & BITMASK);  		/* return data, 8 bits. */
}


/* send a byte to channel 1 */
sendbyte(data, singdnld)
char    data;
int	singdnld;
{
	char    dataout;
	register struct ascc *sccbptr;

	if(singdnld) /* using chan a instead. */
		sccbptr = AUXASCC0A;
	else /* normal channel for download. */
		sccbptr = AUXASCC0B;
	dataout = data & BITMASK;	/* only send one byte. */
	while(!(sccbptr->reg[0].reg & RR0_TX) )
		;
	sccbptr->reg[8].reg = dataout; /* sent one byte */
	return;
}

#ifdef	SPM_PROM
dnld(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned *ptr = (unsigned *)0x103e000; /* point to buffer. */
	unsigned char *ovptr;
	unsigned char *addr; /* point to buffer. */
	int singdnld=0;

	if(*(comm_str) == 'o') /* if this is "newboot" command. */
	{
		newdnld=0; /* show doing old one. */
		comm_str++;	/* and don't blow the rest of compares. */
	}
	else
		newdnld = 1;	/* make sure it's new stuff. */

	if(*(comm_str) == 'S') /* if this is a SINGLE download. */
		singdnld = 1;	/* now, do single port download. */
	else
		singdnld = 0;	/* do double port download. */

	if(arg_cnt)
		if(newdnld)
			*ptr = (unsigned)atox(comm_args[1]); /* user jump point. */
		else
			addr = (unsigned char *)atox(comm_args[1]); /* user jump point. */
	else
		if(newdnld)
			*ptr = (unsigned)0x1000400;	/* normal jump point. */
		else
			addr = (unsigned char *)0x1010400; /* normal jump point. */

	if(newdnld)
		ovptr = (unsigned char	*)(loadpoint);
	else
		ovptr = (unsigned char	*)(oloadpoint);

	head = tail = input_q;
	if (singdnld || connect())	/* if request is complete: */
	{
		if(newdnld)	/* if using new stuff. */
			dnfile(singdnld); /* do the download (in prom), never comes back. */
		else
		{
			if(!rfile(ovptr, singdnld)) /* it passed.. */
			{
				printf("\rDownload completed.\n");
				if(load_sections(ovptr)) /* failed magic #. */
					return; 
				(*(PFI)addr)(); /* go jump to program. */
			}
			else
				printf("Download failed.\n");
		}
	}
}
#endif

/*
	Set up connection with host computer 
*/
connect()
{
	int     c;

	while (1) {
		if (( c = keyin(0) ) != -1)
		{
			if ( c == CNT_C ) 	/* abort it */
				return(0);
			if ( c == CNT_Z )	/* continue download */
				return(1);
			keyout(c,1);
		}
		if (( c = keyin(1) ) != -1)
		{
			keyout(c,0);
		}
	}
}

signal(num)
unsigned num;
{
	if(num & 1)
		*WRCNTL2 = *WRCNTL2 & ~WR2_GRNLED; 
	else
		*WRCNTL2 = *WRCNTL2 | WR2_GRNLED;
}
	

keyin(port)
char        port;
{
	int     c;
	register struct ascc *sccaptr = AUXASCC0A;
	register struct ascc *sccbptr = AUXASCC0B;

	if ( port == 0 )	{
		if(sccaptr->reg[0].reg & RR0_RX) { 	/* data available */
			c = sccaptr->reg[8].reg; 	/* read it */
			return(c & BITMASK);  		/* return data 8 bits */
		}
		else	{
			return(-1);
		}
	}
	if ( port == 1 )	{
		ringin();
		if (head != tail)	{
			c = (*head++);
			if ( head == &input_q[sizeof input_q])
				head = input_q;
			return(c & BITMASK);
		}
		else	{
			return(-1);
		}
	}
}

/* send one byte data to a port */
keyout(data,port)
char        port;
int    data;
{
	char    dataout;
	register struct ascc *sccaptr = AUXASCC0A;
	register struct ascc *sccbptr = AUXASCC0B;

	dataout = (char)data & BITMASK;	/* only send one byte. */
	if ( port == 0 )	{
		while(!(sccaptr->reg[0].reg & RR0_TX) )
			ringin();
		sccaptr->reg[8].reg = dataout; /* sent one byte to channel 0 */
	}
	if ( port == 1 )	{
		while(!(sccbptr->reg[0].reg & RR0_TX) )
			;
		sccbptr->reg[8].reg = dataout; /* sent one byte to channel 1 */
	}
		return;
}

ringin()
{
	char	c;
	register struct ascc *sccbptr = AUXASCC0B;

	if(sccbptr->reg[0].reg & RR0_RX) { 
		c = sccbptr->reg[8].reg; 
		*tail++ = c;
		if ( tail == &input_q[sizeof input_q])
			tail = input_q;
	}
}

load_sections(object_ptr) /* old code, to insure boot still works for now. */
unsigned char *object_ptr;
{
	register struct scnhdr *scnptr;
	register struct fhdr *fhptr;
	unsigned char *loadptr,*fptr;
	register i,ssize;

	fhptr = (struct fhdr *)object_ptr;
	if(fhptr->filhdr.f_magic != A68020MAGIC)
	{
		printf("Invalid magic number: %4x\n",fhptr->filhdr.f_magic);
		return(1);
	}
	scnptr=fhptr->sctnhdr;
	for(i=0; i<fhptr->filhdr.f_nscns; i++,scnptr++)
	{
		loadptr = (unsigned char *)scnptr->s_paddr;
		fptr = scnptr->s_scnptr + object_ptr;
		for(ssize=0; ssize<scnptr->s_size; ssize++,loadptr++,fptr++) 
			*loadptr = *fptr;
	}
	return(0);
}

#ifdef	SPM_IMAGE
static char savfile[]="macbuf";
static char str1mac[]="cat >> "; /* startup string. */
#endif

#ifdef	SPM_IMAGE
macsav(comm_str,arg_cnt) /* save a macro into host memory. */
char *comm_str;
int arg_cnt;
{
	unsigned char *addr;
	char *name;
	int	i, i1, singdnld=0;

	if(arg_cnt) /* if there is at least 1. */
		name = comm_args[1]; /* point name at it. */
	else
		name = savfile;

	if(arg_cnt > 1) /* if there  is an address as well. */
		addr = (unsigned char *)atox(comm_args[2]);
	else
		addr = (unsigned char *)macbuf;

	head = tail = input_q;	/* initilize connect routine. */
	if (connect())	/* connect passed. */
	{
		for(i = 0; str1mac[i]; i++) /* while chars in command string */
			send1byte(str1mac[i]); /* send it */
		while(*name) /* while chars in file name */
			send1byte(*name++); /* send it */
		send1byte('\n'); /* make it start. */
		for(i = 0; i < 80000; i++) ; /* sigh. */
		while(*addr)  /* while chars here. */
			send1byte(*addr++);
		for(i1 = 0; i1 < 50000; i1++) ; /* sigh. */
		addr--;
		if((*addr&0x7f) != '\n')
		{
			send1byte('\n'); /* send a final linefeed. */
			for(i1 = 0; i1 < 50000; i1++) ; /* sigh. */
		}
		send1byte('\004'); /* send a control-D. */
		for(i1 = 0; i1 < 20000; i1++) ; /* sigh. */
		while(keyin(1) != -1) ; /* remove echo'd chars. */
		printf("\rMacro transfer completed.\n");
	}
}
#endif

#ifdef	SPM_IMAGE
send1byte(ch, singdnld)
int singdnld;
{
	int	i;

/*	for(i = 0; i < 5000; i++) ;	/* */
/*	sendbyte(ch, singdnld);	/* */
	sendbyte(ch, singdnld);	/* send this character. */
	for(i = 0; i < 38000; i++)	/* loop for a long time.. */
	{
		if(keyin(1) != -1)	/* if a key came back.. */
			break;	/* exit loop. key for key.. */
	}
	while(keyin(1) != - 1) ; /* loop in case extra chars come across. */
}
#endif

#ifdef	SPM_IMAGE
macget(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	unsigned char *addr;
	int singdnld=0;

	if(arg_cnt)
		addr = (unsigned char *)atox(comm_args[1]);
	else
		addr = (unsigned char *)macbuf;
	head = tail = input_q;
	if (connect())
	{
		if (rfile(addr, singdnld))	/* send it over. */
			printf("Download failed.\n");
		else
			printf("\rDownload complete.\n");
	}
}
#endif

putline(fmt, args) /* print a line, without using ram other than stack. */
char *fmt;
int args;
{
#ifdef	SPM_IMAGE
	char buf[80]; /* only one line possible. */
	int 	i=0, i1;

	i1 = args; /* we only print one, eh? */
	sprintf(buf, fmt, i1); /* convert string. */
	while(buf[i]) /* now, put entire string on screen. */
		con_out(buf[i++]); /* send this char. */
#endif

#ifdef	SPM_PROM
	printf (fmt, args);
#endif
}

