/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dispn.c: version 25.1 created on 11/27/91 at 14:34:31	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dispn.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
	non-directed interupt tests.
*/
#include "disp.h"
#include "spm.h"
#include "iom.h"

extern int cpu1here[];			/* slots for cpu's... eh? */
extern unsigned char bdhere[];		/* CSS bus slot configuration. */
extern char cpuack;				/* show we passed test. */
extern unsigned char myslot;	/* This is where I am. */

chkint(loop, iom)	/* go setup our cpu now. */
int	loop, iom;
{
	int i;
	register unsigned *j, dat;

	j = (unsigned *)((0x0c002000 | (loop<< 8))); /* build starting address.. */
	dat = 0x00800000 | (loop << 12) | (iom << 8);

	for(i = 0; i < 63; i++)	/* test all 63 address points. */
	{
		if((*j&0xffffff00) != dat)
		{
			printf("Failed CPU%d int 4 data compare: Got:%08x:  Exp:%08x: i=:%d:\n",loop,*j,dat, i);
			return(1);	/* skip this area.. */
		}
		j++;	/* next int location. */
	}

	dat = (0x0c003000 | (loop<< 8));	/* build starting address.. */
	j = (unsigned *)dat; /* and copy across.. */
	dat = 0x00810000 | (loop << 12) | (iom << 8);
	for(i = 0; i < 63; i++)	/* test all 63 address points. */
	{
		if((*j&0xffffff00) != dat)
		{
			printf("Failed CPU%d int 5 data compare: Got:%08x:  Exp:%08x: i=:%d:\n",loop,*j,dat, i);
			return(1);	/* skip this area.. */
		}
		j++;	/* next int location. */
	}
	j = (unsigned *)(0xa0000000 + (loop * 32) + 20); /* use map2, offset 0. */
	if(*j != 63)  /* sigh. it was bad, eh? */
	{
		printf("Memory count CPU%d level 5 failed.  exp:63: got:%d:\n",loop, *j);
		return(1);
	}

	j = (unsigned *)(0xa0000000 + (loop * 32) + 24); /* use map2, offset 0. */
	if(*j != 63)  /* sigh. it was bad, eh? */
	{
		printf("Memory count CPU%d level 6 failed.  exp:63: got:%d:\n",loop, *j);
		return(1);
	}

	return(0);
}

nchkint(loop, iom)	/* go setup our cpu now. */
int	loop, iom;
{
	register unsigned *j, dat;
	int i, i1;
	int count[4];	/* four int's worth. */

	j = (unsigned *)((0x0c000000 | (loop<< 11))); /* build starting address.. */
	if(loop == 1 || loop == 2) /* sigh. */
		loop = (loop==1)? 2:1; /* if not, invert it. */
	dat = 0x00000000 | (loop << 16) | (iom << 8);

	for(i = 0; i < 127; i++)	/* test all 63 address points. */
	{
		if((*j&0xffffff00) != dat)
		{
			printf("Failed int level %d data compare: Got:%08x:  Exp:%08x: offset=:%d:\n",loop,(*j & 0xffffff00),dat, i);
			return(1);	/* skip this area.. */
		}
		j++;	/* next int location. */
	}
	return(0);
}


nchkdat(idle)	/* check the data in memory. */
int	idle;	/* if set, only ONE cpu should be data... first one. */
{
	register unsigned *j;
	int i, i1, er_st=0;
	int count[4];	/* four int's worth. */

	count[0] = count[1] = count[2] = count[3] = 0; /* clear all out. */
	for(i = 0; i< 16; i++)  /* now, loop through all cpu's, adding up counts. */
		if(bdhere[i] == CPUHERE)	/* if we found a cpu here.. */
		{
			j = (unsigned *)(0xa0000000 + (i * 32) + 4); /* base offset.*/
			for(i1 = 0; i1 < 4; i1++)	/* count four levels here.. */
				count[i1] += *j++;	/* add in data. */
			if(idle) /* if doing idle test, only first cpu should count. */
				break; /* get out of loop NOW. */
		}
	if(count[0] != 127)	/* failed.. */
	{
		printf("Memory count level 0 failed.  exp:127: got:%d:\n", count[0]);
		er_st |=8; /* show bad. */
	}
	if(count[1] != 127)	/* failed.. */
	{
		printf("Memory count level 1 failed.  exp:127: got:%d:\n", count[1]);
		er_st |=8; /* show bad. */
	}
	if(count[2] != 127)	/* failed.. */
	{
		printf("Memory count level 2 failed.  exp:127: got:%d:\n", count[2]);
		er_st |=8; /* show bad. */
	}
	if(count[3] != 127)	/* failed.. */
	{
		printf("Memory count level 3 failed.  exp:127: got:%d:\n", count[3]);
		er_st |=8; /* show bad. */
	}

	return(er_st);
}

/*------------------------------------------------------------------------------
	unmap()	: program one cpu for commands.
------------------------------------------------------------------------------*/
unmap(targ, mem, non)
int targ,mem;
int non;						/* if set, also program lower ones. */
{
	cssmap(MAP03,(unsigned char)targ,(unsigned char)0x0f); /* setup map */

	cpuack = 1;							/* we handle our ack's quietly. */
	if(ipccsend(targ,0x33,(int)myslot)) return(1);	/* cpu not handle int's */
	if(non)										/* if doing this. */
	{
		if(ipccsend(targ,0x35,1)) return(1);	/* tell cpu to skip int's.. */
		if(ipccsend(targ,0x35,2)) return(1);	/* tell cpu to skip int's.. */
		if(ipccsend(targ,0x35,3)) return(1);	/* tell cpu to skip int's.. */
		if(ipccsend(targ,0x35,4)) return(1);	/* tell cpu to skip int's.. */
		if(ipccsend(targ,0x3a,1)) return(1);	/* disable mem accounting. */
		if(ipccsend(targ,0x3a,2)) return(1);	/* disable mem accounting. */
		if(ipccsend(targ,0x3a,3)) return(1);	/* disable mem accounting. */
		if(ipccsend(targ,0x3a,4)) return(1);	/* disable mem accounting. */
	}
	if(!non || non == 2) {
		if(ipccsend(targ,0x35,5)) return(1);	/* tell cpu to skip int's.. */
		if(ipccsend(targ,0x35,6)) return(1);	/* tell cpu to skip int's.. */
		if(ipccsend(targ,0x3a,5)) return(1);	/* disable mem accounting. */
		if(ipccsend(targ,0x3a,6)) return(1);	/* disable memory accounting. */
	}
	cpuack = 0;						/* we don't handle our ack's quietly. */
	return(0);
}

domap(targ,mem,non)			/* program one cpu for commands. */
int targ,mem;
int non;					/* if set, do the lower levels too.. */
{
	cssmap(MAP03,(unsigned char)targ,(unsigned char)0x0f);	/* setup address. */
	cpuack = 1;							/* we don't handle our ack's quietly. */

	if(ipccsend(targ,0x38,myslot)) return(1);	/* tell cpu myslot slot. */
	if(ipccsend(targ,0x32,myslot)) return(1);	/* tell cpu to handle int's */
	if(ipccsend(targ,0x36,mem)) return(1);		/* tell cpu memory slot. */
	if(ipccsend(targ,0x37,(targ*32))) return(1);/* tell cpu memory offset. */
	if(non)	{							/* if doing this. */
		if(ipccsend(targ,0x39,1)) return(1);	/* enable accounting to mem. */
		if(ipccsend(targ,0x39,2)) return(1);	/* enable accounting to mem. */
		if(ipccsend(targ,0x39,3)) return(1);	/* enable accounting to mem. */
		if(ipccsend(targ,0x39,4)) return(1);	/* enable accounting to mem. */
		if(ipccsend(targ,0x34,1)) return(1);	/* tell cpu to ack the int. */
		if(ipccsend(targ,0x34,2)) return(1);	/* tell cpu to ack the int. */
		if(ipccsend(targ,0x34,3)) return(1);	/* tell cpu to ack the int. */
		if(ipccsend(targ,0x34,4)) return(1);	/* tell cpu to ack the int. */
	}
	if(!non || non==2)					/* if doing this. */
	{
		if(ipccsend(targ,0x39,5)) return(1);	/* enable accounting  memory. */
		if(ipccsend(targ,0x39,6)) return(1);	/* enable accounting  memory. */
		if(ipccsend(targ,0x34,5)) return(1);	/* tell cpu to ack interrupt. */
		if(ipccsend(targ,0x34,6)) return(1);	/* tell cpu to ack interrupt. */
	}
	cpuack = 0;			/* Show we don't want to handle our ack's quietly. */
	return(0);
}


sendidle(j1)	/* send all the idle characters.. */
register char *j1;  /* pointer to send commands to iom.. */
{
	register unsigned int cpu;	/* used to program the idle register. */
	int	i, i1, i2, i3;

/*	printf("Idle CPU %d.\n", cpu1here[0]-1); /*show which one. */
	*WRCNTL1 &= ~WR1_IDLERST; /* let's reset the beasty.. */
	*WRCNTL1 |=  WR1_IDLERST; /* let's reset the beasty.. */
	cpu = ((unsigned int)(cpu1here[0]-1)) << IDLESHFT; /* take first in slot. */
	for(i = 0; i < 16; i++)	/* let's fill up the first 16 of these.. */
		*IDLEREG = cpu; /* fill in the slot. */

	for(i = 0; i < 127; i++)	/* generate 127 of these ints.. */
	{ /* generate 127 sets of four.. */
		*j1 = 18; /*gen int, level 0.*/
		for(i3 = 0; i3 < 800; i3++)   ;  /* pause a bit.. */
		*j1 = 19; /*gen int, level 1.*/
		for(i3 = 0; i3 < 800; i3++)   ;  /* pause a bit.. */
		*j1 = 20; /*gen int, level 2.*/
		for(i3 = 0; i3 < 800; i3++)   ;  /* pause a bit.. */
		*j1 = 21; /*gen int, level 3.*/
		for(i3 = 0; i3 < 800; i3++)   ;  /* pause a bit.. */
		i2 = 0;
		while((*STATUSREG & STAT_IDLE_FULL) && (i2++ < 32)) /* keep it full.. */
			*IDLEREG = cpu; /* fill in the slot. */
	}
	for(i = 0; i < 1000; i++)	/* ok.. let's have fun.. */
		;
}

