/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dispd.c: version 25.1 created on 11/27/91 at 14:34:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dispd.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
	directed mode dispatcher tests.
*/
#include "types.h"
#include "globl.h"
#include "global.h"
#include "spm.h"
#include "iom.h"
#include "routines.h"
#include "disp.h"

/* the following garbage is for the directed interrupt to my slot.. */
extern char tstdisp;	/* set if we are in test mode. */
extern char overflow;	/* if set, in special dispatcher test mode. */
extern unsigned char myslot;		/* This is where I am. */

char disptest;	/* set if we are in test mode. */
char ack5;	/* set if we want to only ack ourselves.. */
char ack6;	/* set if we want to only ack ourselves.. */
int  acks5;	/* number of ack's already. */
int  acks6;	/* number of ack's already. */
unsigned *jack5;	/* pointer to ack level 5's. */
unsigned *jack6;	/* pointer to ack level 5's. */
int ackdat5;	/* data from ack level. */
int ackdat6;	/* data from ack level. */
extern unsigned char bdhere[];		/* CSS bus slot configuration. */
int cpu1here[8];	/* slots for active cpu's... for converted table. */

mdasp_test(non, idle)	/* do the dispatcher test. */
int	non;	/* if set, doing non-directed ints. */
int	idle;	/* if set, program idle loops to be active.. */
{
	register unsigned i;
	register char *j1 = (char *)0x8ffffc00;	/* setup command pointer. */
	register unsigned *j;
	int	er_st=0, loop, tmlp;	/* err code.. good or bad. */
	int	mem=0, iom=0, prt=0, i3, ttb;

	if((iom = findiom(1)) == 18) return;
	if((mem = findmem(1)) == 18) return;
	for(i = 0; i < 8; i++)
		cpu1here[i] = 0;	/* make sure local cpu table is all cleared. */
	i = 0;
	for(loop = 0; loop < 16; loop++)	/* find the cpu's.. */
		if(bdhere[loop] == CPUHERE) {	/* found first one. */
			if(domap(loop,mem,non))		/* go setup our cpu now. */
				return(1);
			cpu1here[i++] = loop+1;		/* what slot this is. */
		}

	printf("Testing slots: SPM %d, MEM %d, IOM %d,  ", (int)myslot, mem, iom);
	printf("CPU(s): ");
	for(i = 0; i < 8; i++)				/* only allow's 8.. */
		if(cpu1here[i])					/* if we are using this one.. */
			printf(" %X,", (cpu1here[i] -1));
	printf("%c \n", 0x08);				/* hehehe.. */
	cssmap(MAP02,(unsigned char)mem,(unsigned char)0); /* memory for buffers. */
	cssmap(MAP04,(unsigned char)myslot,(unsigned char)0x0f); /*slot to ack*/

	mdisp_init(0); /* just this stuff. */

	minitiom(iom); /* program iom tables for directed ints. */

/* now, all is setup.. We hope.. */
	disptest = 1;	/* toggle in the dispatcher test mode. */
	tstdisp = 1;	/* toggle in the dispatcher test mode. */
	overflow = 0;	/* make sure it's cleared. */
	ack5 = ack6 = 0;
	jack5 = (unsigned *)0xcfffff2c; /* point to int 5. (excptions.c) */
	jack6 = (unsigned *)0xcfffff34; /* point to int 6. (excptions.c) */

	while(1)	/* silly looping mech.. */
	{
		if(ifesc())  break;	/* if pressed escape, skip it. */

		acks5 = acks6 = 0;
		j = (unsigned *)0xa0000000; /* use map2, offset 0. */
		for(i = 0; i < 500; i++)	/* fill memory to be used with zeros. */
			*j++ = 0;	/* fill all working memory with zeros...  */

		if(!idle)	/* not doing idle loops. */
		{
			if(non)	/* if doing non-directed ints. */
			{
				for(i = 0; i < 127; i++) /* generate 127 of these ints.. */
				{ /* generate 127 sets of four.. */
					*j1 = 18; /*gen int, level 0.*/
					*j1 = 19; /*gen int, level 1.*/
					*j1 = 20; /*gen int, level 2.*/
					*j1 = 21; /*gen int, level 3.*/
				}
			}
			if(!non || non==2)  /*if doing directed ints. */
			{
				for(i = 0; i < 63; i++)	/* generate 63 of these ints.. */
				{
					for(loop = 0; loop < 8; loop++)	/* sigh.. */
						if(cpu1here[loop]) /* there is a valid cpu here..*/
						{
							*j1 = ((loop * 2) + 1); /*gen int, level 5.*/
							*j1 = (loop * 2);       /*gen int, level 6.*/
						}
				}
			}
/* ok, now.. generate our spm slot interrupts. */
			if(!non || non == 2) {
				ack5 = 1;	/* enable checking of level 5 acks.. */
				for(i = 0; i < 63; i++)	/* let's do this many.. */
					*j1 = 16;	/* generate spm interrupts.. eh? */
					for(i = 0; i < 800; i++)  ;	/* pause again. */
				ack5 = 0;	/* disable checking of level 5 acks.. */

				ack6 = 1;	/* enable checking of level 6 acks.. */
				for(i = 0; i < 63; i++)	/* let's do this many.. */
					*j1 = 17;	/* generate spm interrupts.. eh? */
				for(i = 0; i < 800; i++)  ;	/* pause again. */
				ack6 = 0;	/* disable checking of level 6 acks.. */

				if(acks5 != 63)	/* sigh. .*/
					printf("Failed count on SPM level 5 ints.  Got:%d:\n", acks5);
				if(acks6 != 63)	/* sigh. .*/
					printf("Failed count on SPM level 6 ints.  Got:%d:\n", acks6);
			}

			if(non)
/*				for(i = 0; i < 185000; i++) ; /* give a *lot* of time. */
				for(i = 0; i < 185000; i++)  /* give a *lot* of time. */
					ttb = *((unsigned *)(0xaffffffc)); /* read bd id. */
			else
/*				for(i = 0; i < 85000; i++) ; /* give a *lot* of time. */
				for(i = 0; i < 85000; i++)  /* give a *lot* of time. */
					ttb = *((unsigned *)(0xaffffffc)); /* read bd id. */
		}
		else	/* must be idle loops.. eh? */
			sendidle(j1);	/* send idle xmit's, eh? */

		*WRCNTL1 &= ~WR1_DREQ; /* request our dispatcher rams. */

/* at this point, we should not have a count in the dispatcher rams.. */

		i = 0;  /* loop until ours. */
		while ((*STATUSREG & STAT_REG_IDRAM) && (i < 1000))  i++;
		if(i == 1000)
		{
			printf("\nUnable to access Dispatcher RAMs\n");
			break; /* failed.. */
		}
/*	check ram contents here make sure slot ram is full. */
		if(non)	/* if doing nondirected ints.. */
		{
			for( j = MISC_RAM, loop=0; loop < 4; j++, loop++)
			{ /* slide through them all. */
				if((*j&0x3ff) != (0x3ff))
				{
					printf("Failed count on level %d. (%3X)\n",loop,(*j&0x3ff));
					er_st |= 1; /* add in error code. */
				}
			}

			for(loop = 0; loop < 4; loop++)	/* find the cpu's.. */
				if(nchkint(loop, iom))	/* go setup our cpu now. */
					er_st |= 2; /* add in error code. */

			nchkdat(idle);	/* go check the data in main memory now. */
		}
		if(!non || non==2) /* if doing directed ints. */
		{
			j = MISC_RAM + 4;	/* starting point. */
			if((*j&0x3ff) != (0x3ff))
			{
				printf("Failed count on level 4. (%3X)\n", (*j&0x3ff));
				er_st |= 1; /* add in error code. */
			}

			j += 1;	/* starting point. */
			if((*j&0x3ff) != (0x3ff))
			{
				printf("Failed count on level 5. (%3X)\n", (*j&0x3ff));
				er_st |= 2; /* add in error code. */
			}

			for(loop = 0; loop < 16; loop++)	/* find the cpu's.. */
				if(bdhere[loop] == CPUHERE)	/* found first one. */
					if(chkint(loop, iom))	/* go setup our cpu now. */
						er_st |= 2; /* add in error code. */

		}
		if(overflow)	/* if this errored.. */
			er_st |= 8;
		if(!er_st)	/* if passed all tests,clear out disp ram. */
		{
			;
/*			for(j=QUEUE_RAM; j<QUEUE_RAM + QUEUE_LWORDS;j++)  /* */
/*				*j = ((unsigned)j << 16) | ((unsigned)j & 0x0000ffff); /* */
			for(j=POINTER_RAM; j<POINTER_RAM + POINTER_LWORDS;j++)
				i = *j; /* just read pointer instead of write */
/*				*j= 0x7f7f0000;	/* */
		}

		*WRCNTL1 &= ~WR1_IDLERST; /* let's reset the beasty.. */
		*WRCNTL1 |=  WR1_IDLERST; /* let's reset the beasty.. */
		*WRCNTL1 |= WR1_DREQ; /* enable the dispatcher rams. */
		if(prt++ == 4)	/* if time to print a dot.. */
		{
			printf(".");
			prt = 0;
		}
		if(er_st) break; /* get out of loop if bad. */
	}

	printf("\n");
	for(loop = 0; loop < 16; loop++)	/* find the cpu's.. */
		if(bdhere[loop] == CPUHERE)	/* found first one. */
			if(unmap(loop, mem, 0))	/* go setup our cpu now. */
				return(1);

	tstdisp = 0;	/* toggle out the dispatcher test mode. */
	disptest = 0;	/* toggle out the dispatcher test mode. */

	return(0);	/* return status.. eh? */
}

mdisp_init(only)
int only;	/* if set, for all slots. */
{
	register unsigned mapnum;
	register unsigned char slotnum,slotadd;
	register unsigned char* i;
	register unsigned *j;
	register unsigned  slot,inv_slot;
	int	old, loop, noslot;

/* first, do SOME of the init_css command. */
	BusFault = 0;
	*WRCNTL2 = *WRCNTL2 | WR2_BDRST;	/* set board reset */
	slot = (*STATUSREG & STAT_SLOTMASK) >> STAT_SLOTSH;
	inv_slot = ~slot & 0x0f; 
	*WRCNTL0 = WR0_FRC_INH7 | (slot << 8) | (slot << 12) |
								(slot << 16) | (inv_slot << 20);
	mapnum = 0;	/* using map zero. */
	slotnum = (char) slot;	/* setup our real slot here. */

	for(loop = 0; loop < 15; loop++)  /* find highest not used slot. */
		if(bdhere[loop] == MEMHERE) /* get a blank slot number... */
			break;	/* found one. */
	noslot = loop; /* sigh.. assume it has one memory card, from test. */

	for(loop=0; loop < 15; loop++)	/* find lowest cpu card.. */
		if(bdhere[loop] == CPUHERE) /* if none, assume slot f has one. */
			break;
	slotadd=(unsigned char)loop; /* save it. */

	i=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*i = (slotnum << 4) | slotadd;
	*WRCNTL1 &= ~WR1_ID_RST;
	*WRCNTL1 |= WR1_ID_RST;
	*WRCNTL1 &= ~WR1_DREQ; 
	*WRCNTL1 &= ~WR1_IDLERST; /* let's reset the beasty.. */
	*WRCNTL1 |=  WR1_IDLERST; /* let's reset the beasty.. */
	/* reset interrupt dispatcher */
	/* source slot */
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) |
		(((unsigned)slotnum << 16) &0x0f0000) | ((~(unsigned)slotnum << 20) & 0xf00000) ;
	/* slot id */
	*WRCNTL0 = (*WRCNTL0 & 0xffff00ff) | 
		(((unsigned)slotnum << 12) &0xf000) | (((unsigned)noslot<<8) & 0x0f00);
	/* initialize the queue ram */
	for(j=QUEUE_RAM; j<QUEUE_RAM + QUEUE_LWORDS;j++) 
		*j = ((unsigned)j << 16) | ((unsigned)j & 0x0000ffff);
	/* initialize the pointer rams */
	for(j=POINTER_RAM; j<POINTER_RAM + POINTER_LWORDS;j++)
		*j= 0x7f7f0000;

	/* initialize the miscellaneous rams to first cpu only. */
	for(j=MISC_RAM; j<MISC_RAM + MISC_LWORDS; j++)
		if(only)	/* well, our cpu instead then. */
			*j= (0xe00003ff | (((unsigned)slotnum << 24)& 0x0f000000)); /* */
		else
			*j= (0xf00003ff | (((unsigned)slotadd << 24)& 0x0f000000)); /* */

	old = loop;	/* save starting point. */
	while(++loop < 16)	/* look for all other cpu's now. */
	{
		if(bdhere[loop] == CPUHERE)	/* if there is one here now.. */
		{
			j = MISC_RAM;	/* give starting point. */
			j += old; /* find second cpu. */
			if(only)  /* if only testing my spm. */
				*j= (0xe00003ff | (((unsigned)loop << 24)& 0x0f000000)); /**/
			else
				*j= (0xf00003ff | (((unsigned)loop << 24)& 0x0f000000)); /**/
			old = loop;	/* save it again. */
		}
	}
	j = MISC_RAM;	/* give starting point. */
	if(only)
		j += slot; /* find our spm slot. */
	else
		j += old; /* find our spm slot. */
	*j= (0xe00003ff | (((unsigned)slot << 24)& 0x0f000000)); /* */

	*WRCNTL1 = WR1_FRC_RST_ACK | WR1_IRDY | WR1_RRDY | WR1_FMOD
			| WR1_FDEST | WR1_DATYPE | WR1_FINTREC | WR1_DREQ
			| WR1_IDLERST | WR1_RSTREC | WR1_TPOL | WR1_CSSRST
			| WR1_UFTYPE | WR1_ID_RST | WR1_4BYTE_RD
			| WR1_MOTOR | WR1_FDACK | WR1_FRES | WR1_TP
			| (slot << WR1_DEST_SH)
			| WR1_POL; 
	*WRCNTL1 &= ~WR1_ID_RST;	/* now, reset this AFTER it's running and */
	*WRCNTL1 |= WR1_ID_RST;		/* it's been programmed. */
	iready();
}

/* sigh.  just do this for now, and fix it up later */
minitiom(iom_slot)
int	iom_slot;
{
	register unsigned 	*start, offset;
	unsigned char		addr, *mem;

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,(unsigned char)iom_slot,addr);
	*mem = 0x31;			/* set IO module link config. */

	mem = (unsigned char *)IOM_ER_RST; /* IOM error reset register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,(unsigned char)iom_slot,addr);
	*mem = 0x00;			/* reset IO module error */

	offset = IOM_INT_V;		/* addr of IO module interrupt vector */
	start = (unsigned *)CSSMAP(offset);
	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,(unsigned char)iom_slot,addr);	/*setup to point to int table.*/

	minilp(start); /* build a table. */

	offset = IOS_INT_V;		/* addr of IO device interrupt vector */
	start = (unsigned *)CSSMAP(offset);
	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,(unsigned char)iom_slot,addr);

	minilp(start); /* build a table. */
}

minilp(start) /* build a table for directed ints. */
int *start;
{
	register unsigned 	data;
	int	loop, nob;

	/* initial IO device interrupt vector table */
	for(loop = 0; loop < 8; loop++) /* allow for only 8 cpu's, but any slot. */
	{
		data = 0x00800000; /* start with direct int bit */
		data |= ((unsigned)myslot << 8);	/* our slot... */
		nob = cpu1here[loop];	/* get cpu slot number. */
		if(nob) nob--;	/* sub one if needed. */
		data |= ((unsigned)nob << 12);	/* dest slot. */
		*start++ = data;	/* store level 4 int's.. */
		start++;	/* once more.. sigh. */
		data |= 0x00010000; /* set level 5 interrupt */
		*start++ = data;		/* store level 5 int's.. */
		start++;	/* once more.. sigh. */
	}
	data = 0x00800000; /* start with direct int bit */
	data |= ((unsigned)myslot << 8);	/* our slot... */
	data |= ((unsigned)myslot << 12);	/* dest slot. */
	*start++ = data;	/* store level 4 int's.. */
	start++;	/* once more.. sigh. */
	data |= 0x00010000; /* set level 5 interrupt */
	*start++ = data;		/* store level 5 int's.. */
	start++;	/* once more.. sigh. */

	for(loop = 0; loop < 4; loop++) /* do four of them. */
	{ /* setup non-directed int table. */
		data = 0; /* start with zero data, non-directed int */
		data |= ((unsigned)myslot << 8);	/* our slot... */
		data |= ((unsigned)loop << 16); /* add in priority lvl. */
		*start++ = data;	/* store level loop1 int's.. */
		start++;	/* once more.. sigh. */
	}
}

fdasp_it(comm_str, arg_cnt)	/* multi-cpu test first of many. */
char *comm_str;
int arg_cnt;
{
	int	i, non=0, idle=0;
	unsigned char iom_slot;

	if(clokpr(0))
		return;	/* already printed bad.  so just return.*/
	if(findcpu(1) == 18)	/* not one found.. */
		return;

	if(findmem(1) == 18)	/* not one found.. */
		return;

	if((i = findiom(1)) == 18)	/* not one found.. */
		return;
	if(comm_str[0] == 'n') /* non-directed ints. */
		non = 1;
	else if(comm_str[0] == 'b') /* both non and directed ints. */
		non = 2;	/* setup for both directed and non directed. */
	else if(comm_str[0] == 'i')	 /* if idle loops test.. */
	{
		non = 1;	/* use non-directed ints, */
		idle = 1;	/* and enable the idle loops. */
	}

	iom_slot = (unsigned char)i; /* fixup for char passing. */
	iom_rst(iom_slot);	/* make sure the board is reset. */

	printf("\nType escape <ESC> to terminate test\n");
	mdasp_test(non, idle); /* do it. */
/*	iom_rst(iom_slot);	/* make sure the board is reset. */
}


odasp_it(comm_str, arg_cnt)	/* multi-cpu test first of many. */
char *comm_str;
int arg_cnt;
{
	register unsigned i, lop=0;
	register char *j1 = (char *)0x8ffffc00;	/* setup command pointer. */

	if(clokpr(0))
		return;	/* already printed bad.  so just return.*/

	printf("\nType escape <ESC> to terminate test\n");

	cssmap(MAP04,(unsigned char)myslot,(unsigned char)0x0f); /*slot to ack*/
	cssmap(MAP00,(unsigned char)myslot,(unsigned char)0x0f); /*slot to ack*/

	mdisp_init(1); /* just this stuff. */

	disptest = 1;					/* toggle in the dispatcher test mode. */
	tstdisp = 1;					/* toggle in the dispatcher test mode. */
	overflow = 0;					/* make sure it's cleared. */
	ack5 = ack6 = 0;
	jack5 = (unsigned *)0xcfffff2c; /* point to int 5. (excptions.c) */
	jack6 = (unsigned *)0xcfffff34; /* point to int 6. (excptions.c) */

	while(1)
	{
		if(ifesc())  break;			/* if pressed escape, skip it. */

		acks5 = acks6 = 0;
		ack5 = 1;					/* enable checking of level 5 acks.. */
		for(i = 0; i < 63; i++)		/* let's do this many.. */
			send_int(1,(unsigned)myslot,4,0);		/* send one int. */
		for(i = 0; i < 800; i++);					/* pause again. */
		ack5 = 0;					/* disable checking of level 5 acks.. */
		if(acks5 != 63) {			/* sigh. .*/
			printf("Failed count on SPM level 5 ints.  Got:%d:\n", acks5);
			break;
		}
		ack6 = 1;					/* enable checking of level 6 acks.. */
		for(i = 0; i < 63; i++)		/* let's do this many.. */
			send_int(1,(unsigned)myslot,5,0); /* send one int. */
		for(i = 0; i < 800; i++);	/* pause again. */
		ack6 = 0;					/* disable checking of level 6 acks.. */
		if(acks6 != 63)	{			/* sigh. .*/
			printf("Failed count on SPM level 6 ints.  Got:%d:\n", acks6);
			break;
		}
		if(lop++ == 25)	{			/* if 25 times around loop. */
			printf(".");
			lop = 0;
		}
	}
	tstdisp = 0;				/* toggle out the dispatcher test mode. */
	disptest = 0;				/* toggle out the dispatcher test mode. */
	printf("\n");
	return(0);					/* all done. */
}
