/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) disp.c: version 25.1 created on 11/27/91 at 14:34:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)disp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
	Dispatcher test module
*/
#include "types.h"
#include "globl.h"
#include "global.h"
#include "spm.h"
#include "iom.h"
#include "menu.h"
#include "routines.h"
#include "disp.h"

#define int_4 1 
#define int_5 2 /* a directed interrupt */

char overflow;		/* test pass or fail flag */
char tstdisp;		/* test mode flag */

extern char cpuack;	/* command ack flag; set to see acks  */
extern char cpuacked;	/* set if acked by CPU */
extern char dummiebd;	/* this is set if we don't want to increment ready */
extern unsigned char myslot;	/* this is where the board is */

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
struct init_menu id_diag1 [] = {

	"fcp(u)","",
	"Self test - directed ints", 'c', 0,0, odasp_it,(char *)0,

	"icp(u)","",
	"Non-directed with idle loop test", 'c',0,0,fdasp_it,(char *)0,

	"bcp(u)","",
	"Both non-directed and directed test", 'c',0,0,fdasp_it,(char *)0,

	"ncp(u)","",
	"Non-directed interrupt test", 'c',0,0,fdasp_it,(char *)0,

	"dcp(u)","",
	"Directed interrupt test", 'c',0,0,fdasp_it,(char *)0,

	"scp(u)","<cpu_slot> <iom_slot>",
	"Directed interrupts (single CPU) test", 'c',0,2,dasp_it,(char *)0,

	"hcp(u)","<cpu_slot> <iom_slot>",
	"Half test - IOM ints to dispatcher test", 'c',0,2,disp_it,(char *)0,

	"acp(u)","<iom_slot>",
	"Half test - IOM all slots", 'c',0,1,ldisp_it,(char *)0,

	"ipc","<cpu_slot>",
	"Test IPCC handshake", 'c',0,1,ipcc,(char *)0,

	"err","",
	"Force error checking ", 'c',0,0,errs,(char *)0,

	"errl","",
	"Force error checking looping", 'c',0,0,errs,(char *)0,

	"", "", "", '\0', 0, 0, 0, (char *)0,
};

/*------------------------------------------------------------------------------
	dasp_test():	test actual dispatching to CPUs
------------------------------------------------------------------------------*/
dasp_test(cpuslot, iomslot)
int cpuslot, iomslot;
{
	register unsigned *j, dat, i;
	unsigned char targ;
	int	er_st=0;	/* err code; good or bad */

	cpuack = 1;		/* show we want to handle our ack's quietly */
	dummiebd = 0;		/* make sure it's cleared */

	printf("Testing slots: SPM %d, CPU %d, IOM %d\n",myslot,cpuslot,iomslot);
	cssmap(MAP03,cpuslot,0x0f);	/* setup slot board id reg address */

	ipccsend(cpuslot,0x38,(int)myslot);
	ipccsend(cpuslot,0x32,(int)myslot);
	ipccsend(cpuslot,0x34,5);
	ipccsend(cpuslot,0x34,6);

	targ = (char)cpuslot;		/* setup */
	disp_init(1, targ);		/* just this stuff */
	initiom(iomslot, cpuslot);	/* program IOM tables */
				        /* now, all setup */
	for(i = 0; i < 63; i++)		/* generate 63 of these ints */
		generate(int_4, cpuslot); /* generate level 4 int */
	for(i = 0; i < 63; i++) 	  /* generate 63 of these ints */
		generate(int_5, cpuslot); /* generate level 5 int */

	for(i = 0; i < 80000; i++) ; /* give a little time */

	*WRCNTL1 &= ~WR1_DREQ; /* request our dispatcher rams */

/* At this point, we should not have a count in the dispatcher rams. */

	while (*STATUSREG & STAT_REG_IDRAM);	/* loop until ours */

/*	Check ram contents here to make sure slot ram is full. */

	j = MISC_RAM + 4;			/* starting point */
	if((*j & 0x3ff) != (0x3ff)) {
		printf("Failed count on level 4 : CPU %d\n", cpuslot);
		er_st |= 1;			/* add in error code */
	}

	j += 1;					/* starting point */
	if((*j & 0x3ff) != (0x3ff)) {
		printf("Failed count on level 5 : CPU %d\n", cpuslot);
		er_st |= 2;			/* add in error code */
	}

	dat = (0x0c002000 | (cpuslot<< 8));	/* build starting address */
	j = (unsigned *)dat;			/* and copy across */
	dat = 0x00800000 | (cpuslot << 12) | (iomslot << 8);

	for(i = 0; i < 63; i++)			/* test all 63 address points */
	{
		if((*j & 0xffffff00) != dat)
		{
			printf("Failed int 4 data compare: Got:%08x:  Exp:%08x:\n",*j,dat);
			break;		/* skip this area */
		}
		j++;			/* next int location */
	}

	dat = (0x0c003000 | (cpuslot << 8));	/* build starting address */
	j = (unsigned *)dat;			/* and copy across */
	dat = 0x00810000 | (cpuslot << 12) | (iomslot << 8);

	for(i = 0; i < 63; i++)  		/* test all 63 address points */
	{
		if((*j & 0xffffff00) != dat) {
			printf("Failed int 5 data compare: Got:%08x:  Exp:%08x:\n",*j,dat);
			break;  	/* skip this area */
		}
		j++;			/* next int location */
	}

	*WRCNTL1 |= WR1_DREQ;		/* enable the dispatcher rams */
	ipccsend(cpuslot,0x33,(int)myslot); /* tell cpu to not handle int's */
	ipccsend(cpuslot,0x35,5);	/* tell cpu to skip int's */
	ipccsend(cpuslot,0x35,6);       /* tell cpu to skip int's */
	cpuack = 0;			/* disable the command ack's */
	return(er_st);			/* return status */
}

/*------------------------------------------------------------------------------
	disp_test() : test particular cpu, directed interrupts 4, 5.
------------------------------------------------------------------------------*/
disp_test(cpuslot, iomslot, exinit)
int	cpuslot;
int	iomslot;
int	exinit;	/* if set, re-init it after done */
{
	register unsigned *j, dat, i;
	int	er_st = 0;	/* err code, good or bad */

	if(cpuslot == 0x0f)
		disp_init(1, (unsigned char)0x0e); /* use alternate slot */
	else
		disp_init(0, (unsigned char)0x00);	/* just this stuff */

	initiom(iomslot, cpuslot);			/* program iom tables */

	for(i = 0; i < 63; i++)	/* generate 63 of these ints */
		generate(int_4 | int_5, cpuslot); /* generate level 4 & 5 int */

	for(i = 0; i < 10; i++); 		/* give a little time */

	*WRCNTL1 &= ~WR1_DREQ;		/* request our dispatcher rams*/

	while(*STATUSREG & STAT_REG_IDRAM);	/* loop until ours */

/*------------- check ram contents here to make sure slot ram is full --------*/

	j = MISC_RAM + 4;		 	/* starting point */

	if((*j&0x3ff) != (0x3ff - 63)) {
		printf("Failed count on level 4 : CPU %d\n", cpuslot);
		er_st |= 1;	 		/* add in error code */
	}

	j += 1;					/* starting point */
	if((*j&0x3ff) != (0x3ff - 63)) {
		printf("Failed count on level 5 : CPU %d\n", cpuslot);
		er_st |= 2;			/* add in error code */
	}

/*---------- now that the count is correct, let's compare the data -------- */

	dat = (0x0c002000 | (cpuslot<< 8));	/* build starting address */
	j = (unsigned *)dat;			/* and copy across */
	dat = 0x00800000 | (cpuslot << 12) | (iomslot << 8);

	for(i = 0; i < 63; i++)	{		/* test all 63 address points */
		if((*j&0xffffff00) != dat) {
			printf("Failed int 4 data compare: Got:%08x:  Exp:%08x:\n",*j,dat);
			break;			/* skip this area */
		}
		j++;				/* next int location */
	}
	dat = (0x0c003000 | (cpuslot<< 8));	/* build starting address */
	j = (unsigned *)dat;			/* and copy across */
	dat = 0x00810000 | (cpuslot << 12) | (iomslot << 8);

	for(i = 0; i < 63; i++)	{		/* test all 63 address points */
		if((*j&0xffffff00) != dat) {
			printf("Failed int 5 data compare: Got:%08x:  Exp:%08x:\n",*j,dat);
			break;			/* skip this area */
		}
		j++;				/* next int location */
	}

	*WRCNTL1 |= WR1_DREQ;			/* enable the dispatcher rams */

	while (!(*STATUSREG & STAT_REG_IDRAM));	/* loop until started */

	tstdisp=1;				/* show in test mode */
	overflow = 0;				/* clear it */
	generate(int_4, cpuslot);		/* test for this */

	for(i = 0; i < 4; i++);			/* give a little time */

	if(!overflow) {				/* overflow failed */
		printf("Failed overflow level 4. CPU test :%d:\n", cpuslot);
		er_st |= 4;			/* add in error code */
	}
	iready();				/* in case we passed */
	overflow=0;	 			/* make sure it's cleared */
	generate(int_5, cpuslot);		/* test for this */

	for(i = 0; i < 4; i++);			/* give a little time */

	if(!overflow) {				/* overflow failed */
		printf("Failed overflow level 5. CPU test :%d:\n", cpuslot);
		er_st |= 8;			/* add in error code */
	}
	tstdisp = 0;				/* disable test mode */
	iready();				/* in case we passed */

	if(exinit)		/* if set, we want to reset the dispatcher */
		disp_init(0, 0);		/* restore dispatcher status */
	return(er_st);				/* return status */
}

/*------------------------------------------------------------------------------
	generate(type, cpuslot)	: generate a set of interrupts
	  type = type of interrupt
	  cpuslot = slot location
	note: map should have already been setup using map 00.
------------------------------------------------------------------------------*/
generate(int_type, cpuslot)
uchar	int_type;
{
	register char *j = (char *)0x8ffffc00;	/* setup command pointer */

	if(int_type & 0x01)		/* if we need to generate type 4 int */
		*j = (char)(cpuslot << 1);
	if(int_type & 0x02)		/* if we need to generate type 5 int */
		*j = (char)((cpuslot << 1) + 1);
}

/*------------------------------------------------------------------------------
	initilize the iom to send interrupts to us, at specified levels.
------------------------------------------------------------------------------*/
initiom(iom_slot,cpu_slot)
int	iom_slot;
int	cpu_slot;
{
	register unsigned 	*start, *end, data, offset;
	unsigned char		addr, oft, *mem;

	mem = (unsigned char *)LNKCTL;	/* IO module link control register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x31;			/* set IO module link config */

	mem = (unsigned char *)IOM_ER_RST; /* IOM error reset register */
	addr  = (unsigned char)CSSADD((unsigned)mem);
	mem = (unsigned char *)CSSMAP((unsigned)mem);
	cssmap(MAP00,iom_slot,addr);
	*mem = 0x00;			/* reset IO module error */

	offset = IOM_INT_V;		/* addr of IO module interrupt vector */
	start = (unsigned *)CSSMAP(offset);
	end   = (unsigned *)(CSSMAP(offset) + INT_SIZE);
	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,iom_slot,addr);	/* setup to point to int table */

/*------------------ initialize IOM interrupt vector table -------------------*/
	oft = 0;
	while (start < end) {
		data = 0;		/* start with nothing for data */
		data = data | ((unsigned)myslot << 8);	/* our slot? */
		data = data | ((unsigned)cpu_slot << 12);	/* dest slot */
		if(oft)	/* default is level 4, otherwise set to level 4 */
			data = data | 0x00010000; /* set level 5 interrupt */
		oft = ~oft;	 			/* invert */
		data = data | 0x00800000;		/* set direct int bit */
		*start = data;
		start++; start++;
	}

	offset = IOS_INT_V;		/* addr of IO device interrupt vector */
	start = (unsigned *)CSSMAP(offset);
	end   = (unsigned *)(CSSMAP(offset) + INT_SIZE);
	addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,iom_slot,addr);
	
	/* initial IO device interrupt vector table */
	
	oft = 0;
	while (start < end) {
		data = 0;
		data = data | ((unsigned)myslot << 8);
		data = data | ((unsigned)cpu_slot << 12);
		if(oft)	/* default is level 4, otherwise set to level 4. */
			data = data | 0x00010000; /* set level 5 interrupt */
		oft = ~oft;				/* invert */
		data = data | 0x00800000; 		/* set direct int bit */
		*start = data;
		start++; start++;
	}
}

/*------------------------------------------------------------------------------
	disp_init : 
------------------------------------------------------------------------------*/
disp_init(oth, cpu)
int oth;
char cpu;	/* if oth is set, use this instead of slot for target cpu. */
{
	register unsigned mapnum;
	register unsigned char slotnum,slotadd;
	register unsigned char* i;
	register unsigned *j,k;
	register unsigned  slot,inv_slot;

		/* First, do some of the init_css command. */

	BusFault = 0;
	*WRCNTL2 = *WRCNTL2 | WR2_BDRST;	/* set board reset */
	slot = (*STATUSREG & STAT_SLOTMASK) >> STAT_SLOTSH;
	inv_slot = ~slot & 0x0f; 
	*WRCNTL0 = WR0_FRC_INH7 | (slot << 8) | (slot << 12) |
		   (slot << 16) | (inv_slot << 20);
	mapnum = 0;				/* using map zero */
	slotnum = (char) slot;			/* setup our real slot here */
	if(oth) 
		slotadd = cpu;			/* special; moves as not cpu */
	else 
		slotadd = 0x0f;			/* special; moves as not cpu */
	i=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*i = (slotnum << 4) | slotadd;
	*WRCNTL1 &= ~WR1_ID_RST;
	*WRCNTL1 |= WR1_ID_RST;
	*WRCNTL1 &= ~WR1_DREQ; 

	/* reset interrupt dispatcher */

	/* source slot */
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) | (((unsigned)slotnum << 16) &0x0f0000) |	((~(unsigned)slotnum << 20) & 0xf00000);

	/* slot id */
	*WRCNTL0 = (*WRCNTL0 & 0xffff00ff) | 
		(((unsigned)slotnum << 12) &0xf000) | (((unsigned)slotadd<<8) & 0x0f00);
	
	/* initialize the queue ram */
	for(j=QUEUE_RAM; j<QUEUE_RAM + QUEUE_LWORDS;j++) 
		*j = ((unsigned)j << 16) | ((unsigned)j & 0x0000ffff);
		
	/* initialize the pointer rams */
	for(j=POINTER_RAM; j<POINTER_RAM + POINTER_LWORDS;j++)
		*j= 0x7f7f0000;

	/* initialize the miscellaneous rams */
	for(j=MISC_RAM; j<MISC_RAM + MISC_LWORDS; j++)
		*j= (0x100003ff | (((unsigned)slotadd << 24)& 0x0f000000));

	*WRCNTL1 = WR1_FRC_RST_ACK | WR1_IRDY | WR1_RRDY | WR1_FMOD
			| WR1_FDEST | WR1_DATYPE | WR1_FINTREC | WR1_DREQ
			| WR1_IDLERST | WR1_RSTREC | WR1_TPOL | WR1_CSSRST
			| WR1_UFTYPE | WR1_ID_RST | WR1_4BYTE_RD
			| WR1_MOTOR | WR1_FDACK | WR1_FRES | WR1_TP
			| (slot << WR1_DEST_SH)
			| WR1_POL; 
	
	for(k=0;k<0x15000;k++);		/* wait a while because of WR1_CSSRST */
	*WRCNTL1 &= ~WR1_ID_RST;	/* reset this after running */
	*WRCNTL1 |= WR1_ID_RST;
	iready();
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
ipcc(comm_str, arg_cnt) 	/* test the ipcc */
char *comm_str;
int arg_cnt;
{
	int	cpuslot, i=0;

	if(clokpr(0)) return;	/* already printed bad, so just return */
	if(arg_cnt > 0)
		cpuslot=(int)atox(comm_args[1]);	/* get slot number */
	else			/* use auto-finder */
		if((cpuslot = (unsigned char)findcpu(1)) == 18)
		/* find first cpu card */
			return;

	if((cpuslot > 0x0f) || (cpuslot < 0)) {
		printf("Invalid CPU slot assignment.\n");
		return;
	}
	cpuack = 1;	/* show we want to handle our ack's quietly */
	dummiebd = 0;	/* make sure it's cleared */
	printf("Testing slots: SPM %d, CPU %d\n", myslot, cpuslot);
	i = 0;

	while(1) {
		if(i++ > 100) {			/* show some dots */
			i = 0;
			printf(".");
		}
		if(ipccsend(cpuslot,0x38,(int)myslot)) break;
		if(ifesc())  break;
	}
	cpuack = 0;
	printf("\n");				/* when escaped */
}
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
disp_it(comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	int	cpuslot, iomslot;
	unsigned char iom_slot;

	if(clokpr(0)) return;	/* already printed bad, so just return */
	if(arg_cnt > 0)		/* if passed args */
		cpuslot = (int)atox(comm_args[1]); /* get slot number */
	else 	/* use auto-finder */
		if((cpuslot = (unsigned char)findcpu(1)) == 18)
		/* find first cpu */
			return;

	if(arg_cnt > 1)	 /* if passed args */
		iomslot = (int)atox(comm_args[2]); /* get slot number */
	else 	/* use auto-finder */
		if((iomslot = (unsigned char)findiom(1)) == 18)
		/* find first iom card */
			return;

	if((cpuslot > 0x0f) || (cpuslot < 0)) {
		printf("Invalid CPU slot assignment.\n");
		return;
	}

	if((iomslot > 0x0f) || (iomslot < 0)) {
		printf("Invalid IOM slot assignment.\n");
		return;
	}

	iom_slot = (unsigned char)iomslot; /* fixup for char passing */
	iom_rst(iom_slot);
	printf("Testing slots: SPM %d, CPU %d, IOM %d\n",
							myslot, cpuslot, iomslot);
	disp_test(cpuslot, iomslot, 1); /* do it */
	iom_rst(iom_slot);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
ldisp_it(comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	int	cpuslot, iomslot;
	unsigned char iom_slot;

	if(clokpr(0))
		return;	/* already printed bad,  so just return */
	if(arg_cnt > 0)	 /* if passed args */
		iomslot = (int)atox(comm_args[1]); /* get slot number */
	else 	/* use auto-finder */
		if((iomslot = (unsigned char)findiom(1)) == 18)
		/* find first iom card */
			return;

	if((iomslot > 0x0f) || (iomslot < 0)) {
		printf("Invalid IOM slot assignment.\n");
		return;
	}
	iom_slot = (unsigned char)iomslot; /* fixup for char passing */
	iom_rst(iom_slot);

	printf("Testing slots: SPM %d, CPU <all slots>, IOM %d\n",myslot,iomslot);
	for(cpuslot = 0; cpuslot < 0x0f; cpuslot++) /* loop this many times */
		disp_test(cpuslot, iomslot, 1); /* do it */

	iom_rst(iom_slot);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
dasp_it(comm_str, arg_cnt) 
char *comm_str;
int arg_cnt;
{
	int	cpuslot, iomslot;
	unsigned char iom_slot;

	if(clokpr(0)) return;	/* If Local clock return */

	if(arg_cnt > 0)		/* if passed args */
		cpuslot = (int)atox(comm_args[1]); /* get slot number */
	else	/* use auto-finder */
		if((cpuslot = (unsigned char)findcpu(1)) == 18)
		/* find first cpu card */
			return;

	if(arg_cnt > 1)		/* if passed args */
		iomslot = (int)atox(comm_args[2]); /* get slot number */
	else	/* use auto-finder */
		if((iomslot = (unsigned char)findiom(1)) == 18)
		/* find first iom card */
			return;

	if((cpuslot > 0x0f) || (cpuslot < 0)) {
		printf("Invalid CPU slot assignment.\n");
		return;
	}
	if((iomslot > 0x0f) || (iomslot < 0)) {
		printf("Invalid IOM slot assignment.\n");
		return;
	}
	iom_slot = (unsigned char)iomslot;	/* fixup for char passing */
	iom_rst(iom_slot);
	dasp_test(cpuslot, iomslot);		/* do it */
	iom_rst(iom_slot);
}

/*----------------------------------------------------------------------------*/
